/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOutboundBuffer$1;
import io.netty.channel.ChannelOutboundBuffer$2;
import io.netty.channel.ChannelOutboundBuffer$3;
import io.netty.channel.ChannelOutboundBuffer$Entry;
import io.netty.channel.ChannelOutboundBuffer$MessageProcessor;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelProgressivePromise;
import io.netty.channel.ChannelPromise;
import io.netty.channel.FileRegion;
import io.netty.channel.VoidChannelPromise;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.internal.InternalThreadLocalMap;
import io.netty.util.internal.PromiseNotificationUtil;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public final class ChannelOutboundBuffer {
    static final int CHANNEL_OUTBOUND_BUFFER_ENTRY_OVERHEAD = SystemPropertyUtil.getInt("io.netty.transport.outboundBufferEntrySizeOverhead", 96);
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ChannelOutboundBuffer.class);
    private static final FastThreadLocal<ByteBuffer[]> NIO_BUFFERS = new ChannelOutboundBuffer$1();
    private final Channel channel;
    private ChannelOutboundBuffer$Entry flushedEntry;
    private ChannelOutboundBuffer$Entry unflushedEntry;
    private ChannelOutboundBuffer$Entry tailEntry;
    private int flushed;
    private int nioBufferCount;
    private long nioBufferSize;
    private boolean inFail;
    private static final AtomicLongFieldUpdater<ChannelOutboundBuffer> TOTAL_PENDING_SIZE_UPDATER = AtomicLongFieldUpdater.newUpdater(ChannelOutboundBuffer.class, "totalPendingSize");
    private volatile long totalPendingSize;
    private static final AtomicIntegerFieldUpdater<ChannelOutboundBuffer> UNWRITABLE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ChannelOutboundBuffer.class, "unwritable");
    private volatile int unwritable;
    private volatile Runnable fireChannelWritabilityChangedTask;

    ChannelOutboundBuffer(AbstractChannel abstractChannel) {
        this.channel = abstractChannel;
    }

    public void addMessage(Object object, int n2, ChannelPromise channelPromise) {
        ChannelOutboundBuffer$Entry channelOutboundBuffer$Entry = ChannelOutboundBuffer$Entry.newInstance(object, n2, ChannelOutboundBuffer.total(object), channelPromise);
        if (this.tailEntry == null) {
            this.flushedEntry = null;
        } else {
            ChannelOutboundBuffer$Entry channelOutboundBuffer$Entry2 = this.tailEntry;
            channelOutboundBuffer$Entry2.next = channelOutboundBuffer$Entry;
        }
        this.tailEntry = channelOutboundBuffer$Entry;
        if (this.unflushedEntry == null) {
            this.unflushedEntry = channelOutboundBuffer$Entry;
        }
        this.incrementPendingOutboundBytes(channelOutboundBuffer$Entry.pendingSize, false);
    }

    public void addFlush() {
        ChannelOutboundBuffer$Entry channelOutboundBuffer$Entry = this.unflushedEntry;
        if (channelOutboundBuffer$Entry != null) {
            if (this.flushedEntry == null) {
                this.flushedEntry = channelOutboundBuffer$Entry;
            }
            do {
                ++this.flushed;
                if (channelOutboundBuffer$Entry.promise.setUncancellable()) continue;
                int n2 = channelOutboundBuffer$Entry.cancel();
                this.decrementPendingOutboundBytes(n2, false, true);
            } while ((channelOutboundBuffer$Entry = channelOutboundBuffer$Entry.next) != null);
            this.unflushedEntry = null;
        }
    }

    void incrementPendingOutboundBytes(long l2) {
        this.incrementPendingOutboundBytes(l2, true);
    }

    private void incrementPendingOutboundBytes(long l2, boolean bl2) {
        if (l2 == 0L) {
            return;
        }
        long l3 = TOTAL_PENDING_SIZE_UPDATER.addAndGet(this, l2);
        if (l3 > (long)this.channel.config().getWriteBufferHighWaterMark()) {
            this.setUnwritable(bl2);
        }
    }

    void decrementPendingOutboundBytes(long l2) {
        this.decrementPendingOutboundBytes(l2, true, true);
    }

    private void decrementPendingOutboundBytes(long l2, boolean bl2, boolean bl3) {
        if (l2 == 0L) {
            return;
        }
        long l3 = TOTAL_PENDING_SIZE_UPDATER.addAndGet(this, -l2);
        if (bl3 && l3 < (long)this.channel.config().getWriteBufferLowWaterMark()) {
            this.setWritable(bl2);
        }
    }

    private static long total(Object object) {
        if (object instanceof ByteBuf) {
            return ((ByteBuf)object).readableBytes();
        }
        if (object instanceof FileRegion) {
            return ((FileRegion)object).count();
        }
        if (object instanceof ByteBufHolder) {
            return ((ByteBufHolder)object).content().readableBytes();
        }
        return -1L;
    }

    public Object current() {
        ChannelOutboundBuffer$Entry channelOutboundBuffer$Entry = this.flushedEntry;
        if (channelOutboundBuffer$Entry == null) {
            return null;
        }
        return channelOutboundBuffer$Entry.msg;
    }

    public void progress(long l2) {
        ChannelOutboundBuffer$Entry channelOutboundBuffer$Entry = this.flushedEntry;
        assert (channelOutboundBuffer$Entry != null);
        ChannelPromise channelPromise = channelOutboundBuffer$Entry.promise;
        if (channelPromise instanceof ChannelProgressivePromise) {
            long l3;
            channelOutboundBuffer$Entry.progress = l3 = channelOutboundBuffer$Entry.progress + l2;
            ((ChannelProgressivePromise)channelPromise).tryProgress(l3, channelOutboundBuffer$Entry.total);
        }
    }

    public boolean remove() {
        ChannelOutboundBuffer$Entry channelOutboundBuffer$Entry = this.flushedEntry;
        if (channelOutboundBuffer$Entry == null) {
            this.clearNioBuffers();
            return false;
        }
        Object object = channelOutboundBuffer$Entry.msg;
        ChannelPromise channelPromise = channelOutboundBuffer$Entry.promise;
        int n2 = channelOutboundBuffer$Entry.pendingSize;
        this.removeEntry(channelOutboundBuffer$Entry);
        if (!channelOutboundBuffer$Entry.cancelled) {
            ReferenceCountUtil.safeRelease(object);
            ChannelOutboundBuffer.safeSuccess(channelPromise);
            this.decrementPendingOutboundBytes(n2, false, true);
        }
        channelOutboundBuffer$Entry.recycle();
        return true;
    }

    public boolean remove(Throwable throwable) {
        return this.remove0(throwable, true);
    }

    private boolean remove0(Throwable throwable, boolean bl2) {
        ChannelOutboundBuffer$Entry channelOutboundBuffer$Entry = this.flushedEntry;
        if (channelOutboundBuffer$Entry == null) {
            this.clearNioBuffers();
            return false;
        }
        Object object = channelOutboundBuffer$Entry.msg;
        ChannelPromise channelPromise = channelOutboundBuffer$Entry.promise;
        int n2 = channelOutboundBuffer$Entry.pendingSize;
        this.removeEntry(channelOutboundBuffer$Entry);
        if (!channelOutboundBuffer$Entry.cancelled) {
            ReferenceCountUtil.safeRelease(object);
            ChannelOutboundBuffer.safeFail(channelPromise, throwable);
            this.decrementPendingOutboundBytes(n2, false, bl2);
        }
        channelOutboundBuffer$Entry.recycle();
        return true;
    }

    private void removeEntry(ChannelOutboundBuffer$Entry channelOutboundBuffer$Entry) {
        if (--this.flushed == 0) {
            this.flushedEntry = null;
            if (channelOutboundBuffer$Entry == this.tailEntry) {
                this.tailEntry = null;
                this.unflushedEntry = null;
            }
        } else {
            this.flushedEntry = channelOutboundBuffer$Entry.next;
        }
    }

    public void removeBytes(long l2) {
        block5: {
            int n2;
            ByteBuf byteBuf;
            while (true) {
                Object object;
                if (!((object = this.current()) instanceof ByteBuf)) {
                    assert (l2 == 0L);
                    break block5;
                }
                byteBuf = (ByteBuf)object;
                n2 = byteBuf.readerIndex();
                int n3 = byteBuf.writerIndex() - n2;
                if ((long)n3 > l2) break;
                if (l2 != 0L) {
                    this.progress(n3);
                    l2 -= (long)n3;
                }
                this.remove();
            }
            if (l2 != 0L) {
                byteBuf.readerIndex(n2 + (int)l2);
                this.progress(l2);
            }
        }
        this.clearNioBuffers();
    }

    private void clearNioBuffers() {
        int n2 = this.nioBufferCount;
        if (n2 > 0) {
            this.nioBufferCount = 0;
            Arrays.fill(NIO_BUFFERS.get(), 0, n2, null);
        }
    }

    public ByteBuffer[] nioBuffers() {
        return this.nioBuffers(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public ByteBuffer[] nioBuffers(int n2, long l2) {
        assert (n2 > 0);
        assert (l2 > 0L);
        long l3 = 0L;
        int n3 = 0;
        InternalThreadLocalMap internalThreadLocalMap = InternalThreadLocalMap.get();
        ByteBuffer[] byteBufferArray = NIO_BUFFERS.get(internalThreadLocalMap);
        ChannelOutboundBuffer$Entry channelOutboundBuffer$Entry = this.flushedEntry;
        while (this.isFlushedEntry(channelOutboundBuffer$Entry) && channelOutboundBuffer$Entry.msg instanceof ByteBuf) {
            if (!channelOutboundBuffer$Entry.cancelled) {
                ByteBuf byteBuf = (ByteBuf)channelOutboundBuffer$Entry.msg;
                int n4 = byteBuf.readerIndex();
                int n5 = byteBuf.writerIndex() - n4;
                if (n5 > 0) {
                    Object object;
                    int n6;
                    if (l2 - (long)n5 < l3 && n3 != 0) break;
                    l3 += (long)n5;
                    int n7 = channelOutboundBuffer$Entry.count;
                    if (n7 == -1) {
                        channelOutboundBuffer$Entry.count = n7 = byteBuf.nioBufferCount();
                    }
                    if ((n6 = Math.min(n2, n3 + n7)) > byteBufferArray.length) {
                        byteBufferArray = ChannelOutboundBuffer.expandNioBufferArray(byteBufferArray, n6, n3);
                        NIO_BUFFERS.set(internalThreadLocalMap, byteBufferArray);
                    }
                    if (n7 == 1) {
                        object = channelOutboundBuffer$Entry.buf;
                        if (object == null) {
                            object = byteBuf.internalNioBuffer(n4, n5);
                            channelOutboundBuffer$Entry.buf = object;
                        }
                        byteBufferArray[n3++] = object;
                    } else {
                        ByteBuffer byteBuffer;
                        object = channelOutboundBuffer$Entry.bufs;
                        if (object == null) {
                            channelOutboundBuffer$Entry.bufs = object = byteBuf.nioBuffers();
                        }
                        for (int i2 = 0; i2 < ((ByteBuffer[])object).length && n3 < n2 && (byteBuffer = object[i2]) != null; ++i2) {
                            if (!byteBuffer.hasRemaining()) continue;
                            byteBufferArray[n3++] = byteBuffer;
                        }
                    }
                    if (n3 == n2) break;
                }
            }
            channelOutboundBuffer$Entry = channelOutboundBuffer$Entry.next;
        }
        this.nioBufferCount = n3;
        this.nioBufferSize = l3;
        return byteBufferArray;
    }

    private static ByteBuffer[] expandNioBufferArray(ByteBuffer[] byteBufferArray, int n2, int n3) {
        int n4 = byteBufferArray.length;
        do {
            if ((n4 <<= 1) >= 0) continue;
            throw new IllegalStateException();
        } while (n2 > n4);
        ByteBuffer[] byteBufferArray2 = new ByteBuffer[n4];
        System.arraycopy(byteBufferArray, 0, byteBufferArray2, 0, n3);
        return byteBufferArray2;
    }

    public int nioBufferCount() {
        return this.nioBufferCount;
    }

    public long nioBufferSize() {
        return this.nioBufferSize;
    }

    public boolean isWritable() {
        return this.unwritable == 0;
    }

    public boolean getUserDefinedWritability(int n2) {
        return (this.unwritable & ChannelOutboundBuffer.writabilityMask(n2)) == 0;
    }

    public void setUserDefinedWritability(int n2, boolean bl2) {
        if (bl2) {
            this.setUserDefinedWritability(n2);
        } else {
            this.clearUserDefinedWritability(n2);
        }
    }

    private void setUserDefinedWritability(int n2) {
        block1: {
            int n3;
            int n4;
            int n5 = ~ChannelOutboundBuffer.writabilityMask(n2);
            while (!UNWRITABLE_UPDATER.compareAndSet(this, n4 = this.unwritable, n3 = n4 & n5)) {
            }
            if (n4 == 0 || n3 != 0) break block1;
            this.fireChannelWritabilityChanged(true);
        }
    }

    private void clearUserDefinedWritability(int n2) {
        block1: {
            int n3;
            int n4;
            int n5 = ChannelOutboundBuffer.writabilityMask(n2);
            while (!UNWRITABLE_UPDATER.compareAndSet(this, n4 = this.unwritable, n3 = n4 | n5)) {
            }
            if (n4 != 0 || n3 == 0) break block1;
            this.fireChannelWritabilityChanged(true);
        }
    }

    private static int writabilityMask(int n2) {
        if (n2 < 1 || n2 > 31) {
            throw new IllegalArgumentException("index: " + n2 + " (expected: 1~31)");
        }
        return 1 << n2;
    }

    private void setWritable(boolean bl2) {
        block1: {
            int n2;
            int n3;
            while (!UNWRITABLE_UPDATER.compareAndSet(this, n3 = this.unwritable, n2 = n3 & 0xFFFFFFFE)) {
            }
            if (n3 == 0 || n2 != 0) break block1;
            this.fireChannelWritabilityChanged(bl2);
        }
    }

    private void setUnwritable(boolean bl2) {
        block1: {
            int n2;
            int n3;
            while (!UNWRITABLE_UPDATER.compareAndSet(this, n3 = this.unwritable, n2 = n3 | 1)) {
            }
            if (n3 != 0 || n2 == 0) break block1;
            this.fireChannelWritabilityChanged(bl2);
        }
    }

    private void fireChannelWritabilityChanged(boolean bl2) {
        ChannelPipeline channelPipeline = this.channel.pipeline();
        if (bl2) {
            Runnable runnable = this.fireChannelWritabilityChangedTask;
            if (runnable == null) {
                this.fireChannelWritabilityChangedTask = runnable = new ChannelOutboundBuffer$2(this, channelPipeline);
            }
            this.channel.eventLoop().execute(runnable);
        } else {
            channelPipeline.fireChannelWritabilityChanged();
        }
    }

    public int size() {
        return this.flushed;
    }

    public boolean isEmpty() {
        return this.flushed == 0;
    }

    void failFlushed(Throwable throwable, boolean bl2) {
        if (this.inFail) {
            return;
        }
        try {
            this.inFail = true;
            while (this.remove0(throwable, bl2)) {
            }
        }
        finally {
            this.inFail = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(Throwable throwable, boolean bl2) {
        if (this.inFail) {
            this.channel.eventLoop().execute(new ChannelOutboundBuffer$3(this, throwable, bl2));
            return;
        }
        this.inFail = true;
        if (!bl2 && this.channel.isOpen()) {
            throw new IllegalStateException("close() must be invoked after the channel is closed.");
        }
        if (!this.isEmpty()) {
            throw new IllegalStateException("close() must be invoked after all flushed writes are handled.");
        }
        try {
            for (ChannelOutboundBuffer$Entry channelOutboundBuffer$Entry = this.unflushedEntry; channelOutboundBuffer$Entry != null; channelOutboundBuffer$Entry = channelOutboundBuffer$Entry.recycleAndGetNext()) {
                int n2 = channelOutboundBuffer$Entry.pendingSize;
                TOTAL_PENDING_SIZE_UPDATER.addAndGet(this, -n2);
                if (channelOutboundBuffer$Entry.cancelled) continue;
                ReferenceCountUtil.safeRelease(channelOutboundBuffer$Entry.msg);
                ChannelOutboundBuffer.safeFail(channelOutboundBuffer$Entry.promise, throwable);
            }
        }
        finally {
            this.inFail = false;
        }
        this.clearNioBuffers();
    }

    void close(ClosedChannelException closedChannelException) {
        this.close(closedChannelException, false);
    }

    private static void safeSuccess(ChannelPromise channelPromise) {
        PromiseNotificationUtil.trySuccess(channelPromise, null, channelPromise instanceof VoidChannelPromise ? null : logger);
    }

    private static void safeFail(ChannelPromise channelPromise, Throwable throwable) {
        PromiseNotificationUtil.tryFailure(channelPromise, throwable, channelPromise instanceof VoidChannelPromise ? null : logger);
    }

    @Deprecated
    public void recycle() {
    }

    public long totalPendingWriteBytes() {
        return this.totalPendingSize;
    }

    public long bytesBeforeUnwritable() {
        long l2 = (long)this.channel.config().getWriteBufferHighWaterMark() - this.totalPendingSize;
        if (l2 > 0L) {
            return this.isWritable() ? l2 : 0L;
        }
        return 0L;
    }

    public long bytesBeforeWritable() {
        long l2 = this.totalPendingSize - (long)this.channel.config().getWriteBufferLowWaterMark();
        if (l2 > 0L) {
            return this.isWritable() ? 0L : l2;
        }
        return 0L;
    }

    public void forEachFlushedMessage(ChannelOutboundBuffer$MessageProcessor channelOutboundBuffer$MessageProcessor) {
        if (channelOutboundBuffer$MessageProcessor == null) {
            throw new NullPointerException("processor");
        }
        ChannelOutboundBuffer$Entry channelOutboundBuffer$Entry = this.flushedEntry;
        if (channelOutboundBuffer$Entry == null) {
            return;
        }
        do {
            if (channelOutboundBuffer$Entry.cancelled || channelOutboundBuffer$MessageProcessor.processMessage(channelOutboundBuffer$Entry.msg)) continue;
            return;
        } while (this.isFlushedEntry(channelOutboundBuffer$Entry = channelOutboundBuffer$Entry.next));
    }

    private boolean isFlushedEntry(ChannelOutboundBuffer$Entry channelOutboundBuffer$Entry) {
        return channelOutboundBuffer$Entry != null && channelOutboundBuffer$Entry != this.unflushedEntry;
    }
}

