/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.SwappedByteBuf;
import io.netty.buffer.UnsafeByteBufUtil;
import io.netty.buffer.UnsafeDirectSwappedByteBuf;
import io.netty.util.internal.PlatformDependent;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

public class UnpooledUnsafeDirectByteBuf
extends AbstractReferenceCountedByteBuf {
    private final ByteBufAllocator alloc;
    private ByteBuffer tmpNioBuf;
    private int capacity;
    private boolean doNotFree;
    ByteBuffer buffer;
    long memoryAddress;

    public UnpooledUnsafeDirectByteBuf(ByteBufAllocator byteBufAllocator, int n2, int n3) {
        super(n3);
        if (byteBufAllocator == null) {
            throw new NullPointerException("alloc");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("initialCapacity: " + n2);
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("maxCapacity: " + n3);
        }
        if (n2 > n3) {
            throw new IllegalArgumentException(String.format("initialCapacity(%d) > maxCapacity(%d)", n2, n3));
        }
        this.alloc = byteBufAllocator;
        this.setByteBuffer(this.allocateDirect(n2), false);
    }

    protected UnpooledUnsafeDirectByteBuf(ByteBufAllocator byteBufAllocator, ByteBuffer byteBuffer, int n2) {
        this(byteBufAllocator, byteBuffer.slice(), n2, false);
    }

    UnpooledUnsafeDirectByteBuf(ByteBufAllocator byteBufAllocator, ByteBuffer byteBuffer, int n2, boolean bl2) {
        super(n2);
        if (byteBufAllocator == null) {
            throw new NullPointerException("alloc");
        }
        if (byteBuffer == null) {
            throw new NullPointerException("initialBuffer");
        }
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("initialBuffer is not a direct buffer.");
        }
        if (byteBuffer.isReadOnly()) {
            throw new IllegalArgumentException("initialBuffer is a read-only buffer.");
        }
        int n3 = byteBuffer.remaining();
        if (n3 > n2) {
            throw new IllegalArgumentException(String.format("initialCapacity(%d) > maxCapacity(%d)", n3, n2));
        }
        this.alloc = byteBufAllocator;
        this.doNotFree = !bl2;
        this.setByteBuffer(byteBuffer.order(ByteOrder.BIG_ENDIAN), false);
        this.writerIndex(n3);
    }

    protected ByteBuffer allocateDirect(int n2) {
        return ByteBuffer.allocateDirect(n2);
    }

    protected void freeDirect(ByteBuffer byteBuffer) {
        PlatformDependent.freeDirectBuffer(byteBuffer);
    }

    final void setByteBuffer(ByteBuffer byteBuffer, boolean bl2) {
        ByteBuffer byteBuffer2;
        if (bl2 && (byteBuffer2 = this.buffer) != null) {
            if (this.doNotFree) {
                this.doNotFree = false;
            } else {
                this.freeDirect(byteBuffer2);
            }
        }
        this.buffer = byteBuffer;
        this.memoryAddress = PlatformDependent.directBufferAddress(byteBuffer);
        this.tmpNioBuf = null;
        this.capacity = byteBuffer.remaining();
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public ByteBuf capacity(int n2) {
        this.checkNewCapacity(n2);
        int n3 = this.readerIndex();
        int n4 = this.writerIndex();
        int n5 = this.capacity;
        if (n2 > n5) {
            ByteBuffer byteBuffer = this.buffer;
            ByteBuffer byteBuffer2 = this.allocateDirect(n2);
            byteBuffer.position(0).limit(byteBuffer.capacity());
            byteBuffer2.position(0).limit(byteBuffer.capacity());
            byteBuffer2.put(byteBuffer);
            byteBuffer2.clear();
            this.setByteBuffer(byteBuffer2, true);
        } else if (n2 < n5) {
            ByteBuffer byteBuffer = this.buffer;
            ByteBuffer byteBuffer3 = this.allocateDirect(n2);
            if (n3 < n2) {
                if (n4 > n2) {
                    n4 = n2;
                    this.writerIndex(n4);
                }
                byteBuffer.position(n3).limit(n4);
                byteBuffer3.position(n3).limit(n4);
                byteBuffer3.put(byteBuffer);
                byteBuffer3.clear();
            } else {
                this.setIndex(n2, n2);
            }
            this.setByteBuffer(byteBuffer3, true);
        }
        return this;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.alloc;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }

    @Override
    public boolean hasArray() {
        return false;
    }

    @Override
    public byte[] array() {
        throw new UnsupportedOperationException("direct buffer");
    }

    @Override
    public int arrayOffset() {
        throw new UnsupportedOperationException("direct buffer");
    }

    @Override
    public boolean hasMemoryAddress() {
        return true;
    }

    @Override
    public long memoryAddress() {
        this.ensureAccessible();
        return this.memoryAddress;
    }

    @Override
    protected byte _getByte(int n2) {
        return UnsafeByteBufUtil.getByte(this.addr(n2));
    }

    @Override
    protected short _getShort(int n2) {
        return UnsafeByteBufUtil.getShort(this.addr(n2));
    }

    @Override
    protected short _getShortLE(int n2) {
        return UnsafeByteBufUtil.getShortLE(this.addr(n2));
    }

    @Override
    protected int _getUnsignedMedium(int n2) {
        return UnsafeByteBufUtil.getUnsignedMedium(this.addr(n2));
    }

    @Override
    protected int _getUnsignedMediumLE(int n2) {
        return UnsafeByteBufUtil.getUnsignedMediumLE(this.addr(n2));
    }

    @Override
    protected int _getInt(int n2) {
        return UnsafeByteBufUtil.getInt(this.addr(n2));
    }

    @Override
    protected int _getIntLE(int n2) {
        return UnsafeByteBufUtil.getIntLE(this.addr(n2));
    }

    @Override
    protected long _getLong(int n2) {
        return UnsafeByteBufUtil.getLong(this.addr(n2));
    }

    @Override
    protected long _getLongLE(int n2) {
        return UnsafeByteBufUtil.getLongLE(this.addr(n2));
    }

    @Override
    public ByteBuf getBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        UnsafeByteBufUtil.getBytes((AbstractByteBuf)this, this.addr(n2), n2, byteBuf, n3, n4);
        return this;
    }

    @Override
    public ByteBuf getBytes(int n2, byte[] byArray, int n3, int n4) {
        UnsafeByteBufUtil.getBytes((AbstractByteBuf)this, this.addr(n2), n2, byArray, n3, n4);
        return this;
    }

    @Override
    public ByteBuf getBytes(int n2, ByteBuffer byteBuffer) {
        UnsafeByteBufUtil.getBytes(this, this.addr(n2), n2, byteBuffer);
        return this;
    }

    @Override
    public ByteBuf readBytes(ByteBuffer byteBuffer) {
        int n2 = byteBuffer.remaining();
        this.checkReadableBytes(n2);
        this.getBytes(this.readerIndex, byteBuffer);
        this.readerIndex += n2;
        return this;
    }

    @Override
    protected void _setByte(int n2, int n3) {
        UnsafeByteBufUtil.setByte(this.addr(n2), n3);
    }

    @Override
    protected void _setShort(int n2, int n3) {
        UnsafeByteBufUtil.setShort(this.addr(n2), n3);
    }

    @Override
    protected void _setShortLE(int n2, int n3) {
        UnsafeByteBufUtil.setShortLE(this.addr(n2), n3);
    }

    @Override
    protected void _setMedium(int n2, int n3) {
        UnsafeByteBufUtil.setMedium(this.addr(n2), n3);
    }

    @Override
    protected void _setMediumLE(int n2, int n3) {
        UnsafeByteBufUtil.setMediumLE(this.addr(n2), n3);
    }

    @Override
    protected void _setInt(int n2, int n3) {
        UnsafeByteBufUtil.setInt(this.addr(n2), n3);
    }

    @Override
    protected void _setIntLE(int n2, int n3) {
        UnsafeByteBufUtil.setIntLE(this.addr(n2), n3);
    }

    @Override
    protected void _setLong(int n2, long l2) {
        UnsafeByteBufUtil.setLong(this.addr(n2), l2);
    }

    @Override
    protected void _setLongLE(int n2, long l2) {
        UnsafeByteBufUtil.setLongLE(this.addr(n2), l2);
    }

    @Override
    public ByteBuf setBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        UnsafeByteBufUtil.setBytes((AbstractByteBuf)this, this.addr(n2), n2, byteBuf, n3, n4);
        return this;
    }

    @Override
    public ByteBuf setBytes(int n2, byte[] byArray, int n3, int n4) {
        UnsafeByteBufUtil.setBytes((AbstractByteBuf)this, this.addr(n2), n2, byArray, n3, n4);
        return this;
    }

    @Override
    public ByteBuf setBytes(int n2, ByteBuffer byteBuffer) {
        UnsafeByteBufUtil.setBytes(this, this.addr(n2), n2, byteBuffer);
        return this;
    }

    @Override
    public ByteBuf getBytes(int n2, OutputStream outputStream, int n3) {
        UnsafeByteBufUtil.getBytes(this, this.addr(n2), n2, outputStream, n3);
        return this;
    }

    @Override
    public int getBytes(int n2, GatheringByteChannel gatheringByteChannel, int n3) {
        return this.getBytes(n2, gatheringByteChannel, n3, false);
    }

    private int getBytes(int n2, GatheringByteChannel gatheringByteChannel, int n3, boolean bl2) {
        this.ensureAccessible();
        if (n3 == 0) {
            return 0;
        }
        ByteBuffer byteBuffer = bl2 ? this.internalNioBuffer() : this.buffer.duplicate();
        byteBuffer.clear().position(n2).limit(n2 + n3);
        return gatheringByteChannel.write(byteBuffer);
    }

    @Override
    public int getBytes(int n2, FileChannel fileChannel, long l2, int n3) {
        return this.getBytes(n2, fileChannel, l2, n3, false);
    }

    private int getBytes(int n2, FileChannel fileChannel, long l2, int n3, boolean bl2) {
        this.ensureAccessible();
        if (n3 == 0) {
            return 0;
        }
        ByteBuffer byteBuffer = bl2 ? this.internalNioBuffer() : this.buffer.duplicate();
        byteBuffer.clear().position(n2).limit(n2 + n3);
        return fileChannel.write(byteBuffer, l2);
    }

    @Override
    public int readBytes(GatheringByteChannel gatheringByteChannel, int n2) {
        this.checkReadableBytes(n2);
        int n3 = this.getBytes(this.readerIndex, gatheringByteChannel, n2, true);
        this.readerIndex += n3;
        return n3;
    }

    @Override
    public int readBytes(FileChannel fileChannel, long l2, int n2) {
        this.checkReadableBytes(n2);
        int n3 = this.getBytes(this.readerIndex, fileChannel, l2, n2, true);
        this.readerIndex += n3;
        return n3;
    }

    @Override
    public int setBytes(int n2, InputStream inputStream, int n3) {
        return UnsafeByteBufUtil.setBytes(this, this.addr(n2), n2, inputStream, n3);
    }

    @Override
    public int setBytes(int n2, ScatteringByteChannel scatteringByteChannel, int n3) {
        this.ensureAccessible();
        ByteBuffer byteBuffer = this.internalNioBuffer();
        byteBuffer.clear().position(n2).limit(n2 + n3);
        try {
            return scatteringByteChannel.read(byteBuffer);
        }
        catch (ClosedChannelException closedChannelException) {
            return -1;
        }
    }

    @Override
    public int setBytes(int n2, FileChannel fileChannel, long l2, int n3) {
        this.ensureAccessible();
        ByteBuffer byteBuffer = this.internalNioBuffer();
        byteBuffer.clear().position(n2).limit(n2 + n3);
        try {
            return fileChannel.read(byteBuffer, l2);
        }
        catch (ClosedChannelException closedChannelException) {
            return -1;
        }
    }

    @Override
    public int nioBufferCount() {
        return 1;
    }

    @Override
    public ByteBuffer[] nioBuffers(int n2, int n3) {
        return new ByteBuffer[]{this.nioBuffer(n2, n3)};
    }

    @Override
    public ByteBuf copy(int n2, int n3) {
        return UnsafeByteBufUtil.copy(this, this.addr(n2), n2, n3);
    }

    @Override
    public ByteBuffer internalNioBuffer(int n2, int n3) {
        this.checkIndex(n2, n3);
        return (ByteBuffer)this.internalNioBuffer().clear().position(n2).limit(n2 + n3);
    }

    private ByteBuffer internalNioBuffer() {
        ByteBuffer byteBuffer = this.tmpNioBuf;
        if (byteBuffer == null) {
            this.tmpNioBuf = byteBuffer = this.buffer.duplicate();
        }
        return byteBuffer;
    }

    @Override
    public ByteBuffer nioBuffer(int n2, int n3) {
        this.checkIndex(n2, n3);
        return ((ByteBuffer)this.buffer.duplicate().position(n2).limit(n2 + n3)).slice();
    }

    @Override
    protected void deallocate() {
        ByteBuffer byteBuffer = this.buffer;
        if (byteBuffer == null) {
            return;
        }
        this.buffer = null;
        if (!this.doNotFree) {
            this.freeDirect(byteBuffer);
        }
    }

    @Override
    public ByteBuf unwrap() {
        return null;
    }

    long addr(int n2) {
        return this.memoryAddress + (long)n2;
    }

    @Override
    protected SwappedByteBuf newSwappedByteBuf() {
        if (PlatformDependent.isUnaligned()) {
            return new UnsafeDirectSwappedByteBuf(this);
        }
        return super.newSwappedByteBuf();
    }

    @Override
    public ByteBuf setZero(int n2, int n3) {
        this.checkIndex(n2, n3);
        UnsafeByteBufUtil.setZero(this.addr(n2), n3);
        return this;
    }

    @Override
    public ByteBuf writeZero(int n2) {
        this.ensureWritable(n2);
        int n3 = this.writerIndex;
        UnsafeByteBufUtil.setZero(this.addr(n3), n2);
        this.writerIndex = n3 + n2;
        return this;
    }
}

