/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.HeapByteBufUtil;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

public class UnpooledHeapByteBuf
extends AbstractReferenceCountedByteBuf {
    private final ByteBufAllocator alloc;
    byte[] array;
    private ByteBuffer tmpNioBuf;

    public UnpooledHeapByteBuf(ByteBufAllocator byteBufAllocator, int n2, int n3) {
        super(n3);
        ObjectUtil.checkNotNull(byteBufAllocator, "alloc");
        if (n2 > n3) {
            throw new IllegalArgumentException(String.format("initialCapacity(%d) > maxCapacity(%d)", n2, n3));
        }
        this.alloc = byteBufAllocator;
        this.setArray(this.allocateArray(n2));
        this.setIndex(0, 0);
    }

    protected UnpooledHeapByteBuf(ByteBufAllocator byteBufAllocator, byte[] byArray, int n2) {
        super(n2);
        ObjectUtil.checkNotNull(byteBufAllocator, "alloc");
        ObjectUtil.checkNotNull(byArray, "initialArray");
        if (byArray.length > n2) {
            throw new IllegalArgumentException(String.format("initialCapacity(%d) > maxCapacity(%d)", byArray.length, n2));
        }
        this.alloc = byteBufAllocator;
        this.setArray(byArray);
        this.setIndex(0, byArray.length);
    }

    byte[] allocateArray(int n2) {
        return new byte[n2];
    }

    void freeArray(byte[] byArray) {
    }

    private void setArray(byte[] byArray) {
        this.array = byArray;
        this.tmpNioBuf = null;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.alloc;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public int capacity() {
        return this.array.length;
    }

    @Override
    public ByteBuf capacity(int n2) {
        this.checkNewCapacity(n2);
        int n3 = this.array.length;
        byte[] byArray = this.array;
        if (n2 > n3) {
            byte[] byArray2 = this.allocateArray(n2);
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            this.setArray(byArray2);
            this.freeArray(byArray);
        } else if (n2 < n3) {
            byte[] byArray3 = this.allocateArray(n2);
            int n4 = this.readerIndex();
            if (n4 < n2) {
                int n5 = this.writerIndex();
                if (n5 > n2) {
                    n5 = n2;
                    this.writerIndex(n5);
                }
                System.arraycopy(byArray, n4, byArray3, n4, n5 - n4);
            } else {
                this.setIndex(n2, n2);
            }
            this.setArray(byArray3);
            this.freeArray(byArray);
        }
        return this;
    }

    @Override
    public boolean hasArray() {
        return true;
    }

    @Override
    public byte[] array() {
        this.ensureAccessible();
        return this.array;
    }

    @Override
    public int arrayOffset() {
        return 0;
    }

    @Override
    public boolean hasMemoryAddress() {
        return false;
    }

    @Override
    public long memoryAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuf getBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        this.checkDstIndex(n2, n4, n3, byteBuf.capacity());
        if (byteBuf.hasMemoryAddress()) {
            PlatformDependent.copyMemory(this.array, n2, byteBuf.memoryAddress() + (long)n3, (long)n4);
        } else if (byteBuf.hasArray()) {
            this.getBytes(n2, byteBuf.array(), byteBuf.arrayOffset() + n3, n4);
        } else {
            byteBuf.setBytes(n3, this.array, n2, n4);
        }
        return this;
    }

    @Override
    public ByteBuf getBytes(int n2, byte[] byArray, int n3, int n4) {
        this.checkDstIndex(n2, n4, n3, byArray.length);
        System.arraycopy(this.array, n2, byArray, n3, n4);
        return this;
    }

    @Override
    public ByteBuf getBytes(int n2, ByteBuffer byteBuffer) {
        this.checkIndex(n2, byteBuffer.remaining());
        byteBuffer.put(this.array, n2, byteBuffer.remaining());
        return this;
    }

    @Override
    public ByteBuf getBytes(int n2, OutputStream outputStream, int n3) {
        this.ensureAccessible();
        outputStream.write(this.array, n2, n3);
        return this;
    }

    @Override
    public int getBytes(int n2, GatheringByteChannel gatheringByteChannel, int n3) {
        this.ensureAccessible();
        return this.getBytes(n2, gatheringByteChannel, n3, false);
    }

    @Override
    public int getBytes(int n2, FileChannel fileChannel, long l2, int n3) {
        this.ensureAccessible();
        return this.getBytes(n2, fileChannel, l2, n3, false);
    }

    private int getBytes(int n2, GatheringByteChannel gatheringByteChannel, int n3, boolean bl2) {
        this.ensureAccessible();
        ByteBuffer byteBuffer = bl2 ? this.internalNioBuffer() : ByteBuffer.wrap(this.array);
        return gatheringByteChannel.write((ByteBuffer)byteBuffer.clear().position(n2).limit(n2 + n3));
    }

    private int getBytes(int n2, FileChannel fileChannel, long l2, int n3, boolean bl2) {
        this.ensureAccessible();
        ByteBuffer byteBuffer = bl2 ? this.internalNioBuffer() : ByteBuffer.wrap(this.array);
        return fileChannel.write((ByteBuffer)byteBuffer.clear().position(n2).limit(n2 + n3), l2);
    }

    @Override
    public int readBytes(GatheringByteChannel gatheringByteChannel, int n2) {
        this.checkReadableBytes(n2);
        int n3 = this.getBytes(this.readerIndex, gatheringByteChannel, n2, true);
        this.readerIndex += n3;
        return n3;
    }

    @Override
    public int readBytes(FileChannel fileChannel, long l2, int n2) {
        this.checkReadableBytes(n2);
        int n3 = this.getBytes(this.readerIndex, fileChannel, l2, n2, true);
        this.readerIndex += n3;
        return n3;
    }

    @Override
    public ByteBuf setBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        this.checkSrcIndex(n2, n4, n3, byteBuf.capacity());
        if (byteBuf.hasMemoryAddress()) {
            PlatformDependent.copyMemory(byteBuf.memoryAddress() + (long)n3, this.array, n2, (long)n4);
        } else if (byteBuf.hasArray()) {
            this.setBytes(n2, byteBuf.array(), byteBuf.arrayOffset() + n3, n4);
        } else {
            byteBuf.getBytes(n3, this.array, n2, n4);
        }
        return this;
    }

    @Override
    public ByteBuf setBytes(int n2, byte[] byArray, int n3, int n4) {
        this.checkSrcIndex(n2, n4, n3, byArray.length);
        System.arraycopy(byArray, n3, this.array, n2, n4);
        return this;
    }

    @Override
    public ByteBuf setBytes(int n2, ByteBuffer byteBuffer) {
        this.ensureAccessible();
        byteBuffer.get(this.array, n2, byteBuffer.remaining());
        return this;
    }

    @Override
    public int setBytes(int n2, InputStream inputStream, int n3) {
        this.ensureAccessible();
        return inputStream.read(this.array, n2, n3);
    }

    @Override
    public int setBytes(int n2, ScatteringByteChannel scatteringByteChannel, int n3) {
        this.ensureAccessible();
        try {
            return scatteringByteChannel.read((ByteBuffer)this.internalNioBuffer().clear().position(n2).limit(n2 + n3));
        }
        catch (ClosedChannelException closedChannelException) {
            return -1;
        }
    }

    @Override
    public int setBytes(int n2, FileChannel fileChannel, long l2, int n3) {
        this.ensureAccessible();
        try {
            return fileChannel.read((ByteBuffer)this.internalNioBuffer().clear().position(n2).limit(n2 + n3), l2);
        }
        catch (ClosedChannelException closedChannelException) {
            return -1;
        }
    }

    @Override
    public int nioBufferCount() {
        return 1;
    }

    @Override
    public ByteBuffer nioBuffer(int n2, int n3) {
        this.ensureAccessible();
        return ByteBuffer.wrap(this.array, n2, n3).slice();
    }

    @Override
    public ByteBuffer[] nioBuffers(int n2, int n3) {
        return new ByteBuffer[]{this.nioBuffer(n2, n3)};
    }

    @Override
    public ByteBuffer internalNioBuffer(int n2, int n3) {
        this.checkIndex(n2, n3);
        return (ByteBuffer)this.internalNioBuffer().clear().position(n2).limit(n2 + n3);
    }

    @Override
    public byte getByte(int n2) {
        this.ensureAccessible();
        return this._getByte(n2);
    }

    @Override
    protected byte _getByte(int n2) {
        return HeapByteBufUtil.getByte(this.array, n2);
    }

    @Override
    public short getShort(int n2) {
        this.ensureAccessible();
        return this._getShort(n2);
    }

    @Override
    protected short _getShort(int n2) {
        return HeapByteBufUtil.getShort(this.array, n2);
    }

    @Override
    public short getShortLE(int n2) {
        this.ensureAccessible();
        return this._getShortLE(n2);
    }

    @Override
    protected short _getShortLE(int n2) {
        return HeapByteBufUtil.getShortLE(this.array, n2);
    }

    @Override
    public int getUnsignedMedium(int n2) {
        this.ensureAccessible();
        return this._getUnsignedMedium(n2);
    }

    @Override
    protected int _getUnsignedMedium(int n2) {
        return HeapByteBufUtil.getUnsignedMedium(this.array, n2);
    }

    @Override
    public int getUnsignedMediumLE(int n2) {
        this.ensureAccessible();
        return this._getUnsignedMediumLE(n2);
    }

    @Override
    protected int _getUnsignedMediumLE(int n2) {
        return HeapByteBufUtil.getUnsignedMediumLE(this.array, n2);
    }

    @Override
    public int getInt(int n2) {
        this.ensureAccessible();
        return this._getInt(n2);
    }

    @Override
    protected int _getInt(int n2) {
        return HeapByteBufUtil.getInt(this.array, n2);
    }

    @Override
    public int getIntLE(int n2) {
        this.ensureAccessible();
        return this._getIntLE(n2);
    }

    @Override
    protected int _getIntLE(int n2) {
        return HeapByteBufUtil.getIntLE(this.array, n2);
    }

    @Override
    public long getLong(int n2) {
        this.ensureAccessible();
        return this._getLong(n2);
    }

    @Override
    protected long _getLong(int n2) {
        return HeapByteBufUtil.getLong(this.array, n2);
    }

    @Override
    public long getLongLE(int n2) {
        this.ensureAccessible();
        return this._getLongLE(n2);
    }

    @Override
    protected long _getLongLE(int n2) {
        return HeapByteBufUtil.getLongLE(this.array, n2);
    }

    @Override
    public ByteBuf setByte(int n2, int n3) {
        this.ensureAccessible();
        this._setByte(n2, n3);
        return this;
    }

    @Override
    protected void _setByte(int n2, int n3) {
        HeapByteBufUtil.setByte(this.array, n2, n3);
    }

    @Override
    public ByteBuf setShort(int n2, int n3) {
        this.ensureAccessible();
        this._setShort(n2, n3);
        return this;
    }

    @Override
    protected void _setShort(int n2, int n3) {
        HeapByteBufUtil.setShort(this.array, n2, n3);
    }

    @Override
    public ByteBuf setShortLE(int n2, int n3) {
        this.ensureAccessible();
        this._setShortLE(n2, n3);
        return this;
    }

    @Override
    protected void _setShortLE(int n2, int n3) {
        HeapByteBufUtil.setShortLE(this.array, n2, n3);
    }

    @Override
    public ByteBuf setMedium(int n2, int n3) {
        this.ensureAccessible();
        this._setMedium(n2, n3);
        return this;
    }

    @Override
    protected void _setMedium(int n2, int n3) {
        HeapByteBufUtil.setMedium(this.array, n2, n3);
    }

    @Override
    public ByteBuf setMediumLE(int n2, int n3) {
        this.ensureAccessible();
        this._setMediumLE(n2, n3);
        return this;
    }

    @Override
    protected void _setMediumLE(int n2, int n3) {
        HeapByteBufUtil.setMediumLE(this.array, n2, n3);
    }

    @Override
    public ByteBuf setInt(int n2, int n3) {
        this.ensureAccessible();
        this._setInt(n2, n3);
        return this;
    }

    @Override
    protected void _setInt(int n2, int n3) {
        HeapByteBufUtil.setInt(this.array, n2, n3);
    }

    @Override
    public ByteBuf setIntLE(int n2, int n3) {
        this.ensureAccessible();
        this._setIntLE(n2, n3);
        return this;
    }

    @Override
    protected void _setIntLE(int n2, int n3) {
        HeapByteBufUtil.setIntLE(this.array, n2, n3);
    }

    @Override
    public ByteBuf setLong(int n2, long l2) {
        this.ensureAccessible();
        this._setLong(n2, l2);
        return this;
    }

    @Override
    protected void _setLong(int n2, long l2) {
        HeapByteBufUtil.setLong(this.array, n2, l2);
    }

    @Override
    public ByteBuf setLongLE(int n2, long l2) {
        this.ensureAccessible();
        this._setLongLE(n2, l2);
        return this;
    }

    @Override
    protected void _setLongLE(int n2, long l2) {
        HeapByteBufUtil.setLongLE(this.array, n2, l2);
    }

    @Override
    public ByteBuf copy(int n2, int n3) {
        this.checkIndex(n2, n3);
        byte[] byArray = new byte[n3];
        System.arraycopy(this.array, n2, byArray, 0, n3);
        return new UnpooledHeapByteBuf(this.alloc(), byArray, this.maxCapacity());
    }

    private ByteBuffer internalNioBuffer() {
        ByteBuffer byteBuffer = this.tmpNioBuf;
        if (byteBuffer == null) {
            this.tmpNioBuf = byteBuffer = ByteBuffer.wrap(this.array);
        }
        return byteBuffer;
    }

    @Override
    protected void deallocate() {
        this.freeArray(this.array);
        this.array = EmptyArrays.EMPTY_BYTES;
    }

    @Override
    public ByteBuf unwrap() {
        return null;
    }
}

