/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBufAllocator;
import io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocatorMetric;
import io.netty.buffer.ByteBufAllocatorMetricProvider;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator$InstrumentedUnpooledDirectByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator$InstrumentedUnpooledHeapByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator$InstrumentedUnpooledUnsafeDirectByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator$InstrumentedUnpooledUnsafeHeapByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator$InstrumentedUnpooledUnsafeNoCleanerDirectByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator$UnpooledByteBufAllocatorMetric;
import io.netty.util.internal.PlatformDependent;

public final class UnpooledByteBufAllocator
extends AbstractByteBufAllocator
implements ByteBufAllocatorMetricProvider {
    private final UnpooledByteBufAllocator$UnpooledByteBufAllocatorMetric metric = new UnpooledByteBufAllocator$UnpooledByteBufAllocatorMetric(null);
    private final boolean disableLeakDetector;
    private final boolean noCleaner;
    public static final UnpooledByteBufAllocator DEFAULT = new UnpooledByteBufAllocator(PlatformDependent.directBufferPreferred());

    public UnpooledByteBufAllocator(boolean bl2) {
        this(bl2, false);
    }

    public UnpooledByteBufAllocator(boolean bl2, boolean bl3) {
        this(bl2, bl3, PlatformDependent.useDirectBufferNoCleaner());
    }

    public UnpooledByteBufAllocator(boolean bl2, boolean bl3, boolean bl4) {
        super(bl2);
        this.disableLeakDetector = bl3;
        this.noCleaner = bl4 && PlatformDependent.hasUnsafe() && PlatformDependent.hasDirectBufferNoCleanerConstructor();
    }

    @Override
    protected ByteBuf newHeapBuffer(int n2, int n3) {
        return PlatformDependent.hasUnsafe() ? new UnpooledByteBufAllocator$InstrumentedUnpooledUnsafeHeapByteBuf(this, n2, n3) : new UnpooledByteBufAllocator$InstrumentedUnpooledHeapByteBuf(this, n2, n3);
    }

    @Override
    protected ByteBuf newDirectBuffer(int n2, int n3) {
        AbstractReferenceCountedByteBuf abstractReferenceCountedByteBuf = PlatformDependent.hasUnsafe() ? (this.noCleaner ? new UnpooledByteBufAllocator$InstrumentedUnpooledUnsafeNoCleanerDirectByteBuf(this, n2, n3) : new UnpooledByteBufAllocator$InstrumentedUnpooledUnsafeDirectByteBuf(this, n2, n3)) : new UnpooledByteBufAllocator$InstrumentedUnpooledDirectByteBuf(this, n2, n3);
        return this.disableLeakDetector ? abstractReferenceCountedByteBuf : UnpooledByteBufAllocator.toLeakAwareBuffer(abstractReferenceCountedByteBuf);
    }

    @Override
    public CompositeByteBuf compositeHeapBuffer(int n2) {
        CompositeByteBuf compositeByteBuf = new CompositeByteBuf(this, false, n2);
        return this.disableLeakDetector ? compositeByteBuf : UnpooledByteBufAllocator.toLeakAwareBuffer(compositeByteBuf);
    }

    @Override
    public CompositeByteBuf compositeDirectBuffer(int n2) {
        CompositeByteBuf compositeByteBuf = new CompositeByteBuf(this, true, n2);
        return this.disableLeakDetector ? compositeByteBuf : UnpooledByteBufAllocator.toLeakAwareBuffer(compositeByteBuf);
    }

    @Override
    public boolean isDirectBufferPooled() {
        return false;
    }

    @Override
    public ByteBufAllocatorMetric metric() {
        return this.metric;
    }

    void incrementDirect(int n2) {
        this.metric.directCounter.add(n2);
    }

    void decrementDirect(int n2) {
        this.metric.directCounter.add(-n2);
    }

    void incrementHeap(int n2) {
        this.metric.heapCounter.add(n2);
    }

    void decrementHeap(int n2) {
        this.metric.heapCounter.add(-n2);
    }
}

