/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.util.ByteProcessor;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;

@Deprecated
public class SwappedByteBuf
extends ByteBuf {
    private final ByteBuf buf;
    private final ByteOrder order;

    public SwappedByteBuf(ByteBuf byteBuf) {
        if (byteBuf == null) {
            throw new NullPointerException("buf");
        }
        this.buf = byteBuf;
        this.order = byteBuf.order() == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }

    @Override
    public ByteOrder order() {
        return this.order;
    }

    @Override
    public ByteBuf order(ByteOrder byteOrder) {
        if (byteOrder == null) {
            throw new NullPointerException("endianness");
        }
        if (byteOrder == this.order) {
            return this;
        }
        return this.buf;
    }

    @Override
    public ByteBuf unwrap() {
        return this.buf;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.buf.alloc();
    }

    @Override
    public int capacity() {
        return this.buf.capacity();
    }

    @Override
    public ByteBuf capacity(int n2) {
        this.buf.capacity(n2);
        return this;
    }

    @Override
    public int maxCapacity() {
        return this.buf.maxCapacity();
    }

    @Override
    public boolean isReadOnly() {
        return this.buf.isReadOnly();
    }

    @Override
    public ByteBuf asReadOnly() {
        return Unpooled.unmodifiableBuffer((ByteBuf)this);
    }

    @Override
    public boolean isDirect() {
        return this.buf.isDirect();
    }

    @Override
    public int readerIndex() {
        return this.buf.readerIndex();
    }

    @Override
    public ByteBuf readerIndex(int n2) {
        this.buf.readerIndex(n2);
        return this;
    }

    @Override
    public int writerIndex() {
        return this.buf.writerIndex();
    }

    @Override
    public ByteBuf writerIndex(int n2) {
        this.buf.writerIndex(n2);
        return this;
    }

    @Override
    public ByteBuf setIndex(int n2, int n3) {
        this.buf.setIndex(n2, n3);
        return this;
    }

    @Override
    public int readableBytes() {
        return this.buf.readableBytes();
    }

    @Override
    public int writableBytes() {
        return this.buf.writableBytes();
    }

    @Override
    public int maxWritableBytes() {
        return this.buf.maxWritableBytes();
    }

    @Override
    public boolean isReadable() {
        return this.buf.isReadable();
    }

    @Override
    public boolean isReadable(int n2) {
        return this.buf.isReadable(n2);
    }

    @Override
    public boolean isWritable() {
        return this.buf.isWritable();
    }

    @Override
    public boolean isWritable(int n2) {
        return this.buf.isWritable(n2);
    }

    @Override
    public ByteBuf clear() {
        this.buf.clear();
        return this;
    }

    @Override
    public ByteBuf markReaderIndex() {
        this.buf.markReaderIndex();
        return this;
    }

    @Override
    public ByteBuf resetReaderIndex() {
        this.buf.resetReaderIndex();
        return this;
    }

    @Override
    public ByteBuf markWriterIndex() {
        this.buf.markWriterIndex();
        return this;
    }

    @Override
    public ByteBuf resetWriterIndex() {
        this.buf.resetWriterIndex();
        return this;
    }

    @Override
    public ByteBuf discardReadBytes() {
        this.buf.discardReadBytes();
        return this;
    }

    @Override
    public ByteBuf discardSomeReadBytes() {
        this.buf.discardSomeReadBytes();
        return this;
    }

    @Override
    public ByteBuf ensureWritable(int n2) {
        this.buf.ensureWritable(n2);
        return this;
    }

    @Override
    public int ensureWritable(int n2, boolean bl2) {
        return this.buf.ensureWritable(n2, bl2);
    }

    @Override
    public boolean getBoolean(int n2) {
        return this.buf.getBoolean(n2);
    }

    @Override
    public byte getByte(int n2) {
        return this.buf.getByte(n2);
    }

    @Override
    public short getUnsignedByte(int n2) {
        return this.buf.getUnsignedByte(n2);
    }

    @Override
    public short getShort(int n2) {
        return ByteBufUtil.swapShort(this.buf.getShort(n2));
    }

    @Override
    public short getShortLE(int n2) {
        return this.buf.getShort(n2);
    }

    @Override
    public int getUnsignedShort(int n2) {
        return this.getShort(n2) & 0xFFFF;
    }

    @Override
    public int getUnsignedShortLE(int n2) {
        return this.getShortLE(n2) & 0xFFFF;
    }

    @Override
    public int getMedium(int n2) {
        return ByteBufUtil.swapMedium(this.buf.getMedium(n2));
    }

    @Override
    public int getMediumLE(int n2) {
        return this.buf.getMedium(n2);
    }

    @Override
    public int getUnsignedMedium(int n2) {
        return this.getMedium(n2) & 0xFFFFFF;
    }

    @Override
    public int getUnsignedMediumLE(int n2) {
        return this.getMediumLE(n2) & 0xFFFFFF;
    }

    @Override
    public int getInt(int n2) {
        return ByteBufUtil.swapInt(this.buf.getInt(n2));
    }

    @Override
    public int getIntLE(int n2) {
        return this.buf.getInt(n2);
    }

    @Override
    public long getUnsignedInt(int n2) {
        return (long)this.getInt(n2) & 0xFFFFFFFFL;
    }

    @Override
    public long getUnsignedIntLE(int n2) {
        return (long)this.getIntLE(n2) & 0xFFFFFFFFL;
    }

    @Override
    public long getLong(int n2) {
        return ByteBufUtil.swapLong(this.buf.getLong(n2));
    }

    @Override
    public long getLongLE(int n2) {
        return this.buf.getLong(n2);
    }

    @Override
    public char getChar(int n2) {
        return (char)this.getShort(n2);
    }

    @Override
    public float getFloat(int n2) {
        return Float.intBitsToFloat(this.getInt(n2));
    }

    @Override
    public double getDouble(int n2) {
        return Double.longBitsToDouble(this.getLong(n2));
    }

    @Override
    public ByteBuf getBytes(int n2, ByteBuf byteBuf) {
        this.buf.getBytes(n2, byteBuf);
        return this;
    }

    @Override
    public ByteBuf getBytes(int n2, ByteBuf byteBuf, int n3) {
        this.buf.getBytes(n2, byteBuf, n3);
        return this;
    }

    @Override
    public ByteBuf getBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        this.buf.getBytes(n2, byteBuf, n3, n4);
        return this;
    }

    @Override
    public ByteBuf getBytes(int n2, byte[] byArray) {
        this.buf.getBytes(n2, byArray);
        return this;
    }

    @Override
    public ByteBuf getBytes(int n2, byte[] byArray, int n3, int n4) {
        this.buf.getBytes(n2, byArray, n3, n4);
        return this;
    }

    @Override
    public ByteBuf getBytes(int n2, ByteBuffer byteBuffer) {
        this.buf.getBytes(n2, byteBuffer);
        return this;
    }

    @Override
    public ByteBuf getBytes(int n2, OutputStream outputStream, int n3) {
        this.buf.getBytes(n2, outputStream, n3);
        return this;
    }

    @Override
    public int getBytes(int n2, GatheringByteChannel gatheringByteChannel, int n3) {
        return this.buf.getBytes(n2, gatheringByteChannel, n3);
    }

    @Override
    public int getBytes(int n2, FileChannel fileChannel, long l2, int n3) {
        return this.buf.getBytes(n2, fileChannel, l2, n3);
    }

    @Override
    public CharSequence getCharSequence(int n2, int n3, Charset charset) {
        return this.buf.getCharSequence(n2, n3, charset);
    }

    @Override
    public ByteBuf setBoolean(int n2, boolean bl2) {
        this.buf.setBoolean(n2, bl2);
        return this;
    }

    @Override
    public ByteBuf setByte(int n2, int n3) {
        this.buf.setByte(n2, n3);
        return this;
    }

    @Override
    public ByteBuf setShort(int n2, int n3) {
        this.buf.setShort(n2, ByteBufUtil.swapShort((short)n3));
        return this;
    }

    @Override
    public ByteBuf setShortLE(int n2, int n3) {
        this.buf.setShort(n2, (short)n3);
        return this;
    }

    @Override
    public ByteBuf setMedium(int n2, int n3) {
        this.buf.setMedium(n2, ByteBufUtil.swapMedium(n3));
        return this;
    }

    @Override
    public ByteBuf setMediumLE(int n2, int n3) {
        this.buf.setMedium(n2, n3);
        return this;
    }

    @Override
    public ByteBuf setInt(int n2, int n3) {
        this.buf.setInt(n2, ByteBufUtil.swapInt(n3));
        return this;
    }

    @Override
    public ByteBuf setIntLE(int n2, int n3) {
        this.buf.setInt(n2, n3);
        return this;
    }

    @Override
    public ByteBuf setLong(int n2, long l2) {
        this.buf.setLong(n2, ByteBufUtil.swapLong(l2));
        return this;
    }

    @Override
    public ByteBuf setLongLE(int n2, long l2) {
        this.buf.setLong(n2, l2);
        return this;
    }

    @Override
    public ByteBuf setChar(int n2, int n3) {
        this.setShort(n2, n3);
        return this;
    }

    @Override
    public ByteBuf setFloat(int n2, float f2) {
        this.setInt(n2, Float.floatToRawIntBits(f2));
        return this;
    }

    @Override
    public ByteBuf setDouble(int n2, double d2) {
        this.setLong(n2, Double.doubleToRawLongBits(d2));
        return this;
    }

    @Override
    public ByteBuf setBytes(int n2, ByteBuf byteBuf) {
        this.buf.setBytes(n2, byteBuf);
        return this;
    }

    @Override
    public ByteBuf setBytes(int n2, ByteBuf byteBuf, int n3) {
        this.buf.setBytes(n2, byteBuf, n3);
        return this;
    }

    @Override
    public ByteBuf setBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        this.buf.setBytes(n2, byteBuf, n3, n4);
        return this;
    }

    @Override
    public ByteBuf setBytes(int n2, byte[] byArray) {
        this.buf.setBytes(n2, byArray);
        return this;
    }

    @Override
    public ByteBuf setBytes(int n2, byte[] byArray, int n3, int n4) {
        this.buf.setBytes(n2, byArray, n3, n4);
        return this;
    }

    @Override
    public ByteBuf setBytes(int n2, ByteBuffer byteBuffer) {
        this.buf.setBytes(n2, byteBuffer);
        return this;
    }

    @Override
    public int setBytes(int n2, InputStream inputStream, int n3) {
        return this.buf.setBytes(n2, inputStream, n3);
    }

    @Override
    public int setBytes(int n2, ScatteringByteChannel scatteringByteChannel, int n3) {
        return this.buf.setBytes(n2, scatteringByteChannel, n3);
    }

    @Override
    public int setBytes(int n2, FileChannel fileChannel, long l2, int n3) {
        return this.buf.setBytes(n2, fileChannel, l2, n3);
    }

    @Override
    public ByteBuf setZero(int n2, int n3) {
        this.buf.setZero(n2, n3);
        return this;
    }

    @Override
    public int setCharSequence(int n2, CharSequence charSequence, Charset charset) {
        return this.buf.setCharSequence(n2, charSequence, charset);
    }

    @Override
    public boolean readBoolean() {
        return this.buf.readBoolean();
    }

    @Override
    public byte readByte() {
        return this.buf.readByte();
    }

    @Override
    public short readUnsignedByte() {
        return this.buf.readUnsignedByte();
    }

    @Override
    public short readShort() {
        return ByteBufUtil.swapShort(this.buf.readShort());
    }

    @Override
    public short readShortLE() {
        return this.buf.readShort();
    }

    @Override
    public int readUnsignedShort() {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public int readUnsignedShortLE() {
        return this.readShortLE() & 0xFFFF;
    }

    @Override
    public int readMedium() {
        return ByteBufUtil.swapMedium(this.buf.readMedium());
    }

    @Override
    public int readMediumLE() {
        return this.buf.readMedium();
    }

    @Override
    public int readUnsignedMedium() {
        return this.readMedium() & 0xFFFFFF;
    }

    @Override
    public int readUnsignedMediumLE() {
        return this.readMediumLE() & 0xFFFFFF;
    }

    @Override
    public int readInt() {
        return ByteBufUtil.swapInt(this.buf.readInt());
    }

    @Override
    public int readIntLE() {
        return this.buf.readInt();
    }

    @Override
    public long readUnsignedInt() {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    @Override
    public long readUnsignedIntLE() {
        return (long)this.readIntLE() & 0xFFFFFFFFL;
    }

    @Override
    public long readLong() {
        return ByteBufUtil.swapLong(this.buf.readLong());
    }

    @Override
    public long readLongLE() {
        return this.buf.readLong();
    }

    @Override
    public char readChar() {
        return (char)this.readShort();
    }

    @Override
    public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public ByteBuf readBytes(int n2) {
        return this.buf.readBytes(n2).order(this.order());
    }

    @Override
    public ByteBuf readSlice(int n2) {
        return this.buf.readSlice(n2).order(this.order);
    }

    @Override
    public ByteBuf readRetainedSlice(int n2) {
        return this.buf.readRetainedSlice(n2).order(this.order);
    }

    @Override
    public ByteBuf readBytes(ByteBuf byteBuf) {
        this.buf.readBytes(byteBuf);
        return this;
    }

    @Override
    public ByteBuf readBytes(ByteBuf byteBuf, int n2) {
        this.buf.readBytes(byteBuf, n2);
        return this;
    }

    @Override
    public ByteBuf readBytes(ByteBuf byteBuf, int n2, int n3) {
        this.buf.readBytes(byteBuf, n2, n3);
        return this;
    }

    @Override
    public ByteBuf readBytes(byte[] byArray) {
        this.buf.readBytes(byArray);
        return this;
    }

    @Override
    public ByteBuf readBytes(byte[] byArray, int n2, int n3) {
        this.buf.readBytes(byArray, n2, n3);
        return this;
    }

    @Override
    public ByteBuf readBytes(ByteBuffer byteBuffer) {
        this.buf.readBytes(byteBuffer);
        return this;
    }

    @Override
    public ByteBuf readBytes(OutputStream outputStream, int n2) {
        this.buf.readBytes(outputStream, n2);
        return this;
    }

    @Override
    public int readBytes(GatheringByteChannel gatheringByteChannel, int n2) {
        return this.buf.readBytes(gatheringByteChannel, n2);
    }

    @Override
    public int readBytes(FileChannel fileChannel, long l2, int n2) {
        return this.buf.readBytes(fileChannel, l2, n2);
    }

    @Override
    public CharSequence readCharSequence(int n2, Charset charset) {
        return this.buf.readCharSequence(n2, charset);
    }

    @Override
    public ByteBuf skipBytes(int n2) {
        this.buf.skipBytes(n2);
        return this;
    }

    @Override
    public ByteBuf writeBoolean(boolean bl2) {
        this.buf.writeBoolean(bl2);
        return this;
    }

    @Override
    public ByteBuf writeByte(int n2) {
        this.buf.writeByte(n2);
        return this;
    }

    @Override
    public ByteBuf writeShort(int n2) {
        this.buf.writeShort(ByteBufUtil.swapShort((short)n2));
        return this;
    }

    @Override
    public ByteBuf writeShortLE(int n2) {
        this.buf.writeShort((short)n2);
        return this;
    }

    @Override
    public ByteBuf writeMedium(int n2) {
        this.buf.writeMedium(ByteBufUtil.swapMedium(n2));
        return this;
    }

    @Override
    public ByteBuf writeMediumLE(int n2) {
        this.buf.writeMedium(n2);
        return this;
    }

    @Override
    public ByteBuf writeInt(int n2) {
        this.buf.writeInt(ByteBufUtil.swapInt(n2));
        return this;
    }

    @Override
    public ByteBuf writeIntLE(int n2) {
        this.buf.writeInt(n2);
        return this;
    }

    @Override
    public ByteBuf writeLong(long l2) {
        this.buf.writeLong(ByteBufUtil.swapLong(l2));
        return this;
    }

    @Override
    public ByteBuf writeLongLE(long l2) {
        this.buf.writeLong(l2);
        return this;
    }

    @Override
    public ByteBuf writeChar(int n2) {
        this.writeShort(n2);
        return this;
    }

    @Override
    public ByteBuf writeFloat(float f2) {
        this.writeInt(Float.floatToRawIntBits(f2));
        return this;
    }

    @Override
    public ByteBuf writeDouble(double d2) {
        this.writeLong(Double.doubleToRawLongBits(d2));
        return this;
    }

    @Override
    public ByteBuf writeBytes(ByteBuf byteBuf) {
        this.buf.writeBytes(byteBuf);
        return this;
    }

    @Override
    public ByteBuf writeBytes(ByteBuf byteBuf, int n2) {
        this.buf.writeBytes(byteBuf, n2);
        return this;
    }

    @Override
    public ByteBuf writeBytes(ByteBuf byteBuf, int n2, int n3) {
        this.buf.writeBytes(byteBuf, n2, n3);
        return this;
    }

    @Override
    public ByteBuf writeBytes(byte[] byArray) {
        this.buf.writeBytes(byArray);
        return this;
    }

    @Override
    public ByteBuf writeBytes(byte[] byArray, int n2, int n3) {
        this.buf.writeBytes(byArray, n2, n3);
        return this;
    }

    @Override
    public ByteBuf writeBytes(ByteBuffer byteBuffer) {
        this.buf.writeBytes(byteBuffer);
        return this;
    }

    @Override
    public int writeBytes(InputStream inputStream, int n2) {
        return this.buf.writeBytes(inputStream, n2);
    }

    @Override
    public int writeBytes(ScatteringByteChannel scatteringByteChannel, int n2) {
        return this.buf.writeBytes(scatteringByteChannel, n2);
    }

    @Override
    public int writeBytes(FileChannel fileChannel, long l2, int n2) {
        return this.buf.writeBytes(fileChannel, l2, n2);
    }

    @Override
    public ByteBuf writeZero(int n2) {
        this.buf.writeZero(n2);
        return this;
    }

    @Override
    public int writeCharSequence(CharSequence charSequence, Charset charset) {
        return this.buf.writeCharSequence(charSequence, charset);
    }

    @Override
    public int indexOf(int n2, int n3, byte by2) {
        return this.buf.indexOf(n2, n3, by2);
    }

    @Override
    public int bytesBefore(byte by2) {
        return this.buf.bytesBefore(by2);
    }

    @Override
    public int bytesBefore(int n2, byte by2) {
        return this.buf.bytesBefore(n2, by2);
    }

    @Override
    public int bytesBefore(int n2, int n3, byte by2) {
        return this.buf.bytesBefore(n2, n3, by2);
    }

    @Override
    public int forEachByte(ByteProcessor byteProcessor) {
        return this.buf.forEachByte(byteProcessor);
    }

    @Override
    public int forEachByte(int n2, int n3, ByteProcessor byteProcessor) {
        return this.buf.forEachByte(n2, n3, byteProcessor);
    }

    @Override
    public int forEachByteDesc(ByteProcessor byteProcessor) {
        return this.buf.forEachByteDesc(byteProcessor);
    }

    @Override
    public int forEachByteDesc(int n2, int n3, ByteProcessor byteProcessor) {
        return this.buf.forEachByteDesc(n2, n3, byteProcessor);
    }

    @Override
    public ByteBuf copy() {
        return this.buf.copy().order(this.order);
    }

    @Override
    public ByteBuf copy(int n2, int n3) {
        return this.buf.copy(n2, n3).order(this.order);
    }

    @Override
    public ByteBuf slice() {
        return this.buf.slice().order(this.order);
    }

    @Override
    public ByteBuf retainedSlice() {
        return this.buf.retainedSlice().order(this.order);
    }

    @Override
    public ByteBuf slice(int n2, int n3) {
        return this.buf.slice(n2, n3).order(this.order);
    }

    @Override
    public ByteBuf retainedSlice(int n2, int n3) {
        return this.buf.retainedSlice(n2, n3).order(this.order);
    }

    @Override
    public ByteBuf duplicate() {
        return this.buf.duplicate().order(this.order);
    }

    @Override
    public ByteBuf retainedDuplicate() {
        return this.buf.retainedDuplicate().order(this.order);
    }

    @Override
    public int nioBufferCount() {
        return this.buf.nioBufferCount();
    }

    @Override
    public ByteBuffer nioBuffer() {
        return this.buf.nioBuffer().order(this.order);
    }

    @Override
    public ByteBuffer nioBuffer(int n2, int n3) {
        return this.buf.nioBuffer(n2, n3).order(this.order);
    }

    @Override
    public ByteBuffer internalNioBuffer(int n2, int n3) {
        return this.nioBuffer(n2, n3);
    }

    @Override
    public ByteBuffer[] nioBuffers() {
        ByteBuffer[] byteBufferArray = this.buf.nioBuffers();
        for (int i2 = 0; i2 < byteBufferArray.length; ++i2) {
            byteBufferArray[i2] = byteBufferArray[i2].order(this.order);
        }
        return byteBufferArray;
    }

    @Override
    public ByteBuffer[] nioBuffers(int n2, int n3) {
        ByteBuffer[] byteBufferArray = this.buf.nioBuffers(n2, n3);
        for (int i2 = 0; i2 < byteBufferArray.length; ++i2) {
            byteBufferArray[i2] = byteBufferArray[i2].order(this.order);
        }
        return byteBufferArray;
    }

    @Override
    public boolean hasArray() {
        return this.buf.hasArray();
    }

    @Override
    public byte[] array() {
        return this.buf.array();
    }

    @Override
    public int arrayOffset() {
        return this.buf.arrayOffset();
    }

    @Override
    public boolean hasMemoryAddress() {
        return this.buf.hasMemoryAddress();
    }

    @Override
    public long memoryAddress() {
        return this.buf.memoryAddress();
    }

    @Override
    public String toString(Charset charset) {
        return this.buf.toString(charset);
    }

    @Override
    public String toString(int n2, int n3, Charset charset) {
        return this.buf.toString(n2, n3, charset);
    }

    @Override
    public int refCnt() {
        return this.buf.refCnt();
    }

    @Override
    public ByteBuf retain() {
        this.buf.retain();
        return this;
    }

    @Override
    public ByteBuf retain(int n2) {
        this.buf.retain(n2);
        return this;
    }

    @Override
    public ByteBuf touch() {
        this.buf.touch();
        return this;
    }

    @Override
    public ByteBuf touch(Object object) {
        this.buf.touch(object);
        return this;
    }

    @Override
    public boolean release() {
        return this.buf.release();
    }

    @Override
    public boolean release(int n2) {
        return this.buf.release(n2);
    }

    @Override
    public int hashCode() {
        return this.buf.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ByteBuf) {
            return ByteBufUtil.equals(this, (ByteBuf)object);
        }
        return false;
    }

    @Override
    public int compareTo(ByteBuf byteBuf) {
        return ByteBufUtil.compare(this, byteBuf);
    }

    @Override
    public String toString() {
        return "Swapped(" + this.buf + ')';
    }
}

