/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.internal.StringUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

class ReadOnlyByteBufferBuf
extends AbstractReferenceCountedByteBuf {
    protected final ByteBuffer buffer;
    private final ByteBufAllocator allocator;
    private ByteBuffer tmpNioBuf;

    ReadOnlyByteBufferBuf(ByteBufAllocator byteBufAllocator, ByteBuffer byteBuffer) {
        super(byteBuffer.remaining());
        if (!byteBuffer.isReadOnly()) {
            throw new IllegalArgumentException("must be a readonly buffer: " + StringUtil.simpleClassName(byteBuffer));
        }
        this.allocator = byteBufAllocator;
        this.buffer = byteBuffer.slice().order(ByteOrder.BIG_ENDIAN);
        this.writerIndex(this.buffer.limit());
    }

    @Override
    protected void deallocate() {
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public boolean isWritable(int n2) {
        return false;
    }

    @Override
    public ByteBuf ensureWritable(int n2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public int ensureWritable(int n2, boolean bl2) {
        return 1;
    }

    @Override
    public byte getByte(int n2) {
        this.ensureAccessible();
        return this._getByte(n2);
    }

    @Override
    protected byte _getByte(int n2) {
        return this.buffer.get(n2);
    }

    @Override
    public short getShort(int n2) {
        this.ensureAccessible();
        return this._getShort(n2);
    }

    @Override
    protected short _getShort(int n2) {
        return this.buffer.getShort(n2);
    }

    @Override
    public short getShortLE(int n2) {
        this.ensureAccessible();
        return this._getShortLE(n2);
    }

    @Override
    protected short _getShortLE(int n2) {
        return ByteBufUtil.swapShort(this.buffer.getShort(n2));
    }

    @Override
    public int getUnsignedMedium(int n2) {
        this.ensureAccessible();
        return this._getUnsignedMedium(n2);
    }

    @Override
    protected int _getUnsignedMedium(int n2) {
        return (this.getByte(n2) & 0xFF) << 16 | (this.getByte(n2 + 1) & 0xFF) << 8 | this.getByte(n2 + 2) & 0xFF;
    }

    @Override
    public int getUnsignedMediumLE(int n2) {
        this.ensureAccessible();
        return this._getUnsignedMediumLE(n2);
    }

    @Override
    protected int _getUnsignedMediumLE(int n2) {
        return this.getByte(n2) & 0xFF | (this.getByte(n2 + 1) & 0xFF) << 8 | (this.getByte(n2 + 2) & 0xFF) << 16;
    }

    @Override
    public int getInt(int n2) {
        this.ensureAccessible();
        return this._getInt(n2);
    }

    @Override
    protected int _getInt(int n2) {
        return this.buffer.getInt(n2);
    }

    @Override
    public int getIntLE(int n2) {
        this.ensureAccessible();
        return this._getIntLE(n2);
    }

    @Override
    protected int _getIntLE(int n2) {
        return ByteBufUtil.swapInt(this.buffer.getInt(n2));
    }

    @Override
    public long getLong(int n2) {
        this.ensureAccessible();
        return this._getLong(n2);
    }

    @Override
    protected long _getLong(int n2) {
        return this.buffer.getLong(n2);
    }

    @Override
    public long getLongLE(int n2) {
        this.ensureAccessible();
        return this._getLongLE(n2);
    }

    @Override
    protected long _getLongLE(int n2) {
        return ByteBufUtil.swapLong(this.buffer.getLong(n2));
    }

    @Override
    public ByteBuf getBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        this.checkDstIndex(n2, n4, n3, byteBuf.capacity());
        if (byteBuf.hasArray()) {
            this.getBytes(n2, byteBuf.array(), byteBuf.arrayOffset() + n3, n4);
        } else if (byteBuf.nioBufferCount() > 0) {
            for (ByteBuffer byteBuffer : byteBuf.nioBuffers(n3, n4)) {
                int n5 = byteBuffer.remaining();
                this.getBytes(n2, byteBuffer);
                n2 += n5;
            }
        } else {
            byteBuf.setBytes(n3, this, n2, n4);
        }
        return this;
    }

    @Override
    public ByteBuf getBytes(int n2, byte[] byArray, int n3, int n4) {
        this.checkDstIndex(n2, n4, n3, byArray.length);
        if (n3 < 0 || n3 > byArray.length - n4) {
            throw new IndexOutOfBoundsException(String.format("dstIndex: %d, length: %d (expected: range(0, %d))", n3, n4, byArray.length));
        }
        ByteBuffer byteBuffer = this.internalNioBuffer();
        byteBuffer.clear().position(n2).limit(n2 + n4);
        byteBuffer.get(byArray, n3, n4);
        return this;
    }

    @Override
    public ByteBuf getBytes(int n2, ByteBuffer byteBuffer) {
        this.checkIndex(n2);
        if (byteBuffer == null) {
            throw new NullPointerException("dst");
        }
        int n3 = Math.min(this.capacity() - n2, byteBuffer.remaining());
        ByteBuffer byteBuffer2 = this.internalNioBuffer();
        byteBuffer2.clear().position(n2).limit(n2 + n3);
        byteBuffer.put(byteBuffer2);
        return this;
    }

    @Override
    public ByteBuf setByte(int n2, int n3) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setByte(int n2, int n3) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setShort(int n2, int n3) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setShort(int n2, int n3) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setShortLE(int n2, int n3) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setShortLE(int n2, int n3) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setMedium(int n2, int n3) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setMedium(int n2, int n3) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setMediumLE(int n2, int n3) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setMediumLE(int n2, int n3) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setInt(int n2, int n3) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setInt(int n2, int n3) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setIntLE(int n2, int n3) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setIntLE(int n2, int n3) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setLong(int n2, long l2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setLong(int n2, long l2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setLongLE(int n2, long l2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setLongLE(int n2, long l2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public int capacity() {
        return this.maxCapacity();
    }

    @Override
    public ByteBuf capacity(int n2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.allocator;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }

    @Override
    public ByteBuf unwrap() {
        return null;
    }

    @Override
    public boolean isReadOnly() {
        return this.buffer.isReadOnly();
    }

    @Override
    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    @Override
    public ByteBuf getBytes(int n2, OutputStream outputStream, int n3) {
        this.ensureAccessible();
        if (n3 == 0) {
            return this;
        }
        if (this.buffer.hasArray()) {
            outputStream.write(this.buffer.array(), n2 + this.buffer.arrayOffset(), n3);
        } else {
            byte[] byArray = new byte[n3];
            ByteBuffer byteBuffer = this.internalNioBuffer();
            byteBuffer.clear().position(n2);
            byteBuffer.get(byArray);
            outputStream.write(byArray);
        }
        return this;
    }

    @Override
    public int getBytes(int n2, GatheringByteChannel gatheringByteChannel, int n3) {
        this.ensureAccessible();
        if (n3 == 0) {
            return 0;
        }
        ByteBuffer byteBuffer = this.internalNioBuffer();
        byteBuffer.clear().position(n2).limit(n2 + n3);
        return gatheringByteChannel.write(byteBuffer);
    }

    @Override
    public int getBytes(int n2, FileChannel fileChannel, long l2, int n3) {
        this.ensureAccessible();
        if (n3 == 0) {
            return 0;
        }
        ByteBuffer byteBuffer = this.internalNioBuffer();
        byteBuffer.clear().position(n2).limit(n2 + n3);
        return fileChannel.write(byteBuffer, l2);
    }

    @Override
    public ByteBuf setBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setBytes(int n2, byte[] byArray, int n3, int n4) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setBytes(int n2, ByteBuffer byteBuffer) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public int setBytes(int n2, InputStream inputStream, int n3) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public int setBytes(int n2, ScatteringByteChannel scatteringByteChannel, int n3) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public int setBytes(int n2, FileChannel fileChannel, long l2, int n3) {
        throw new ReadOnlyBufferException();
    }

    protected final ByteBuffer internalNioBuffer() {
        ByteBuffer byteBuffer = this.tmpNioBuf;
        if (byteBuffer == null) {
            this.tmpNioBuf = byteBuffer = this.buffer.duplicate();
        }
        return byteBuffer;
    }

    @Override
    public ByteBuf copy(int n2, int n3) {
        ByteBuffer byteBuffer;
        this.ensureAccessible();
        try {
            byteBuffer = (ByteBuffer)this.internalNioBuffer().clear().position(n2).limit(n2 + n3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IndexOutOfBoundsException("Too many bytes to read - Need " + (n2 + n3));
        }
        ByteBuf byteBuf = byteBuffer.isDirect() ? this.alloc().directBuffer(n3) : this.alloc().heapBuffer(n3);
        byteBuf.writeBytes(byteBuffer);
        return byteBuf;
    }

    @Override
    public int nioBufferCount() {
        return 1;
    }

    @Override
    public ByteBuffer[] nioBuffers(int n2, int n3) {
        return new ByteBuffer[]{this.nioBuffer(n2, n3)};
    }

    @Override
    public ByteBuffer nioBuffer(int n2, int n3) {
        return (ByteBuffer)this.buffer.duplicate().position(n2).limit(n2 + n3);
    }

    @Override
    public ByteBuffer internalNioBuffer(int n2, int n3) {
        this.ensureAccessible();
        return (ByteBuffer)this.internalNioBuffer().clear().position(n2).limit(n2 + n3);
    }

    @Override
    public boolean hasArray() {
        return this.buffer.hasArray();
    }

    @Override
    public byte[] array() {
        return this.buffer.array();
    }

    @Override
    public int arrayOffset() {
        return this.buffer.arrayOffset();
    }

    @Override
    public boolean hasMemoryAddress() {
        return false;
    }

    @Override
    public long memoryAddress() {
        throw new UnsupportedOperationException();
    }
}

