/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledHeapByteBuf;
import io.netty.buffer.PooledUnsafeHeapByteBuf$1;
import io.netty.buffer.SwappedByteBuf;
import io.netty.buffer.UnsafeByteBufUtil;
import io.netty.buffer.UnsafeHeapSwappedByteBuf;
import io.netty.util.Recycler;
import io.netty.util.Recycler$Handle;
import io.netty.util.internal.PlatformDependent;

final class PooledUnsafeHeapByteBuf
extends PooledHeapByteBuf {
    private static final Recycler<PooledUnsafeHeapByteBuf> RECYCLER = new PooledUnsafeHeapByteBuf$1();

    static PooledUnsafeHeapByteBuf newUnsafeInstance(int n2) {
        PooledUnsafeHeapByteBuf pooledUnsafeHeapByteBuf = RECYCLER.get();
        pooledUnsafeHeapByteBuf.reuse(n2);
        return pooledUnsafeHeapByteBuf;
    }

    private PooledUnsafeHeapByteBuf(Recycler$Handle<PooledUnsafeHeapByteBuf> recycler$Handle, int n2) {
        super((Recycler$Handle<? extends PooledHeapByteBuf>)recycler$Handle, n2);
    }

    @Override
    protected byte _getByte(int n2) {
        return UnsafeByteBufUtil.getByte((byte[])this.memory, this.idx(n2));
    }

    @Override
    protected short _getShort(int n2) {
        return UnsafeByteBufUtil.getShort((byte[])this.memory, this.idx(n2));
    }

    @Override
    protected short _getShortLE(int n2) {
        return UnsafeByteBufUtil.getShortLE((byte[])this.memory, this.idx(n2));
    }

    @Override
    protected int _getUnsignedMedium(int n2) {
        return UnsafeByteBufUtil.getUnsignedMedium((byte[])this.memory, this.idx(n2));
    }

    @Override
    protected int _getUnsignedMediumLE(int n2) {
        return UnsafeByteBufUtil.getUnsignedMediumLE((byte[])this.memory, this.idx(n2));
    }

    @Override
    protected int _getInt(int n2) {
        return UnsafeByteBufUtil.getInt((byte[])this.memory, this.idx(n2));
    }

    @Override
    protected int _getIntLE(int n2) {
        return UnsafeByteBufUtil.getIntLE((byte[])this.memory, this.idx(n2));
    }

    @Override
    protected long _getLong(int n2) {
        return UnsafeByteBufUtil.getLong((byte[])this.memory, this.idx(n2));
    }

    @Override
    protected long _getLongLE(int n2) {
        return UnsafeByteBufUtil.getLongLE((byte[])this.memory, this.idx(n2));
    }

    @Override
    protected void _setByte(int n2, int n3) {
        UnsafeByteBufUtil.setByte((byte[])this.memory, this.idx(n2), n3);
    }

    @Override
    protected void _setShort(int n2, int n3) {
        UnsafeByteBufUtil.setShort((byte[])this.memory, this.idx(n2), n3);
    }

    @Override
    protected void _setShortLE(int n2, int n3) {
        UnsafeByteBufUtil.setShortLE((byte[])this.memory, this.idx(n2), n3);
    }

    @Override
    protected void _setMedium(int n2, int n3) {
        UnsafeByteBufUtil.setMedium((byte[])this.memory, this.idx(n2), n3);
    }

    @Override
    protected void _setMediumLE(int n2, int n3) {
        UnsafeByteBufUtil.setMediumLE((byte[])this.memory, this.idx(n2), n3);
    }

    @Override
    protected void _setInt(int n2, int n3) {
        UnsafeByteBufUtil.setInt((byte[])this.memory, this.idx(n2), n3);
    }

    @Override
    protected void _setIntLE(int n2, int n3) {
        UnsafeByteBufUtil.setIntLE((byte[])this.memory, this.idx(n2), n3);
    }

    @Override
    protected void _setLong(int n2, long l2) {
        UnsafeByteBufUtil.setLong((byte[])this.memory, this.idx(n2), l2);
    }

    @Override
    protected void _setLongLE(int n2, long l2) {
        UnsafeByteBufUtil.setLongLE((byte[])this.memory, this.idx(n2), l2);
    }

    @Override
    public ByteBuf setZero(int n2, int n3) {
        if (PlatformDependent.javaVersion() >= 7) {
            this.checkIndex(n2, n3);
            UnsafeByteBufUtil.setZero((byte[])this.memory, this.idx(n2), n3);
            return this;
        }
        return super.setZero(n2, n3);
    }

    @Override
    public ByteBuf writeZero(int n2) {
        if (PlatformDependent.javaVersion() >= 7) {
            this.ensureWritable(n2);
            int n3 = this.writerIndex;
            UnsafeByteBufUtil.setZero((byte[])this.memory, this.idx(n3), n2);
            this.writerIndex = n3 + n2;
            return this;
        }
        return super.writeZero(n2);
    }

    @Override
    @Deprecated
    protected SwappedByteBuf newSwappedByteBuf() {
        if (PlatformDependent.isUnaligned()) {
            return new UnsafeHeapSwappedByteBuf(this);
        }
        return super.newSwappedByteBuf();
    }

    /* synthetic */ PooledUnsafeHeapByteBuf(Recycler$Handle recycler$Handle, int n2, PooledUnsafeHeapByteBuf$1 pooledUnsafeHeapByteBuf$1) {
        this(recycler$Handle, n2);
    }
}

