/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PoolChunk;
import io.netty.buffer.PoolThreadCache;
import io.netty.buffer.PooledByteBuf;
import io.netty.buffer.PooledUnsafeDirectByteBuf$1;
import io.netty.buffer.SwappedByteBuf;
import io.netty.buffer.UnsafeByteBufUtil;
import io.netty.buffer.UnsafeDirectSwappedByteBuf;
import io.netty.util.Recycler;
import io.netty.util.Recycler$Handle;
import io.netty.util.internal.PlatformDependent;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

final class PooledUnsafeDirectByteBuf
extends PooledByteBuf<ByteBuffer> {
    private static final Recycler<PooledUnsafeDirectByteBuf> RECYCLER = new PooledUnsafeDirectByteBuf$1();
    private long memoryAddress;

    static PooledUnsafeDirectByteBuf newInstance(int n2) {
        PooledUnsafeDirectByteBuf pooledUnsafeDirectByteBuf = RECYCLER.get();
        pooledUnsafeDirectByteBuf.reuse(n2);
        return pooledUnsafeDirectByteBuf;
    }

    private PooledUnsafeDirectByteBuf(Recycler$Handle<PooledUnsafeDirectByteBuf> recycler$Handle, int n2) {
        super(recycler$Handle, n2);
    }

    @Override
    void init(PoolChunk<ByteBuffer> poolChunk, long l2, int n2, int n3, int n4, PoolThreadCache poolThreadCache) {
        super.init(poolChunk, l2, n2, n3, n4, poolThreadCache);
        this.initMemoryAddress();
    }

    @Override
    void initUnpooled(PoolChunk<ByteBuffer> poolChunk, int n2) {
        super.initUnpooled(poolChunk, n2);
        this.initMemoryAddress();
    }

    private void initMemoryAddress() {
        this.memoryAddress = PlatformDependent.directBufferAddress((ByteBuffer)this.memory) + (long)this.offset;
    }

    @Override
    protected ByteBuffer newInternalNioBuffer(ByteBuffer byteBuffer) {
        return byteBuffer.duplicate();
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    protected byte _getByte(int n2) {
        return UnsafeByteBufUtil.getByte(this.addr(n2));
    }

    @Override
    protected short _getShort(int n2) {
        return UnsafeByteBufUtil.getShort(this.addr(n2));
    }

    @Override
    protected short _getShortLE(int n2) {
        return UnsafeByteBufUtil.getShortLE(this.addr(n2));
    }

    @Override
    protected int _getUnsignedMedium(int n2) {
        return UnsafeByteBufUtil.getUnsignedMedium(this.addr(n2));
    }

    @Override
    protected int _getUnsignedMediumLE(int n2) {
        return UnsafeByteBufUtil.getUnsignedMediumLE(this.addr(n2));
    }

    @Override
    protected int _getInt(int n2) {
        return UnsafeByteBufUtil.getInt(this.addr(n2));
    }

    @Override
    protected int _getIntLE(int n2) {
        return UnsafeByteBufUtil.getIntLE(this.addr(n2));
    }

    @Override
    protected long _getLong(int n2) {
        return UnsafeByteBufUtil.getLong(this.addr(n2));
    }

    @Override
    protected long _getLongLE(int n2) {
        return UnsafeByteBufUtil.getLongLE(this.addr(n2));
    }

    @Override
    public ByteBuf getBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        UnsafeByteBufUtil.getBytes((AbstractByteBuf)this, this.addr(n2), n2, byteBuf, n3, n4);
        return this;
    }

    @Override
    public ByteBuf getBytes(int n2, byte[] byArray, int n3, int n4) {
        UnsafeByteBufUtil.getBytes((AbstractByteBuf)this, this.addr(n2), n2, byArray, n3, n4);
        return this;
    }

    @Override
    public ByteBuf getBytes(int n2, ByteBuffer byteBuffer) {
        UnsafeByteBufUtil.getBytes(this, this.addr(n2), n2, byteBuffer);
        return this;
    }

    @Override
    public ByteBuf readBytes(ByteBuffer byteBuffer) {
        int n2 = byteBuffer.remaining();
        this.checkReadableBytes(n2);
        this.getBytes(this.readerIndex, byteBuffer);
        this.readerIndex += n2;
        return this;
    }

    @Override
    public ByteBuf getBytes(int n2, OutputStream outputStream, int n3) {
        UnsafeByteBufUtil.getBytes(this, this.addr(n2), n2, outputStream, n3);
        return this;
    }

    @Override
    public int getBytes(int n2, GatheringByteChannel gatheringByteChannel, int n3) {
        return this.getBytes(n2, gatheringByteChannel, n3, false);
    }

    private int getBytes(int n2, GatheringByteChannel gatheringByteChannel, int n3, boolean bl2) {
        this.checkIndex(n2, n3);
        if (n3 == 0) {
            return 0;
        }
        ByteBuffer byteBuffer = bl2 ? this.internalNioBuffer() : ((ByteBuffer)this.memory).duplicate();
        n2 = this.idx(n2);
        byteBuffer.clear().position(n2).limit(n2 + n3);
        return gatheringByteChannel.write(byteBuffer);
    }

    @Override
    public int getBytes(int n2, FileChannel fileChannel, long l2, int n3) {
        return this.getBytes(n2, fileChannel, l2, n3, false);
    }

    private int getBytes(int n2, FileChannel fileChannel, long l2, int n3, boolean bl2) {
        this.checkIndex(n2, n3);
        if (n3 == 0) {
            return 0;
        }
        ByteBuffer byteBuffer = bl2 ? this.internalNioBuffer() : ((ByteBuffer)this.memory).duplicate();
        n2 = this.idx(n2);
        byteBuffer.clear().position(n2).limit(n2 + n3);
        return fileChannel.write(byteBuffer, l2);
    }

    @Override
    public int readBytes(GatheringByteChannel gatheringByteChannel, int n2) {
        this.checkReadableBytes(n2);
        int n3 = this.getBytes(this.readerIndex, gatheringByteChannel, n2, true);
        this.readerIndex += n3;
        return n3;
    }

    @Override
    public int readBytes(FileChannel fileChannel, long l2, int n2) {
        this.checkReadableBytes(n2);
        int n3 = this.getBytes(this.readerIndex, fileChannel, l2, n2, true);
        this.readerIndex += n3;
        return n3;
    }

    @Override
    protected void _setByte(int n2, int n3) {
        UnsafeByteBufUtil.setByte(this.addr(n2), (byte)n3);
    }

    @Override
    protected void _setShort(int n2, int n3) {
        UnsafeByteBufUtil.setShort(this.addr(n2), n3);
    }

    @Override
    protected void _setShortLE(int n2, int n3) {
        UnsafeByteBufUtil.setShortLE(this.addr(n2), n3);
    }

    @Override
    protected void _setMedium(int n2, int n3) {
        UnsafeByteBufUtil.setMedium(this.addr(n2), n3);
    }

    @Override
    protected void _setMediumLE(int n2, int n3) {
        UnsafeByteBufUtil.setMediumLE(this.addr(n2), n3);
    }

    @Override
    protected void _setInt(int n2, int n3) {
        UnsafeByteBufUtil.setInt(this.addr(n2), n3);
    }

    @Override
    protected void _setIntLE(int n2, int n3) {
        UnsafeByteBufUtil.setIntLE(this.addr(n2), n3);
    }

    @Override
    protected void _setLong(int n2, long l2) {
        UnsafeByteBufUtil.setLong(this.addr(n2), l2);
    }

    @Override
    protected void _setLongLE(int n2, long l2) {
        UnsafeByteBufUtil.setLongLE(this.addr(n2), l2);
    }

    @Override
    public ByteBuf setBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        UnsafeByteBufUtil.setBytes((AbstractByteBuf)this, this.addr(n2), n2, byteBuf, n3, n4);
        return this;
    }

    @Override
    public ByteBuf setBytes(int n2, byte[] byArray, int n3, int n4) {
        UnsafeByteBufUtil.setBytes((AbstractByteBuf)this, this.addr(n2), n2, byArray, n3, n4);
        return this;
    }

    @Override
    public ByteBuf setBytes(int n2, ByteBuffer byteBuffer) {
        UnsafeByteBufUtil.setBytes(this, this.addr(n2), n2, byteBuffer);
        return this;
    }

    @Override
    public int setBytes(int n2, InputStream inputStream, int n3) {
        return UnsafeByteBufUtil.setBytes(this, this.addr(n2), n2, inputStream, n3);
    }

    @Override
    public int setBytes(int n2, ScatteringByteChannel scatteringByteChannel, int n3) {
        this.checkIndex(n2, n3);
        ByteBuffer byteBuffer = this.internalNioBuffer();
        n2 = this.idx(n2);
        byteBuffer.clear().position(n2).limit(n2 + n3);
        try {
            return scatteringByteChannel.read(byteBuffer);
        }
        catch (ClosedChannelException closedChannelException) {
            return -1;
        }
    }

    @Override
    public int setBytes(int n2, FileChannel fileChannel, long l2, int n3) {
        this.checkIndex(n2, n3);
        ByteBuffer byteBuffer = this.internalNioBuffer();
        n2 = this.idx(n2);
        byteBuffer.clear().position(n2).limit(n2 + n3);
        try {
            return fileChannel.read(byteBuffer, l2);
        }
        catch (ClosedChannelException closedChannelException) {
            return -1;
        }
    }

    @Override
    public ByteBuf copy(int n2, int n3) {
        return UnsafeByteBufUtil.copy(this, this.addr(n2), n2, n3);
    }

    @Override
    public int nioBufferCount() {
        return 1;
    }

    @Override
    public ByteBuffer[] nioBuffers(int n2, int n3) {
        return new ByteBuffer[]{this.nioBuffer(n2, n3)};
    }

    @Override
    public ByteBuffer nioBuffer(int n2, int n3) {
        this.checkIndex(n2, n3);
        n2 = this.idx(n2);
        return ((ByteBuffer)((ByteBuffer)this.memory).duplicate().position(n2).limit(n2 + n3)).slice();
    }

    @Override
    public ByteBuffer internalNioBuffer(int n2, int n3) {
        this.checkIndex(n2, n3);
        n2 = this.idx(n2);
        return (ByteBuffer)this.internalNioBuffer().clear().position(n2).limit(n2 + n3);
    }

    @Override
    public boolean hasArray() {
        return false;
    }

    @Override
    public byte[] array() {
        throw new UnsupportedOperationException("direct buffer");
    }

    @Override
    public int arrayOffset() {
        throw new UnsupportedOperationException("direct buffer");
    }

    @Override
    public boolean hasMemoryAddress() {
        return true;
    }

    @Override
    public long memoryAddress() {
        this.ensureAccessible();
        return this.memoryAddress;
    }

    private long addr(int n2) {
        return this.memoryAddress + (long)n2;
    }

    @Override
    protected SwappedByteBuf newSwappedByteBuf() {
        if (PlatformDependent.isUnaligned()) {
            return new UnsafeDirectSwappedByteBuf(this);
        }
        return super.newSwappedByteBuf();
    }

    @Override
    public ByteBuf setZero(int n2, int n3) {
        this.checkIndex(n2, n3);
        UnsafeByteBufUtil.setZero(this.addr(n2), n3);
        return this;
    }

    @Override
    public ByteBuf writeZero(int n2) {
        this.ensureWritable(n2);
        int n3 = this.writerIndex;
        UnsafeByteBufUtil.setZero(this.addr(n3), n2);
        this.writerIndex = n3 + n2;
        return this;
    }

    /* synthetic */ PooledUnsafeDirectByteBuf(Recycler$Handle recycler$Handle, int n2, PooledUnsafeDirectByteBuf$1 pooledUnsafeDirectByteBuf$1) {
        this(recycler$Handle, n2);
    }
}

