/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.AbstractPooledDerivedByteBuf;
import io.netty.buffer.AbstractUnpooledSlicedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledDuplicatedByteBuf;
import io.netty.buffer.PooledSlicedByteBuf$1;
import io.netty.util.ByteProcessor;
import io.netty.util.Recycler;
import io.netty.util.Recycler$Handle;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

final class PooledSlicedByteBuf
extends AbstractPooledDerivedByteBuf {
    private static final Recycler<PooledSlicedByteBuf> RECYCLER = new PooledSlicedByteBuf$1();
    int adjustment;

    static PooledSlicedByteBuf newInstance(AbstractByteBuf abstractByteBuf, ByteBuf byteBuf, int n2, int n3) {
        AbstractUnpooledSlicedByteBuf.checkSliceOutOfBounds(n2, n3, abstractByteBuf);
        return PooledSlicedByteBuf.newInstance0(abstractByteBuf, byteBuf, n2, n3);
    }

    private static PooledSlicedByteBuf newInstance0(AbstractByteBuf abstractByteBuf, ByteBuf byteBuf, int n2, int n3) {
        PooledSlicedByteBuf pooledSlicedByteBuf = RECYCLER.get();
        pooledSlicedByteBuf.init(abstractByteBuf, byteBuf, 0, n3, n3);
        pooledSlicedByteBuf.discardMarks();
        pooledSlicedByteBuf.adjustment = n2;
        return pooledSlicedByteBuf;
    }

    private PooledSlicedByteBuf(Recycler$Handle<PooledSlicedByteBuf> recycler$Handle) {
        super(recycler$Handle);
    }

    @Override
    public int capacity() {
        return this.maxCapacity();
    }

    @Override
    public ByteBuf capacity(int n2) {
        throw new UnsupportedOperationException("sliced buffer");
    }

    @Override
    public int arrayOffset() {
        return this.idx(this.unwrap().arrayOffset());
    }

    @Override
    public long memoryAddress() {
        return this.unwrap().memoryAddress() + (long)this.adjustment;
    }

    @Override
    public ByteBuffer nioBuffer(int n2, int n3) {
        this.checkIndex0(n2, n3);
        return this.unwrap().nioBuffer(this.idx(n2), n3);
    }

    @Override
    public ByteBuffer[] nioBuffers(int n2, int n3) {
        this.checkIndex0(n2, n3);
        return this.unwrap().nioBuffers(this.idx(n2), n3);
    }

    @Override
    public ByteBuf copy(int n2, int n3) {
        this.checkIndex0(n2, n3);
        return this.unwrap().copy(this.idx(n2), n3);
    }

    @Override
    public ByteBuf slice(int n2, int n3) {
        this.checkIndex0(n2, n3);
        return super.slice(this.idx(n2), n3);
    }

    @Override
    public ByteBuf retainedSlice(int n2, int n3) {
        this.checkIndex0(n2, n3);
        return PooledSlicedByteBuf.newInstance0(this.unwrap(), this, this.idx(n2), n3);
    }

    @Override
    public ByteBuf duplicate() {
        return this.duplicate0().setIndex(this.idx(this.readerIndex()), this.idx(this.writerIndex()));
    }

    @Override
    public ByteBuf retainedDuplicate() {
        return PooledDuplicatedByteBuf.newInstance(this.unwrap(), this, this.idx(this.readerIndex()), this.idx(this.writerIndex()));
    }

    @Override
    public byte getByte(int n2) {
        this.checkIndex0(n2, 1);
        return this.unwrap().getByte(this.idx(n2));
    }

    @Override
    protected byte _getByte(int n2) {
        return this.unwrap()._getByte(this.idx(n2));
    }

    @Override
    public short getShort(int n2) {
        this.checkIndex0(n2, 2);
        return this.unwrap().getShort(this.idx(n2));
    }

    @Override
    protected short _getShort(int n2) {
        return this.unwrap()._getShort(this.idx(n2));
    }

    @Override
    public short getShortLE(int n2) {
        this.checkIndex0(n2, 2);
        return this.unwrap().getShortLE(this.idx(n2));
    }

    @Override
    protected short _getShortLE(int n2) {
        return this.unwrap()._getShortLE(this.idx(n2));
    }

    @Override
    public int getUnsignedMedium(int n2) {
        this.checkIndex0(n2, 3);
        return this.unwrap().getUnsignedMedium(this.idx(n2));
    }

    @Override
    protected int _getUnsignedMedium(int n2) {
        return this.unwrap()._getUnsignedMedium(this.idx(n2));
    }

    @Override
    public int getUnsignedMediumLE(int n2) {
        this.checkIndex0(n2, 3);
        return this.unwrap().getUnsignedMediumLE(this.idx(n2));
    }

    @Override
    protected int _getUnsignedMediumLE(int n2) {
        return this.unwrap()._getUnsignedMediumLE(this.idx(n2));
    }

    @Override
    public int getInt(int n2) {
        this.checkIndex0(n2, 4);
        return this.unwrap().getInt(this.idx(n2));
    }

    @Override
    protected int _getInt(int n2) {
        return this.unwrap()._getInt(this.idx(n2));
    }

    @Override
    public int getIntLE(int n2) {
        this.checkIndex0(n2, 4);
        return this.unwrap().getIntLE(this.idx(n2));
    }

    @Override
    protected int _getIntLE(int n2) {
        return this.unwrap()._getIntLE(this.idx(n2));
    }

    @Override
    public long getLong(int n2) {
        this.checkIndex0(n2, 8);
        return this.unwrap().getLong(this.idx(n2));
    }

    @Override
    protected long _getLong(int n2) {
        return this.unwrap()._getLong(this.idx(n2));
    }

    @Override
    public long getLongLE(int n2) {
        this.checkIndex0(n2, 8);
        return this.unwrap().getLongLE(this.idx(n2));
    }

    @Override
    protected long _getLongLE(int n2) {
        return this.unwrap()._getLongLE(this.idx(n2));
    }

    @Override
    public ByteBuf getBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        this.checkIndex0(n2, n4);
        this.unwrap().getBytes(this.idx(n2), byteBuf, n3, n4);
        return this;
    }

    @Override
    public ByteBuf getBytes(int n2, byte[] byArray, int n3, int n4) {
        this.checkIndex0(n2, n4);
        this.unwrap().getBytes(this.idx(n2), byArray, n3, n4);
        return this;
    }

    @Override
    public ByteBuf getBytes(int n2, ByteBuffer byteBuffer) {
        this.checkIndex0(n2, byteBuffer.remaining());
        this.unwrap().getBytes(this.idx(n2), byteBuffer);
        return this;
    }

    @Override
    public ByteBuf setByte(int n2, int n3) {
        this.checkIndex0(n2, 1);
        this.unwrap().setByte(this.idx(n2), n3);
        return this;
    }

    @Override
    protected void _setByte(int n2, int n3) {
        this.unwrap()._setByte(this.idx(n2), n3);
    }

    @Override
    public ByteBuf setShort(int n2, int n3) {
        this.checkIndex0(n2, 2);
        this.unwrap().setShort(this.idx(n2), n3);
        return this;
    }

    @Override
    protected void _setShort(int n2, int n3) {
        this.unwrap()._setShort(this.idx(n2), n3);
    }

    @Override
    public ByteBuf setShortLE(int n2, int n3) {
        this.checkIndex0(n2, 2);
        this.unwrap().setShortLE(this.idx(n2), n3);
        return this;
    }

    @Override
    protected void _setShortLE(int n2, int n3) {
        this.unwrap()._setShortLE(this.idx(n2), n3);
    }

    @Override
    public ByteBuf setMedium(int n2, int n3) {
        this.checkIndex0(n2, 3);
        this.unwrap().setMedium(this.idx(n2), n3);
        return this;
    }

    @Override
    protected void _setMedium(int n2, int n3) {
        this.unwrap()._setMedium(this.idx(n2), n3);
    }

    @Override
    public ByteBuf setMediumLE(int n2, int n3) {
        this.checkIndex0(n2, 3);
        this.unwrap().setMediumLE(this.idx(n2), n3);
        return this;
    }

    @Override
    protected void _setMediumLE(int n2, int n3) {
        this.unwrap()._setMediumLE(this.idx(n2), n3);
    }

    @Override
    public ByteBuf setInt(int n2, int n3) {
        this.checkIndex0(n2, 4);
        this.unwrap().setInt(this.idx(n2), n3);
        return this;
    }

    @Override
    protected void _setInt(int n2, int n3) {
        this.unwrap()._setInt(this.idx(n2), n3);
    }

    @Override
    public ByteBuf setIntLE(int n2, int n3) {
        this.checkIndex0(n2, 4);
        this.unwrap().setIntLE(this.idx(n2), n3);
        return this;
    }

    @Override
    protected void _setIntLE(int n2, int n3) {
        this.unwrap()._setIntLE(this.idx(n2), n3);
    }

    @Override
    public ByteBuf setLong(int n2, long l2) {
        this.checkIndex0(n2, 8);
        this.unwrap().setLong(this.idx(n2), l2);
        return this;
    }

    @Override
    protected void _setLong(int n2, long l2) {
        this.unwrap()._setLong(this.idx(n2), l2);
    }

    @Override
    public ByteBuf setLongLE(int n2, long l2) {
        this.checkIndex0(n2, 8);
        this.unwrap().setLongLE(this.idx(n2), l2);
        return this;
    }

    @Override
    protected void _setLongLE(int n2, long l2) {
        this.unwrap().setLongLE(this.idx(n2), l2);
    }

    @Override
    public ByteBuf setBytes(int n2, byte[] byArray, int n3, int n4) {
        this.checkIndex0(n2, n4);
        this.unwrap().setBytes(this.idx(n2), byArray, n3, n4);
        return this;
    }

    @Override
    public ByteBuf setBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        this.checkIndex0(n2, n4);
        this.unwrap().setBytes(this.idx(n2), byteBuf, n3, n4);
        return this;
    }

    @Override
    public ByteBuf setBytes(int n2, ByteBuffer byteBuffer) {
        this.checkIndex0(n2, byteBuffer.remaining());
        this.unwrap().setBytes(this.idx(n2), byteBuffer);
        return this;
    }

    @Override
    public ByteBuf getBytes(int n2, OutputStream outputStream, int n3) {
        this.checkIndex0(n2, n3);
        this.unwrap().getBytes(this.idx(n2), outputStream, n3);
        return this;
    }

    @Override
    public int getBytes(int n2, GatheringByteChannel gatheringByteChannel, int n3) {
        this.checkIndex0(n2, n3);
        return this.unwrap().getBytes(this.idx(n2), gatheringByteChannel, n3);
    }

    @Override
    public int getBytes(int n2, FileChannel fileChannel, long l2, int n3) {
        this.checkIndex0(n2, n3);
        return this.unwrap().getBytes(this.idx(n2), fileChannel, l2, n3);
    }

    @Override
    public int setBytes(int n2, InputStream inputStream, int n3) {
        this.checkIndex0(n2, n3);
        return this.unwrap().setBytes(this.idx(n2), inputStream, n3);
    }

    @Override
    public int setBytes(int n2, ScatteringByteChannel scatteringByteChannel, int n3) {
        this.checkIndex0(n2, n3);
        return this.unwrap().setBytes(this.idx(n2), scatteringByteChannel, n3);
    }

    @Override
    public int setBytes(int n2, FileChannel fileChannel, long l2, int n3) {
        this.checkIndex0(n2, n3);
        return this.unwrap().setBytes(this.idx(n2), fileChannel, l2, n3);
    }

    @Override
    public int forEachByte(int n2, int n3, ByteProcessor byteProcessor) {
        this.checkIndex0(n2, n3);
        int n4 = this.unwrap().forEachByte(this.idx(n2), n3, byteProcessor);
        if (n4 < this.adjustment) {
            return -1;
        }
        return n4 - this.adjustment;
    }

    @Override
    public int forEachByteDesc(int n2, int n3, ByteProcessor byteProcessor) {
        this.checkIndex0(n2, n3);
        int n4 = this.unwrap().forEachByteDesc(this.idx(n2), n3, byteProcessor);
        if (n4 < this.adjustment) {
            return -1;
        }
        return n4 - this.adjustment;
    }

    private int idx(int n2) {
        return n2 + this.adjustment;
    }

    /* synthetic */ PooledSlicedByteBuf(Recycler$Handle recycler$Handle, PooledSlicedByteBuf$1 pooledSlicedByteBuf$1) {
        this(recycler$Handle);
    }
}

