/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.PooledByteBuf;
import io.netty.buffer.PooledDirectByteBuf$1;
import io.netty.util.Recycler;
import io.netty.util.Recycler$Handle;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

final class PooledDirectByteBuf
extends PooledByteBuf<ByteBuffer> {
    private static final Recycler<PooledDirectByteBuf> RECYCLER = new PooledDirectByteBuf$1();

    static PooledDirectByteBuf newInstance(int n2) {
        PooledDirectByteBuf pooledDirectByteBuf = RECYCLER.get();
        pooledDirectByteBuf.reuse(n2);
        return pooledDirectByteBuf;
    }

    private PooledDirectByteBuf(Recycler$Handle<PooledDirectByteBuf> recycler$Handle, int n2) {
        super(recycler$Handle, n2);
    }

    @Override
    protected ByteBuffer newInternalNioBuffer(ByteBuffer byteBuffer) {
        return byteBuffer.duplicate();
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    protected byte _getByte(int n2) {
        return ((ByteBuffer)this.memory).get(this.idx(n2));
    }

    @Override
    protected short _getShort(int n2) {
        return ((ByteBuffer)this.memory).getShort(this.idx(n2));
    }

    @Override
    protected short _getShortLE(int n2) {
        return ByteBufUtil.swapShort(this._getShort(n2));
    }

    @Override
    protected int _getUnsignedMedium(int n2) {
        n2 = this.idx(n2);
        return (((ByteBuffer)this.memory).get(n2) & 0xFF) << 16 | (((ByteBuffer)this.memory).get(n2 + 1) & 0xFF) << 8 | ((ByteBuffer)this.memory).get(n2 + 2) & 0xFF;
    }

    @Override
    protected int _getUnsignedMediumLE(int n2) {
        n2 = this.idx(n2);
        return ((ByteBuffer)this.memory).get(n2) & 0xFF | (((ByteBuffer)this.memory).get(n2 + 1) & 0xFF) << 8 | (((ByteBuffer)this.memory).get(n2 + 2) & 0xFF) << 16;
    }

    @Override
    protected int _getInt(int n2) {
        return ((ByteBuffer)this.memory).getInt(this.idx(n2));
    }

    @Override
    protected int _getIntLE(int n2) {
        return ByteBufUtil.swapInt(this._getInt(n2));
    }

    @Override
    protected long _getLong(int n2) {
        return ((ByteBuffer)this.memory).getLong(this.idx(n2));
    }

    @Override
    protected long _getLongLE(int n2) {
        return ByteBufUtil.swapLong(this._getLong(n2));
    }

    @Override
    public ByteBuf getBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        this.checkDstIndex(n2, n4, n3, byteBuf.capacity());
        if (byteBuf.hasArray()) {
            this.getBytes(n2, byteBuf.array(), byteBuf.arrayOffset() + n3, n4);
        } else if (byteBuf.nioBufferCount() > 0) {
            for (ByteBuffer byteBuffer : byteBuf.nioBuffers(n3, n4)) {
                int n5 = byteBuffer.remaining();
                this.getBytes(n2, byteBuffer);
                n2 += n5;
            }
        } else {
            byteBuf.setBytes(n3, this, n2, n4);
        }
        return this;
    }

    @Override
    public ByteBuf getBytes(int n2, byte[] byArray, int n3, int n4) {
        this.getBytes(n2, byArray, n3, n4, false);
        return this;
    }

    private void getBytes(int n2, byte[] byArray, int n3, int n4, boolean bl2) {
        this.checkDstIndex(n2, n4, n3, byArray.length);
        ByteBuffer byteBuffer = bl2 ? this.internalNioBuffer() : ((ByteBuffer)this.memory).duplicate();
        n2 = this.idx(n2);
        byteBuffer.clear().position(n2).limit(n2 + n4);
        byteBuffer.get(byArray, n3, n4);
    }

    @Override
    public ByteBuf readBytes(byte[] byArray, int n2, int n3) {
        this.checkReadableBytes(n3);
        this.getBytes(this.readerIndex, byArray, n2, n3, true);
        this.readerIndex += n3;
        return this;
    }

    @Override
    public ByteBuf getBytes(int n2, ByteBuffer byteBuffer) {
        this.getBytes(n2, byteBuffer, false);
        return this;
    }

    private void getBytes(int n2, ByteBuffer byteBuffer, boolean bl2) {
        this.checkIndex(n2, byteBuffer.remaining());
        ByteBuffer byteBuffer2 = bl2 ? this.internalNioBuffer() : ((ByteBuffer)this.memory).duplicate();
        n2 = this.idx(n2);
        byteBuffer2.clear().position(n2).limit(n2 + byteBuffer.remaining());
        byteBuffer.put(byteBuffer2);
    }

    @Override
    public ByteBuf readBytes(ByteBuffer byteBuffer) {
        int n2 = byteBuffer.remaining();
        this.checkReadableBytes(n2);
        this.getBytes(this.readerIndex, byteBuffer, true);
        this.readerIndex += n2;
        return this;
    }

    @Override
    public ByteBuf getBytes(int n2, OutputStream outputStream, int n3) {
        this.getBytes(n2, outputStream, n3, false);
        return this;
    }

    private void getBytes(int n2, OutputStream outputStream, int n3, boolean bl2) {
        this.checkIndex(n2, n3);
        if (n3 == 0) {
            return;
        }
        ByteBufUtil.readBytes(this.alloc(), bl2 ? this.internalNioBuffer() : ((ByteBuffer)this.memory).duplicate(), this.idx(n2), n3, outputStream);
    }

    @Override
    public ByteBuf readBytes(OutputStream outputStream, int n2) {
        this.checkReadableBytes(n2);
        this.getBytes(this.readerIndex, outputStream, n2, true);
        this.readerIndex += n2;
        return this;
    }

    @Override
    public int getBytes(int n2, GatheringByteChannel gatheringByteChannel, int n3) {
        return this.getBytes(n2, gatheringByteChannel, n3, false);
    }

    private int getBytes(int n2, GatheringByteChannel gatheringByteChannel, int n3, boolean bl2) {
        this.checkIndex(n2, n3);
        if (n3 == 0) {
            return 0;
        }
        ByteBuffer byteBuffer = bl2 ? this.internalNioBuffer() : ((ByteBuffer)this.memory).duplicate();
        n2 = this.idx(n2);
        byteBuffer.clear().position(n2).limit(n2 + n3);
        return gatheringByteChannel.write(byteBuffer);
    }

    @Override
    public int getBytes(int n2, FileChannel fileChannel, long l2, int n3) {
        return this.getBytes(n2, fileChannel, l2, n3, false);
    }

    private int getBytes(int n2, FileChannel fileChannel, long l2, int n3, boolean bl2) {
        this.checkIndex(n2, n3);
        if (n3 == 0) {
            return 0;
        }
        ByteBuffer byteBuffer = bl2 ? this.internalNioBuffer() : ((ByteBuffer)this.memory).duplicate();
        n2 = this.idx(n2);
        byteBuffer.clear().position(n2).limit(n2 + n3);
        return fileChannel.write(byteBuffer, l2);
    }

    @Override
    public int readBytes(GatheringByteChannel gatheringByteChannel, int n2) {
        this.checkReadableBytes(n2);
        int n3 = this.getBytes(this.readerIndex, gatheringByteChannel, n2, true);
        this.readerIndex += n3;
        return n3;
    }

    @Override
    public int readBytes(FileChannel fileChannel, long l2, int n2) {
        this.checkReadableBytes(n2);
        int n3 = this.getBytes(this.readerIndex, fileChannel, l2, n2, true);
        this.readerIndex += n3;
        return n3;
    }

    @Override
    protected void _setByte(int n2, int n3) {
        ((ByteBuffer)this.memory).put(this.idx(n2), (byte)n3);
    }

    @Override
    protected void _setShort(int n2, int n3) {
        ((ByteBuffer)this.memory).putShort(this.idx(n2), (short)n3);
    }

    @Override
    protected void _setShortLE(int n2, int n3) {
        this._setShort(n2, ByteBufUtil.swapShort((short)n3));
    }

    @Override
    protected void _setMedium(int n2, int n3) {
        n2 = this.idx(n2);
        ((ByteBuffer)this.memory).put(n2, (byte)(n3 >>> 16));
        ((ByteBuffer)this.memory).put(n2 + 1, (byte)(n3 >>> 8));
        ((ByteBuffer)this.memory).put(n2 + 2, (byte)n3);
    }

    @Override
    protected void _setMediumLE(int n2, int n3) {
        n2 = this.idx(n2);
        ((ByteBuffer)this.memory).put(n2, (byte)n3);
        ((ByteBuffer)this.memory).put(n2 + 1, (byte)(n3 >>> 8));
        ((ByteBuffer)this.memory).put(n2 + 2, (byte)(n3 >>> 16));
    }

    @Override
    protected void _setInt(int n2, int n3) {
        ((ByteBuffer)this.memory).putInt(this.idx(n2), n3);
    }

    @Override
    protected void _setIntLE(int n2, int n3) {
        this._setInt(n2, ByteBufUtil.swapInt(n3));
    }

    @Override
    protected void _setLong(int n2, long l2) {
        ((ByteBuffer)this.memory).putLong(this.idx(n2), l2);
    }

    @Override
    protected void _setLongLE(int n2, long l2) {
        this._setLong(n2, ByteBufUtil.swapLong(l2));
    }

    @Override
    public ByteBuf setBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        this.checkSrcIndex(n2, n4, n3, byteBuf.capacity());
        if (byteBuf.hasArray()) {
            this.setBytes(n2, byteBuf.array(), byteBuf.arrayOffset() + n3, n4);
        } else if (byteBuf.nioBufferCount() > 0) {
            for (ByteBuffer byteBuffer : byteBuf.nioBuffers(n3, n4)) {
                int n5 = byteBuffer.remaining();
                this.setBytes(n2, byteBuffer);
                n2 += n5;
            }
        } else {
            byteBuf.getBytes(n3, this, n2, n4);
        }
        return this;
    }

    @Override
    public ByteBuf setBytes(int n2, byte[] byArray, int n3, int n4) {
        this.checkSrcIndex(n2, n4, n3, byArray.length);
        ByteBuffer byteBuffer = this.internalNioBuffer();
        n2 = this.idx(n2);
        byteBuffer.clear().position(n2).limit(n2 + n4);
        byteBuffer.put(byArray, n3, n4);
        return this;
    }

    @Override
    public ByteBuf setBytes(int n2, ByteBuffer byteBuffer) {
        this.checkIndex(n2, byteBuffer.remaining());
        ByteBuffer byteBuffer2 = this.internalNioBuffer();
        if (byteBuffer == byteBuffer2) {
            byteBuffer = byteBuffer.duplicate();
        }
        n2 = this.idx(n2);
        byteBuffer2.clear().position(n2).limit(n2 + byteBuffer.remaining());
        byteBuffer2.put(byteBuffer);
        return this;
    }

    @Override
    public int setBytes(int n2, InputStream inputStream, int n3) {
        this.checkIndex(n2, n3);
        byte[] byArray = new byte[n3];
        int n4 = inputStream.read(byArray);
        if (n4 <= 0) {
            return n4;
        }
        ByteBuffer byteBuffer = this.internalNioBuffer();
        byteBuffer.clear().position(this.idx(n2));
        byteBuffer.put(byArray, 0, n4);
        return n4;
    }

    @Override
    public int setBytes(int n2, ScatteringByteChannel scatteringByteChannel, int n3) {
        this.checkIndex(n2, n3);
        ByteBuffer byteBuffer = this.internalNioBuffer();
        n2 = this.idx(n2);
        byteBuffer.clear().position(n2).limit(n2 + n3);
        try {
            return scatteringByteChannel.read(byteBuffer);
        }
        catch (ClosedChannelException closedChannelException) {
            return -1;
        }
    }

    @Override
    public int setBytes(int n2, FileChannel fileChannel, long l2, int n3) {
        this.checkIndex(n2, n3);
        ByteBuffer byteBuffer = this.internalNioBuffer();
        n2 = this.idx(n2);
        byteBuffer.clear().position(n2).limit(n2 + n3);
        try {
            return fileChannel.read(byteBuffer, l2);
        }
        catch (ClosedChannelException closedChannelException) {
            return -1;
        }
    }

    @Override
    public ByteBuf copy(int n2, int n3) {
        this.checkIndex(n2, n3);
        ByteBuf byteBuf = this.alloc().directBuffer(n3, this.maxCapacity());
        byteBuf.writeBytes(this, n2, n3);
        return byteBuf;
    }

    @Override
    public int nioBufferCount() {
        return 1;
    }

    @Override
    public ByteBuffer nioBuffer(int n2, int n3) {
        this.checkIndex(n2, n3);
        n2 = this.idx(n2);
        return ((ByteBuffer)((ByteBuffer)this.memory).duplicate().position(n2).limit(n2 + n3)).slice();
    }

    @Override
    public ByteBuffer[] nioBuffers(int n2, int n3) {
        return new ByteBuffer[]{this.nioBuffer(n2, n3)};
    }

    @Override
    public ByteBuffer internalNioBuffer(int n2, int n3) {
        this.checkIndex(n2, n3);
        n2 = this.idx(n2);
        return (ByteBuffer)this.internalNioBuffer().clear().position(n2).limit(n2 + n3);
    }

    @Override
    public boolean hasArray() {
        return false;
    }

    @Override
    public byte[] array() {
        throw new UnsupportedOperationException("direct buffer");
    }

    @Override
    public int arrayOffset() {
        throw new UnsupportedOperationException("direct buffer");
    }

    @Override
    public boolean hasMemoryAddress() {
        return false;
    }

    @Override
    public long memoryAddress() {
        throw new UnsupportedOperationException();
    }

    /* synthetic */ PooledDirectByteBuf(Recycler$Handle recycler$Handle, int n2, PooledDirectByteBuf$1 pooledDirectByteBuf$1) {
        this(recycler$Handle, n2);
    }
}

