/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBufAllocator;
import io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufAllocatorMetricProvider;
import io.netty.buffer.PoolArena;
import io.netty.buffer.PoolArena$DirectArena;
import io.netty.buffer.PoolArena$HeapArena;
import io.netty.buffer.PoolArenaMetric;
import io.netty.buffer.PoolThreadCache;
import io.netty.buffer.PooledByteBufAllocator$PoolThreadLocalCache;
import io.netty.buffer.PooledByteBufAllocatorMetric;
import io.netty.buffer.UnpooledDirectByteBuf;
import io.netty.buffer.UnpooledHeapByteBuf;
import io.netty.buffer.UnpooledUnsafeHeapByteBuf;
import io.netty.buffer.UnsafeByteBufUtil;
import io.netty.util.NettyRuntime;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PooledByteBufAllocator
extends AbstractByteBufAllocator
implements ByteBufAllocatorMetricProvider {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PooledByteBufAllocator.class);
    private static final int DEFAULT_NUM_HEAP_ARENA;
    private static final int DEFAULT_NUM_DIRECT_ARENA;
    private static final int DEFAULT_PAGE_SIZE;
    private static final int DEFAULT_MAX_ORDER;
    private static final int DEFAULT_TINY_CACHE_SIZE;
    private static final int DEFAULT_SMALL_CACHE_SIZE;
    private static final int DEFAULT_NORMAL_CACHE_SIZE;
    private static final int DEFAULT_MAX_CACHED_BUFFER_CAPACITY;
    private static final int DEFAULT_CACHE_TRIM_INTERVAL;
    private static final boolean DEFAULT_USE_CACHE_FOR_ALL_THREADS;
    private static final int DEFAULT_DIRECT_MEMORY_CACHE_ALIGNMENT;
    private static final int MIN_PAGE_SIZE = 4096;
    private static final int MAX_CHUNK_SIZE = 0x40000000;
    public static final PooledByteBufAllocator DEFAULT;
    private final PoolArena<byte[]>[] heapArenas;
    private final PoolArena<ByteBuffer>[] directArenas;
    private final int tinyCacheSize;
    private final int smallCacheSize;
    private final int normalCacheSize;
    private final List<PoolArenaMetric> heapArenaMetrics;
    private final List<PoolArenaMetric> directArenaMetrics;
    private final PooledByteBufAllocator$PoolThreadLocalCache threadCache;
    private final int chunkSize;
    private final PooledByteBufAllocatorMetric metric;

    public PooledByteBufAllocator() {
        this(false);
    }

    public PooledByteBufAllocator(boolean bl2) {
        this(bl2, DEFAULT_NUM_HEAP_ARENA, DEFAULT_NUM_DIRECT_ARENA, DEFAULT_PAGE_SIZE, DEFAULT_MAX_ORDER);
    }

    public PooledByteBufAllocator(int n2, int n3, int n4, int n5) {
        this(false, n2, n3, n4, n5);
    }

    @Deprecated
    public PooledByteBufAllocator(boolean bl2, int n2, int n3, int n4, int n5) {
        this(bl2, n2, n3, n4, n5, DEFAULT_TINY_CACHE_SIZE, DEFAULT_SMALL_CACHE_SIZE, DEFAULT_NORMAL_CACHE_SIZE);
    }

    @Deprecated
    public PooledByteBufAllocator(boolean bl2, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this(bl2, n2, n3, n4, n5, n6, n7, n8, DEFAULT_USE_CACHE_FOR_ALL_THREADS, DEFAULT_DIRECT_MEMORY_CACHE_ALIGNMENT);
    }

    public PooledByteBufAllocator(boolean bl2, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl3) {
        this(bl2, n2, n3, n4, n5, n6, n7, n8, bl3, DEFAULT_DIRECT_MEMORY_CACHE_ALIGNMENT);
    }

    public PooledByteBufAllocator(boolean bl2, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl3, int n9) {
        super(bl2);
        PoolArena poolArena;
        int n10;
        ArrayList<PoolArena$HeapArena> arrayList;
        this.threadCache = new PooledByteBufAllocator$PoolThreadLocalCache(this, bl3);
        this.tinyCacheSize = n6;
        this.smallCacheSize = n7;
        this.normalCacheSize = n8;
        this.chunkSize = PooledByteBufAllocator.validateAndCalculateChunkSize(n4, n5);
        if (n2 < 0) {
            throw new IllegalArgumentException("nHeapArena: " + n2 + " (expected: >= 0)");
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("nDirectArea: " + n3 + " (expected: >= 0)");
        }
        if (n9 < 0) {
            throw new IllegalArgumentException("directMemoryCacheAlignment: " + n9 + " (expected: >= 0)");
        }
        if (n9 > 0 && !PooledByteBufAllocator.isDirectMemoryCacheAlignmentSupported()) {
            throw new IllegalArgumentException("directMemoryCacheAlignment is not supported");
        }
        if ((n9 & -n9) != n9) {
            throw new IllegalArgumentException("directMemoryCacheAlignment: " + n9 + " (expected: power of two)");
        }
        int n11 = PooledByteBufAllocator.validateAndCalculatePageShifts(n4);
        if (n2 > 0) {
            this.heapArenas = PooledByteBufAllocator.newArenaArray(n2);
            arrayList = new ArrayList<PoolArena$HeapArena>(this.heapArenas.length);
            for (n10 = 0; n10 < this.heapArenas.length; ++n10) {
                this.heapArenas[n10] = poolArena = new PoolArena$HeapArena(this, n4, n5, n11, this.chunkSize, n9);
                arrayList.add((PoolArena$HeapArena)poolArena);
            }
            this.heapArenaMetrics = Collections.unmodifiableList(arrayList);
        } else {
            this.heapArenas = null;
            this.heapArenaMetrics = Collections.emptyList();
        }
        if (n3 > 0) {
            this.directArenas = PooledByteBufAllocator.newArenaArray(n3);
            arrayList = new ArrayList(this.directArenas.length);
            for (n10 = 0; n10 < this.directArenas.length; ++n10) {
                this.directArenas[n10] = poolArena = new PoolArena$DirectArena(this, n4, n5, n11, this.chunkSize, n9);
                arrayList.add((PoolArena$HeapArena)poolArena);
            }
            this.directArenaMetrics = Collections.unmodifiableList(arrayList);
        } else {
            this.directArenas = null;
            this.directArenaMetrics = Collections.emptyList();
        }
        this.metric = new PooledByteBufAllocatorMetric(this);
    }

    private static <T> PoolArena<T>[] newArenaArray(int n2) {
        return new PoolArena[n2];
    }

    private static int validateAndCalculatePageShifts(int n2) {
        if (n2 < 4096) {
            throw new IllegalArgumentException("pageSize: " + n2 + " (expected: " + 4096 + ")");
        }
        if ((n2 & n2 - 1) != 0) {
            throw new IllegalArgumentException("pageSize: " + n2 + " (expected: power of 2)");
        }
        return 31 - Integer.numberOfLeadingZeros(n2);
    }

    private static int validateAndCalculateChunkSize(int n2, int n3) {
        if (n3 > 14) {
            throw new IllegalArgumentException("maxOrder: " + n3 + " (expected: 0-14)");
        }
        int n4 = n2;
        for (int i2 = n3; i2 > 0; --i2) {
            if (n4 > 0x20000000) {
                throw new IllegalArgumentException(String.format("pageSize (%d) << maxOrder (%d) must not exceed %d", n2, n3, 0x40000000));
            }
            n4 <<= 1;
        }
        return n4;
    }

    @Override
    protected ByteBuf newHeapBuffer(int n2, int n3) {
        PoolThreadCache poolThreadCache = (PoolThreadCache)this.threadCache.get();
        PoolArena<byte[]> poolArena = poolThreadCache.heapArena;
        AbstractReferenceCountedByteBuf abstractReferenceCountedByteBuf = poolArena != null ? poolArena.allocate(poolThreadCache, n2, n3) : (PlatformDependent.hasUnsafe() ? new UnpooledUnsafeHeapByteBuf((ByteBufAllocator)this, n2, n3) : new UnpooledHeapByteBuf((ByteBufAllocator)this, n2, n3));
        return PooledByteBufAllocator.toLeakAwareBuffer(abstractReferenceCountedByteBuf);
    }

    @Override
    protected ByteBuf newDirectBuffer(int n2, int n3) {
        PoolThreadCache poolThreadCache = (PoolThreadCache)this.threadCache.get();
        PoolArena<ByteBuffer> poolArena = poolThreadCache.directArena;
        AbstractReferenceCountedByteBuf abstractReferenceCountedByteBuf = poolArena != null ? poolArena.allocate(poolThreadCache, n2, n3) : (PlatformDependent.hasUnsafe() ? UnsafeByteBufUtil.newUnsafeDirectByteBuf(this, n2, n3) : new UnpooledDirectByteBuf((ByteBufAllocator)this, n2, n3));
        return PooledByteBufAllocator.toLeakAwareBuffer(abstractReferenceCountedByteBuf);
    }

    public static int defaultNumHeapArena() {
        return DEFAULT_NUM_HEAP_ARENA;
    }

    public static int defaultNumDirectArena() {
        return DEFAULT_NUM_DIRECT_ARENA;
    }

    public static int defaultPageSize() {
        return DEFAULT_PAGE_SIZE;
    }

    public static int defaultMaxOrder() {
        return DEFAULT_MAX_ORDER;
    }

    public static boolean defaultUseCacheForAllThreads() {
        return DEFAULT_USE_CACHE_FOR_ALL_THREADS;
    }

    public static boolean defaultPreferDirect() {
        return PlatformDependent.directBufferPreferred();
    }

    public static int defaultTinyCacheSize() {
        return DEFAULT_TINY_CACHE_SIZE;
    }

    public static int defaultSmallCacheSize() {
        return DEFAULT_SMALL_CACHE_SIZE;
    }

    public static int defaultNormalCacheSize() {
        return DEFAULT_NORMAL_CACHE_SIZE;
    }

    public static boolean isDirectMemoryCacheAlignmentSupported() {
        return PlatformDependent.hasUnsafe();
    }

    @Override
    public boolean isDirectBufferPooled() {
        return this.directArenas != null;
    }

    @Deprecated
    public boolean hasThreadLocalCache() {
        return this.threadCache.isSet();
    }

    @Deprecated
    public void freeThreadLocalCache() {
        this.threadCache.remove();
    }

    @Override
    public PooledByteBufAllocatorMetric metric() {
        return this.metric;
    }

    @Deprecated
    public int numHeapArenas() {
        return this.heapArenaMetrics.size();
    }

    @Deprecated
    public int numDirectArenas() {
        return this.directArenaMetrics.size();
    }

    @Deprecated
    public List<PoolArenaMetric> heapArenas() {
        return this.heapArenaMetrics;
    }

    @Deprecated
    public List<PoolArenaMetric> directArenas() {
        return this.directArenaMetrics;
    }

    @Deprecated
    public int numThreadLocalCaches() {
        PoolArena<Object>[] poolArenaArray;
        PoolArena<Object>[] poolArenaArray2 = poolArenaArray = this.heapArenas != null ? this.heapArenas : this.directArenas;
        if (poolArenaArray == null) {
            return 0;
        }
        int n2 = 0;
        for (PoolArena<Object> poolArena : poolArenaArray) {
            n2 += poolArena.numThreadCaches.get();
        }
        return n2;
    }

    @Deprecated
    public int tinyCacheSize() {
        return this.tinyCacheSize;
    }

    @Deprecated
    public int smallCacheSize() {
        return this.smallCacheSize;
    }

    @Deprecated
    public int normalCacheSize() {
        return this.normalCacheSize;
    }

    @Deprecated
    public final int chunkSize() {
        return this.chunkSize;
    }

    final long usedHeapMemory() {
        return PooledByteBufAllocator.usedMemory(this.heapArenas);
    }

    final long usedDirectMemory() {
        return PooledByteBufAllocator.usedMemory(this.directArenas);
    }

    private static long usedMemory(PoolArena<?> ... poolArenaArray) {
        if (poolArenaArray == null) {
            return -1L;
        }
        long l2 = 0L;
        for (PoolArena<?> poolArena : poolArenaArray) {
            if ((l2 += poolArena.numActiveBytes()) >= 0L) continue;
            return Long.MAX_VALUE;
        }
        return l2;
    }

    final PoolThreadCache threadCache() {
        PoolThreadCache poolThreadCache = (PoolThreadCache)this.threadCache.get();
        assert (poolThreadCache != null);
        return poolThreadCache;
    }

    public String dumpStats() {
        int n2 = this.heapArenas == null ? 0 : this.heapArenas.length;
        StringBuilder stringBuilder = new StringBuilder(512).append(n2).append(" heap arena(s):").append(StringUtil.NEWLINE);
        if (n2 > 0) {
            for (PoolArena<byte[]> poolArena : this.heapArenas) {
                stringBuilder.append(poolArena);
            }
        }
        int n3 = this.directArenas == null ? 0 : this.directArenas.length;
        stringBuilder.append(n3).append(" direct arena(s):").append(StringUtil.NEWLINE);
        if (n3 > 0) {
            for (PoolArena<ByteBuffer> poolArena : this.directArenas) {
                stringBuilder.append(poolArena);
            }
        }
        return stringBuilder.toString();
    }

    static /* synthetic */ PoolArena[] access$000(PooledByteBufAllocator pooledByteBufAllocator) {
        return pooledByteBufAllocator.heapArenas;
    }

    static /* synthetic */ PoolArena[] access$100(PooledByteBufAllocator pooledByteBufAllocator) {
        return pooledByteBufAllocator.directArenas;
    }

    static /* synthetic */ int access$200(PooledByteBufAllocator pooledByteBufAllocator) {
        return pooledByteBufAllocator.tinyCacheSize;
    }

    static /* synthetic */ int access$300(PooledByteBufAllocator pooledByteBufAllocator) {
        return pooledByteBufAllocator.smallCacheSize;
    }

    static /* synthetic */ int access$400(PooledByteBufAllocator pooledByteBufAllocator) {
        return pooledByteBufAllocator.normalCacheSize;
    }

    static /* synthetic */ int access$500() {
        return DEFAULT_MAX_CACHED_BUFFER_CAPACITY;
    }

    static /* synthetic */ int access$600() {
        return DEFAULT_CACHE_TRIM_INTERVAL;
    }

    static {
        int n2 = SystemPropertyUtil.getInt("io.netty.allocator.pageSize", 8192);
        Throwable throwable = null;
        try {
            PooledByteBufAllocator.validateAndCalculatePageShifts(n2);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            n2 = 8192;
        }
        DEFAULT_PAGE_SIZE = n2;
        int n3 = SystemPropertyUtil.getInt("io.netty.allocator.maxOrder", 11);
        Throwable throwable3 = null;
        try {
            PooledByteBufAllocator.validateAndCalculateChunkSize(DEFAULT_PAGE_SIZE, n3);
        }
        catch (Throwable throwable4) {
            throwable3 = throwable4;
            n3 = 11;
        }
        DEFAULT_MAX_ORDER = n3;
        Runtime runtime = Runtime.getRuntime();
        int n4 = NettyRuntime.availableProcessors() * 2;
        int n5 = DEFAULT_PAGE_SIZE << DEFAULT_MAX_ORDER;
        DEFAULT_NUM_HEAP_ARENA = Math.max(0, SystemPropertyUtil.getInt("io.netty.allocator.numHeapArenas", (int)Math.min((long)n4, runtime.maxMemory() / (long)n5 / 2L / 3L)));
        DEFAULT_NUM_DIRECT_ARENA = Math.max(0, SystemPropertyUtil.getInt("io.netty.allocator.numDirectArenas", (int)Math.min((long)n4, PlatformDependent.maxDirectMemory() / (long)n5 / 2L / 3L)));
        DEFAULT_TINY_CACHE_SIZE = SystemPropertyUtil.getInt("io.netty.allocator.tinyCacheSize", 512);
        DEFAULT_SMALL_CACHE_SIZE = SystemPropertyUtil.getInt("io.netty.allocator.smallCacheSize", 256);
        DEFAULT_NORMAL_CACHE_SIZE = SystemPropertyUtil.getInt("io.netty.allocator.normalCacheSize", 64);
        DEFAULT_MAX_CACHED_BUFFER_CAPACITY = SystemPropertyUtil.getInt("io.netty.allocator.maxCachedBufferCapacity", 32768);
        DEFAULT_CACHE_TRIM_INTERVAL = SystemPropertyUtil.getInt("io.netty.allocator.cacheTrimInterval", 8192);
        DEFAULT_USE_CACHE_FOR_ALL_THREADS = SystemPropertyUtil.getBoolean("io.netty.allocator.useCacheForAllThreads", true);
        DEFAULT_DIRECT_MEMORY_CACHE_ALIGNMENT = SystemPropertyUtil.getInt("io.netty.allocator.directMemoryCacheAlignment", 0);
        if (logger.isDebugEnabled()) {
            logger.debug("-Dio.netty.allocator.numHeapArenas: {}", (Object)DEFAULT_NUM_HEAP_ARENA);
            logger.debug("-Dio.netty.allocator.numDirectArenas: {}", (Object)DEFAULT_NUM_DIRECT_ARENA);
            if (throwable == null) {
                logger.debug("-Dio.netty.allocator.pageSize: {}", (Object)DEFAULT_PAGE_SIZE);
            } else {
                logger.debug("-Dio.netty.allocator.pageSize: {}", (Object)DEFAULT_PAGE_SIZE, (Object)throwable);
            }
            if (throwable3 == null) {
                logger.debug("-Dio.netty.allocator.maxOrder: {}", (Object)DEFAULT_MAX_ORDER);
            } else {
                logger.debug("-Dio.netty.allocator.maxOrder: {}", (Object)DEFAULT_MAX_ORDER, (Object)throwable3);
            }
            logger.debug("-Dio.netty.allocator.chunkSize: {}", (Object)(DEFAULT_PAGE_SIZE << DEFAULT_MAX_ORDER));
            logger.debug("-Dio.netty.allocator.tinyCacheSize: {}", (Object)DEFAULT_TINY_CACHE_SIZE);
            logger.debug("-Dio.netty.allocator.smallCacheSize: {}", (Object)DEFAULT_SMALL_CACHE_SIZE);
            logger.debug("-Dio.netty.allocator.normalCacheSize: {}", (Object)DEFAULT_NORMAL_CACHE_SIZE);
            logger.debug("-Dio.netty.allocator.maxCachedBufferCapacity: {}", (Object)DEFAULT_MAX_CACHED_BUFFER_CAPACITY);
            logger.debug("-Dio.netty.allocator.cacheTrimInterval: {}", (Object)DEFAULT_CACHE_TRIM_INTERVAL);
            logger.debug("-Dio.netty.allocator.useCacheForAllThreads: {}", (Object)DEFAULT_USE_CACHE_FOR_ALL_THREADS);
        }
        DEFAULT = new PooledByteBufAllocator(PlatformDependent.directBufferPreferred());
    }
}

