/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PoolChunk;
import io.netty.buffer.PoolThreadCache;
import io.netty.buffer.PooledDuplicatedByteBuf;
import io.netty.buffer.PooledSlicedByteBuf;
import io.netty.util.Recycler$Handle;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

abstract class PooledByteBuf<T>
extends AbstractReferenceCountedByteBuf {
    private final Recycler$Handle<PooledByteBuf<T>> recyclerHandle;
    protected PoolChunk<T> chunk;
    protected long handle;
    protected T memory;
    protected int offset;
    protected int length;
    int maxLength;
    PoolThreadCache cache;
    private ByteBuffer tmpNioBuf;
    private ByteBufAllocator allocator;

    protected PooledByteBuf(Recycler$Handle<? extends PooledByteBuf<T>> recycler$Handle, int n2) {
        super(n2);
        this.recyclerHandle = recycler$Handle;
    }

    void init(PoolChunk<T> poolChunk, long l2, int n2, int n3, int n4, PoolThreadCache poolThreadCache) {
        this.init0(poolChunk, l2, n2, n3, n4, poolThreadCache);
    }

    void initUnpooled(PoolChunk<T> poolChunk, int n2) {
        this.init0(poolChunk, 0L, poolChunk.offset, n2, n2, null);
    }

    private void init0(PoolChunk<T> poolChunk, long l2, int n2, int n3, int n4, PoolThreadCache poolThreadCache) {
        assert (l2 >= 0L);
        assert (poolChunk != null);
        this.chunk = poolChunk;
        this.memory = poolChunk.memory;
        this.allocator = poolChunk.arena.parent;
        this.cache = poolThreadCache;
        this.handle = l2;
        this.offset = n2;
        this.length = n3;
        this.maxLength = n4;
        this.tmpNioBuf = null;
    }

    final void reuse(int n2) {
        this.maxCapacity(n2);
        this.setRefCnt(1);
        this.setIndex0(0, 0);
        this.discardMarks();
    }

    @Override
    public final int capacity() {
        return this.length;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final ByteBuf capacity(int n2) {
        this.checkNewCapacity(n2);
        if (this.chunk.unpooled) {
            if (n2 == this.length) {
                return this;
            }
        } else if (n2 > this.length) {
            if (n2 <= this.maxLength) {
                this.length = n2;
                return this;
            }
        } else {
            if (n2 >= this.length) return this;
            if (n2 > this.maxLength >>> 1) {
                if (this.maxLength <= 512) {
                    if (n2 > this.maxLength - 16) {
                        this.length = n2;
                        this.setIndex(Math.min(this.readerIndex(), n2), Math.min(this.writerIndex(), n2));
                        return this;
                    }
                } else {
                    this.length = n2;
                    this.setIndex(Math.min(this.readerIndex(), n2), Math.min(this.writerIndex(), n2));
                    return this;
                }
            }
        }
        this.chunk.arena.reallocate(this, n2, true);
        return this;
    }

    @Override
    public final ByteBufAllocator alloc() {
        return this.allocator;
    }

    @Override
    public final ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }

    @Override
    public final ByteBuf unwrap() {
        return null;
    }

    @Override
    public final ByteBuf retainedDuplicate() {
        return PooledDuplicatedByteBuf.newInstance(this, this, this.readerIndex(), this.writerIndex());
    }

    @Override
    public final ByteBuf retainedSlice() {
        int n2 = this.readerIndex();
        return this.retainedSlice(n2, this.writerIndex() - n2);
    }

    @Override
    public final ByteBuf retainedSlice(int n2, int n3) {
        return PooledSlicedByteBuf.newInstance(this, this, n2, n3);
    }

    protected final ByteBuffer internalNioBuffer() {
        ByteBuffer byteBuffer = this.tmpNioBuf;
        if (byteBuffer == null) {
            this.tmpNioBuf = byteBuffer = this.newInternalNioBuffer(this.memory);
        }
        return byteBuffer;
    }

    protected abstract ByteBuffer newInternalNioBuffer(T var1);

    @Override
    protected final void deallocate() {
        if (this.handle >= 0L) {
            long l2 = this.handle;
            this.handle = -1L;
            this.memory = null;
            this.tmpNioBuf = null;
            this.chunk.arena.free(this.chunk, l2, this.maxLength, this.cache);
            this.chunk = null;
            this.recycle();
        }
    }

    private void recycle() {
        this.recyclerHandle.recycle(this);
    }

    protected final int idx(int n2) {
        return this.offset + n2;
    }
}

