/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.PoolArena;
import io.netty.buffer.PoolArena$SizeClass;
import io.netty.buffer.PoolChunk;
import io.netty.buffer.PoolThreadCache$MemoryRegionCache;
import io.netty.buffer.PoolThreadCache$NormalMemoryRegionCache;
import io.netty.buffer.PoolThreadCache$SubPageMemoryRegionCache;
import io.netty.buffer.PooledByteBuf;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteBuffer;

final class PoolThreadCache {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PoolThreadCache.class);
    final PoolArena<byte[]> heapArena;
    final PoolArena<ByteBuffer> directArena;
    private final PoolThreadCache$MemoryRegionCache<byte[]>[] tinySubPageHeapCaches;
    private final PoolThreadCache$MemoryRegionCache<byte[]>[] smallSubPageHeapCaches;
    private final PoolThreadCache$MemoryRegionCache<ByteBuffer>[] tinySubPageDirectCaches;
    private final PoolThreadCache$MemoryRegionCache<ByteBuffer>[] smallSubPageDirectCaches;
    private final PoolThreadCache$MemoryRegionCache<byte[]>[] normalHeapCaches;
    private final PoolThreadCache$MemoryRegionCache<ByteBuffer>[] normalDirectCaches;
    private final int numShiftsNormalDirect;
    private final int numShiftsNormalHeap;
    private final int freeSweepAllocationThreshold;
    private int allocations;

    PoolThreadCache(PoolArena<byte[]> poolArena, PoolArena<ByteBuffer> poolArena2, int n2, int n3, int n4, int n5, int n6) {
        if (n5 < 0) {
            throw new IllegalArgumentException("maxCachedBufferCapacity: " + n5 + " (expected: >= 0)");
        }
        this.freeSweepAllocationThreshold = n6;
        this.heapArena = poolArena;
        this.directArena = poolArena2;
        if (poolArena2 != null) {
            this.tinySubPageDirectCaches = PoolThreadCache.createSubPageCaches(n2, 32, PoolArena$SizeClass.Tiny);
            this.smallSubPageDirectCaches = PoolThreadCache.createSubPageCaches(n3, poolArena2.numSmallSubpagePools, PoolArena$SizeClass.Small);
            this.numShiftsNormalDirect = PoolThreadCache.log2(poolArena2.pageSize);
            this.normalDirectCaches = PoolThreadCache.createNormalCaches(n4, n5, poolArena2);
            poolArena2.numThreadCaches.getAndIncrement();
        } else {
            this.tinySubPageDirectCaches = null;
            this.smallSubPageDirectCaches = null;
            this.normalDirectCaches = null;
            this.numShiftsNormalDirect = -1;
        }
        if (poolArena != null) {
            this.tinySubPageHeapCaches = PoolThreadCache.createSubPageCaches(n2, 32, PoolArena$SizeClass.Tiny);
            this.smallSubPageHeapCaches = PoolThreadCache.createSubPageCaches(n3, poolArena.numSmallSubpagePools, PoolArena$SizeClass.Small);
            this.numShiftsNormalHeap = PoolThreadCache.log2(poolArena.pageSize);
            this.normalHeapCaches = PoolThreadCache.createNormalCaches(n4, n5, poolArena);
            poolArena.numThreadCaches.getAndIncrement();
        } else {
            this.tinySubPageHeapCaches = null;
            this.smallSubPageHeapCaches = null;
            this.normalHeapCaches = null;
            this.numShiftsNormalHeap = -1;
        }
        if ((this.tinySubPageDirectCaches != null || this.smallSubPageDirectCaches != null || this.normalDirectCaches != null || this.tinySubPageHeapCaches != null || this.smallSubPageHeapCaches != null || this.normalHeapCaches != null) && n6 < 1) {
            throw new IllegalArgumentException("freeSweepAllocationThreshold: " + n6 + " (expected: > 0)");
        }
    }

    private static <T> PoolThreadCache$MemoryRegionCache<T>[] createSubPageCaches(int n2, int n3, PoolArena$SizeClass poolArena$SizeClass) {
        if (n2 > 0 && n3 > 0) {
            PoolThreadCache$MemoryRegionCache[] poolThreadCache$MemoryRegionCacheArray = new PoolThreadCache$MemoryRegionCache[n3];
            for (int i2 = 0; i2 < poolThreadCache$MemoryRegionCacheArray.length; ++i2) {
                poolThreadCache$MemoryRegionCacheArray[i2] = new PoolThreadCache$SubPageMemoryRegionCache(n2, poolArena$SizeClass);
            }
            return poolThreadCache$MemoryRegionCacheArray;
        }
        return null;
    }

    private static <T> PoolThreadCache$MemoryRegionCache<T>[] createNormalCaches(int n2, int n3, PoolArena<T> poolArena) {
        if (n2 > 0 && n3 > 0) {
            int n4 = Math.min(poolArena.chunkSize, n3);
            int n5 = Math.max(1, PoolThreadCache.log2(n4 / poolArena.pageSize) + 1);
            PoolThreadCache$MemoryRegionCache[] poolThreadCache$MemoryRegionCacheArray = new PoolThreadCache$MemoryRegionCache[n5];
            for (int i2 = 0; i2 < poolThreadCache$MemoryRegionCacheArray.length; ++i2) {
                poolThreadCache$MemoryRegionCacheArray[i2] = new PoolThreadCache$NormalMemoryRegionCache(n2);
            }
            return poolThreadCache$MemoryRegionCacheArray;
        }
        return null;
    }

    private static int log2(int n2) {
        int n3 = 0;
        while (n2 > 1) {
            n2 >>= 1;
            ++n3;
        }
        return n3;
    }

    boolean allocateTiny(PoolArena<?> poolArena, PooledByteBuf<?> pooledByteBuf, int n2, int n3) {
        return this.allocate(this.cacheForTiny(poolArena, n3), pooledByteBuf, n2);
    }

    boolean allocateSmall(PoolArena<?> poolArena, PooledByteBuf<?> pooledByteBuf, int n2, int n3) {
        return this.allocate(this.cacheForSmall(poolArena, n3), pooledByteBuf, n2);
    }

    boolean allocateNormal(PoolArena<?> poolArena, PooledByteBuf<?> pooledByteBuf, int n2, int n3) {
        return this.allocate(this.cacheForNormal(poolArena, n3), pooledByteBuf, n2);
    }

    private boolean allocate(PoolThreadCache$MemoryRegionCache<?> poolThreadCache$MemoryRegionCache, PooledByteBuf pooledByteBuf, int n2) {
        if (poolThreadCache$MemoryRegionCache == null) {
            return false;
        }
        boolean bl2 = poolThreadCache$MemoryRegionCache.allocate(pooledByteBuf, n2);
        if (++this.allocations >= this.freeSweepAllocationThreshold) {
            this.allocations = 0;
            this.trim();
        }
        return bl2;
    }

    boolean add(PoolArena<?> poolArena, PoolChunk poolChunk, long l2, int n2, PoolArena$SizeClass poolArena$SizeClass) {
        PoolThreadCache$MemoryRegionCache<?> poolThreadCache$MemoryRegionCache = this.cache(poolArena, n2, poolArena$SizeClass);
        if (poolThreadCache$MemoryRegionCache == null) {
            return false;
        }
        return poolThreadCache$MemoryRegionCache.add(poolChunk, l2);
    }

    private PoolThreadCache$MemoryRegionCache<?> cache(PoolArena<?> poolArena, int n2, PoolArena$SizeClass poolArena$SizeClass) {
        switch (poolArena$SizeClass) {
            case Normal: {
                return this.cacheForNormal(poolArena, n2);
            }
            case Small: {
                return this.cacheForSmall(poolArena, n2);
            }
            case Tiny: {
                return this.cacheForTiny(poolArena, n2);
            }
        }
        throw new Error();
    }

    void free() {
        int n2 = PoolThreadCache.free(this.tinySubPageDirectCaches) + PoolThreadCache.free(this.smallSubPageDirectCaches) + PoolThreadCache.free(this.normalDirectCaches) + PoolThreadCache.free(this.tinySubPageHeapCaches) + PoolThreadCache.free(this.smallSubPageHeapCaches) + PoolThreadCache.free(this.normalHeapCaches);
        if (n2 > 0 && logger.isDebugEnabled()) {
            logger.debug("Freed {} thread-local buffer(s) from thread: {}", (Object)n2, (Object)Thread.currentThread().getName());
        }
        if (this.directArena != null) {
            this.directArena.numThreadCaches.getAndDecrement();
        }
        if (this.heapArena != null) {
            this.heapArena.numThreadCaches.getAndDecrement();
        }
    }

    private static int free(PoolThreadCache$MemoryRegionCache<?>[] poolThreadCache$MemoryRegionCacheArray) {
        if (poolThreadCache$MemoryRegionCacheArray == null) {
            return 0;
        }
        int n2 = 0;
        for (PoolThreadCache$MemoryRegionCache<?> poolThreadCache$MemoryRegionCache : poolThreadCache$MemoryRegionCacheArray) {
            n2 += PoolThreadCache.free(poolThreadCache$MemoryRegionCache);
        }
        return n2;
    }

    private static int free(PoolThreadCache$MemoryRegionCache<?> poolThreadCache$MemoryRegionCache) {
        if (poolThreadCache$MemoryRegionCache == null) {
            return 0;
        }
        return poolThreadCache$MemoryRegionCache.free();
    }

    void trim() {
        PoolThreadCache.trim(this.tinySubPageDirectCaches);
        PoolThreadCache.trim(this.smallSubPageDirectCaches);
        PoolThreadCache.trim(this.normalDirectCaches);
        PoolThreadCache.trim(this.tinySubPageHeapCaches);
        PoolThreadCache.trim(this.smallSubPageHeapCaches);
        PoolThreadCache.trim(this.normalHeapCaches);
    }

    private static void trim(PoolThreadCache$MemoryRegionCache<?>[] poolThreadCache$MemoryRegionCacheArray) {
        if (poolThreadCache$MemoryRegionCacheArray == null) {
            return;
        }
        for (PoolThreadCache$MemoryRegionCache<?> poolThreadCache$MemoryRegionCache : poolThreadCache$MemoryRegionCacheArray) {
            PoolThreadCache.trim(poolThreadCache$MemoryRegionCache);
        }
    }

    private static void trim(PoolThreadCache$MemoryRegionCache<?> poolThreadCache$MemoryRegionCache) {
        if (poolThreadCache$MemoryRegionCache == null) {
            return;
        }
        poolThreadCache$MemoryRegionCache.trim();
    }

    private PoolThreadCache$MemoryRegionCache<?> cacheForTiny(PoolArena<?> poolArena, int n2) {
        int n3 = PoolArena.tinyIdx(n2);
        if (poolArena.isDirect()) {
            return PoolThreadCache.cache(this.tinySubPageDirectCaches, n3);
        }
        return PoolThreadCache.cache(this.tinySubPageHeapCaches, n3);
    }

    private PoolThreadCache$MemoryRegionCache<?> cacheForSmall(PoolArena<?> poolArena, int n2) {
        int n3 = PoolArena.smallIdx(n2);
        if (poolArena.isDirect()) {
            return PoolThreadCache.cache(this.smallSubPageDirectCaches, n3);
        }
        return PoolThreadCache.cache(this.smallSubPageHeapCaches, n3);
    }

    private PoolThreadCache$MemoryRegionCache<?> cacheForNormal(PoolArena<?> poolArena, int n2) {
        if (poolArena.isDirect()) {
            int n3 = PoolThreadCache.log2(n2 >> this.numShiftsNormalDirect);
            return PoolThreadCache.cache(this.normalDirectCaches, n3);
        }
        int n4 = PoolThreadCache.log2(n2 >> this.numShiftsNormalHeap);
        return PoolThreadCache.cache(this.normalHeapCaches, n4);
    }

    private static <T> PoolThreadCache$MemoryRegionCache<T> cache(PoolThreadCache$MemoryRegionCache<T>[] poolThreadCache$MemoryRegionCacheArray, int n2) {
        if (poolThreadCache$MemoryRegionCacheArray == null || n2 > poolThreadCache$MemoryRegionCacheArray.length - 1) {
            return null;
        }
        return poolThreadCache$MemoryRegionCacheArray[n2];
    }
}

