/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.PoolArena;
import io.netty.buffer.PoolChunk;
import io.netty.buffer.PoolSubpageMetric;

final class PoolSubpage<T>
implements PoolSubpageMetric {
    final PoolChunk<T> chunk;
    private final int memoryMapIdx;
    private final int runOffset;
    private final int pageSize;
    private final long[] bitmap;
    PoolSubpage<T> prev;
    PoolSubpage<T> next;
    boolean doNotDestroy;
    int elemSize;
    private int maxNumElems;
    private int bitmapLength;
    private int nextAvail;
    private int numAvail;

    PoolSubpage(int n2) {
        this.chunk = null;
        this.memoryMapIdx = -1;
        this.runOffset = -1;
        this.elemSize = -1;
        this.pageSize = n2;
        this.bitmap = null;
    }

    PoolSubpage(PoolSubpage<T> poolSubpage, PoolChunk<T> poolChunk, int n2, int n3, int n4, int n5) {
        this.chunk = poolChunk;
        this.memoryMapIdx = n2;
        this.runOffset = n3;
        this.pageSize = n4;
        this.bitmap = new long[n4 >>> 10];
        this.init(poolSubpage, n5);
    }

    void init(PoolSubpage<T> poolSubpage, int n2) {
        this.doNotDestroy = true;
        this.elemSize = n2;
        if (n2 != 0) {
            this.maxNumElems = this.numAvail = this.pageSize / n2;
            this.nextAvail = 0;
            this.bitmapLength = this.maxNumElems >>> 6;
            if ((this.maxNumElems & 0x3F) != 0) {
                ++this.bitmapLength;
            }
            for (int i2 = 0; i2 < this.bitmapLength; ++i2) {
                this.bitmap[i2] = 0L;
            }
        }
        this.addToPool(poolSubpage);
    }

    long allocate() {
        if (this.elemSize == 0) {
            return this.toHandle(0);
        }
        if (this.numAvail == 0 || !this.doNotDestroy) {
            return -1L;
        }
        int n2 = this.getNextAvail();
        int n3 = n2 >>> 6;
        int n4 = n2 & 0x3F;
        assert ((this.bitmap[n3] >>> n4 & 1L) == 0L);
        int n5 = n3;
        this.bitmap[n5] = this.bitmap[n5] | 1L << n4;
        if (--this.numAvail == 0) {
            this.removeFromPool();
        }
        return this.toHandle(n2);
    }

    boolean free(PoolSubpage<T> poolSubpage, int n2) {
        if (this.elemSize == 0) {
            return true;
        }
        int n3 = n2 >>> 6;
        int n4 = n2 & 0x3F;
        assert ((this.bitmap[n3] >>> n4 & 1L) != 0L);
        int n5 = n3;
        this.bitmap[n5] = this.bitmap[n5] ^ 1L << n4;
        this.setNextAvail(n2);
        if (this.numAvail++ == 0) {
            this.addToPool(poolSubpage);
            return true;
        }
        if (this.numAvail != this.maxNumElems) {
            return true;
        }
        if (this.prev == this.next) {
            return true;
        }
        this.doNotDestroy = false;
        this.removeFromPool();
        return false;
    }

    private void addToPool(PoolSubpage<T> poolSubpage) {
        assert (this.prev == null && this.next == null);
        this.prev = poolSubpage;
        this.next = poolSubpage.next;
        this.next.prev = this;
        poolSubpage.next = this;
    }

    private void removeFromPool() {
        assert (this.prev != null && this.next != null);
        this.prev.next = this.next;
        this.next.prev = this.prev;
        this.next = null;
        this.prev = null;
    }

    private void setNextAvail(int n2) {
        this.nextAvail = n2;
    }

    private int getNextAvail() {
        int n2 = this.nextAvail;
        if (n2 >= 0) {
            this.nextAvail = -1;
            return n2;
        }
        return this.findNextAvail();
    }

    private int findNextAvail() {
        long[] lArray = this.bitmap;
        int n2 = this.bitmapLength;
        for (int i2 = 0; i2 < n2; ++i2) {
            long l2 = lArray[i2];
            if ((l2 ^ 0xFFFFFFFFFFFFFFFFL) == 0L) continue;
            return this.findNextAvail0(i2, l2);
        }
        return -1;
    }

    private int findNextAvail0(int n2, long l2) {
        int n3 = this.maxNumElems;
        int n4 = n2 << 6;
        for (int i2 = 0; i2 < 64; ++i2) {
            if ((l2 & 1L) == 0L) {
                int n5 = n4 | i2;
                if (n5 >= n3) break;
                return n5;
            }
            l2 >>>= 1;
        }
        return -1;
    }

    private long toHandle(int n2) {
        return 0x4000000000000000L | (long)n2 << 32 | (long)this.memoryMapIdx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        int n2;
        int n3;
        int n4;
        boolean bl2;
        PoolArena poolArena = this.chunk.arena;
        synchronized (poolArena) {
            if (!this.doNotDestroy) {
                bl2 = false;
                n4 = -1;
                n3 = -1;
                n2 = -1;
            } else {
                bl2 = true;
                n2 = this.maxNumElems;
                n3 = this.numAvail;
                n4 = this.elemSize;
            }
        }
        if (!bl2) {
            return "(" + this.memoryMapIdx + ": not in use)";
        }
        return "(" + this.memoryMapIdx + ": " + (n2 - n3) + '/' + n2 + ", offset: " + this.runOffset + ", length: " + this.pageSize + ", elemSize: " + n4 + ')';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int maxNumElements() {
        PoolArena poolArena = this.chunk.arena;
        synchronized (poolArena) {
            return this.maxNumElems;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int numAvailable() {
        PoolArena poolArena = this.chunk.arena;
        synchronized (poolArena) {
            return this.numAvail;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int elementSize() {
        PoolArena poolArena = this.chunk.arena;
        synchronized (poolArena) {
            return this.elemSize;
        }
    }

    @Override
    public int pageSize() {
        return this.pageSize;
    }

    void destroy() {
        if (this.chunk != null) {
            this.chunk.destroy();
        }
    }
}

