/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.PoolArena;
import io.netty.buffer.PoolChunk;
import io.netty.buffer.PoolChunkListMetric;
import io.netty.buffer.PoolChunkMetric;
import io.netty.buffer.PooledByteBuf;
import io.netty.util.internal.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

final class PoolChunkList<T>
implements PoolChunkListMetric {
    private static final Iterator<PoolChunkMetric> EMPTY_METRICS = Collections.emptyList().iterator();
    private final PoolArena<T> arena;
    private final PoolChunkList<T> nextList;
    private final int minUsage;
    private final int maxUsage;
    private final int maxCapacity;
    private PoolChunk<T> head;
    private PoolChunkList<T> prevList;

    PoolChunkList(PoolArena<T> poolArena, PoolChunkList<T> poolChunkList, int n2, int n3, int n4) {
        assert (n2 <= n3);
        this.arena = poolArena;
        this.nextList = poolChunkList;
        this.minUsage = n2;
        this.maxUsage = n3;
        this.maxCapacity = PoolChunkList.calculateMaxCapacity(n2, n4);
    }

    private static int calculateMaxCapacity(int n2, int n3) {
        if ((n2 = PoolChunkList.minUsage0(n2)) == 100) {
            return 0;
        }
        return (int)((long)n3 * (100L - (long)n2) / 100L);
    }

    void prevList(PoolChunkList<T> poolChunkList) {
        assert (this.prevList == null);
        this.prevList = poolChunkList;
    }

    boolean allocate(PooledByteBuf<T> pooledByteBuf, int n2, int n3) {
        long l2;
        if (this.head == null || n3 > this.maxCapacity) {
            return false;
        }
        PoolChunk<T> poolChunk = this.head;
        while ((l2 = poolChunk.allocate(n3)) < 0L) {
            poolChunk = poolChunk.next;
            if (poolChunk != null) continue;
            return false;
        }
        poolChunk.initBuf(pooledByteBuf, l2, n2);
        if (poolChunk.usage() >= this.maxUsage) {
            this.remove(poolChunk);
            this.nextList.add(poolChunk);
        }
        return true;
    }

    boolean free(PoolChunk<T> poolChunk, long l2) {
        poolChunk.free(l2);
        if (poolChunk.usage() < this.minUsage) {
            this.remove(poolChunk);
            return this.move0(poolChunk);
        }
        return true;
    }

    private boolean move(PoolChunk<T> poolChunk) {
        assert (poolChunk.usage() < this.maxUsage);
        if (poolChunk.usage() < this.minUsage) {
            return this.move0(poolChunk);
        }
        this.add0(poolChunk);
        return true;
    }

    private boolean move0(PoolChunk<T> poolChunk) {
        if (this.prevList == null) {
            assert (poolChunk.usage() == 0);
            return false;
        }
        return super.move(poolChunk);
    }

    void add(PoolChunk<T> poolChunk) {
        if (poolChunk.usage() >= this.maxUsage) {
            this.nextList.add(poolChunk);
            return;
        }
        this.add0(poolChunk);
    }

    void add0(PoolChunk<T> poolChunk) {
        poolChunk.parent = this;
        if (this.head == null) {
            this.head = poolChunk;
            poolChunk.prev = null;
            poolChunk.next = null;
        } else {
            poolChunk.prev = null;
            poolChunk.next = this.head;
            this.head.prev = poolChunk;
            this.head = poolChunk;
        }
    }

    private void remove(PoolChunk<T> poolChunk) {
        if (poolChunk == this.head) {
            this.head = poolChunk.next;
            if (this.head != null) {
                this.head.prev = null;
            }
        } else {
            PoolChunk poolChunk2;
            poolChunk.prev.next = poolChunk2 = poolChunk.next;
            if (poolChunk2 != null) {
                poolChunk2.prev = poolChunk.prev;
            }
        }
    }

    @Override
    public int minUsage() {
        return PoolChunkList.minUsage0(this.minUsage);
    }

    @Override
    public int maxUsage() {
        return Math.min(this.maxUsage, 100);
    }

    private static int minUsage0(int n2) {
        return Math.max(1, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<PoolChunkMetric> iterator() {
        PoolArena<T> poolArena = this.arena;
        synchronized (poolArena) {
            if (this.head == null) {
                return EMPTY_METRICS;
            }
            ArrayList<PoolChunk<T>> arrayList = new ArrayList<PoolChunk<T>>();
            PoolChunk<T> poolChunk = this.head;
            do {
                arrayList.add(poolChunk);
            } while ((poolChunk = poolChunk.next) != null);
            return arrayList.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        PoolArena<T> poolArena = this.arena;
        synchronized (poolArena) {
            if (this.head == null) {
                return "none";
            }
            PoolChunk<T> poolChunk = this.head;
            while (true) {
                stringBuilder.append(poolChunk);
                poolChunk = poolChunk.next;
                if (poolChunk == null) break;
                stringBuilder.append(StringUtil.NEWLINE);
            }
        }
        return stringBuilder.toString();
    }

    void destroy(PoolArena<T> poolArena) {
        PoolChunk<T> poolChunk = this.head;
        while (poolChunk != null) {
            poolArena.destroyChunk(poolChunk);
            poolChunk = poolChunk.next;
        }
        this.head = null;
    }
}

