/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.PoolArena;
import io.netty.buffer.PoolChunkList;
import io.netty.buffer.PoolChunkMetric;
import io.netty.buffer.PoolSubpage;
import io.netty.buffer.PooledByteBuf;

final class PoolChunk<T>
implements PoolChunkMetric {
    private static final int INTEGER_SIZE_MINUS_ONE = 31;
    final PoolArena<T> arena;
    final T memory;
    final boolean unpooled;
    final int offset;
    private final byte[] memoryMap;
    private final byte[] depthMap;
    private final PoolSubpage<T>[] subpages;
    private final int subpageOverflowMask;
    private final int pageSize;
    private final int pageShifts;
    private final int maxOrder;
    private final int chunkSize;
    private final int log2ChunkSize;
    private final int maxSubpageAllocs;
    private final byte unusable;
    private int freeBytes;
    PoolChunkList<T> parent;
    PoolChunk<T> prev;
    PoolChunk<T> next;

    PoolChunk(PoolArena<T> poolArena, T t2, int n2, int n3, int n4, int n5, int n6) {
        this.unpooled = false;
        this.arena = poolArena;
        this.memory = t2;
        this.pageSize = n2;
        this.pageShifts = n4;
        this.maxOrder = n3;
        this.chunkSize = n5;
        this.offset = n6;
        this.unusable = (byte)(n3 + 1);
        this.log2ChunkSize = PoolChunk.log2(n5);
        this.subpageOverflowMask = ~(n2 - 1);
        this.freeBytes = n5;
        assert (n3 < 30) : "maxOrder should be < 30, but is: " + n3;
        this.maxSubpageAllocs = 1 << n3;
        this.memoryMap = new byte[this.maxSubpageAllocs << 1];
        this.depthMap = new byte[this.memoryMap.length];
        int n7 = 1;
        for (int i2 = 0; i2 <= n3; ++i2) {
            int n8 = 1 << i2;
            for (int i3 = 0; i3 < n8; ++i3) {
                this.memoryMap[n7] = (byte)i2;
                this.depthMap[n7] = (byte)i2;
                ++n7;
            }
        }
        this.subpages = this.newSubpageArray(this.maxSubpageAllocs);
    }

    PoolChunk(PoolArena<T> poolArena, T t2, int n2, int n3) {
        this.unpooled = true;
        this.arena = poolArena;
        this.memory = t2;
        this.offset = n3;
        this.memoryMap = null;
        this.depthMap = null;
        this.subpages = null;
        this.subpageOverflowMask = 0;
        this.pageSize = 0;
        this.pageShifts = 0;
        this.maxOrder = 0;
        this.unusable = (byte)(this.maxOrder + 1);
        this.chunkSize = n2;
        this.log2ChunkSize = PoolChunk.log2(this.chunkSize);
        this.maxSubpageAllocs = 0;
    }

    private PoolSubpage<T>[] newSubpageArray(int n2) {
        return new PoolSubpage[n2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int usage() {
        int n2;
        PoolArena<T> poolArena = this.arena;
        synchronized (poolArena) {
            n2 = this.freeBytes;
        }
        return this.usage(n2);
    }

    private int usage(int n2) {
        if (n2 == 0) {
            return 100;
        }
        int n3 = (int)((long)n2 * 100L / (long)this.chunkSize);
        if (n3 == 0) {
            return 99;
        }
        return 100 - n3;
    }

    long allocate(int n2) {
        if ((n2 & this.subpageOverflowMask) != 0) {
            return this.allocateRun(n2);
        }
        return this.allocateSubpage(n2);
    }

    private void updateParentsAlloc(int n2) {
        while (n2 > 1) {
            byte by2;
            int n3 = n2 >>> 1;
            byte by3 = this.value(n2);
            byte by4 = by3 < (by2 = this.value(n2 ^ 1)) ? by3 : by2;
            this.setValue(n3, by4);
            n2 = n3;
        }
    }

    private void updateParentsFree(int n2) {
        int n3 = this.depth(n2) + 1;
        while (n2 > 1) {
            int n4 = n2 >>> 1;
            byte by2 = this.value(n2);
            byte by3 = this.value(n2 ^ 1);
            if (by2 == --n3 && by3 == n3) {
                this.setValue(n4, (byte)(n3 - 1));
            } else {
                byte by4 = by2 < by3 ? by2 : by3;
                this.setValue(n4, by4);
            }
            n2 = n4;
        }
    }

    private int allocateNode(int n2) {
        int n3 = 1;
        int n4 = -(1 << n2);
        byte by2 = this.value(n3);
        if (by2 > n2) {
            return -1;
        }
        while (by2 < n2 || (n3 & n4) == 0) {
            by2 = this.value(n3 <<= 1);
            if (by2 <= n2) continue;
            by2 = this.value(n3 ^= 1);
        }
        byte by3 = this.value(n3);
        assert (by3 == n2 && (n3 & n4) == 1 << n2) : String.format("val = %d, id & initial = %d, d = %d", by3, n3 & n4, n2);
        this.setValue(n3, this.unusable);
        this.updateParentsAlloc(n3);
        return n3;
    }

    private long allocateRun(int n2) {
        int n3 = this.maxOrder - (PoolChunk.log2(n2) - this.pageShifts);
        int n4 = this.allocateNode(n3);
        if (n4 < 0) {
            return n4;
        }
        this.freeBytes -= this.runLength(n4);
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long allocateSubpage(int n2) {
        PoolSubpage<T> poolSubpage;
        PoolSubpage<T> poolSubpage2 = poolSubpage = this.arena.findSubpagePoolHead(n2);
        synchronized (poolSubpage2) {
            int n3 = this.maxOrder;
            int n4 = this.allocateNode(n3);
            if (n4 < 0) {
                return n4;
            }
            PoolSubpage<T>[] poolSubpageArray = this.subpages;
            int n5 = this.pageSize;
            this.freeBytes -= n5;
            int n6 = this.subpageIdx(n4);
            PoolSubpage<T> poolSubpage3 = poolSubpageArray[n6];
            if (poolSubpage3 == null) {
                poolSubpage3 = new PoolSubpage<T>(poolSubpage, this, n4, this.runOffset(n4), n5, n2);
                poolSubpageArray[n6] = poolSubpage3;
            } else {
                poolSubpage3.init(poolSubpage, n2);
            }
            return poolSubpage3.allocate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void free(long l2) {
        int n2 = PoolChunk.memoryMapIdx(l2);
        int n3 = PoolChunk.bitmapIdx(l2);
        if (n3 != 0) {
            PoolSubpage<T> poolSubpage;
            PoolSubpage<T> poolSubpage2 = this.subpages[this.subpageIdx(n2)];
            assert (poolSubpage2 != null && poolSubpage2.doNotDestroy);
            PoolSubpage<T> poolSubpage3 = poolSubpage = this.arena.findSubpagePoolHead(poolSubpage2.elemSize);
            synchronized (poolSubpage3) {
                if (poolSubpage2.free(poolSubpage, n3 & 0x3FFFFFFF)) {
                    return;
                }
            }
        }
        this.freeBytes += this.runLength(n2);
        this.setValue(n2, this.depth(n2));
        this.updateParentsFree(n2);
    }

    void initBuf(PooledByteBuf<T> pooledByteBuf, long l2, int n2) {
        int n3 = PoolChunk.memoryMapIdx(l2);
        int n4 = PoolChunk.bitmapIdx(l2);
        if (n4 == 0) {
            byte by2 = this.value(n3);
            assert (by2 == this.unusable) : String.valueOf(by2);
            pooledByteBuf.init(this, l2, this.runOffset(n3) + this.offset, n2, this.runLength(n3), this.arena.parent.threadCache());
        } else {
            this.initBufWithSubpage(pooledByteBuf, l2, n4, n2);
        }
    }

    void initBufWithSubpage(PooledByteBuf<T> pooledByteBuf, long l2, int n2) {
        this.initBufWithSubpage(pooledByteBuf, l2, PoolChunk.bitmapIdx(l2), n2);
    }

    private void initBufWithSubpage(PooledByteBuf<T> pooledByteBuf, long l2, int n2, int n3) {
        assert (n2 != 0);
        int n4 = PoolChunk.memoryMapIdx(l2);
        PoolSubpage<T> poolSubpage = this.subpages[this.subpageIdx(n4)];
        assert (poolSubpage.doNotDestroy);
        assert (n3 <= poolSubpage.elemSize);
        pooledByteBuf.init(this, l2, this.runOffset(n4) + (n2 & 0x3FFFFFFF) * poolSubpage.elemSize + this.offset, n3, poolSubpage.elemSize, this.arena.parent.threadCache());
    }

    private byte value(int n2) {
        return this.memoryMap[n2];
    }

    private void setValue(int n2, byte by2) {
        this.memoryMap[n2] = by2;
    }

    private byte depth(int n2) {
        return this.depthMap[n2];
    }

    private static int log2(int n2) {
        return 31 - Integer.numberOfLeadingZeros(n2);
    }

    private int runLength(int n2) {
        return 1 << this.log2ChunkSize - this.depth(n2);
    }

    private int runOffset(int n2) {
        int n3 = n2 ^ 1 << this.depth(n2);
        return n3 * this.runLength(n2);
    }

    private int subpageIdx(int n2) {
        return n2 ^ this.maxSubpageAllocs;
    }

    private static int memoryMapIdx(long l2) {
        return (int)l2;
    }

    private static int bitmapIdx(long l2) {
        return (int)(l2 >>> 32);
    }

    @Override
    public int chunkSize() {
        return this.chunkSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int freeBytes() {
        PoolArena<T> poolArena = this.arena;
        synchronized (poolArena) {
            return this.freeBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        int n2;
        PoolArena<T> poolArena = this.arena;
        synchronized (poolArena) {
            n2 = this.freeBytes;
        }
        return "Chunk(" + Integer.toHexString(System.identityHashCode(this)) + ": " + this.usage(n2) + "%, " + (this.chunkSize - n2) + '/' + this.chunkSize + ')';
    }

    void destroy() {
        this.arena.destroyChunk(this);
    }
}

