/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.PoolArena$SizeClass;
import io.netty.buffer.PoolArenaMetric;
import io.netty.buffer.PoolChunk;
import io.netty.buffer.PoolChunkList;
import io.netty.buffer.PoolChunkListMetric;
import io.netty.buffer.PoolChunkMetric;
import io.netty.buffer.PoolSubpage;
import io.netty.buffer.PoolSubpageMetric;
import io.netty.buffer.PoolThreadCache;
import io.netty.buffer.PooledByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.util.internal.LongCounter;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

abstract class PoolArena<T>
implements PoolArenaMetric {
    static final boolean HAS_UNSAFE = PlatformDependent.hasUnsafe();
    static final int numTinySubpagePools = 32;
    final PooledByteBufAllocator parent;
    private final int maxOrder;
    final int pageSize;
    final int pageShifts;
    final int chunkSize;
    final int subpageOverflowMask;
    final int numSmallSubpagePools;
    final int directMemoryCacheAlignment;
    final int directMemoryCacheAlignmentMask;
    private final PoolSubpage<T>[] tinySubpagePools;
    private final PoolSubpage<T>[] smallSubpagePools;
    private final PoolChunkList<T> q050;
    private final PoolChunkList<T> q025;
    private final PoolChunkList<T> q000;
    private final PoolChunkList<T> qInit;
    private final PoolChunkList<T> q075;
    private final PoolChunkList<T> q100;
    private final List<PoolChunkListMetric> chunkListMetrics;
    private long allocationsNormal;
    private final LongCounter allocationsTiny = PlatformDependent.newLongCounter();
    private final LongCounter allocationsSmall = PlatformDependent.newLongCounter();
    private final LongCounter allocationsHuge = PlatformDependent.newLongCounter();
    private final LongCounter activeBytesHuge = PlatformDependent.newLongCounter();
    private long deallocationsTiny;
    private long deallocationsSmall;
    private long deallocationsNormal;
    private final LongCounter deallocationsHuge = PlatformDependent.newLongCounter();
    final AtomicInteger numThreadCaches = new AtomicInteger();

    protected PoolArena(PooledByteBufAllocator pooledByteBufAllocator, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        this.parent = pooledByteBufAllocator;
        this.pageSize = n2;
        this.maxOrder = n3;
        this.pageShifts = n4;
        this.chunkSize = n5;
        this.directMemoryCacheAlignment = n6;
        this.directMemoryCacheAlignmentMask = n6 - 1;
        this.subpageOverflowMask = ~(n2 - 1);
        this.tinySubpagePools = this.newSubpagePoolArray(32);
        for (n7 = 0; n7 < this.tinySubpagePools.length; ++n7) {
            this.tinySubpagePools[n7] = this.newSubpagePoolHead(n2);
        }
        this.numSmallSubpagePools = n4 - 9;
        this.smallSubpagePools = this.newSubpagePoolArray(this.numSmallSubpagePools);
        for (n7 = 0; n7 < this.smallSubpagePools.length; ++n7) {
            this.smallSubpagePools[n7] = this.newSubpagePoolHead(n2);
        }
        this.q100 = new PoolChunkList(this, null, 100, Integer.MAX_VALUE, n5);
        this.q075 = new PoolChunkList<T>(this, this.q100, 75, 100, n5);
        this.q050 = new PoolChunkList<T>(this, this.q075, 50, 100, n5);
        this.q025 = new PoolChunkList<T>(this, this.q050, 25, 75, n5);
        this.q000 = new PoolChunkList<T>(this, this.q025, 1, 50, n5);
        this.qInit = new PoolChunkList<T>(this, this.q000, Integer.MIN_VALUE, 25, n5);
        this.q100.prevList(this.q075);
        this.q075.prevList(this.q050);
        this.q050.prevList(this.q025);
        this.q025.prevList(this.q000);
        this.q000.prevList(null);
        this.qInit.prevList(this.qInit);
        ArrayList<PoolChunkList<T>> arrayList = new ArrayList<PoolChunkList<T>>(6);
        arrayList.add(this.qInit);
        arrayList.add(this.q000);
        arrayList.add(this.q025);
        arrayList.add(this.q050);
        arrayList.add(this.q075);
        arrayList.add(this.q100);
        this.chunkListMetrics = Collections.unmodifiableList(arrayList);
    }

    private PoolSubpage<T> newSubpagePoolHead(int n2) {
        PoolSubpage poolSubpage = new PoolSubpage(n2);
        poolSubpage.prev = poolSubpage;
        poolSubpage.next = poolSubpage;
        return poolSubpage;
    }

    private PoolSubpage<T>[] newSubpagePoolArray(int n2) {
        return new PoolSubpage[n2];
    }

    abstract boolean isDirect();

    PooledByteBuf<T> allocate(PoolThreadCache poolThreadCache, int n2, int n3) {
        PooledByteBuf<T> pooledByteBuf = this.newByteBuf(n3);
        this.allocate(poolThreadCache, pooledByteBuf, n2);
        return pooledByteBuf;
    }

    static int tinyIdx(int n2) {
        return n2 >>> 4;
    }

    static int smallIdx(int n2) {
        int n3 = 0;
        int n4 = n2 >>> 10;
        while (n4 != 0) {
            n4 >>>= 1;
            ++n3;
        }
        return n3;
    }

    boolean isTinyOrSmall(int n2) {
        return (n2 & this.subpageOverflowMask) == 0;
    }

    static boolean isTiny(int n2) {
        return (n2 & 0xFFFFFE00) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void allocate(PoolThreadCache poolThreadCache, PooledByteBuf<T> pooledByteBuf, int n2) {
        int n3 = this.normalizeCapacity(n2);
        if (this.isTinyOrSmall(n3)) {
            PoolSubpage<T>[] poolSubpageArray;
            int n4;
            boolean bl2 = PoolArena.isTiny(n3);
            if (bl2) {
                if (poolThreadCache.allocateTiny(this, pooledByteBuf, n2, n3)) {
                    return;
                }
                n4 = PoolArena.tinyIdx(n3);
                poolSubpageArray = this.tinySubpagePools;
            } else {
                if (poolThreadCache.allocateSmall(this, pooledByteBuf, n2, n3)) {
                    return;
                }
                n4 = PoolArena.smallIdx(n3);
                poolSubpageArray = this.smallSubpagePools;
            }
            PoolSubpage<T> poolSubpage = poolSubpageArray[n4];
            Object object = poolSubpage;
            synchronized (object) {
                PoolSubpage poolSubpage2 = poolSubpage.next;
                if (poolSubpage2 != poolSubpage) {
                    assert (poolSubpage2.doNotDestroy && poolSubpage2.elemSize == n3);
                    long l2 = poolSubpage2.allocate();
                    assert (l2 >= 0L);
                    poolSubpage2.chunk.initBufWithSubpage(pooledByteBuf, l2, n2);
                    this.incTinySmallAllocation(bl2);
                    return;
                }
            }
            object = this;
            synchronized (object) {
                this.allocateNormal(pooledByteBuf, n2, n3);
            }
            this.incTinySmallAllocation(bl2);
            return;
        }
        if (n3 <= this.chunkSize) {
            if (poolThreadCache.allocateNormal(this, pooledByteBuf, n2, n3)) {
                return;
            }
            PoolArena poolArena = this;
            synchronized (poolArena) {
                this.allocateNormal(pooledByteBuf, n2, n3);
                ++this.allocationsNormal;
            }
        } else {
            this.allocateHuge(pooledByteBuf, n2);
        }
    }

    private void allocateNormal(PooledByteBuf<T> pooledByteBuf, int n2, int n3) {
        if (this.q050.allocate(pooledByteBuf, n2, n3) || this.q025.allocate(pooledByteBuf, n2, n3) || this.q000.allocate(pooledByteBuf, n2, n3) || this.qInit.allocate(pooledByteBuf, n2, n3) || this.q075.allocate(pooledByteBuf, n2, n3)) {
            return;
        }
        PoolChunk<T> poolChunk = this.newChunk(this.pageSize, this.maxOrder, this.pageShifts, this.chunkSize);
        long l2 = poolChunk.allocate(n3);
        assert (l2 > 0L);
        poolChunk.initBuf(pooledByteBuf, l2, n2);
        this.qInit.add(poolChunk);
    }

    private void incTinySmallAllocation(boolean bl2) {
        if (bl2) {
            this.allocationsTiny.increment();
        } else {
            this.allocationsSmall.increment();
        }
    }

    private void allocateHuge(PooledByteBuf<T> pooledByteBuf, int n2) {
        PoolChunk<T> poolChunk = this.newUnpooledChunk(n2);
        this.activeBytesHuge.add(poolChunk.chunkSize());
        pooledByteBuf.initUnpooled(poolChunk, n2);
        this.allocationsHuge.increment();
    }

    void free(PoolChunk<T> poolChunk, long l2, int n2, PoolThreadCache poolThreadCache) {
        if (poolChunk.unpooled) {
            int n3 = poolChunk.chunkSize();
            this.destroyChunk(poolChunk);
            this.activeBytesHuge.add(-n3);
            this.deallocationsHuge.increment();
        } else {
            PoolArena$SizeClass poolArena$SizeClass = this.sizeClass(n2);
            if (poolThreadCache != null && poolThreadCache.add(this, poolChunk, l2, n2, poolArena$SizeClass)) {
                return;
            }
            this.freeChunk(poolChunk, l2, poolArena$SizeClass);
        }
    }

    private PoolArena$SizeClass sizeClass(int n2) {
        if (!this.isTinyOrSmall(n2)) {
            return PoolArena$SizeClass.Normal;
        }
        return PoolArena.isTiny(n2) ? PoolArena$SizeClass.Tiny : PoolArena$SizeClass.Small;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeChunk(PoolChunk<T> poolChunk, long l2, PoolArena$SizeClass poolArena$SizeClass) {
        boolean bl2;
        PoolArena poolArena = this;
        synchronized (poolArena) {
            switch (poolArena$SizeClass) {
                case Normal: {
                    ++this.deallocationsNormal;
                    break;
                }
                case Small: {
                    ++this.deallocationsSmall;
                    break;
                }
                case Tiny: {
                    ++this.deallocationsTiny;
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            bl2 = !poolChunk.parent.free(poolChunk, l2);
        }
        if (bl2) {
            this.destroyChunk(poolChunk);
        }
    }

    PoolSubpage<T> findSubpagePoolHead(int n2) {
        PoolSubpage<T>[] poolSubpageArray;
        int n3;
        if (PoolArena.isTiny(n2)) {
            n3 = n2 >>> 4;
            poolSubpageArray = this.tinySubpagePools;
        } else {
            n3 = 0;
            n2 >>>= 10;
            while (n2 != 0) {
                n2 >>>= 1;
                ++n3;
            }
            poolSubpageArray = this.smallSubpagePools;
        }
        return poolSubpageArray[n3];
    }

    int normalizeCapacity(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("capacity: " + n2 + " (expected: 0+)");
        }
        if (n2 >= this.chunkSize) {
            return this.directMemoryCacheAlignment == 0 ? n2 : this.alignCapacity(n2);
        }
        if (!PoolArena.isTiny(n2)) {
            int n3 = n2;
            --n3;
            n3 |= n3 >>> 1;
            n3 |= n3 >>> 2;
            n3 |= n3 >>> 4;
            n3 |= n3 >>> 8;
            n3 |= n3 >>> 16;
            if (++n3 < 0) {
                n3 >>>= 1;
            }
            assert (this.directMemoryCacheAlignment == 0 || (n3 & this.directMemoryCacheAlignmentMask) == 0);
            return n3;
        }
        if (this.directMemoryCacheAlignment > 0) {
            return this.alignCapacity(n2);
        }
        if ((n2 & 0xF) == 0) {
            return n2;
        }
        return (n2 & 0xFFFFFFF0) + 16;
    }

    int alignCapacity(int n2) {
        int n3 = n2 & this.directMemoryCacheAlignmentMask;
        return n3 == 0 ? n2 : n2 + this.directMemoryCacheAlignment - n3;
    }

    void reallocate(PooledByteBuf<T> pooledByteBuf, int n2, boolean bl2) {
        if (n2 < 0 || n2 > pooledByteBuf.maxCapacity()) {
            throw new IllegalArgumentException("newCapacity: " + n2);
        }
        int n3 = pooledByteBuf.length;
        if (n3 == n2) {
            return;
        }
        PoolChunk poolChunk = pooledByteBuf.chunk;
        long l2 = pooledByteBuf.handle;
        Object t2 = pooledByteBuf.memory;
        int n4 = pooledByteBuf.offset;
        int n5 = pooledByteBuf.maxLength;
        int n6 = pooledByteBuf.readerIndex();
        int n7 = pooledByteBuf.writerIndex();
        this.allocate(this.parent.threadCache(), pooledByteBuf, n2);
        if (n2 > n3) {
            this.memoryCopy(t2, n4, pooledByteBuf.memory, pooledByteBuf.offset, n3);
        } else if (n2 < n3) {
            if (n6 < n2) {
                if (n7 > n2) {
                    n7 = n2;
                }
                this.memoryCopy(t2, n4 + n6, pooledByteBuf.memory, pooledByteBuf.offset + n6, n7 - n6);
            } else {
                n6 = n7 = n2;
            }
        }
        pooledByteBuf.setIndex(n6, n7);
        if (bl2) {
            this.free(poolChunk, l2, n5, pooledByteBuf.cache);
        }
    }

    @Override
    public int numThreadCaches() {
        return this.numThreadCaches.get();
    }

    @Override
    public int numTinySubpages() {
        return this.tinySubpagePools.length;
    }

    @Override
    public int numSmallSubpages() {
        return this.smallSubpagePools.length;
    }

    @Override
    public int numChunkLists() {
        return this.chunkListMetrics.size();
    }

    @Override
    public List<PoolSubpageMetric> tinySubpages() {
        return PoolArena.subPageMetricList(this.tinySubpagePools);
    }

    @Override
    public List<PoolSubpageMetric> smallSubpages() {
        return PoolArena.subPageMetricList(this.smallSubpagePools);
    }

    @Override
    public List<PoolChunkListMetric> chunkLists() {
        return this.chunkListMetrics;
    }

    private static List<PoolSubpageMetric> subPageMetricList(PoolSubpage<?>[] poolSubpageArray) {
        ArrayList<PoolSubpageMetric> arrayList = new ArrayList<PoolSubpageMetric>();
        for (PoolSubpage<?> poolSubpage : poolSubpageArray) {
            if (poolSubpage.next == poolSubpage) continue;
            PoolSubpage poolSubpage2 = poolSubpage.next;
            do {
                arrayList.add(poolSubpage2);
            } while ((poolSubpage2 = poolSubpage2.next) != poolSubpage);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long numAllocations() {
        long l2;
        PoolArena poolArena = this;
        synchronized (poolArena) {
            l2 = this.allocationsNormal;
        }
        return this.allocationsTiny.value() + this.allocationsSmall.value() + l2 + this.allocationsHuge.value();
    }

    @Override
    public long numTinyAllocations() {
        return this.allocationsTiny.value();
    }

    @Override
    public long numSmallAllocations() {
        return this.allocationsSmall.value();
    }

    @Override
    public synchronized long numNormalAllocations() {
        return this.allocationsNormal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long numDeallocations() {
        long l2;
        PoolArena poolArena = this;
        synchronized (poolArena) {
            l2 = this.deallocationsTiny + this.deallocationsSmall + this.deallocationsNormal;
        }
        return l2 + this.deallocationsHuge.value();
    }

    @Override
    public synchronized long numTinyDeallocations() {
        return this.deallocationsTiny;
    }

    @Override
    public synchronized long numSmallDeallocations() {
        return this.deallocationsSmall;
    }

    @Override
    public synchronized long numNormalDeallocations() {
        return this.deallocationsNormal;
    }

    @Override
    public long numHugeAllocations() {
        return this.allocationsHuge.value();
    }

    @Override
    public long numHugeDeallocations() {
        return this.deallocationsHuge.value();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long numActiveAllocations() {
        long l2 = this.allocationsTiny.value() + this.allocationsSmall.value() + this.allocationsHuge.value() - this.deallocationsHuge.value();
        PoolArena poolArena = this;
        synchronized (poolArena) {
        }
        return Math.max(l2 += this.allocationsNormal - (this.deallocationsTiny + this.deallocationsSmall + this.deallocationsNormal), 0L);
    }

    @Override
    public long numActiveTinyAllocations() {
        return Math.max(this.numTinyAllocations() - this.numTinyDeallocations(), 0L);
    }

    @Override
    public long numActiveSmallAllocations() {
        return Math.max(this.numSmallAllocations() - this.numSmallDeallocations(), 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long numActiveNormalAllocations() {
        long l2;
        PoolArena poolArena = this;
        synchronized (poolArena) {
            l2 = this.allocationsNormal - this.deallocationsNormal;
        }
        return Math.max(l2, 0L);
    }

    @Override
    public long numActiveHugeAllocations() {
        return Math.max(this.numHugeAllocations() - this.numHugeDeallocations(), 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long numActiveBytes() {
        long l2 = this.activeBytesHuge.value();
        PoolArena poolArena = this;
        synchronized (poolArena) {
            for (int i2 = 0; i2 < this.chunkListMetrics.size(); ++i2) {
                for (PoolChunkMetric poolChunkMetric : this.chunkListMetrics.get(i2)) {
                    l2 += (long)poolChunkMetric.chunkSize();
                }
            }
        }
        return Math.max(0L, l2);
    }

    protected abstract PoolChunk<T> newChunk(int var1, int var2, int var3, int var4);

    protected abstract PoolChunk<T> newUnpooledChunk(int var1);

    protected abstract PooledByteBuf<T> newByteBuf(int var1);

    protected abstract void memoryCopy(T var1, int var2, T var3, int var4, int var5);

    protected abstract void destroyChunk(PoolChunk<T> var1);

    public synchronized String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("Chunk(s) at 0~25%:").append(StringUtil.NEWLINE).append(this.qInit).append(StringUtil.NEWLINE).append("Chunk(s) at 0~50%:").append(StringUtil.NEWLINE).append(this.q000).append(StringUtil.NEWLINE).append("Chunk(s) at 25~75%:").append(StringUtil.NEWLINE).append(this.q025).append(StringUtil.NEWLINE).append("Chunk(s) at 50~100%:").append(StringUtil.NEWLINE).append(this.q050).append(StringUtil.NEWLINE).append("Chunk(s) at 75~100%:").append(StringUtil.NEWLINE).append(this.q075).append(StringUtil.NEWLINE).append("Chunk(s) at 100%:").append(StringUtil.NEWLINE).append(this.q100).append(StringUtil.NEWLINE).append("tiny subpages:");
        PoolArena.appendPoolSubPages(stringBuilder, this.tinySubpagePools);
        stringBuilder.append(StringUtil.NEWLINE).append("small subpages:");
        PoolArena.appendPoolSubPages(stringBuilder, this.smallSubpagePools);
        stringBuilder.append(StringUtil.NEWLINE);
        return stringBuilder.toString();
    }

    private static void appendPoolSubPages(StringBuilder stringBuilder, PoolSubpage<?>[] poolSubpageArray) {
        for (int i2 = 0; i2 < poolSubpageArray.length; ++i2) {
            PoolSubpage<?> poolSubpage = poolSubpageArray[i2];
            if (poolSubpage.next == poolSubpage) continue;
            stringBuilder.append(StringUtil.NEWLINE).append(i2).append(": ");
            PoolSubpage poolSubpage2 = poolSubpage.next;
            do {
                stringBuilder.append(poolSubpage2);
            } while ((poolSubpage2 = poolSubpage2.next) != poolSubpage);
        }
    }

    protected final void finalize() {
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            PoolArena.destroyPoolSubPages(this.smallSubpagePools);
            PoolArena.destroyPoolSubPages(this.tinySubpagePools);
            this.destroyPoolChunkLists(this.qInit, this.q000, this.q025, this.q050, this.q075, this.q100);
            throw throwable;
        }
        PoolArena.destroyPoolSubPages(this.smallSubpagePools);
        PoolArena.destroyPoolSubPages(this.tinySubpagePools);
        this.destroyPoolChunkLists(this.qInit, this.q000, this.q025, this.q050, this.q075, this.q100);
    }

    private static void destroyPoolSubPages(PoolSubpage<?>[] poolSubpageArray) {
        for (PoolSubpage<?> poolSubpage : poolSubpageArray) {
            poolSubpage.destroy();
        }
    }

    private void destroyPoolChunkLists(PoolChunkList<T> ... poolChunkListArray) {
        for (PoolChunkList<T> poolChunkList : poolChunkListArray) {
            poolChunkList.destroy(this);
        }
    }
}

