/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.PoolArena;
import io.netty.buffer.PoolChunk;
import io.netty.buffer.PooledByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.PooledDirectByteBuf;
import io.netty.buffer.PooledUnsafeDirectByteBuf;
import io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;

final class PoolArena$DirectArena
extends PoolArena<ByteBuffer> {
    PoolArena$DirectArena(PooledByteBufAllocator pooledByteBufAllocator, int n2, int n3, int n4, int n5, int n6) {
        super(pooledByteBufAllocator, n2, n3, n4, n5, n6);
    }

    @Override
    boolean isDirect() {
        return true;
    }

    private int offsetCacheLine(ByteBuffer byteBuffer) {
        return HAS_UNSAFE ? (int)(PlatformDependent.directBufferAddress(byteBuffer) & (long)this.directMemoryCacheAlignmentMask) : 0;
    }

    @Override
    protected PoolChunk<ByteBuffer> newChunk(int n2, int n3, int n4, int n5) {
        if (this.directMemoryCacheAlignment == 0) {
            return new PoolChunk<ByteBuffer>(this, PoolArena$DirectArena.allocateDirect(n5), n2, n3, n4, n5, 0);
        }
        ByteBuffer byteBuffer = PoolArena$DirectArena.allocateDirect(n5 + this.directMemoryCacheAlignment);
        return new PoolChunk<ByteBuffer>(this, byteBuffer, n2, n3, n4, n5, this.offsetCacheLine(byteBuffer));
    }

    @Override
    protected PoolChunk<ByteBuffer> newUnpooledChunk(int n2) {
        if (this.directMemoryCacheAlignment == 0) {
            return new PoolChunk<ByteBuffer>(this, PoolArena$DirectArena.allocateDirect(n2), n2, 0);
        }
        ByteBuffer byteBuffer = PoolArena$DirectArena.allocateDirect(n2 + this.directMemoryCacheAlignment);
        return new PoolChunk<ByteBuffer>(this, byteBuffer, n2, this.offsetCacheLine(byteBuffer));
    }

    private static ByteBuffer allocateDirect(int n2) {
        return PlatformDependent.useDirectBufferNoCleaner() ? PlatformDependent.allocateDirectNoCleaner(n2) : ByteBuffer.allocateDirect(n2);
    }

    @Override
    protected void destroyChunk(PoolChunk<ByteBuffer> poolChunk) {
        if (PlatformDependent.useDirectBufferNoCleaner()) {
            PlatformDependent.freeDirectNoCleaner((ByteBuffer)poolChunk.memory);
        } else {
            PlatformDependent.freeDirectBuffer((ByteBuffer)poolChunk.memory);
        }
    }

    @Override
    protected PooledByteBuf<ByteBuffer> newByteBuf(int n2) {
        if (HAS_UNSAFE) {
            return PooledUnsafeDirectByteBuf.newInstance(n2);
        }
        return PooledDirectByteBuf.newInstance(n2);
    }

    @Override
    protected void memoryCopy(ByteBuffer byteBuffer, int n2, ByteBuffer byteBuffer2, int n3, int n4) {
        if (n4 == 0) {
            return;
        }
        if (HAS_UNSAFE) {
            PlatformDependent.copyMemory(PlatformDependent.directBufferAddress(byteBuffer) + (long)n2, PlatformDependent.directBufferAddress(byteBuffer2) + (long)n3, n4);
        } else {
            byteBuffer = byteBuffer.duplicate();
            byteBuffer2 = byteBuffer2.duplicate();
            byteBuffer.position(n2).limit(n2 + n4);
            byteBuffer2.position(n3);
            byteBuffer2.put(byteBuffer);
        }
    }
}

