/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.FixedCompositeByteBuf$Component;
import io.netty.buffer.Unpooled;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.RecyclableArrayList;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.util.Collections;

final class FixedCompositeByteBuf
extends AbstractReferenceCountedByteBuf {
    private static final ByteBuf[] EMPTY = new ByteBuf[]{Unpooled.EMPTY_BUFFER};
    private final int nioBufferCount;
    private final int capacity;
    private final ByteBufAllocator allocator;
    private final ByteOrder order;
    private final Object[] buffers;
    private final boolean direct;

    FixedCompositeByteBuf(ByteBufAllocator byteBufAllocator, ByteBuf ... byteBufArray) {
        super(Integer.MAX_VALUE);
        if (byteBufArray.length == 0) {
            this.buffers = EMPTY;
            this.order = ByteOrder.BIG_ENDIAN;
            this.nioBufferCount = 1;
            this.capacity = 0;
            this.direct = false;
        } else {
            ByteBuf byteBuf = byteBufArray[0];
            this.buffers = new Object[byteBufArray.length];
            this.buffers[0] = byteBuf;
            boolean bl2 = true;
            int n2 = byteBuf.nioBufferCount();
            int n3 = byteBuf.readableBytes();
            this.order = byteBuf.order();
            for (int i2 = 1; i2 < byteBufArray.length; ++i2) {
                byteBuf = byteBufArray[i2];
                if (byteBufArray[i2].order() != this.order) {
                    throw new IllegalArgumentException("All ByteBufs need to have same ByteOrder");
                }
                n2 += byteBuf.nioBufferCount();
                n3 += byteBuf.readableBytes();
                if (!byteBuf.isDirect()) {
                    bl2 = false;
                }
                this.buffers[i2] = byteBuf;
            }
            this.nioBufferCount = n2;
            this.capacity = n3;
            this.direct = bl2;
        }
        this.setIndex(0, this.capacity());
        this.allocator = byteBufAllocator;
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public boolean isWritable(int n2) {
        return false;
    }

    @Override
    public ByteBuf discardReadBytes() {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setBytes(int n2, byte[] byArray, int n3, int n4) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setBytes(int n2, ByteBuffer byteBuffer) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setByte(int n2, int n3) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setByte(int n2, int n3) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setShort(int n2, int n3) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setShort(int n2, int n3) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setShortLE(int n2, int n3) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setMedium(int n2, int n3) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setMedium(int n2, int n3) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setMediumLE(int n2, int n3) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setInt(int n2, int n3) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setInt(int n2, int n3) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setIntLE(int n2, int n3) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setLong(int n2, long l2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setLong(int n2, long l2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setLongLE(int n2, long l2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public int setBytes(int n2, InputStream inputStream, int n3) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public int setBytes(int n2, ScatteringByteChannel scatteringByteChannel, int n3) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public int setBytes(int n2, FileChannel fileChannel, long l2, int n3) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public int maxCapacity() {
        return this.capacity;
    }

    @Override
    public ByteBuf capacity(int n2) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.allocator;
    }

    @Override
    public ByteOrder order() {
        return this.order;
    }

    @Override
    public ByteBuf unwrap() {
        return null;
    }

    @Override
    public boolean isDirect() {
        return this.direct;
    }

    private FixedCompositeByteBuf$Component findComponent(int n2) {
        int n3 = 0;
        for (int i2 = 0; i2 < this.buffers.length; ++i2) {
            boolean bl2;
            ByteBuf byteBuf;
            FixedCompositeByteBuf$Component fixedCompositeByteBuf$Component = null;
            Object object = this.buffers[i2];
            if (object instanceof ByteBuf) {
                byteBuf = (ByteBuf)object;
                bl2 = true;
            } else {
                fixedCompositeByteBuf$Component = (FixedCompositeByteBuf$Component)object;
                byteBuf = FixedCompositeByteBuf$Component.access$000(fixedCompositeByteBuf$Component);
                bl2 = false;
            }
            if (n2 >= (n3 += byteBuf.readableBytes())) continue;
            if (bl2) {
                fixedCompositeByteBuf$Component = new FixedCompositeByteBuf$Component(i2, n3 - byteBuf.readableBytes(), byteBuf);
                this.buffers[i2] = fixedCompositeByteBuf$Component;
            }
            return fixedCompositeByteBuf$Component;
        }
        throw new IllegalStateException();
    }

    private ByteBuf buffer(int n2) {
        Object object = this.buffers[n2];
        if (object instanceof ByteBuf) {
            return (ByteBuf)object;
        }
        return FixedCompositeByteBuf$Component.access$000((FixedCompositeByteBuf$Component)object);
    }

    @Override
    public byte getByte(int n2) {
        return this._getByte(n2);
    }

    @Override
    protected byte _getByte(int n2) {
        FixedCompositeByteBuf$Component fixedCompositeByteBuf$Component = this.findComponent(n2);
        return FixedCompositeByteBuf$Component.access$000(fixedCompositeByteBuf$Component).getByte(n2 - FixedCompositeByteBuf$Component.access$100(fixedCompositeByteBuf$Component));
    }

    @Override
    protected short _getShort(int n2) {
        FixedCompositeByteBuf$Component fixedCompositeByteBuf$Component = this.findComponent(n2);
        if (n2 + 2 <= FixedCompositeByteBuf$Component.access$200(fixedCompositeByteBuf$Component)) {
            return FixedCompositeByteBuf$Component.access$000(fixedCompositeByteBuf$Component).getShort(n2 - FixedCompositeByteBuf$Component.access$100(fixedCompositeByteBuf$Component));
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return (short)((this._getByte(n2) & 0xFF) << 8 | this._getByte(n2 + 1) & 0xFF);
        }
        return (short)(this._getByte(n2) & 0xFF | (this._getByte(n2 + 1) & 0xFF) << 8);
    }

    @Override
    protected short _getShortLE(int n2) {
        FixedCompositeByteBuf$Component fixedCompositeByteBuf$Component = this.findComponent(n2);
        if (n2 + 2 <= FixedCompositeByteBuf$Component.access$200(fixedCompositeByteBuf$Component)) {
            return FixedCompositeByteBuf$Component.access$000(fixedCompositeByteBuf$Component).getShortLE(n2 - FixedCompositeByteBuf$Component.access$100(fixedCompositeByteBuf$Component));
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return (short)(this._getByte(n2) & 0xFF | (this._getByte(n2 + 1) & 0xFF) << 8);
        }
        return (short)((this._getByte(n2) & 0xFF) << 8 | this._getByte(n2 + 1) & 0xFF);
    }

    @Override
    protected int _getUnsignedMedium(int n2) {
        FixedCompositeByteBuf$Component fixedCompositeByteBuf$Component = this.findComponent(n2);
        if (n2 + 3 <= FixedCompositeByteBuf$Component.access$200(fixedCompositeByteBuf$Component)) {
            return FixedCompositeByteBuf$Component.access$000(fixedCompositeByteBuf$Component).getUnsignedMedium(n2 - FixedCompositeByteBuf$Component.access$100(fixedCompositeByteBuf$Component));
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return (this._getShort(n2) & 0xFFFF) << 8 | this._getByte(n2 + 2) & 0xFF;
        }
        return this._getShort(n2) & 0xFFFF | (this._getByte(n2 + 2) & 0xFF) << 16;
    }

    @Override
    protected int _getUnsignedMediumLE(int n2) {
        FixedCompositeByteBuf$Component fixedCompositeByteBuf$Component = this.findComponent(n2);
        if (n2 + 3 <= FixedCompositeByteBuf$Component.access$200(fixedCompositeByteBuf$Component)) {
            return FixedCompositeByteBuf$Component.access$000(fixedCompositeByteBuf$Component).getUnsignedMediumLE(n2 - FixedCompositeByteBuf$Component.access$100(fixedCompositeByteBuf$Component));
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return this._getShortLE(n2) & 0xFFFF | (this._getByte(n2 + 2) & 0xFF) << 16;
        }
        return (this._getShortLE(n2) & 0xFFFF) << 8 | this._getByte(n2 + 2) & 0xFF;
    }

    @Override
    protected int _getInt(int n2) {
        FixedCompositeByteBuf$Component fixedCompositeByteBuf$Component = this.findComponent(n2);
        if (n2 + 4 <= FixedCompositeByteBuf$Component.access$200(fixedCompositeByteBuf$Component)) {
            return FixedCompositeByteBuf$Component.access$000(fixedCompositeByteBuf$Component).getInt(n2 - FixedCompositeByteBuf$Component.access$100(fixedCompositeByteBuf$Component));
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return (this._getShort(n2) & 0xFFFF) << 16 | this._getShort(n2 + 2) & 0xFFFF;
        }
        return this._getShort(n2) & 0xFFFF | (this._getShort(n2 + 2) & 0xFFFF) << 16;
    }

    @Override
    protected int _getIntLE(int n2) {
        FixedCompositeByteBuf$Component fixedCompositeByteBuf$Component = this.findComponent(n2);
        if (n2 + 4 <= FixedCompositeByteBuf$Component.access$200(fixedCompositeByteBuf$Component)) {
            return FixedCompositeByteBuf$Component.access$000(fixedCompositeByteBuf$Component).getIntLE(n2 - FixedCompositeByteBuf$Component.access$100(fixedCompositeByteBuf$Component));
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return this._getShortLE(n2) & 0xFFFF | (this._getShortLE(n2 + 2) & 0xFFFF) << 16;
        }
        return (this._getShortLE(n2) & 0xFFFF) << 16 | this._getShortLE(n2 + 2) & 0xFFFF;
    }

    @Override
    protected long _getLong(int n2) {
        FixedCompositeByteBuf$Component fixedCompositeByteBuf$Component = this.findComponent(n2);
        if (n2 + 8 <= FixedCompositeByteBuf$Component.access$200(fixedCompositeByteBuf$Component)) {
            return FixedCompositeByteBuf$Component.access$000(fixedCompositeByteBuf$Component).getLong(n2 - FixedCompositeByteBuf$Component.access$100(fixedCompositeByteBuf$Component));
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return ((long)this._getInt(n2) & 0xFFFFFFFFL) << 32 | (long)this._getInt(n2 + 4) & 0xFFFFFFFFL;
        }
        return (long)this._getInt(n2) & 0xFFFFFFFFL | ((long)this._getInt(n2 + 4) & 0xFFFFFFFFL) << 32;
    }

    @Override
    protected long _getLongLE(int n2) {
        FixedCompositeByteBuf$Component fixedCompositeByteBuf$Component = this.findComponent(n2);
        if (n2 + 8 <= FixedCompositeByteBuf$Component.access$200(fixedCompositeByteBuf$Component)) {
            return FixedCompositeByteBuf$Component.access$000(fixedCompositeByteBuf$Component).getLongLE(n2 - FixedCompositeByteBuf$Component.access$100(fixedCompositeByteBuf$Component));
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return (long)this._getIntLE(n2) & 0xFFFFFFFFL | ((long)this._getIntLE(n2 + 4) & 0xFFFFFFFFL) << 32;
        }
        return ((long)this._getIntLE(n2) & 0xFFFFFFFFL) << 32 | (long)this._getIntLE(n2 + 4) & 0xFFFFFFFFL;
    }

    @Override
    public ByteBuf getBytes(int n2, byte[] byArray, int n3, int n4) {
        this.checkDstIndex(n2, n4, n3, byArray.length);
        if (n4 == 0) {
            return this;
        }
        FixedCompositeByteBuf$Component fixedCompositeByteBuf$Component = this.findComponent(n2);
        int n5 = FixedCompositeByteBuf$Component.access$300(fixedCompositeByteBuf$Component);
        int n6 = FixedCompositeByteBuf$Component.access$100(fixedCompositeByteBuf$Component);
        ByteBuf byteBuf = FixedCompositeByteBuf$Component.access$000(fixedCompositeByteBuf$Component);
        while (true) {
            int n7 = Math.min(n4, byteBuf.readableBytes() - (n2 - n6));
            byteBuf.getBytes(n2 - n6, byArray, n3, n7);
            n2 += n7;
            n3 += n7;
            n6 += byteBuf.readableBytes();
            if ((n4 -= n7) <= 0) break;
            byteBuf = this.buffer(++n5);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf getBytes(int n2, ByteBuffer byteBuffer) {
        int n3 = byteBuffer.limit();
        int n4 = byteBuffer.remaining();
        this.checkIndex(n2, n4);
        if (n4 == 0) {
            return this;
        }
        try {
            FixedCompositeByteBuf$Component fixedCompositeByteBuf$Component = this.findComponent(n2);
            int n5 = FixedCompositeByteBuf$Component.access$300(fixedCompositeByteBuf$Component);
            int n6 = FixedCompositeByteBuf$Component.access$100(fixedCompositeByteBuf$Component);
            ByteBuf byteBuf = FixedCompositeByteBuf$Component.access$000(fixedCompositeByteBuf$Component);
            while (true) {
                int n7 = Math.min(n4, byteBuf.readableBytes() - (n2 - n6));
                byteBuffer.limit(byteBuffer.position() + n7);
                byteBuf.getBytes(n2 - n6, byteBuffer);
                n2 += n7;
                n6 += byteBuf.readableBytes();
                if ((n4 -= n7) <= 0) {
                    break;
                }
                byteBuf = this.buffer(++n5);
            }
        }
        finally {
            byteBuffer.limit(n3);
        }
        return this;
    }

    @Override
    public ByteBuf getBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        this.checkDstIndex(n2, n4, n3, byteBuf.capacity());
        if (n4 == 0) {
            return this;
        }
        FixedCompositeByteBuf$Component fixedCompositeByteBuf$Component = this.findComponent(n2);
        int n5 = FixedCompositeByteBuf$Component.access$300(fixedCompositeByteBuf$Component);
        int n6 = FixedCompositeByteBuf$Component.access$100(fixedCompositeByteBuf$Component);
        ByteBuf byteBuf2 = FixedCompositeByteBuf$Component.access$000(fixedCompositeByteBuf$Component);
        while (true) {
            int n7 = Math.min(n4, byteBuf2.readableBytes() - (n2 - n6));
            byteBuf2.getBytes(n2 - n6, byteBuf, n3, n7);
            n2 += n7;
            n3 += n7;
            n6 += byteBuf2.readableBytes();
            if ((n4 -= n7) <= 0) break;
            byteBuf2 = this.buffer(++n5);
        }
        return this;
    }

    @Override
    public int getBytes(int n2, GatheringByteChannel gatheringByteChannel, int n3) {
        int n4 = this.nioBufferCount();
        if (n4 == 1) {
            return gatheringByteChannel.write(this.internalNioBuffer(n2, n3));
        }
        long l2 = gatheringByteChannel.write(this.nioBuffers(n2, n3));
        if (l2 > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l2;
    }

    @Override
    public int getBytes(int n2, FileChannel fileChannel, long l2, int n3) {
        int n4 = this.nioBufferCount();
        if (n4 == 1) {
            return fileChannel.write(this.internalNioBuffer(n2, n3), l2);
        }
        long l3 = 0L;
        for (ByteBuffer byteBuffer : this.nioBuffers(n2, n3)) {
            l3 += (long)fileChannel.write(byteBuffer, l2 + l3);
        }
        if (l3 > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l3;
    }

    @Override
    public ByteBuf getBytes(int n2, OutputStream outputStream, int n3) {
        this.checkIndex(n2, n3);
        if (n3 == 0) {
            return this;
        }
        FixedCompositeByteBuf$Component fixedCompositeByteBuf$Component = this.findComponent(n2);
        int n4 = FixedCompositeByteBuf$Component.access$300(fixedCompositeByteBuf$Component);
        int n5 = FixedCompositeByteBuf$Component.access$100(fixedCompositeByteBuf$Component);
        ByteBuf byteBuf = FixedCompositeByteBuf$Component.access$000(fixedCompositeByteBuf$Component);
        while (true) {
            int n6 = Math.min(n3, byteBuf.readableBytes() - (n2 - n5));
            byteBuf.getBytes(n2 - n5, outputStream, n6);
            n2 += n6;
            n5 += byteBuf.readableBytes();
            if ((n3 -= n6) <= 0) break;
            byteBuf = this.buffer(++n4);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf copy(int n2, int n3) {
        this.checkIndex(n2, n3);
        boolean bl2 = true;
        ByteBuf byteBuf = this.alloc().buffer(n3);
        try {
            byteBuf.writeBytes(this, n2, n3);
            bl2 = false;
            ByteBuf byteBuf2 = byteBuf;
            return byteBuf2;
        }
        finally {
            if (bl2) {
                byteBuf.release();
            }
        }
    }

    @Override
    public int nioBufferCount() {
        return this.nioBufferCount;
    }

    @Override
    public ByteBuffer nioBuffer(int n2, int n3) {
        Comparable<ByteBuf> comparable;
        this.checkIndex(n2, n3);
        if (this.buffers.length == 1 && ((ByteBuf)(comparable = this.buffer(0))).nioBufferCount() == 1) {
            return ((ByteBuf)comparable).nioBuffer(n2, n3);
        }
        comparable = ByteBuffer.allocate(n3).order(this.order());
        ByteBuffer[] byteBufferArray = this.nioBuffers(n2, n3);
        for (int i2 = 0; i2 < byteBufferArray.length; ++i2) {
            ((ByteBuffer)comparable).put(byteBufferArray[i2]);
        }
        ((ByteBuffer)comparable).flip();
        return comparable;
    }

    @Override
    public ByteBuffer internalNioBuffer(int n2, int n3) {
        if (this.buffers.length == 1) {
            return this.buffer(0).internalNioBuffer(n2, n3);
        }
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer[] nioBuffers(int n2, int n3) {
        this.checkIndex(n2, n3);
        if (n3 == 0) {
            return EmptyArrays.EMPTY_BYTE_BUFFERS;
        }
        RecyclableArrayList recyclableArrayList = RecyclableArrayList.newInstance(this.buffers.length);
        try {
            FixedCompositeByteBuf$Component fixedCompositeByteBuf$Component = this.findComponent(n2);
            int n4 = FixedCompositeByteBuf$Component.access$300(fixedCompositeByteBuf$Component);
            int n5 = FixedCompositeByteBuf$Component.access$100(fixedCompositeByteBuf$Component);
            ByteBuf byteBuf = FixedCompositeByteBuf$Component.access$000(fixedCompositeByteBuf$Component);
            while (true) {
                int n6 = Math.min(n3, byteBuf.readableBytes() - (n2 - n5));
                switch (byteBuf.nioBufferCount()) {
                    case 0: {
                        throw new UnsupportedOperationException();
                    }
                    case 1: {
                        recyclableArrayList.add(byteBuf.nioBuffer(n2 - n5, n6));
                        break;
                    }
                    default: {
                        Collections.addAll(recyclableArrayList, byteBuf.nioBuffers(n2 - n5, n6));
                    }
                }
                n2 += n6;
                n5 += byteBuf.readableBytes();
                if ((n3 -= n6) <= 0) break;
                byteBuf = this.buffer(++n4);
            }
            ByteBuffer[] byteBufferArray = recyclableArrayList.toArray(new ByteBuffer[recyclableArrayList.size()]);
            return byteBufferArray;
        }
        finally {
            recyclableArrayList.recycle();
        }
    }

    @Override
    public boolean hasArray() {
        switch (this.buffers.length) {
            case 0: {
                return true;
            }
            case 1: {
                return this.buffer(0).hasArray();
            }
        }
        return false;
    }

    @Override
    public byte[] array() {
        switch (this.buffers.length) {
            case 0: {
                return EmptyArrays.EMPTY_BYTES;
            }
            case 1: {
                return this.buffer(0).array();
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public int arrayOffset() {
        switch (this.buffers.length) {
            case 0: {
                return 0;
            }
            case 1: {
                return this.buffer(0).arrayOffset();
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasMemoryAddress() {
        switch (this.buffers.length) {
            case 0: {
                return Unpooled.EMPTY_BUFFER.hasMemoryAddress();
            }
            case 1: {
                return this.buffer(0).hasMemoryAddress();
            }
        }
        return false;
    }

    @Override
    public long memoryAddress() {
        switch (this.buffers.length) {
            case 0: {
                return Unpooled.EMPTY_BUFFER.memoryAddress();
            }
            case 1: {
                return this.buffer(0).memoryAddress();
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    protected void deallocate() {
        for (int i2 = 0; i2 < this.buffers.length; ++i2) {
            this.buffer(i2).release();
        }
    }

    @Override
    public String toString() {
        String string = super.toString();
        string = string.substring(0, string.length() - 1);
        return string + ", components=" + this.buffers.length + ')';
    }
}

