/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.AbstractByteBufAllocator;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil$1;
import io.netty.buffer.ByteBufUtil$2;
import io.netty.buffer.ByteBufUtil$HexUtil;
import io.netty.buffer.ByteBufUtil$ThreadLocalDirectByteBuf;
import io.netty.buffer.ByteBufUtil$ThreadLocalUnsafeDirectByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.buffer.WrappedByteBuf;
import io.netty.util.AsciiString;
import io.netty.util.ByteProcessor;
import io.netty.util.ByteProcessor$IndexOfProcessor;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.internal.MathUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Arrays;
import java.util.Locale;

public final class ByteBufUtil {
    private static final InternalLogger logger;
    private static final FastThreadLocal<CharBuffer> CHAR_BUFFERS;
    private static final byte WRITE_UTF_UNKNOWN = 63;
    private static final int MAX_CHAR_BUFFER_SIZE;
    private static final int THREAD_LOCAL_BUFFER_SIZE;
    private static final int MAX_BYTES_PER_CHAR_UTF8;
    static final int WRITE_CHUNK_SIZE = 8192;
    static final ByteBufAllocator DEFAULT_ALLOCATOR;
    private static final ByteProcessor FIND_NON_ASCII;

    public static String hexDump(ByteBuf byteBuf) {
        return ByteBufUtil.hexDump(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes());
    }

    public static String hexDump(ByteBuf byteBuf, int n2, int n3) {
        return ByteBufUtil$HexUtil.access$000(byteBuf, n2, n3);
    }

    public static String hexDump(byte[] byArray) {
        return ByteBufUtil.hexDump(byArray, 0, byArray.length);
    }

    public static String hexDump(byte[] byArray, int n2, int n3) {
        return ByteBufUtil$HexUtil.access$100(byArray, n2, n3);
    }

    public static byte decodeHexByte(CharSequence charSequence, int n2) {
        return StringUtil.decodeHexByte(charSequence, n2);
    }

    public static byte[] decodeHexDump(CharSequence charSequence) {
        return StringUtil.decodeHexDump(charSequence, 0, charSequence.length());
    }

    public static byte[] decodeHexDump(CharSequence charSequence, int n2, int n3) {
        return StringUtil.decodeHexDump(charSequence, n2, n3);
    }

    public static boolean ensureWritableSuccess(int n2) {
        return n2 == 0 || n2 == 2;
    }

    public static int hashCode(ByteBuf byteBuf) {
        int n2;
        int n3 = byteBuf.readableBytes();
        int n4 = n3 >>> 2;
        int n5 = n3 & 3;
        int n6 = 1;
        int n7 = byteBuf.readerIndex();
        if (byteBuf.order() == ByteOrder.BIG_ENDIAN) {
            for (n2 = n4; n2 > 0; --n2) {
                n6 = 31 * n6 + byteBuf.getInt(n7);
                n7 += 4;
            }
        } else {
            for (n2 = n4; n2 > 0; --n2) {
                n6 = 31 * n6 + ByteBufUtil.swapInt(byteBuf.getInt(n7));
                n7 += 4;
            }
        }
        for (n2 = n5; n2 > 0; --n2) {
            n6 = 31 * n6 + byteBuf.getByte(n7++);
        }
        if (n6 == 0) {
            n6 = 1;
        }
        return n6;
    }

    public static int indexOf(ByteBuf byteBuf, ByteBuf byteBuf2) {
        int n2 = byteBuf2.readableBytes() - byteBuf.readableBytes() + 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!ByteBufUtil.equals(byteBuf, byteBuf.readerIndex(), byteBuf2, byteBuf2.readerIndex() + i2, byteBuf.readableBytes())) continue;
            return byteBuf2.readerIndex() + i2;
        }
        return -1;
    }

    public static boolean equals(ByteBuf byteBuf, int n2, ByteBuf byteBuf2, int n3, int n4) {
        int n5;
        if (n2 < 0 || n3 < 0 || n4 < 0) {
            throw new IllegalArgumentException("All indexes and lengths must be non-negative");
        }
        if (byteBuf.writerIndex() - n4 < n2 || byteBuf2.writerIndex() - n4 < n3) {
            return false;
        }
        int n6 = n4 >>> 3;
        int n7 = n4 & 7;
        if (byteBuf.order() == byteBuf2.order()) {
            for (n5 = n6; n5 > 0; --n5) {
                if (byteBuf.getLong(n2) != byteBuf2.getLong(n3)) {
                    return false;
                }
                n2 += 8;
                n3 += 8;
            }
        } else {
            for (n5 = n6; n5 > 0; --n5) {
                if (byteBuf.getLong(n2) != ByteBufUtil.swapLong(byteBuf2.getLong(n3))) {
                    return false;
                }
                n2 += 8;
                n3 += 8;
            }
        }
        for (n5 = n7; n5 > 0; --n5) {
            if (byteBuf.getByte(n2) != byteBuf2.getByte(n3)) {
                return false;
            }
            ++n2;
            ++n3;
        }
        return true;
    }

    public static boolean equals(ByteBuf byteBuf, ByteBuf byteBuf2) {
        int n2 = byteBuf.readableBytes();
        if (n2 != byteBuf2.readableBytes()) {
            return false;
        }
        return ByteBufUtil.equals(byteBuf, byteBuf.readerIndex(), byteBuf2, byteBuf2.readerIndex(), n2);
    }

    public static int compare(ByteBuf byteBuf, ByteBuf byteBuf2) {
        int n2;
        int n3 = byteBuf.readableBytes();
        int n4 = byteBuf2.readableBytes();
        int n5 = Math.min(n3, n4);
        int n6 = n5 >>> 2;
        int n7 = n5 & 3;
        int n8 = byteBuf.readerIndex();
        int n9 = byteBuf2.readerIndex();
        if (n6 > 0) {
            long l2;
            n2 = byteBuf.order() == ByteOrder.BIG_ENDIAN ? 1 : 0;
            int n10 = n6 << 2;
            if (byteBuf.order() == byteBuf2.order()) {
                l2 = n2 != 0 ? ByteBufUtil.compareUintBigEndian(byteBuf, byteBuf2, n8, n9, n10) : ByteBufUtil.compareUintLittleEndian(byteBuf, byteBuf2, n8, n9, n10);
            } else {
                long l3 = l2 = n2 != 0 ? ByteBufUtil.compareUintBigEndianA(byteBuf, byteBuf2, n8, n9, n10) : ByteBufUtil.compareUintBigEndianB(byteBuf, byteBuf2, n8, n9, n10);
            }
            if (l2 != 0L) {
                return (int)Math.min(Integer.MAX_VALUE, Math.max(Integer.MIN_VALUE, l2));
            }
            n8 += n10;
            n9 += n10;
        }
        n2 = n8 + n7;
        while (n8 < n2) {
            int n11 = byteBuf.getUnsignedByte(n8) - byteBuf2.getUnsignedByte(n9);
            if (n11 != 0) {
                return n11;
            }
            ++n8;
            ++n9;
        }
        return n3 - n4;
    }

    private static long compareUintBigEndian(ByteBuf byteBuf, ByteBuf byteBuf2, int n2, int n3, int n4) {
        int n5 = n2 + n4;
        while (n2 < n5) {
            long l2 = byteBuf.getUnsignedInt(n2) - byteBuf2.getUnsignedInt(n3);
            if (l2 != 0L) {
                return l2;
            }
            n2 += 4;
            n3 += 4;
        }
        return 0L;
    }

    private static long compareUintLittleEndian(ByteBuf byteBuf, ByteBuf byteBuf2, int n2, int n3, int n4) {
        int n5 = n2 + n4;
        while (n2 < n5) {
            long l2 = byteBuf.getUnsignedIntLE(n2) - byteBuf2.getUnsignedIntLE(n3);
            if (l2 != 0L) {
                return l2;
            }
            n2 += 4;
            n3 += 4;
        }
        return 0L;
    }

    private static long compareUintBigEndianA(ByteBuf byteBuf, ByteBuf byteBuf2, int n2, int n3, int n4) {
        int n5 = n2 + n4;
        while (n2 < n5) {
            long l2 = byteBuf.getUnsignedInt(n2) - byteBuf2.getUnsignedIntLE(n3);
            if (l2 != 0L) {
                return l2;
            }
            n2 += 4;
            n3 += 4;
        }
        return 0L;
    }

    private static long compareUintBigEndianB(ByteBuf byteBuf, ByteBuf byteBuf2, int n2, int n3, int n4) {
        int n5 = n2 + n4;
        while (n2 < n5) {
            long l2 = byteBuf.getUnsignedIntLE(n2) - byteBuf2.getUnsignedInt(n3);
            if (l2 != 0L) {
                return l2;
            }
            n2 += 4;
            n3 += 4;
        }
        return 0L;
    }

    public static int indexOf(ByteBuf byteBuf, int n2, int n3, byte by2) {
        if (n2 <= n3) {
            return ByteBufUtil.firstIndexOf(byteBuf, n2, n3, by2);
        }
        return ByteBufUtil.lastIndexOf(byteBuf, n2, n3, by2);
    }

    public static short swapShort(short s2) {
        return Short.reverseBytes(s2);
    }

    public static int swapMedium(int n2) {
        int n3 = n2 << 16 & 0xFF0000 | n2 & 0xFF00 | n2 >>> 16 & 0xFF;
        if ((n3 & 0x800000) != 0) {
            n3 |= 0xFF000000;
        }
        return n3;
    }

    public static int swapInt(int n2) {
        return Integer.reverseBytes(n2);
    }

    public static long swapLong(long l2) {
        return Long.reverseBytes(l2);
    }

    public static ByteBuf writeShortBE(ByteBuf byteBuf, int n2) {
        return byteBuf.order() == ByteOrder.BIG_ENDIAN ? byteBuf.writeShort(n2) : byteBuf.writeShortLE(n2);
    }

    public static ByteBuf setShortBE(ByteBuf byteBuf, int n2, int n3) {
        return byteBuf.order() == ByteOrder.BIG_ENDIAN ? byteBuf.setShort(n2, n3) : byteBuf.setShortLE(n2, n3);
    }

    public static ByteBuf writeMediumBE(ByteBuf byteBuf, int n2) {
        return byteBuf.order() == ByteOrder.BIG_ENDIAN ? byteBuf.writeMedium(n2) : byteBuf.writeMediumLE(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuf readBytes(ByteBufAllocator byteBufAllocator, ByteBuf byteBuf, int n2) {
        boolean bl2 = true;
        ByteBuf byteBuf2 = byteBufAllocator.buffer(n2);
        try {
            byteBuf.readBytes(byteBuf2);
            bl2 = false;
            ByteBuf byteBuf3 = byteBuf2;
            return byteBuf3;
        }
        finally {
            if (bl2) {
                byteBuf2.release();
            }
        }
    }

    private static int firstIndexOf(ByteBuf byteBuf, int n2, int n3, byte by2) {
        if ((n2 = Math.max(n2, 0)) >= n3 || byteBuf.capacity() == 0) {
            return -1;
        }
        return byteBuf.forEachByte(n2, n3 - n2, new ByteProcessor$IndexOfProcessor(by2));
    }

    private static int lastIndexOf(ByteBuf byteBuf, int n2, int n3, byte by2) {
        if ((n2 = Math.min(n2, byteBuf.capacity())) < 0 || byteBuf.capacity() == 0) {
            return -1;
        }
        return byteBuf.forEachByteDesc(n3, n2 - n3, new ByteProcessor$IndexOfProcessor(by2));
    }

    public static ByteBuf writeUtf8(ByteBufAllocator byteBufAllocator, CharSequence charSequence) {
        ByteBuf byteBuf = byteBufAllocator.buffer(ByteBufUtil.utf8MaxBytes(charSequence));
        ByteBufUtil.writeUtf8(byteBuf, charSequence);
        return byteBuf;
    }

    public static int writeUtf8(ByteBuf byteBuf, CharSequence charSequence) {
        return ByteBufUtil.reserveAndWriteUtf8(byteBuf, charSequence, ByteBufUtil.utf8MaxBytes(charSequence));
    }

    public static int reserveAndWriteUtf8(ByteBuf byteBuf, CharSequence charSequence, int n2) {
        while (true) {
            if (byteBuf instanceof AbstractByteBuf) {
                AbstractByteBuf abstractByteBuf = (AbstractByteBuf)byteBuf;
                abstractByteBuf.ensureWritable0(n2);
                int n3 = ByteBufUtil.writeUtf8(abstractByteBuf, abstractByteBuf.writerIndex, charSequence, charSequence.length());
                abstractByteBuf.writerIndex += n3;
                return n3;
            }
            if (!(byteBuf instanceof WrappedByteBuf)) break;
            byteBuf = byteBuf.unwrap();
        }
        byte[] byArray = charSequence.toString().getBytes(CharsetUtil.UTF_8);
        byteBuf.writeBytes(byArray);
        return byArray.length;
    }

    static int writeUtf8(AbstractByteBuf abstractByteBuf, int n2, CharSequence charSequence, int n3) {
        int n4 = n2;
        for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = charSequence.charAt(i2);
            if (c2 < '\u0080') {
                abstractByteBuf._setByte(n2++, (byte)c2);
                continue;
            }
            if (c2 < '\u0800') {
                abstractByteBuf._setByte(n2++, (byte)(0xC0 | c2 >> 6));
                abstractByteBuf._setByte(n2++, (byte)(0x80 | c2 & 0x3F));
                continue;
            }
            if (StringUtil.isSurrogate(c2)) {
                char c3;
                if (!Character.isHighSurrogate(c2)) {
                    abstractByteBuf._setByte(n2++, 63);
                    continue;
                }
                try {
                    c3 = charSequence.charAt(++i2);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    abstractByteBuf._setByte(n2++, 63);
                    break;
                }
                if (!Character.isLowSurrogate(c3)) {
                    abstractByteBuf._setByte(n2++, 63);
                    abstractByteBuf._setByte(n2++, Character.isHighSurrogate(c3) ? 63 : (int)c3);
                    continue;
                }
                int n5 = Character.toCodePoint(c2, c3);
                abstractByteBuf._setByte(n2++, (byte)(0xF0 | n5 >> 18));
                abstractByteBuf._setByte(n2++, (byte)(0x80 | n5 >> 12 & 0x3F));
                abstractByteBuf._setByte(n2++, (byte)(0x80 | n5 >> 6 & 0x3F));
                abstractByteBuf._setByte(n2++, (byte)(0x80 | n5 & 0x3F));
                continue;
            }
            abstractByteBuf._setByte(n2++, (byte)(0xE0 | c2 >> 12));
            abstractByteBuf._setByte(n2++, (byte)(0x80 | c2 >> 6 & 0x3F));
            abstractByteBuf._setByte(n2++, (byte)(0x80 | c2 & 0x3F));
        }
        return n2 - n4;
    }

    public static int utf8MaxBytes(int n2) {
        return n2 * MAX_BYTES_PER_CHAR_UTF8;
    }

    public static int utf8MaxBytes(CharSequence charSequence) {
        return ByteBufUtil.utf8MaxBytes(charSequence.length());
    }

    public static int utf8Bytes(CharSequence charSequence) {
        int n2;
        if (charSequence instanceof AsciiString) {
            return charSequence.length();
        }
        int n3 = charSequence.length();
        for (n2 = 0; n2 < n3 && charSequence.charAt(n2) < '\u0080'; ++n2) {
        }
        return n2 < n3 ? n2 + ByteBufUtil.utf8Bytes(charSequence, n2, n3) : n2;
    }

    private static int utf8Bytes(CharSequence charSequence, int n2, int n3) {
        int n4 = 0;
        for (int i2 = n2; i2 < n3; ++i2) {
            char c2 = charSequence.charAt(i2);
            if (c2 < '\u0800') {
                n4 += (127 - c2 >>> 31) + 1;
                continue;
            }
            if (StringUtil.isSurrogate(c2)) {
                char c3;
                if (!Character.isHighSurrogate(c2)) {
                    ++n4;
                    continue;
                }
                try {
                    c3 = charSequence.charAt(++i2);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    ++n4;
                    break;
                }
                if (!Character.isLowSurrogate(c3)) {
                    n4 += 2;
                    continue;
                }
                n4 += 4;
                continue;
            }
            n4 += 3;
        }
        return n4;
    }

    public static ByteBuf writeAscii(ByteBufAllocator byteBufAllocator, CharSequence charSequence) {
        ByteBuf byteBuf = byteBufAllocator.buffer(charSequence.length());
        ByteBufUtil.writeAscii(byteBuf, charSequence);
        return byteBuf;
    }

    public static int writeAscii(ByteBuf byteBuf, CharSequence charSequence) {
        int n2 = charSequence.length();
        if (!(charSequence instanceof AsciiString)) {
            while (true) {
                if (byteBuf instanceof AbstractByteBuf) {
                    AbstractByteBuf abstractByteBuf = (AbstractByteBuf)byteBuf;
                    abstractByteBuf.ensureWritable0(n2);
                    int n3 = ByteBufUtil.writeAscii(abstractByteBuf, abstractByteBuf.writerIndex, charSequence, n2);
                    abstractByteBuf.writerIndex += n3;
                    return n3;
                }
                if (!(byteBuf instanceof WrappedByteBuf)) break;
                byteBuf = byteBuf.unwrap();
            }
            byte[] byArray = charSequence.toString().getBytes(CharsetUtil.US_ASCII);
            byteBuf.writeBytes(byArray);
            return byArray.length;
        }
        AsciiString asciiString = (AsciiString)charSequence;
        byteBuf.writeBytes(asciiString.array(), asciiString.arrayOffset(), n2);
        return n2;
    }

    static int writeAscii(AbstractByteBuf abstractByteBuf, int n2, CharSequence charSequence, int n3) {
        for (int i2 = 0; i2 < n3; ++i2) {
            abstractByteBuf._setByte(n2++, AsciiString.c2b(charSequence.charAt(i2)));
        }
        return n3;
    }

    public static ByteBuf encodeString(ByteBufAllocator byteBufAllocator, CharBuffer charBuffer, Charset charset) {
        return ByteBufUtil.encodeString0(byteBufAllocator, false, charBuffer, charset, 0);
    }

    public static ByteBuf encodeString(ByteBufAllocator byteBufAllocator, CharBuffer charBuffer, Charset charset, int n2) {
        return ByteBufUtil.encodeString0(byteBufAllocator, false, charBuffer, charset, n2);
    }

    static ByteBuf encodeString0(ByteBufAllocator byteBufAllocator, boolean bl2, CharBuffer charBuffer, Charset charset, int n2) {
        CharsetEncoder charsetEncoder = CharsetUtil.encoder(charset);
        int n3 = (int)((double)charBuffer.remaining() * (double)charsetEncoder.maxBytesPerChar()) + n2;
        boolean bl3 = true;
        ByteBuf byteBuf = bl2 ? byteBufAllocator.heapBuffer(n3) : byteBufAllocator.buffer(n3);
        try {
            ByteBuffer byteBuffer = byteBuf.internalNioBuffer(byteBuf.readerIndex(), n3);
            int n4 = byteBuffer.position();
            CoderResult coderResult = charsetEncoder.encode(charBuffer, byteBuffer, true);
            if (!coderResult.isUnderflow()) {
                coderResult.throwException();
            }
            if (!(coderResult = charsetEncoder.flush(byteBuffer)).isUnderflow()) {
                coderResult.throwException();
            }
            byteBuf.writerIndex(byteBuf.writerIndex() + byteBuffer.position() - n4);
            bl3 = false;
            ByteBuf byteBuf2 = byteBuf;
            return byteBuf2;
        }
        catch (CharacterCodingException characterCodingException) {
            throw new IllegalStateException(characterCodingException);
        }
        finally {
            if (bl3) {
                byteBuf.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String decodeString(ByteBuf byteBuf, int n2, int n3, Charset charset) {
        if (n3 == 0) {
            return "";
        }
        CharsetDecoder charsetDecoder = CharsetUtil.decoder(charset);
        int n4 = (int)((double)n3 * (double)charsetDecoder.maxCharsPerByte());
        CharBuffer charBuffer = CHAR_BUFFERS.get();
        if (charBuffer.length() < n4) {
            charBuffer = CharBuffer.allocate(n4);
            if (n4 <= MAX_CHAR_BUFFER_SIZE) {
                CHAR_BUFFERS.set(charBuffer);
            }
        } else {
            charBuffer.clear();
        }
        if (byteBuf.nioBufferCount() == 1) {
            ByteBufUtil.decodeString(charsetDecoder, byteBuf.nioBuffer(n2, n3), charBuffer);
        } else {
            ByteBuf byteBuf2 = byteBuf.alloc().heapBuffer(n3);
            try {
                byteBuf2.writeBytes(byteBuf, n2, n3);
                ByteBufUtil.decodeString(charsetDecoder, byteBuf2.internalNioBuffer(byteBuf2.readerIndex(), n3), charBuffer);
            }
            finally {
                byteBuf2.release();
            }
        }
        return charBuffer.flip().toString();
    }

    private static void decodeString(CharsetDecoder charsetDecoder, ByteBuffer byteBuffer, CharBuffer charBuffer) {
        try {
            CoderResult coderResult = charsetDecoder.decode(byteBuffer, charBuffer, true);
            if (!coderResult.isUnderflow()) {
                coderResult.throwException();
            }
            if (!(coderResult = charsetDecoder.flush(charBuffer)).isUnderflow()) {
                coderResult.throwException();
            }
        }
        catch (CharacterCodingException characterCodingException) {
            throw new IllegalStateException(characterCodingException);
        }
    }

    public static ByteBuf threadLocalDirectBuffer() {
        if (THREAD_LOCAL_BUFFER_SIZE <= 0) {
            return null;
        }
        if (PlatformDependent.hasUnsafe()) {
            return ByteBufUtil$ThreadLocalUnsafeDirectByteBuf.newInstance();
        }
        return ByteBufUtil$ThreadLocalDirectByteBuf.newInstance();
    }

    public static byte[] getBytes(ByteBuf byteBuf) {
        return ByteBufUtil.getBytes(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes());
    }

    public static byte[] getBytes(ByteBuf byteBuf, int n2, int n3) {
        return ByteBufUtil.getBytes(byteBuf, n2, n3, true);
    }

    public static byte[] getBytes(ByteBuf byteBuf, int n2, int n3, boolean bl2) {
        if (MathUtil.isOutOfBounds(n2, n3, byteBuf.capacity())) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + n2 + ") <= start + length(" + n3 + ") <= buf.capacity(" + byteBuf.capacity() + ')');
        }
        if (byteBuf.hasArray()) {
            if (bl2 || n2 != 0 || n3 != byteBuf.capacity()) {
                int n4 = byteBuf.arrayOffset() + n2;
                return Arrays.copyOfRange(byteBuf.array(), n4, n4 + n3);
            }
            return byteBuf.array();
        }
        byte[] byArray = new byte[n3];
        byteBuf.getBytes(n2, byArray);
        return byArray;
    }

    public static void copy(AsciiString asciiString, ByteBuf byteBuf) {
        ByteBufUtil.copy(asciiString, 0, byteBuf, asciiString.length());
    }

    public static void copy(AsciiString asciiString, int n2, ByteBuf byteBuf, int n3, int n4) {
        if (MathUtil.isOutOfBounds(n2, n4, asciiString.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= srcIdx(" + n2 + ") <= srcIdx + length(" + n4 + ") <= srcLen(" + asciiString.length() + ')');
        }
        ObjectUtil.checkNotNull(byteBuf, "dst").setBytes(n3, asciiString.array(), n2 + asciiString.arrayOffset(), n4);
    }

    public static void copy(AsciiString asciiString, int n2, ByteBuf byteBuf, int n3) {
        if (MathUtil.isOutOfBounds(n2, n3, asciiString.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= srcIdx(" + n2 + ") <= srcIdx + length(" + n3 + ") <= srcLen(" + asciiString.length() + ')');
        }
        ObjectUtil.checkNotNull(byteBuf, "dst").writeBytes(asciiString.array(), n2 + asciiString.arrayOffset(), n3);
    }

    public static String prettyHexDump(ByteBuf byteBuf) {
        return ByteBufUtil.prettyHexDump(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes());
    }

    public static String prettyHexDump(ByteBuf byteBuf, int n2, int n3) {
        return ByteBufUtil$HexUtil.access$200(byteBuf, n2, n3);
    }

    public static void appendPrettyHexDump(StringBuilder stringBuilder, ByteBuf byteBuf) {
        ByteBufUtil.appendPrettyHexDump(stringBuilder, byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes());
    }

    public static void appendPrettyHexDump(StringBuilder stringBuilder, ByteBuf byteBuf, int n2, int n3) {
        ByteBufUtil$HexUtil.access$300(stringBuilder, byteBuf, n2, n3);
    }

    public static boolean isText(ByteBuf byteBuf, Charset charset) {
        return ByteBufUtil.isText(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes(), charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isText(ByteBuf byteBuf, int n2, int n3, Charset charset) {
        ObjectUtil.checkNotNull(byteBuf, "buf");
        ObjectUtil.checkNotNull(charset, "charset");
        int n4 = byteBuf.readerIndex() + byteBuf.readableBytes();
        if (n2 < 0 || n3 < 0 || n2 > n4 - n3) {
            throw new IndexOutOfBoundsException("index: " + n2 + " length: " + n3);
        }
        if (charset.equals(CharsetUtil.UTF_8)) {
            return ByteBufUtil.isUtf8(byteBuf, n2, n3);
        }
        if (charset.equals(CharsetUtil.US_ASCII)) {
            return ByteBufUtil.isAscii(byteBuf, n2, n3);
        }
        CharsetDecoder charsetDecoder = CharsetUtil.decoder(charset, CodingErrorAction.REPORT, CodingErrorAction.REPORT);
        try {
            if (byteBuf.nioBufferCount() == 1) {
                charsetDecoder.decode(byteBuf.nioBuffer(n2, n3));
            } else {
                ByteBuf byteBuf2 = byteBuf.alloc().heapBuffer(n3);
                try {
                    byteBuf2.writeBytes(byteBuf, n2, n3);
                    charsetDecoder.decode(byteBuf2.internalNioBuffer(byteBuf2.readerIndex(), n3));
                }
                finally {
                    byteBuf2.release();
                }
            }
            return true;
        }
        catch (CharacterCodingException characterCodingException) {
            return false;
        }
    }

    private static boolean isAscii(ByteBuf byteBuf, int n2, int n3) {
        return byteBuf.forEachByte(n2, n3, FIND_NON_ASCII) == -1;
    }

    private static boolean isUtf8(ByteBuf byteBuf, int n2, int n3) {
        int n4 = n2 + n3;
        while (n2 < n4) {
            byte by2;
            byte by3;
            byte by4;
            if (((by4 = byteBuf.getByte(n2++)) & 0x80) == 0) continue;
            if ((by4 & 0xE0) == 192) {
                if (n2 >= n4) {
                    return false;
                }
                if (((by3 = byteBuf.getByte(n2++)) & 0xC0) != 128) {
                    return false;
                }
                if ((by4 & 0xFF) >= 194) continue;
                return false;
            }
            if ((by4 & 0xF0) == 224) {
                if (n2 > n4 - 2) {
                    return false;
                }
                by3 = byteBuf.getByte(n2++);
                by2 = byteBuf.getByte(n2++);
                if ((by3 & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                    return false;
                }
                if ((by4 & 0xF) == 0 && (by3 & 0xFF) < 160) {
                    return false;
                }
                if ((by4 & 0xF) != 13 || (by3 & 0xFF) <= 159) continue;
                return false;
            }
            if ((by4 & 0xF8) == 240) {
                if (n2 > n4 - 3) {
                    return false;
                }
                by3 = byteBuf.getByte(n2++);
                by2 = byteBuf.getByte(n2++);
                byte by5 = byteBuf.getByte(n2++);
                if ((by3 & 0xC0) != 128 || (by2 & 0xC0) != 128 || (by5 & 0xC0) != 128) {
                    return false;
                }
                if ((by4 & 0xFF) <= 244 && ((by4 & 0xFF) != 240 || (by3 & 0xFF) >= 144) && ((by4 & 0xFF) != 244 || (by3 & 0xFF) <= 143)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void readBytes(ByteBufAllocator byteBufAllocator, ByteBuffer byteBuffer, int n2, int n3, OutputStream outputStream) {
        if (byteBuffer.hasArray()) {
            outputStream.write(byteBuffer.array(), n2 + byteBuffer.arrayOffset(), n3);
        } else {
            int n4 = Math.min(n3, 8192);
            byteBuffer.clear().position(n2);
            if (byteBufAllocator.isDirectBufferPooled()) {
                ByteBuf byteBuf = byteBufAllocator.heapBuffer(n4);
                try {
                    byte[] byArray = byteBuf.array();
                    int n5 = byteBuf.arrayOffset();
                    ByteBufUtil.getBytes(byteBuffer, byArray, n5, n4, outputStream, n3);
                }
                finally {
                    byteBuf.release();
                }
            } else {
                ByteBufUtil.getBytes(byteBuffer, new byte[n4], 0, n4, outputStream, n3);
            }
        }
    }

    private static void getBytes(ByteBuffer byteBuffer, byte[] byArray, int n2, int n3, OutputStream outputStream, int n4) {
        int n5;
        do {
            n5 = Math.min(n3, n4);
            byteBuffer.get(byArray, n2, n5);
            outputStream.write(byArray, n2, n5);
        } while ((n4 -= n5) > 0);
    }

    private ByteBufUtil() {
    }

    static /* synthetic */ int access$500() {
        return THREAD_LOCAL_BUFFER_SIZE;
    }

    static {
        AbstractByteBufAllocator abstractByteBufAllocator;
        logger = InternalLoggerFactory.getInstance(ByteBufUtil.class);
        CHAR_BUFFERS = new ByteBufUtil$1();
        MAX_BYTES_PER_CHAR_UTF8 = (int)CharsetUtil.encoder(CharsetUtil.UTF_8).maxBytesPerChar();
        String string = SystemPropertyUtil.get("io.netty.allocator.type", PlatformDependent.isAndroid() ? "unpooled" : "pooled");
        if ("unpooled".equals(string = string.toLowerCase(Locale.US).trim())) {
            abstractByteBufAllocator = UnpooledByteBufAllocator.DEFAULT;
            logger.debug("-Dio.netty.allocator.type: {}", (Object)string);
        } else if ("pooled".equals(string)) {
            abstractByteBufAllocator = PooledByteBufAllocator.DEFAULT;
            logger.debug("-Dio.netty.allocator.type: {}", (Object)string);
        } else {
            abstractByteBufAllocator = PooledByteBufAllocator.DEFAULT;
            logger.debug("-Dio.netty.allocator.type: pooled (unknown: {})", (Object)string);
        }
        DEFAULT_ALLOCATOR = abstractByteBufAllocator;
        THREAD_LOCAL_BUFFER_SIZE = SystemPropertyUtil.getInt("io.netty.threadLocalDirectBufferSize", 0);
        logger.debug("-Dio.netty.threadLocalDirectBufferSize: {}", (Object)THREAD_LOCAL_BUFFER_SIZE);
        MAX_CHAR_BUFFER_SIZE = SystemPropertyUtil.getInt("io.netty.maxThreadLocalCharBufferSize", 16384);
        logger.debug("-Dio.netty.maxThreadLocalCharBufferSize: {}", (Object)MAX_CHAR_BUFFER_SIZE);
        FIND_NON_ASCII = new ByteBufUtil$2();
    }
}

