/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.util.CharsetUtil;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.OutputStream;

public class ByteBufOutputStream
extends OutputStream
implements DataOutput {
    private final ByteBuf buffer;
    private final int startIndex;
    private final DataOutputStream utf8out = new DataOutputStream(this);

    public ByteBufOutputStream(ByteBuf byteBuf) {
        if (byteBuf == null) {
            throw new NullPointerException("buffer");
        }
        this.buffer = byteBuf;
        this.startIndex = byteBuf.writerIndex();
    }

    public int writtenBytes() {
        return this.buffer.writerIndex() - this.startIndex;
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        if (n3 == 0) {
            return;
        }
        this.buffer.writeBytes(byArray, n2, n3);
    }

    @Override
    public void write(byte[] byArray) {
        this.buffer.writeBytes(byArray);
    }

    @Override
    public void write(int n2) {
        this.buffer.writeByte(n2);
    }

    @Override
    public void writeBoolean(boolean bl2) {
        this.buffer.writeBoolean(bl2);
    }

    @Override
    public void writeByte(int n2) {
        this.buffer.writeByte(n2);
    }

    @Override
    public void writeBytes(String string) {
        this.buffer.writeCharSequence(string, CharsetUtil.US_ASCII);
    }

    @Override
    public void writeChar(int n2) {
        this.buffer.writeChar(n2);
    }

    @Override
    public void writeChars(String string) {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.buffer.writeChar(string.charAt(i2));
        }
    }

    @Override
    public void writeDouble(double d2) {
        this.buffer.writeDouble(d2);
    }

    @Override
    public void writeFloat(float f2) {
        this.buffer.writeFloat(f2);
    }

    @Override
    public void writeInt(int n2) {
        this.buffer.writeInt(n2);
    }

    @Override
    public void writeLong(long l2) {
        this.buffer.writeLong(l2);
    }

    @Override
    public void writeShort(int n2) {
        this.buffer.writeShort((short)n2);
    }

    @Override
    public void writeUTF(String string) {
        this.utf8out.writeUTF(string);
    }

    public ByteBuf buffer() {
        return this.buffer;
    }
}

