/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.internal.ObjectUtil;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public abstract class AbstractReferenceCountedByteBuf
extends AbstractByteBuf {
    private static final AtomicIntegerFieldUpdater<AbstractReferenceCountedByteBuf> refCntUpdater = AtomicIntegerFieldUpdater.newUpdater(AbstractReferenceCountedByteBuf.class, "refCnt");
    private volatile int refCnt;

    protected AbstractReferenceCountedByteBuf(int n2) {
        super(n2);
        refCntUpdater.set(this, 1);
    }

    @Override
    public int refCnt() {
        return this.refCnt;
    }

    protected final void setRefCnt(int n2) {
        refCntUpdater.set(this, n2);
    }

    @Override
    public ByteBuf retain() {
        return this.retain0(1);
    }

    @Override
    public ByteBuf retain(int n2) {
        return this.retain0(ObjectUtil.checkPositive(n2, "increment"));
    }

    private ByteBuf retain0(int n2) {
        int n3 = refCntUpdater.getAndAdd(this, n2);
        if (n3 <= 0 || n3 + n2 < n3) {
            refCntUpdater.getAndAdd(this, -n2);
            throw new IllegalReferenceCountException(n3, n2);
        }
        return this;
    }

    @Override
    public ByteBuf touch() {
        return this;
    }

    @Override
    public ByteBuf touch(Object object) {
        return this;
    }

    @Override
    public boolean release() {
        return this.release0(1);
    }

    @Override
    public boolean release(int n2) {
        return this.release0(ObjectUtil.checkPositive(n2, "decrement"));
    }

    private boolean release0(int n2) {
        int n3 = refCntUpdater.getAndAdd(this, -n2);
        if (n3 == n2) {
            this.deallocate();
            return true;
        }
        if (n3 < n2 || n3 - n2 > n3) {
            refCntUpdater.getAndAdd(this, n2);
            throw new IllegalReferenceCountException(n3, -n2);
        }
        return false;
    }

    protected abstract void deallocate();
}

