/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.AbstractPooledDerivedByteBuf$PooledNonRetainedDuplicateByteBuf;
import io.netty.buffer.AbstractPooledDerivedByteBuf$PooledNonRetainedSlicedByteBuf;
import io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.SimpleLeakAwareByteBuf;
import io.netty.util.Recycler$Handle;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

abstract class AbstractPooledDerivedByteBuf
extends AbstractReferenceCountedByteBuf {
    private final Recycler$Handle<AbstractPooledDerivedByteBuf> recyclerHandle;
    private AbstractByteBuf rootParent;
    private ByteBuf parent;

    AbstractPooledDerivedByteBuf(Recycler$Handle<? extends AbstractPooledDerivedByteBuf> recycler$Handle) {
        super(0);
        this.recyclerHandle = recycler$Handle;
    }

    final void parent(ByteBuf byteBuf) {
        assert (byteBuf instanceof SimpleLeakAwareByteBuf);
        this.parent = byteBuf;
    }

    @Override
    public final AbstractByteBuf unwrap() {
        return this.rootParent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final <U extends AbstractPooledDerivedByteBuf> U init(AbstractByteBuf abstractByteBuf, ByteBuf byteBuf, int n2, int n3, int n4) {
        byteBuf.retain();
        this.parent = byteBuf;
        this.rootParent = abstractByteBuf;
        try {
            this.maxCapacity(n4);
            this.setIndex0(n2, n3);
            this.setRefCnt(1);
            AbstractPooledDerivedByteBuf abstractPooledDerivedByteBuf = this;
            byteBuf = null;
            AbstractPooledDerivedByteBuf abstractPooledDerivedByteBuf2 = abstractPooledDerivedByteBuf;
            return (U)abstractPooledDerivedByteBuf2;
        }
        finally {
            if (byteBuf != null) {
                this.rootParent = null;
                this.parent = null;
                byteBuf.release();
            }
        }
    }

    @Override
    protected final void deallocate() {
        ByteBuf byteBuf = this.parent;
        this.recyclerHandle.recycle(this);
        byteBuf.release();
    }

    @Override
    public final ByteBufAllocator alloc() {
        return this.unwrap().alloc();
    }

    @Override
    @Deprecated
    public final ByteOrder order() {
        return this.unwrap().order();
    }

    @Override
    public boolean isReadOnly() {
        return this.unwrap().isReadOnly();
    }

    @Override
    public final boolean isDirect() {
        return this.unwrap().isDirect();
    }

    @Override
    public boolean hasArray() {
        return this.unwrap().hasArray();
    }

    @Override
    public byte[] array() {
        return this.unwrap().array();
    }

    @Override
    public boolean hasMemoryAddress() {
        return this.unwrap().hasMemoryAddress();
    }

    @Override
    public final int nioBufferCount() {
        return this.unwrap().nioBufferCount();
    }

    @Override
    public final ByteBuffer internalNioBuffer(int n2, int n3) {
        return this.nioBuffer(n2, n3);
    }

    @Override
    public final ByteBuf retainedSlice() {
        int n2 = this.readerIndex();
        return this.retainedSlice(n2, this.writerIndex() - n2);
    }

    @Override
    public ByteBuf slice(int n2, int n3) {
        this.ensureAccessible();
        return new AbstractPooledDerivedByteBuf$PooledNonRetainedSlicedByteBuf(this, this.unwrap(), n2, n3);
    }

    final ByteBuf duplicate0() {
        this.ensureAccessible();
        return new AbstractPooledDerivedByteBuf$PooledNonRetainedDuplicateByteBuf(this, this.unwrap());
    }
}

