/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.AdvancedLeakAwareByteBuf;
import io.netty.buffer.AdvancedLeakAwareCompositeByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.EmptyByteBuf;
import io.netty.buffer.SimpleLeakAwareByteBuf;
import io.netty.buffer.SimpleLeakAwareCompositeByteBuf;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.ResourceLeakTracker;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;

public abstract class AbstractByteBufAllocator
implements ByteBufAllocator {
    static final int DEFAULT_INITIAL_CAPACITY = 256;
    static final int DEFAULT_MAX_CAPACITY = Integer.MAX_VALUE;
    static final int DEFAULT_MAX_COMPONENTS = 16;
    static final int CALCULATE_THRESHOLD = 0x400000;
    private final boolean directByDefault;
    private final ByteBuf emptyBuf;

    protected static ByteBuf toLeakAwareBuffer(ByteBuf byteBuf) {
        switch (ResourceLeakDetector.getLevel()) {
            case SIMPLE: {
                ResourceLeakTracker<ByteBuf> resourceLeakTracker = AbstractByteBuf.leakDetector.track(byteBuf);
                if (resourceLeakTracker == null) break;
                byteBuf = new SimpleLeakAwareByteBuf(byteBuf, resourceLeakTracker);
                break;
            }
            case ADVANCED: 
            case PARANOID: {
                ResourceLeakTracker<ByteBuf> resourceLeakTracker = AbstractByteBuf.leakDetector.track(byteBuf);
                if (resourceLeakTracker == null) break;
                byteBuf = new AdvancedLeakAwareByteBuf(byteBuf, resourceLeakTracker);
                break;
            }
        }
        return byteBuf;
    }

    protected static CompositeByteBuf toLeakAwareBuffer(CompositeByteBuf compositeByteBuf) {
        switch (ResourceLeakDetector.getLevel()) {
            case SIMPLE: {
                ResourceLeakTracker<ByteBuf> resourceLeakTracker = AbstractByteBuf.leakDetector.track(compositeByteBuf);
                if (resourceLeakTracker == null) break;
                compositeByteBuf = new SimpleLeakAwareCompositeByteBuf(compositeByteBuf, resourceLeakTracker);
                break;
            }
            case ADVANCED: 
            case PARANOID: {
                ResourceLeakTracker<ByteBuf> resourceLeakTracker = AbstractByteBuf.leakDetector.track(compositeByteBuf);
                if (resourceLeakTracker == null) break;
                compositeByteBuf = new AdvancedLeakAwareCompositeByteBuf(compositeByteBuf, resourceLeakTracker);
                break;
            }
        }
        return compositeByteBuf;
    }

    protected AbstractByteBufAllocator() {
        this(false);
    }

    protected AbstractByteBufAllocator(boolean bl2) {
        this.directByDefault = bl2 && PlatformDependent.hasUnsafe();
        this.emptyBuf = new EmptyByteBuf(this);
    }

    @Override
    public ByteBuf buffer() {
        if (this.directByDefault) {
            return this.directBuffer();
        }
        return this.heapBuffer();
    }

    @Override
    public ByteBuf buffer(int n2) {
        if (this.directByDefault) {
            return this.directBuffer(n2);
        }
        return this.heapBuffer(n2);
    }

    @Override
    public ByteBuf buffer(int n2, int n3) {
        if (this.directByDefault) {
            return this.directBuffer(n2, n3);
        }
        return this.heapBuffer(n2, n3);
    }

    @Override
    public ByteBuf ioBuffer() {
        if (PlatformDependent.hasUnsafe()) {
            return this.directBuffer(256);
        }
        return this.heapBuffer(256);
    }

    @Override
    public ByteBuf ioBuffer(int n2) {
        if (PlatformDependent.hasUnsafe()) {
            return this.directBuffer(n2);
        }
        return this.heapBuffer(n2);
    }

    @Override
    public ByteBuf ioBuffer(int n2, int n3) {
        if (PlatformDependent.hasUnsafe()) {
            return this.directBuffer(n2, n3);
        }
        return this.heapBuffer(n2, n3);
    }

    @Override
    public ByteBuf heapBuffer() {
        return this.heapBuffer(256, Integer.MAX_VALUE);
    }

    @Override
    public ByteBuf heapBuffer(int n2) {
        return this.heapBuffer(n2, Integer.MAX_VALUE);
    }

    @Override
    public ByteBuf heapBuffer(int n2, int n3) {
        if (n2 == 0 && n3 == 0) {
            return this.emptyBuf;
        }
        AbstractByteBufAllocator.validate(n2, n3);
        return this.newHeapBuffer(n2, n3);
    }

    @Override
    public ByteBuf directBuffer() {
        return this.directBuffer(256, Integer.MAX_VALUE);
    }

    @Override
    public ByteBuf directBuffer(int n2) {
        return this.directBuffer(n2, Integer.MAX_VALUE);
    }

    @Override
    public ByteBuf directBuffer(int n2, int n3) {
        if (n2 == 0 && n3 == 0) {
            return this.emptyBuf;
        }
        AbstractByteBufAllocator.validate(n2, n3);
        return this.newDirectBuffer(n2, n3);
    }

    @Override
    public CompositeByteBuf compositeBuffer() {
        if (this.directByDefault) {
            return this.compositeDirectBuffer();
        }
        return this.compositeHeapBuffer();
    }

    @Override
    public CompositeByteBuf compositeBuffer(int n2) {
        if (this.directByDefault) {
            return this.compositeDirectBuffer(n2);
        }
        return this.compositeHeapBuffer(n2);
    }

    @Override
    public CompositeByteBuf compositeHeapBuffer() {
        return this.compositeHeapBuffer(16);
    }

    @Override
    public CompositeByteBuf compositeHeapBuffer(int n2) {
        return AbstractByteBufAllocator.toLeakAwareBuffer(new CompositeByteBuf(this, false, n2));
    }

    @Override
    public CompositeByteBuf compositeDirectBuffer() {
        return this.compositeDirectBuffer(16);
    }

    @Override
    public CompositeByteBuf compositeDirectBuffer(int n2) {
        return AbstractByteBufAllocator.toLeakAwareBuffer(new CompositeByteBuf(this, true, n2));
    }

    private static void validate(int n2, int n3) {
        if (n2 < 0) {
            throw new IllegalArgumentException("initialCapacity: " + n2 + " (expected: 0+)");
        }
        if (n2 > n3) {
            throw new IllegalArgumentException(String.format("initialCapacity: %d (expected: not greater than maxCapacity(%d)", n2, n3));
        }
    }

    protected abstract ByteBuf newHeapBuffer(int var1, int var2);

    protected abstract ByteBuf newDirectBuffer(int var1, int var2);

    public String toString() {
        return StringUtil.simpleClassName(this) + "(directByDefault: " + this.directByDefault + ')';
    }

    @Override
    public int calculateNewCapacity(int n2, int n3) {
        int n4;
        if (n2 < 0) {
            throw new IllegalArgumentException("minNewCapacity: " + n2 + " (expected: 0+)");
        }
        if (n2 > n3) {
            throw new IllegalArgumentException(String.format("minNewCapacity: %d (expected: not greater than maxCapacity(%d)", n2, n3));
        }
        int n5 = 0x400000;
        if (n2 == 0x400000) {
            return 0x400000;
        }
        if (n2 > 0x400000) {
            int n6 = n2 / 0x400000 * 0x400000;
            n6 = n6 > n3 - 0x400000 ? n3 : (n6 += 0x400000);
            return n6;
        }
        for (n4 = 64; n4 < n2; n4 <<= 1) {
        }
        return Math.min(n4, n3);
    }

    static {
        ResourceLeakDetector.addExclusions(AbstractByteBufAllocator.class, "toLeakAwareBuffer");
    }
}

