/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.SwappedByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledDuplicatedByteBuf;
import io.netty.buffer.UnpooledSlicedByteBuf;
import io.netty.util.ByteProcessor;
import io.netty.util.CharsetUtil;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.ResourceLeakDetectorFactory;
import io.netty.util.internal.MathUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;

public abstract class AbstractByteBuf
extends ByteBuf {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractByteBuf.class);
    private static final String PROP_MODE = "io.netty.buffer.bytebuf.checkAccessible";
    private static final boolean checkAccessible = SystemPropertyUtil.getBoolean("io.netty.buffer.bytebuf.checkAccessible", true);
    static final ResourceLeakDetector<ByteBuf> leakDetector;
    int readerIndex;
    int writerIndex;
    private int markedReaderIndex;
    private int markedWriterIndex;
    private int maxCapacity;

    protected AbstractByteBuf(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("maxCapacity: " + n2 + " (expected: >= 0)");
        }
        this.maxCapacity = n2;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ByteBuf asReadOnly() {
        if (this.isReadOnly()) {
            return this;
        }
        return Unpooled.unmodifiableBuffer((ByteBuf)this);
    }

    @Override
    public int maxCapacity() {
        return this.maxCapacity;
    }

    protected final void maxCapacity(int n2) {
        this.maxCapacity = n2;
    }

    @Override
    public int readerIndex() {
        return this.readerIndex;
    }

    @Override
    public ByteBuf readerIndex(int n2) {
        if (n2 < 0 || n2 > this.writerIndex) {
            throw new IndexOutOfBoundsException(String.format("readerIndex: %d (expected: 0 <= readerIndex <= writerIndex(%d))", n2, this.writerIndex));
        }
        this.readerIndex = n2;
        return this;
    }

    @Override
    public int writerIndex() {
        return this.writerIndex;
    }

    @Override
    public ByteBuf writerIndex(int n2) {
        if (n2 < this.readerIndex || n2 > this.capacity()) {
            throw new IndexOutOfBoundsException(String.format("writerIndex: %d (expected: readerIndex(%d) <= writerIndex <= capacity(%d))", n2, this.readerIndex, this.capacity()));
        }
        this.writerIndex = n2;
        return this;
    }

    @Override
    public ByteBuf setIndex(int n2, int n3) {
        if (n2 < 0 || n2 > n3 || n3 > this.capacity()) {
            throw new IndexOutOfBoundsException(String.format("readerIndex: %d, writerIndex: %d (expected: 0 <= readerIndex <= writerIndex <= capacity(%d))", n2, n3, this.capacity()));
        }
        this.setIndex0(n2, n3);
        return this;
    }

    @Override
    public ByteBuf clear() {
        this.writerIndex = 0;
        this.readerIndex = 0;
        return this;
    }

    @Override
    public boolean isReadable() {
        return this.writerIndex > this.readerIndex;
    }

    @Override
    public boolean isReadable(int n2) {
        return this.writerIndex - this.readerIndex >= n2;
    }

    @Override
    public boolean isWritable() {
        return this.capacity() > this.writerIndex;
    }

    @Override
    public boolean isWritable(int n2) {
        return this.capacity() - this.writerIndex >= n2;
    }

    @Override
    public int readableBytes() {
        return this.writerIndex - this.readerIndex;
    }

    @Override
    public int writableBytes() {
        return this.capacity() - this.writerIndex;
    }

    @Override
    public int maxWritableBytes() {
        return this.maxCapacity() - this.writerIndex;
    }

    @Override
    public ByteBuf markReaderIndex() {
        this.markedReaderIndex = this.readerIndex;
        return this;
    }

    @Override
    public ByteBuf resetReaderIndex() {
        this.readerIndex(this.markedReaderIndex);
        return this;
    }

    @Override
    public ByteBuf markWriterIndex() {
        this.markedWriterIndex = this.writerIndex;
        return this;
    }

    @Override
    public ByteBuf resetWriterIndex() {
        this.writerIndex(this.markedWriterIndex);
        return this;
    }

    @Override
    public ByteBuf discardReadBytes() {
        this.ensureAccessible();
        if (this.readerIndex == 0) {
            return this;
        }
        if (this.readerIndex != this.writerIndex) {
            this.setBytes(0, this, this.readerIndex, this.writerIndex - this.readerIndex);
            this.writerIndex -= this.readerIndex;
            this.adjustMarkers(this.readerIndex);
            this.readerIndex = 0;
        } else {
            this.adjustMarkers(this.readerIndex);
            this.readerIndex = 0;
            this.writerIndex = 0;
        }
        return this;
    }

    @Override
    public ByteBuf discardSomeReadBytes() {
        this.ensureAccessible();
        if (this.readerIndex == 0) {
            return this;
        }
        if (this.readerIndex == this.writerIndex) {
            this.adjustMarkers(this.readerIndex);
            this.readerIndex = 0;
            this.writerIndex = 0;
            return this;
        }
        if (this.readerIndex >= this.capacity() >>> 1) {
            this.setBytes(0, this, this.readerIndex, this.writerIndex - this.readerIndex);
            this.writerIndex -= this.readerIndex;
            this.adjustMarkers(this.readerIndex);
            this.readerIndex = 0;
        }
        return this;
    }

    protected final void adjustMarkers(int n2) {
        int n3 = this.markedReaderIndex;
        if (n3 <= n2) {
            this.markedReaderIndex = 0;
            int n4 = this.markedWriterIndex;
            this.markedWriterIndex = n4 <= n2 ? 0 : n4 - n2;
        } else {
            this.markedReaderIndex = n3 - n2;
            this.markedWriterIndex -= n2;
        }
    }

    @Override
    public ByteBuf ensureWritable(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException(String.format("minWritableBytes: %d (expected: >= 0)", n2));
        }
        this.ensureWritable0(n2);
        return this;
    }

    final void ensureWritable0(int n2) {
        this.ensureAccessible();
        if (n2 <= this.writableBytes()) {
            return;
        }
        if (n2 > this.maxCapacity - this.writerIndex) {
            throw new IndexOutOfBoundsException(String.format("writerIndex(%d) + minWritableBytes(%d) exceeds maxCapacity(%d): %s", this.writerIndex, n2, this.maxCapacity, this));
        }
        int n3 = this.alloc().calculateNewCapacity(this.writerIndex + n2, this.maxCapacity);
        this.capacity(n3);
    }

    @Override
    public int ensureWritable(int n2, boolean bl2) {
        int n3;
        this.ensureAccessible();
        if (n2 < 0) {
            throw new IllegalArgumentException(String.format("minWritableBytes: %d (expected: >= 0)", n2));
        }
        if (n2 <= this.writableBytes()) {
            return 0;
        }
        int n4 = this.maxCapacity();
        if (n2 > n4 - (n3 = this.writerIndex())) {
            if (!bl2 || this.capacity() == n4) {
                return 1;
            }
            this.capacity(n4);
            return 3;
        }
        int n5 = this.alloc().calculateNewCapacity(n3 + n2, n4);
        this.capacity(n5);
        return 2;
    }

    @Override
    public ByteBuf order(ByteOrder byteOrder) {
        if (byteOrder == null) {
            throw new NullPointerException("endianness");
        }
        if (byteOrder == this.order()) {
            return this;
        }
        return this.newSwappedByteBuf();
    }

    protected SwappedByteBuf newSwappedByteBuf() {
        return new SwappedByteBuf(this);
    }

    @Override
    public byte getByte(int n2) {
        this.checkIndex(n2);
        return this._getByte(n2);
    }

    protected abstract byte _getByte(int var1);

    @Override
    public boolean getBoolean(int n2) {
        return this.getByte(n2) != 0;
    }

    @Override
    public short getUnsignedByte(int n2) {
        return (short)(this.getByte(n2) & 0xFF);
    }

    @Override
    public short getShort(int n2) {
        this.checkIndex(n2, 2);
        return this._getShort(n2);
    }

    protected abstract short _getShort(int var1);

    @Override
    public short getShortLE(int n2) {
        this.checkIndex(n2, 2);
        return this._getShortLE(n2);
    }

    protected abstract short _getShortLE(int var1);

    @Override
    public int getUnsignedShort(int n2) {
        return this.getShort(n2) & 0xFFFF;
    }

    @Override
    public int getUnsignedShortLE(int n2) {
        return this.getShortLE(n2) & 0xFFFF;
    }

    @Override
    public int getUnsignedMedium(int n2) {
        this.checkIndex(n2, 3);
        return this._getUnsignedMedium(n2);
    }

    protected abstract int _getUnsignedMedium(int var1);

    @Override
    public int getUnsignedMediumLE(int n2) {
        this.checkIndex(n2, 3);
        return this._getUnsignedMediumLE(n2);
    }

    protected abstract int _getUnsignedMediumLE(int var1);

    @Override
    public int getMedium(int n2) {
        int n3 = this.getUnsignedMedium(n2);
        if ((n3 & 0x800000) != 0) {
            n3 |= 0xFF000000;
        }
        return n3;
    }

    @Override
    public int getMediumLE(int n2) {
        int n3 = this.getUnsignedMediumLE(n2);
        if ((n3 & 0x800000) != 0) {
            n3 |= 0xFF000000;
        }
        return n3;
    }

    @Override
    public int getInt(int n2) {
        this.checkIndex(n2, 4);
        return this._getInt(n2);
    }

    protected abstract int _getInt(int var1);

    @Override
    public int getIntLE(int n2) {
        this.checkIndex(n2, 4);
        return this._getIntLE(n2);
    }

    protected abstract int _getIntLE(int var1);

    @Override
    public long getUnsignedInt(int n2) {
        return (long)this.getInt(n2) & 0xFFFFFFFFL;
    }

    @Override
    public long getUnsignedIntLE(int n2) {
        return (long)this.getIntLE(n2) & 0xFFFFFFFFL;
    }

    @Override
    public long getLong(int n2) {
        this.checkIndex(n2, 8);
        return this._getLong(n2);
    }

    protected abstract long _getLong(int var1);

    @Override
    public long getLongLE(int n2) {
        this.checkIndex(n2, 8);
        return this._getLongLE(n2);
    }

    protected abstract long _getLongLE(int var1);

    @Override
    public char getChar(int n2) {
        return (char)this.getShort(n2);
    }

    @Override
    public float getFloat(int n2) {
        return Float.intBitsToFloat(this.getInt(n2));
    }

    @Override
    public double getDouble(int n2) {
        return Double.longBitsToDouble(this.getLong(n2));
    }

    @Override
    public ByteBuf getBytes(int n2, byte[] byArray) {
        this.getBytes(n2, byArray, 0, byArray.length);
        return this;
    }

    @Override
    public ByteBuf getBytes(int n2, ByteBuf byteBuf) {
        this.getBytes(n2, byteBuf, byteBuf.writableBytes());
        return this;
    }

    @Override
    public ByteBuf getBytes(int n2, ByteBuf byteBuf, int n3) {
        this.getBytes(n2, byteBuf, byteBuf.writerIndex(), n3);
        byteBuf.writerIndex(byteBuf.writerIndex() + n3);
        return this;
    }

    @Override
    public CharSequence getCharSequence(int n2, int n3, Charset charset) {
        return this.toString(n2, n3, charset);
    }

    @Override
    public CharSequence readCharSequence(int n2, Charset charset) {
        CharSequence charSequence = this.getCharSequence(this.readerIndex, n2, charset);
        this.readerIndex += n2;
        return charSequence;
    }

    @Override
    public ByteBuf setByte(int n2, int n3) {
        this.checkIndex(n2);
        this._setByte(n2, n3);
        return this;
    }

    protected abstract void _setByte(int var1, int var2);

    @Override
    public ByteBuf setBoolean(int n2, boolean bl2) {
        this.setByte(n2, bl2 ? 1 : 0);
        return this;
    }

    @Override
    public ByteBuf setShort(int n2, int n3) {
        this.checkIndex(n2, 2);
        this._setShort(n2, n3);
        return this;
    }

    protected abstract void _setShort(int var1, int var2);

    @Override
    public ByteBuf setShortLE(int n2, int n3) {
        this.checkIndex(n2, 2);
        this._setShortLE(n2, n3);
        return this;
    }

    protected abstract void _setShortLE(int var1, int var2);

    @Override
    public ByteBuf setChar(int n2, int n3) {
        this.setShort(n2, n3);
        return this;
    }

    @Override
    public ByteBuf setMedium(int n2, int n3) {
        this.checkIndex(n2, 3);
        this._setMedium(n2, n3);
        return this;
    }

    protected abstract void _setMedium(int var1, int var2);

    @Override
    public ByteBuf setMediumLE(int n2, int n3) {
        this.checkIndex(n2, 3);
        this._setMediumLE(n2, n3);
        return this;
    }

    protected abstract void _setMediumLE(int var1, int var2);

    @Override
    public ByteBuf setInt(int n2, int n3) {
        this.checkIndex(n2, 4);
        this._setInt(n2, n3);
        return this;
    }

    protected abstract void _setInt(int var1, int var2);

    @Override
    public ByteBuf setIntLE(int n2, int n3) {
        this.checkIndex(n2, 4);
        this._setIntLE(n2, n3);
        return this;
    }

    protected abstract void _setIntLE(int var1, int var2);

    @Override
    public ByteBuf setFloat(int n2, float f2) {
        this.setInt(n2, Float.floatToRawIntBits(f2));
        return this;
    }

    @Override
    public ByteBuf setLong(int n2, long l2) {
        this.checkIndex(n2, 8);
        this._setLong(n2, l2);
        return this;
    }

    protected abstract void _setLong(int var1, long var2);

    @Override
    public ByteBuf setLongLE(int n2, long l2) {
        this.checkIndex(n2, 8);
        this._setLongLE(n2, l2);
        return this;
    }

    protected abstract void _setLongLE(int var1, long var2);

    @Override
    public ByteBuf setDouble(int n2, double d2) {
        this.setLong(n2, Double.doubleToRawLongBits(d2));
        return this;
    }

    @Override
    public ByteBuf setBytes(int n2, byte[] byArray) {
        this.setBytes(n2, byArray, 0, byArray.length);
        return this;
    }

    @Override
    public ByteBuf setBytes(int n2, ByteBuf byteBuf) {
        this.setBytes(n2, byteBuf, byteBuf.readableBytes());
        return this;
    }

    @Override
    public ByteBuf setBytes(int n2, ByteBuf byteBuf, int n3) {
        this.checkIndex(n2, n3);
        if (byteBuf == null) {
            throw new NullPointerException("src");
        }
        if (n3 > byteBuf.readableBytes()) {
            throw new IndexOutOfBoundsException(String.format("length(%d) exceeds src.readableBytes(%d) where src is: %s", n3, byteBuf.readableBytes(), byteBuf));
        }
        this.setBytes(n2, byteBuf, byteBuf.readerIndex(), n3);
        byteBuf.readerIndex(byteBuf.readerIndex() + n3);
        return this;
    }

    @Override
    public ByteBuf setZero(int n2, int n3) {
        int n4;
        if (n3 == 0) {
            return this;
        }
        this.checkIndex(n2, n3);
        int n5 = n3 >>> 3;
        int n6 = n3 & 7;
        for (n4 = n5; n4 > 0; --n4) {
            this._setLong(n2, 0L);
            n2 += 8;
        }
        if (n6 == 4) {
            this._setInt(n2, 0);
        } else if (n6 < 4) {
            for (n4 = n6; n4 > 0; --n4) {
                this._setByte(n2, 0);
                ++n2;
            }
        } else {
            this._setInt(n2, 0);
            n2 += 4;
            for (n4 = n6 - 4; n4 > 0; --n4) {
                this._setByte(n2, 0);
                ++n2;
            }
        }
        return this;
    }

    @Override
    public int setCharSequence(int n2, CharSequence charSequence, Charset charset) {
        return this.setCharSequence0(n2, charSequence, charset, false);
    }

    private int setCharSequence0(int n2, CharSequence charSequence, Charset charset, boolean bl2) {
        if (charset.equals(CharsetUtil.UTF_8)) {
            int n3 = ByteBufUtil.utf8MaxBytes(charSequence);
            if (bl2) {
                this.ensureWritable0(n3);
                this.checkIndex0(n2, n3);
            } else {
                this.checkIndex(n2, n3);
            }
            return ByteBufUtil.writeUtf8(this, n2, charSequence, charSequence.length());
        }
        if (charset.equals(CharsetUtil.US_ASCII) || charset.equals(CharsetUtil.ISO_8859_1)) {
            int n4 = charSequence.length();
            if (bl2) {
                this.ensureWritable0(n4);
                this.checkIndex0(n2, n4);
            } else {
                this.checkIndex(n2, n4);
            }
            return ByteBufUtil.writeAscii(this, n2, charSequence, n4);
        }
        byte[] byArray = charSequence.toString().getBytes(charset);
        if (bl2) {
            this.ensureWritable0(byArray.length);
        }
        this.setBytes(n2, byArray);
        return byArray.length;
    }

    @Override
    public byte readByte() {
        this.checkReadableBytes0(1);
        int n2 = this.readerIndex;
        byte by2 = this._getByte(n2);
        this.readerIndex = n2 + 1;
        return by2;
    }

    @Override
    public boolean readBoolean() {
        return this.readByte() != 0;
    }

    @Override
    public short readUnsignedByte() {
        return (short)(this.readByte() & 0xFF);
    }

    @Override
    public short readShort() {
        this.checkReadableBytes0(2);
        short s2 = this._getShort(this.readerIndex);
        this.readerIndex += 2;
        return s2;
    }

    @Override
    public short readShortLE() {
        this.checkReadableBytes0(2);
        short s2 = this._getShortLE(this.readerIndex);
        this.readerIndex += 2;
        return s2;
    }

    @Override
    public int readUnsignedShort() {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public int readUnsignedShortLE() {
        return this.readShortLE() & 0xFFFF;
    }

    @Override
    public int readMedium() {
        int n2 = this.readUnsignedMedium();
        if ((n2 & 0x800000) != 0) {
            n2 |= 0xFF000000;
        }
        return n2;
    }

    @Override
    public int readMediumLE() {
        int n2 = this.readUnsignedMediumLE();
        if ((n2 & 0x800000) != 0) {
            n2 |= 0xFF000000;
        }
        return n2;
    }

    @Override
    public int readUnsignedMedium() {
        this.checkReadableBytes0(3);
        int n2 = this._getUnsignedMedium(this.readerIndex);
        this.readerIndex += 3;
        return n2;
    }

    @Override
    public int readUnsignedMediumLE() {
        this.checkReadableBytes0(3);
        int n2 = this._getUnsignedMediumLE(this.readerIndex);
        this.readerIndex += 3;
        return n2;
    }

    @Override
    public int readInt() {
        this.checkReadableBytes0(4);
        int n2 = this._getInt(this.readerIndex);
        this.readerIndex += 4;
        return n2;
    }

    @Override
    public int readIntLE() {
        this.checkReadableBytes0(4);
        int n2 = this._getIntLE(this.readerIndex);
        this.readerIndex += 4;
        return n2;
    }

    @Override
    public long readUnsignedInt() {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    @Override
    public long readUnsignedIntLE() {
        return (long)this.readIntLE() & 0xFFFFFFFFL;
    }

    @Override
    public long readLong() {
        this.checkReadableBytes0(8);
        long l2 = this._getLong(this.readerIndex);
        this.readerIndex += 8;
        return l2;
    }

    @Override
    public long readLongLE() {
        this.checkReadableBytes0(8);
        long l2 = this._getLongLE(this.readerIndex);
        this.readerIndex += 8;
        return l2;
    }

    @Override
    public char readChar() {
        return (char)this.readShort();
    }

    @Override
    public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public ByteBuf readBytes(int n2) {
        this.checkReadableBytes(n2);
        if (n2 == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        ByteBuf byteBuf = this.alloc().buffer(n2, this.maxCapacity);
        byteBuf.writeBytes(this, this.readerIndex, n2);
        this.readerIndex += n2;
        return byteBuf;
    }

    @Override
    public ByteBuf readSlice(int n2) {
        this.checkReadableBytes(n2);
        ByteBuf byteBuf = this.slice(this.readerIndex, n2);
        this.readerIndex += n2;
        return byteBuf;
    }

    @Override
    public ByteBuf readRetainedSlice(int n2) {
        this.checkReadableBytes(n2);
        ByteBuf byteBuf = this.retainedSlice(this.readerIndex, n2);
        this.readerIndex += n2;
        return byteBuf;
    }

    @Override
    public ByteBuf readBytes(byte[] byArray, int n2, int n3) {
        this.checkReadableBytes(n3);
        this.getBytes(this.readerIndex, byArray, n2, n3);
        this.readerIndex += n3;
        return this;
    }

    @Override
    public ByteBuf readBytes(byte[] byArray) {
        this.readBytes(byArray, 0, byArray.length);
        return this;
    }

    @Override
    public ByteBuf readBytes(ByteBuf byteBuf) {
        this.readBytes(byteBuf, byteBuf.writableBytes());
        return this;
    }

    @Override
    public ByteBuf readBytes(ByteBuf byteBuf, int n2) {
        if (n2 > byteBuf.writableBytes()) {
            throw new IndexOutOfBoundsException(String.format("length(%d) exceeds dst.writableBytes(%d) where dst is: %s", n2, byteBuf.writableBytes(), byteBuf));
        }
        this.readBytes(byteBuf, byteBuf.writerIndex(), n2);
        byteBuf.writerIndex(byteBuf.writerIndex() + n2);
        return this;
    }

    @Override
    public ByteBuf readBytes(ByteBuf byteBuf, int n2, int n3) {
        this.checkReadableBytes(n3);
        this.getBytes(this.readerIndex, byteBuf, n2, n3);
        this.readerIndex += n3;
        return this;
    }

    @Override
    public ByteBuf readBytes(ByteBuffer byteBuffer) {
        int n2 = byteBuffer.remaining();
        this.checkReadableBytes(n2);
        this.getBytes(this.readerIndex, byteBuffer);
        this.readerIndex += n2;
        return this;
    }

    @Override
    public int readBytes(GatheringByteChannel gatheringByteChannel, int n2) {
        this.checkReadableBytes(n2);
        int n3 = this.getBytes(this.readerIndex, gatheringByteChannel, n2);
        this.readerIndex += n3;
        return n3;
    }

    @Override
    public int readBytes(FileChannel fileChannel, long l2, int n2) {
        this.checkReadableBytes(n2);
        int n3 = this.getBytes(this.readerIndex, fileChannel, l2, n2);
        this.readerIndex += n3;
        return n3;
    }

    @Override
    public ByteBuf readBytes(OutputStream outputStream, int n2) {
        this.checkReadableBytes(n2);
        this.getBytes(this.readerIndex, outputStream, n2);
        this.readerIndex += n2;
        return this;
    }

    @Override
    public ByteBuf skipBytes(int n2) {
        this.checkReadableBytes(n2);
        this.readerIndex += n2;
        return this;
    }

    @Override
    public ByteBuf writeBoolean(boolean bl2) {
        this.writeByte(bl2 ? 1 : 0);
        return this;
    }

    @Override
    public ByteBuf writeByte(int n2) {
        this.ensureWritable0(1);
        this._setByte(this.writerIndex++, n2);
        return this;
    }

    @Override
    public ByteBuf writeShort(int n2) {
        this.ensureWritable0(2);
        this._setShort(this.writerIndex, n2);
        this.writerIndex += 2;
        return this;
    }

    @Override
    public ByteBuf writeShortLE(int n2) {
        this.ensureWritable0(2);
        this._setShortLE(this.writerIndex, n2);
        this.writerIndex += 2;
        return this;
    }

    @Override
    public ByteBuf writeMedium(int n2) {
        this.ensureWritable0(3);
        this._setMedium(this.writerIndex, n2);
        this.writerIndex += 3;
        return this;
    }

    @Override
    public ByteBuf writeMediumLE(int n2) {
        this.ensureWritable0(3);
        this._setMediumLE(this.writerIndex, n2);
        this.writerIndex += 3;
        return this;
    }

    @Override
    public ByteBuf writeInt(int n2) {
        this.ensureWritable0(4);
        this._setInt(this.writerIndex, n2);
        this.writerIndex += 4;
        return this;
    }

    @Override
    public ByteBuf writeIntLE(int n2) {
        this.ensureWritable0(4);
        this._setIntLE(this.writerIndex, n2);
        this.writerIndex += 4;
        return this;
    }

    @Override
    public ByteBuf writeLong(long l2) {
        this.ensureWritable0(8);
        this._setLong(this.writerIndex, l2);
        this.writerIndex += 8;
        return this;
    }

    @Override
    public ByteBuf writeLongLE(long l2) {
        this.ensureWritable0(8);
        this._setLongLE(this.writerIndex, l2);
        this.writerIndex += 8;
        return this;
    }

    @Override
    public ByteBuf writeChar(int n2) {
        this.writeShort(n2);
        return this;
    }

    @Override
    public ByteBuf writeFloat(float f2) {
        this.writeInt(Float.floatToRawIntBits(f2));
        return this;
    }

    @Override
    public ByteBuf writeDouble(double d2) {
        this.writeLong(Double.doubleToRawLongBits(d2));
        return this;
    }

    @Override
    public ByteBuf writeBytes(byte[] byArray, int n2, int n3) {
        this.ensureWritable(n3);
        this.setBytes(this.writerIndex, byArray, n2, n3);
        this.writerIndex += n3;
        return this;
    }

    @Override
    public ByteBuf writeBytes(byte[] byArray) {
        this.writeBytes(byArray, 0, byArray.length);
        return this;
    }

    @Override
    public ByteBuf writeBytes(ByteBuf byteBuf) {
        this.writeBytes(byteBuf, byteBuf.readableBytes());
        return this;
    }

    @Override
    public ByteBuf writeBytes(ByteBuf byteBuf, int n2) {
        if (n2 > byteBuf.readableBytes()) {
            throw new IndexOutOfBoundsException(String.format("length(%d) exceeds src.readableBytes(%d) where src is: %s", n2, byteBuf.readableBytes(), byteBuf));
        }
        this.writeBytes(byteBuf, byteBuf.readerIndex(), n2);
        byteBuf.readerIndex(byteBuf.readerIndex() + n2);
        return this;
    }

    @Override
    public ByteBuf writeBytes(ByteBuf byteBuf, int n2, int n3) {
        this.ensureWritable(n3);
        this.setBytes(this.writerIndex, byteBuf, n2, n3);
        this.writerIndex += n3;
        return this;
    }

    @Override
    public ByteBuf writeBytes(ByteBuffer byteBuffer) {
        int n2 = byteBuffer.remaining();
        this.ensureWritable0(n2);
        this.setBytes(this.writerIndex, byteBuffer);
        this.writerIndex += n2;
        return this;
    }

    @Override
    public int writeBytes(InputStream inputStream, int n2) {
        this.ensureWritable(n2);
        int n3 = this.setBytes(this.writerIndex, inputStream, n2);
        if (n3 > 0) {
            this.writerIndex += n3;
        }
        return n3;
    }

    @Override
    public int writeBytes(ScatteringByteChannel scatteringByteChannel, int n2) {
        this.ensureWritable(n2);
        int n3 = this.setBytes(this.writerIndex, scatteringByteChannel, n2);
        if (n3 > 0) {
            this.writerIndex += n3;
        }
        return n3;
    }

    @Override
    public int writeBytes(FileChannel fileChannel, long l2, int n2) {
        this.ensureWritable(n2);
        int n3 = this.setBytes(this.writerIndex, fileChannel, l2, n2);
        if (n3 > 0) {
            this.writerIndex += n3;
        }
        return n3;
    }

    @Override
    public ByteBuf writeZero(int n2) {
        int n3;
        if (n2 == 0) {
            return this;
        }
        this.ensureWritable(n2);
        int n4 = this.writerIndex;
        this.checkIndex0(n4, n2);
        int n5 = n2 >>> 3;
        int n6 = n2 & 7;
        for (n3 = n5; n3 > 0; --n3) {
            this._setLong(n4, 0L);
            n4 += 8;
        }
        if (n6 == 4) {
            this._setInt(n4, 0);
            n4 += 4;
        } else if (n6 < 4) {
            for (n3 = n6; n3 > 0; --n3) {
                this._setByte(n4, 0);
                ++n4;
            }
        } else {
            this._setInt(n4, 0);
            n4 += 4;
            for (n3 = n6 - 4; n3 > 0; --n3) {
                this._setByte(n4, 0);
                ++n4;
            }
        }
        this.writerIndex = n4;
        return this;
    }

    @Override
    public int writeCharSequence(CharSequence charSequence, Charset charset) {
        int n2 = this.setCharSequence0(this.writerIndex, charSequence, charset, true);
        this.writerIndex += n2;
        return n2;
    }

    @Override
    public ByteBuf copy() {
        return this.copy(this.readerIndex, this.readableBytes());
    }

    @Override
    public ByteBuf duplicate() {
        this.ensureAccessible();
        return new UnpooledDuplicatedByteBuf(this);
    }

    @Override
    public ByteBuf retainedDuplicate() {
        return this.duplicate().retain();
    }

    @Override
    public ByteBuf slice() {
        return this.slice(this.readerIndex, this.readableBytes());
    }

    @Override
    public ByteBuf retainedSlice() {
        return this.slice().retain();
    }

    @Override
    public ByteBuf slice(int n2, int n3) {
        this.ensureAccessible();
        return new UnpooledSlicedByteBuf(this, n2, n3);
    }

    @Override
    public ByteBuf retainedSlice(int n2, int n3) {
        return this.slice(n2, n3).retain();
    }

    @Override
    public ByteBuffer nioBuffer() {
        return this.nioBuffer(this.readerIndex, this.readableBytes());
    }

    @Override
    public ByteBuffer[] nioBuffers() {
        return this.nioBuffers(this.readerIndex, this.readableBytes());
    }

    @Override
    public String toString(Charset charset) {
        return this.toString(this.readerIndex, this.readableBytes(), charset);
    }

    @Override
    public String toString(int n2, int n3, Charset charset) {
        return ByteBufUtil.decodeString(this, n2, n3, charset);
    }

    @Override
    public int indexOf(int n2, int n3, byte by2) {
        return ByteBufUtil.indexOf(this, n2, n3, by2);
    }

    @Override
    public int bytesBefore(byte by2) {
        return this.bytesBefore(this.readerIndex(), this.readableBytes(), by2);
    }

    @Override
    public int bytesBefore(int n2, byte by2) {
        this.checkReadableBytes(n2);
        return this.bytesBefore(this.readerIndex(), n2, by2);
    }

    @Override
    public int bytesBefore(int n2, int n3, byte by2) {
        int n4 = this.indexOf(n2, n2 + n3, by2);
        if (n4 < 0) {
            return -1;
        }
        return n4 - n2;
    }

    @Override
    public int forEachByte(ByteProcessor byteProcessor) {
        this.ensureAccessible();
        try {
            return this.forEachByteAsc0(this.readerIndex, this.writerIndex, byteProcessor);
        }
        catch (Exception exception) {
            PlatformDependent.throwException(exception);
            return -1;
        }
    }

    @Override
    public int forEachByte(int n2, int n3, ByteProcessor byteProcessor) {
        this.checkIndex(n2, n3);
        try {
            return this.forEachByteAsc0(n2, n2 + n3, byteProcessor);
        }
        catch (Exception exception) {
            PlatformDependent.throwException(exception);
            return -1;
        }
    }

    private int forEachByteAsc0(int n2, int n3, ByteProcessor byteProcessor) {
        while (n2 < n3) {
            if (!byteProcessor.process(this._getByte(n2))) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    @Override
    public int forEachByteDesc(ByteProcessor byteProcessor) {
        this.ensureAccessible();
        try {
            return this.forEachByteDesc0(this.writerIndex - 1, this.readerIndex, byteProcessor);
        }
        catch (Exception exception) {
            PlatformDependent.throwException(exception);
            return -1;
        }
    }

    @Override
    public int forEachByteDesc(int n2, int n3, ByteProcessor byteProcessor) {
        this.checkIndex(n2, n3);
        try {
            return this.forEachByteDesc0(n2 + n3 - 1, n2, byteProcessor);
        }
        catch (Exception exception) {
            PlatformDependent.throwException(exception);
            return -1;
        }
    }

    private int forEachByteDesc0(int n2, int n3, ByteProcessor byteProcessor) {
        while (n2 >= n3) {
            if (!byteProcessor.process(this._getByte(n2))) {
                return n2;
            }
            --n2;
        }
        return -1;
    }

    @Override
    public int hashCode() {
        return ByteBufUtil.hashCode(this);
    }

    @Override
    public boolean equals(Object object) {
        return this == object || object instanceof ByteBuf && ByteBufUtil.equals(this, (ByteBuf)object);
    }

    @Override
    public int compareTo(ByteBuf byteBuf) {
        return ByteBufUtil.compare(this, byteBuf);
    }

    @Override
    public String toString() {
        ByteBuf byteBuf;
        if (this.refCnt() == 0) {
            return StringUtil.simpleClassName(this) + "(freed)";
        }
        StringBuilder stringBuilder = new StringBuilder().append(StringUtil.simpleClassName(this)).append("(ridx: ").append(this.readerIndex).append(", widx: ").append(this.writerIndex).append(", cap: ").append(this.capacity());
        if (this.maxCapacity != Integer.MAX_VALUE) {
            stringBuilder.append('/').append(this.maxCapacity);
        }
        if ((byteBuf = this.unwrap()) != null) {
            stringBuilder.append(", unwrapped: ").append(byteBuf);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    protected final void checkIndex(int n2) {
        this.checkIndex(n2, 1);
    }

    protected final void checkIndex(int n2, int n3) {
        this.ensureAccessible();
        this.checkIndex0(n2, n3);
    }

    final void checkIndex0(int n2, int n3) {
        if (MathUtil.isOutOfBounds(n2, n3, this.capacity())) {
            throw new IndexOutOfBoundsException(String.format("index: %d, length: %d (expected: range(0, %d))", n2, n3, this.capacity()));
        }
    }

    protected final void checkSrcIndex(int n2, int n3, int n4, int n5) {
        this.checkIndex(n2, n3);
        if (MathUtil.isOutOfBounds(n4, n3, n5)) {
            throw new IndexOutOfBoundsException(String.format("srcIndex: %d, length: %d (expected: range(0, %d))", n4, n3, n5));
        }
    }

    protected final void checkDstIndex(int n2, int n3, int n4, int n5) {
        this.checkIndex(n2, n3);
        if (MathUtil.isOutOfBounds(n4, n3, n5)) {
            throw new IndexOutOfBoundsException(String.format("dstIndex: %d, length: %d (expected: range(0, %d))", n4, n3, n5));
        }
    }

    protected final void checkReadableBytes(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("minimumReadableBytes: " + n2 + " (expected: >= 0)");
        }
        this.checkReadableBytes0(n2);
    }

    protected final void checkNewCapacity(int n2) {
        this.ensureAccessible();
        if (n2 < 0 || n2 > this.maxCapacity()) {
            throw new IllegalArgumentException("newCapacity: " + n2 + " (expected: 0-" + this.maxCapacity() + ')');
        }
    }

    private void checkReadableBytes0(int n2) {
        this.ensureAccessible();
        if (this.readerIndex > this.writerIndex - n2) {
            throw new IndexOutOfBoundsException(String.format("readerIndex(%d) + length(%d) exceeds writerIndex(%d): %s", this.readerIndex, n2, this.writerIndex, this));
        }
    }

    protected final void ensureAccessible() {
        if (checkAccessible && this.refCnt() == 0) {
            throw new IllegalReferenceCountException(0);
        }
    }

    final void setIndex0(int n2, int n3) {
        this.readerIndex = n2;
        this.writerIndex = n3;
    }

    final void discardMarks() {
        this.markedWriterIndex = 0;
        this.markedReaderIndex = 0;
    }

    static {
        if (logger.isDebugEnabled()) {
            logger.debug("-D{}: {}", (Object)PROP_MODE, (Object)checkAccessible);
        }
        leakDetector = ResourceLeakDetectorFactory.instance().newResourceLeakDetector(ByteBuf.class);
    }
}

