/*
 * Decompiled with CFR 0.152.
 */
package io.netty.bootstrap;

import io.netty.bootstrap.AbstractBootstrap;
import io.netty.bootstrap.ServerBootstrap$1;
import io.netty.bootstrap.ServerBootstrapConfig;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.util.AbstractConstant;
import io.netty.util.AttributeKey;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.LinkedHashMap;
import java.util.Map;

public class ServerBootstrap
extends AbstractBootstrap<ServerBootstrap, ServerChannel> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ServerBootstrap.class);
    private final Map<ChannelOption<?>, Object> childOptions = new LinkedHashMap();
    private final Map<AttributeKey<?>, Object> childAttrs = new LinkedHashMap();
    private final ServerBootstrapConfig config = new ServerBootstrapConfig(this);
    private volatile EventLoopGroup childGroup;
    private volatile ChannelHandler childHandler;

    public ServerBootstrap() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerBootstrap(ServerBootstrap serverBootstrap) {
        super(serverBootstrap);
        this.childGroup = serverBootstrap.childGroup;
        this.childHandler = serverBootstrap.childHandler;
        Map<AbstractConstant, Object> map = serverBootstrap.childOptions;
        synchronized (map) {
            this.childOptions.putAll(serverBootstrap.childOptions);
        }
        map = serverBootstrap.childAttrs;
        synchronized (map) {
            this.childAttrs.putAll(serverBootstrap.childAttrs);
        }
    }

    @Override
    public ServerBootstrap group(EventLoopGroup eventLoopGroup) {
        return this.group(eventLoopGroup, eventLoopGroup);
    }

    public ServerBootstrap group(EventLoopGroup eventLoopGroup, EventLoopGroup eventLoopGroup2) {
        super.group(eventLoopGroup);
        if (eventLoopGroup2 == null) {
            throw new NullPointerException("childGroup");
        }
        if (this.childGroup != null) {
            throw new IllegalStateException("childGroup set already");
        }
        this.childGroup = eventLoopGroup2;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> ServerBootstrap childOption(ChannelOption<T> channelOption, T t2) {
        if (channelOption == null) {
            throw new NullPointerException("childOption");
        }
        if (t2 == null) {
            Map<ChannelOption<?>, Object> map = this.childOptions;
            synchronized (map) {
                this.childOptions.remove(channelOption);
            }
        }
        Map<ChannelOption<?>, Object> map = this.childOptions;
        synchronized (map) {
            this.childOptions.put(channelOption, t2);
        }
        return this;
    }

    public <T> ServerBootstrap childAttr(AttributeKey<T> attributeKey, T t2) {
        if (attributeKey == null) {
            throw new NullPointerException("childKey");
        }
        if (t2 == null) {
            this.childAttrs.remove(attributeKey);
        } else {
            this.childAttrs.put(attributeKey, t2);
        }
        return this;
    }

    public ServerBootstrap childHandler(ChannelHandler channelHandler) {
        if (channelHandler == null) {
            throw new NullPointerException("childHandler");
        }
        this.childHandler = channelHandler;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void init(Channel channel) {
        Map.Entry[] entryArray;
        Map.Entry[] entryArray2;
        Map<ChannelOption<?>, Object> map = this.options0();
        Map<AbstractConstant, Object> map2 = map;
        synchronized (map2) {
            ServerBootstrap.setChannelOptions(channel, map, logger);
        }
        map2 = this.attrs0();
        Object object2 = map2;
        synchronized (object2) {
            for (Map.Entry<AbstractConstant, Object> object3 : map2.entrySet()) {
                entryArray2 = (Map.Entry[])object3.getKey();
                channel.attr(entryArray2).set(object3.getValue());
            }
        }
        object2 = channel.pipeline();
        EventLoopGroup eventLoopGroup = this.childGroup;
        ChannelHandler channelHandler = this.childHandler;
        Map<AbstractConstant, Object> map3 = this.childOptions;
        synchronized (map3) {
            entryArray2 = this.childOptions.entrySet().toArray(ServerBootstrap.newOptionArray(this.childOptions.size()));
        }
        map3 = this.childAttrs;
        synchronized (map3) {
            entryArray = this.childAttrs.entrySet().toArray(ServerBootstrap.newAttrArray(this.childAttrs.size()));
        }
        object2.addLast(new ServerBootstrap$1(this, eventLoopGroup, channelHandler, entryArray2, entryArray));
    }

    @Override
    public ServerBootstrap validate() {
        super.validate();
        if (this.childHandler == null) {
            throw new IllegalStateException("childHandler not set");
        }
        if (this.childGroup == null) {
            logger.warn("childGroup is not set. Using parentGroup instead.");
            this.childGroup = this.config.group();
        }
        return this;
    }

    private static Map.Entry<AttributeKey<?>, Object>[] newAttrArray(int n2) {
        return new Map.Entry[n2];
    }

    private static Map.Entry<ChannelOption<?>, Object>[] newOptionArray(int n2) {
        return new Map.Entry[n2];
    }

    @Override
    public ServerBootstrap clone() {
        return new ServerBootstrap(this);
    }

    @Deprecated
    public EventLoopGroup childGroup() {
        return this.childGroup;
    }

    final ChannelHandler childHandler() {
        return this.childHandler;
    }

    final Map<ChannelOption<?>, Object> childOptions() {
        return ServerBootstrap.copiedMap(this.childOptions);
    }

    final Map<AttributeKey<?>, Object> childAttrs() {
        return ServerBootstrap.copiedMap(this.childAttrs);
    }

    public final ServerBootstrapConfig config() {
        return this.config;
    }

    static /* synthetic */ ServerBootstrapConfig access$000(ServerBootstrap serverBootstrap) {
        return serverBootstrap.config;
    }

    static /* synthetic */ InternalLogger access$100() {
        return logger;
    }
}

