/*
 * Decompiled with CFR 0.152.
 */
package dev.wh1tew1ndows.common.impl.proxy;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.wh1tew1ndows.common.impl.proxy.Proxy;
import dev.wh1tew1ndows.common.impl.proxy.ProxyConfig$1;
import dev.wh1tew1ndows.common.impl.proxy.ProxyServer;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import org.apache.commons.io.FileUtils;

public class ProxyConfig {
    private static final String CONFIG_PATH = String.valueOf(Minecraft.getInstance().gameDir) + "/proxyconfig.json";
    public static HashMap<String, Proxy> accounts = new HashMap();
    public static String lastPlayerName = "";

    public static void loadConfig() {
        File file = new File(CONFIG_PATH);
        try {
            if (!file.exists()) {
                if (!file.createNewFile()) {
                    System.out.println("Error creating proxyconfig.json file");
                }
                return;
            }
            String string = FileUtils.readFileToString(file, StandardCharsets.UTF_8);
            if (!string.isEmpty()) {
                JsonObject jsonObject = new JsonParser().parse(string).getAsJsonObject();
                ProxyServer.proxyEnabled = jsonObject.get("proxy-enabled").getAsBoolean();
                Type type = new ProxyConfig$1().getType();
                accounts = (HashMap)new Gson().fromJson(jsonObject.get("accounts"), type);
                if (accounts == null) {
                    accounts = new HashMap();
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Error reading proxyconfig.json file");
            exception.printStackTrace();
        }
    }

    public static void setDefaultProxy(Proxy proxy) {
        accounts.put("", proxy);
    }

    public static void saveConfig() {
        try {
            JsonElement jsonElement = new Gson().toJsonTree(accounts);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("proxy-enabled", ProxyServer.proxyEnabled);
            jsonObject.add("accounts", jsonElement);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            FileUtils.write(new File(CONFIG_PATH), (CharSequence)gson.toJson(jsonObject), StandardCharsets.UTF_8);
        }
        catch (IOException iOException) {
            System.out.println("Error writing proxyconfig.json file");
            iOException.printStackTrace();
        }
    }
}

