/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.util;

import com.viaversion.viaversion.util.BiIntConsumer;
import java.util.function.IntToLongFunction;

public final class CompactArrayUtil {
    private static final long[] RECIPROCAL_MULT_AND_ADD = new long[]{0xFFFFFFFFL, 0L, 0x55555555L, 0L, 0x33333333L, 0x2AAAAAAAL, 0x24924924L, 0L, 0x1C71C71CL, 0x19999999L, 390451572L, 0x15555555L, 0x13B13B13L, 306783378L, 0x11111111L, 0L, 0xF0F0F0FL, 0xE38E38EL, 226050910L, 0xCCCCCCCL, 0xC30C30CL, 195225786L, 186737708L, 0xAAAAAAAL, 171798691L, 0x9D89D89L, 159072862L, 0x9249249L, 148102320L, 0x8888888L, 138547332L, 0L, 130150524L, 0x7878787L, 0x7507507L, 0x71C71C7L, 116080197L, 113025455L, 0x6906906L, 0x6666666L, 104755299L, 0x6186186L, 99882960L, 97612893L, 0x5B05B05L, 93368854L, 91382282L, 0x5555555L, 87652393L, 85899345L, 0x5050505L, 0x4EC4EC4L, 81037118L, 79536431L, 78090314L, 0x4924924L, 75350303L, 74051160L, 72796055L, 0x4444444L, 70409299L, 69273666L, 0x4104104L, 0L};
    private static final int[] RECIPROCAL_RIGHT_SHIFT = new int[]{0, 0, 0, 1, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5};

    public static long[] createCompactArrayWithPadding(int n2, int n3, IntToLongFunction intToLongFunction) {
        long l2 = (1L << n2) - 1L;
        char c2 = (char)(64 / n2);
        int n4 = c2 - '\u0001';
        long l3 = RECIPROCAL_MULT_AND_ADD[n4];
        long l4 = l3 != 0L ? l3 : 0x80000000L;
        int n5 = RECIPROCAL_RIGHT_SHIFT[n4];
        int n6 = (n3 + c2 - 1) / c2;
        long[] lArray = new long[n6];
        for (int i2 = 0; i2 < n3; ++i2) {
            long l5 = intToLongFunction.applyAsLong(i2);
            int n7 = (int)((long)i2 * l4 + l3 >> 32 >> n5);
            int n8 = (i2 - n7 * c2) * n2;
            lArray[n7] = lArray[n7] & (l2 << n8 ^ 0xFFFFFFFFFFFFFFFFL) | (l5 & l2) << n8;
        }
        return lArray;
    }

    public static void iterateCompactArrayWithPadding(int n2, int n3, long[] lArray, BiIntConsumer biIntConsumer) {
        long l2 = (1L << n2) - 1L;
        char c2 = (char)(64 / n2);
        int n4 = c2 - '\u0001';
        long l3 = RECIPROCAL_MULT_AND_ADD[n4];
        long l4 = l3 != 0L ? l3 : 0x80000000L;
        int n5 = RECIPROCAL_RIGHT_SHIFT[n4];
        for (int i2 = 0; i2 < n3; ++i2) {
            int n6 = (int)((long)i2 * l4 + l3 >> 32 >> n5);
            int n7 = (i2 - n6 * c2) * n2;
            int n8 = (int)(lArray[n6] >> n7 & l2);
            biIntConsumer.consume(i2, n8);
        }
    }

    public static long[] createCompactArray(int n2, int n3, IntToLongFunction intToLongFunction) {
        long l2 = (1L << n2) - 1L;
        long[] lArray = new long[(int)Math.ceil((double)(n3 * n2) / 64.0)];
        for (int i2 = 0; i2 < n3; ++i2) {
            long l3 = intToLongFunction.applyAsLong(i2);
            int n4 = i2 * n2;
            int n5 = n4 / 64;
            int n6 = ((i2 + 1) * n2 - 1) / 64;
            int n7 = n4 % 64;
            lArray[n5] = lArray[n5] & (l2 << n7 ^ 0xFFFFFFFFFFFFFFFFL) | (l3 & l2) << n7;
            if (n5 == n6) continue;
            int n8 = 64 - n7;
            lArray[n6] = lArray[n6] >>> n8 << n8 | (l3 & l2) >> n8;
        }
        return lArray;
    }

    public static void iterateCompactArray(int n2, int n3, long[] lArray, BiIntConsumer biIntConsumer) {
        long l2 = (1L << n2) - 1L;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4;
            int n5 = i2 * n2;
            int n6 = n5 / 64;
            int n7 = ((i2 + 1) * n2 - 1) / 64;
            int n8 = n5 % 64;
            if (n6 == n7) {
                n4 = (int)(lArray[n6] >>> n8 & l2);
            } else {
                int n9 = 64 - n8;
                n4 = (int)((lArray[n6] >>> n8 | lArray[n7] << n9) & l2);
            }
            biIntConsumer.consume(i2, n4);
        }
    }
}

