/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.util;

import com.viaversion.viaversion.libs.fastutil.ints.Int2IntMap;
import com.viaversion.viaversion.libs.fastutil.ints.Int2IntOpenHashMap;
import java.util.regex.Pattern;

public class ChatColorUtil {
    public static final Pattern STRIP_COLOR_PATTERN = Pattern.compile("(?i)\u00a7[0-9A-FK-ORX]");
    private static final Int2IntMap COLOR_ORDINALS = new Int2IntOpenHashMap();
    private static int ordinalCounter;

    public static boolean isColorCode(char c2) {
        return COLOR_ORDINALS.containsKey(c2);
    }

    public static int getColorOrdinal(char c2) {
        return COLOR_ORDINALS.getOrDefault(c2, -1);
    }

    public static String translateAlternateColorCodes(String string) {
        char[] cArray = string.toCharArray();
        for (int i2 = 0; i2 < cArray.length - 1; ++i2) {
            if (cArray[i2] != '&' || "0123456789AaBbCcDdEeFfKkLlMmNnOoRrXx".indexOf(cArray[i2 + 1]) <= -1) continue;
            cArray[i2] = 167;
            cArray[i2 + 1] = Character.toLowerCase(cArray[i2 + 1]);
        }
        return new String(cArray);
    }

    public static String stripColor(String string) {
        return STRIP_COLOR_PATTERN.matcher(string).replaceAll("");
    }

    private static void addColorOrdinal(int n2, int n3) {
        for (int i2 = n2; i2 <= n3; ++i2) {
            ChatColorUtil.addColorOrdinal(i2);
        }
    }

    private static void addColorOrdinal(int n2) {
        COLOR_ORDINALS.put(n2, ordinalCounter++);
    }

    static {
        ChatColorUtil.addColorOrdinal(48, 57);
        ChatColorUtil.addColorOrdinal(97, 102);
        ChatColorUtil.addColorOrdinal(107, 111);
        ChatColorUtil.addColorOrdinal(114);
    }
}

