/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.rewriter.meta;

import com.google.common.base.X;
import com.viaversion.viaversion.api.minecraft.entities.EntityType;
import com.viaversion.viaversion.api.minecraft.metadata.Metadata;
import com.viaversion.viaversion.rewriter.meta.MetaHandler;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MetaFilter {
    private final MetaHandler handler;
    private final EntityType type;
    private final int index;
    private final boolean filterFamily;

    public MetaFilter(@Nullable EntityType entityType, boolean bl2, int n2, MetaHandler metaHandler) {
        X.a(metaHandler, (Object)"MetaHandler cannot be null");
        this.type = entityType;
        this.filterFamily = bl2;
        this.index = n2;
        this.handler = metaHandler;
    }

    public MetaHandler handler() {
        return this.handler;
    }

    public boolean isFiltered(@Nullable EntityType entityType, Metadata metadata) {
        return !(this.index != -1 && metadata.id() != this.index || this.type != null && !this.matchesType(entityType));
    }

    private boolean matchesType(@Nullable EntityType entityType) {
        return entityType != null && (this.filterFamily ? entityType.isOrHasParent(this.type) : this.type == entityType);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MetaFilter metaFilter = (MetaFilter)object;
        if (this.index != metaFilter.index) {
            return false;
        }
        if (this.filterFamily != metaFilter.filterFamily) {
            return false;
        }
        if (!this.handler.equals(metaFilter.handler)) {
            return false;
        }
        return Objects.equals(this.type, metaFilter.type);
    }

    public int hashCode() {
        int n2 = this.handler.hashCode();
        n2 = 31 * n2 + (this.type != null ? this.type.hashCode() : 0);
        n2 = 31 * n2 + this.index;
        n2 = 31 * n2 + (this.filterFamily ? 1 : 0);
        return n2;
    }

    public String toString() {
        return "MetaFilter{type=" + this.type + ", filterFamily=" + this.filterFamily + ", index=" + this.index + ", handler=" + this.handler + '}';
    }
}

