/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.rewriter;

import com.viaversion.viaversion.api.data.MappingData;
import com.viaversion.viaversion.api.minecraft.RegistryType;
import com.viaversion.viaversion.api.minecraft.TagData;
import com.viaversion.viaversion.api.protocol.Protocol;
import com.viaversion.viaversion.api.protocol.packet.ClientboundPacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandler;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.libs.fastutil.ints.IntArrayList;
import com.viaversion.viaversion.rewriter.IdRewriteFunction;
import com.viaversion.viaversion.util.Key;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TagRewriter<C extends ClientboundPacketType> {
    private static final int[] EMPTY_ARRAY = new int[0];
    private final Protocol<C, ?, ?, ?> protocol;
    private final Map<RegistryType, List<TagData>> newTags = new EnumMap<RegistryType, List<TagData>>(RegistryType.class);
    private final Map<RegistryType, Map<String, String>> toRename = new EnumMap<RegistryType, Map<String, String>>(RegistryType.class);
    private final Set<String> toRemove = new HashSet<String>();

    public TagRewriter(Protocol<C, ?, ?, ?> protocol) {
        this.protocol = protocol;
    }

    public void loadFromMappingData() {
        for (RegistryType registryType : RegistryType.getValues()) {
            List<TagData> list = this.protocol.getMappingData().getTags(registryType);
            if (list == null) continue;
            this.getOrComputeNewTags(registryType).addAll(list);
        }
    }

    public void removeTags(String string) {
        this.toRemove.add(string);
    }

    public void renameTag(RegistryType registryType2, String string, String string2) {
        this.toRename.computeIfAbsent(registryType2, registryType -> new HashMap()).put(string, string2);
    }

    public void addEmptyTag(RegistryType registryType, String string) {
        this.getOrComputeNewTags(registryType).add(new TagData(string, EMPTY_ARRAY));
    }

    public void addEmptyTags(RegistryType registryType, String ... stringArray) {
        List<TagData> list = this.getOrComputeNewTags(registryType);
        for (String string : stringArray) {
            list.add(new TagData(string, EMPTY_ARRAY));
        }
    }

    public void addTag(RegistryType registryType, String string, int ... nArray) {
        List<TagData> list = this.getOrComputeNewTags(registryType);
        IdRewriteFunction idRewriteFunction = this.getRewriter(registryType);
        if (idRewriteFunction != null) {
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                int n2 = nArray[i2];
                nArray[i2] = idRewriteFunction.rewrite(n2);
            }
        }
        list.add(new TagData(string, nArray));
    }

    public void addTagRaw(RegistryType registryType, String string, int ... nArray) {
        this.getOrComputeNewTags(registryType).add(new TagData(string, nArray));
    }

    public void register(C c2, @Nullable RegistryType registryType) {
        this.protocol.registerClientbound(c2, this.getHandler(registryType));
    }

    public void registerGeneric(C c2) {
        this.protocol.registerClientbound(c2, this.getGenericHandler());
    }

    public PacketHandler getHandler(@Nullable RegistryType registryType) {
        return packetWrapper -> {
            for (RegistryType registryType2 : RegistryType.getValues()) {
                this.handle(packetWrapper, this.getRewriter(registryType2), this.getNewTags(registryType2), this.toRename.get((Object)registryType2));
                if (registryType2 == registryType) break;
            }
        };
    }

    public PacketHandler getGenericHandler() {
        return packetWrapper -> {
            int n2;
            int n3 = n2 = packetWrapper.passthrough(Type.VAR_INT).intValue();
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = packetWrapper.read(Type.STRING);
                if (this.toRemove.contains(string)) {
                    packetWrapper.set(Type.VAR_INT, 0, --n3);
                    int n4 = packetWrapper.read(Type.VAR_INT);
                    for (int i3 = 0; i3 < n4; ++i3) {
                        packetWrapper.read(Type.STRING);
                        packetWrapper.read(Type.VAR_INT_ARRAY_PRIMITIVE);
                    }
                    continue;
                }
                packetWrapper.write(Type.STRING, string);
                string = Key.stripMinecraftNamespace(string);
                RegistryType registryType = RegistryType.getByKey(string);
                if (registryType != null) {
                    this.handle(packetWrapper, this.getRewriter(registryType), this.getNewTags(registryType), this.toRename.get((Object)registryType));
                    continue;
                }
                this.handle(packetWrapper, null, null, null);
            }
        };
    }

    public void handle(PacketWrapper packetWrapper, @Nullable IdRewriteFunction idRewriteFunction, @Nullable List<TagData> list) {
        this.handle(packetWrapper, idRewriteFunction, list, null);
    }

    /*
     * WARNING - void declaration
     */
    public void handle(PacketWrapper packetWrapper, @Nullable IdRewriteFunction idRewriteFunction, @Nullable List<TagData> list, @Nullable Map<String, String> map) {
        int n2 = packetWrapper.read(Type.VAR_INT);
        packetWrapper.write(Type.VAR_INT, list != null ? n2 + list.size() : n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            void object2;
            Object object;
            String string = packetWrapper.read(Type.STRING);
            if (map != null && (object = map.get(string)) != null) {
                String string2 = object;
            }
            packetWrapper.write(Type.STRING, object2);
            object = packetWrapper.read(Type.VAR_INT_ARRAY_PRIMITIVE);
            if (idRewriteFunction != null) {
                IntArrayList intArrayList = new IntArrayList(((Object)object).length);
                for (Object object3 : object) {
                    int n3 = idRewriteFunction.rewrite((int)object3);
                    if (n3 == -1) continue;
                    intArrayList.add(n3);
                }
                packetWrapper.write(Type.VAR_INT_ARRAY_PRIMITIVE, intArrayList.toArray(EMPTY_ARRAY));
                continue;
            }
            packetWrapper.write(Type.VAR_INT_ARRAY_PRIMITIVE, object);
        }
        if (list != null) {
            for (TagData tagData : list) {
                packetWrapper.write(Type.STRING, tagData.identifier());
                packetWrapper.write(Type.VAR_INT_ARRAY_PRIMITIVE, tagData.entries());
            }
        }
    }

    public @Nullable List<TagData> getNewTags(RegistryType registryType) {
        return this.newTags.get((Object)registryType);
    }

    public List<TagData> getOrComputeNewTags(RegistryType registryType2) {
        return this.newTags.computeIfAbsent(registryType2, registryType -> new ArrayList());
    }

    public @Nullable IdRewriteFunction getRewriter(RegistryType registryType) {
        MappingData mappingData = this.protocol.getMappingData();
        switch (registryType) {
            case BLOCK: {
                return mappingData != null && mappingData.getBlockMappings() != null ? mappingData::getNewBlockId : null;
            }
            case ITEM: {
                return mappingData != null && mappingData.getItemMappings() != null ? mappingData::getNewItemId : null;
            }
            case ENTITY: {
                return this.protocol.getEntityRewriter() != null ? n2 -> this.protocol.getEntityRewriter().newEntityId(n2) : null;
            }
        }
        return null;
    }
}

