/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.rewriter;

import com.viaversion.viaversion.api.minecraft.RegistryType;
import com.viaversion.viaversion.api.protocol.Protocol;
import com.viaversion.viaversion.api.protocol.packet.ClientboundPacketType;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.rewriter.IdRewriteFunction;
import org.checkerframework.checker.nullness.qual.Nullable;

public class StatisticsRewriter<C extends ClientboundPacketType> {
    private final Protocol<C, ?, ?, ?> protocol;

    public StatisticsRewriter(Protocol<C, ?, ?, ?> protocol) {
        this.protocol = protocol;
    }

    public void register(C c2) {
        this.protocol.registerClientbound(c2, packetWrapper -> {
            int n2;
            int n3 = n2 = packetWrapper.passthrough(Type.VAR_INT).intValue();
            for (int i2 = 0; i2 < n2; ++i2) {
                int n4 = packetWrapper.read(Type.VAR_INT);
                int n5 = packetWrapper.read(Type.VAR_INT);
                int n6 = packetWrapper.read(Type.VAR_INT);
                if (n4 == 8 && this.protocol.getMappingData().getStatisticsMappings() != null) {
                    n5 = this.protocol.getMappingData().getStatisticsMappings().getNewId(n5);
                    if (n5 == -1) {
                        --n3;
                        continue;
                    }
                } else {
                    IdRewriteFunction idRewriteFunction;
                    RegistryType registryType = this.getRegistryTypeForStatistic(n4);
                    if (registryType != null && (idRewriteFunction = this.getRewriter(registryType)) != null) {
                        n5 = idRewriteFunction.rewrite(n5);
                    }
                }
                packetWrapper.write(Type.VAR_INT, n4);
                packetWrapper.write(Type.VAR_INT, n5);
                packetWrapper.write(Type.VAR_INT, n6);
            }
            if (n3 != n2) {
                packetWrapper.set(Type.VAR_INT, 0, n3);
            }
        });
    }

    protected @Nullable IdRewriteFunction getRewriter(RegistryType registryType) {
        switch (registryType) {
            case BLOCK: {
                return this.protocol.getMappingData().getBlockMappings() != null ? n2 -> this.protocol.getMappingData().getNewBlockId(n2) : null;
            }
            case ITEM: {
                return this.protocol.getMappingData().getItemMappings() != null ? n2 -> this.protocol.getMappingData().getNewItemId(n2) : null;
            }
            case ENTITY: {
                return this.protocol.getEntityRewriter() != null ? n2 -> this.protocol.getEntityRewriter().newEntityId(n2) : null;
            }
        }
        throw new IllegalArgumentException("Unknown registry type in statistics packet: " + (Object)((Object)registryType));
    }

    public @Nullable RegistryType getRegistryTypeForStatistic(int n2) {
        switch (n2) {
            case 0: {
                return RegistryType.BLOCK;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return RegistryType.ITEM;
            }
            case 6: 
            case 7: {
                return RegistryType.ENTITY;
            }
        }
        return null;
    }
}

