/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.rewriter;

import com.viaversion.viaversion.api.minecraft.item.Item;
import com.viaversion.viaversion.api.protocol.Protocol;
import com.viaversion.viaversion.api.protocol.packet.ClientboundPacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.rewriter.RecipeRewriter$RecipeConsumer;
import com.viaversion.viaversion.util.Key;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RecipeRewriter<C extends ClientboundPacketType> {
    protected final Protocol<C, ?, ?, ?> protocol;
    protected final Map<String, RecipeRewriter$RecipeConsumer> recipeHandlers = new HashMap<String, RecipeRewriter$RecipeConsumer>();

    public RecipeRewriter(Protocol<C, ?, ?, ?> protocol) {
        this.protocol = protocol;
        this.recipeHandlers.put("crafting_shapeless", this::handleCraftingShapeless);
        this.recipeHandlers.put("crafting_shaped", this::handleCraftingShaped);
        this.recipeHandlers.put("smelting", this::handleSmelting);
        this.recipeHandlers.put("blasting", this::handleSmelting);
        this.recipeHandlers.put("smoking", this::handleSmelting);
        this.recipeHandlers.put("campfire_cooking", this::handleSmelting);
        this.recipeHandlers.put("stonecutting", this::handleStonecutting);
        this.recipeHandlers.put("smithing", this::handleSmithing);
        this.recipeHandlers.put("smithing_transform", this::handleSmithingTransform);
        this.recipeHandlers.put("smithing_trim", this::handleSmithingTrim);
        this.recipeHandlers.put("crafting_decorated_pot", this::handleSimpleRecipe);
    }

    public void handleRecipeType(PacketWrapper packetWrapper, String string) {
        RecipeRewriter$RecipeConsumer recipeRewriter$RecipeConsumer = this.recipeHandlers.get(string);
        if (recipeRewriter$RecipeConsumer != null) {
            recipeRewriter$RecipeConsumer.accept(packetWrapper);
        }
    }

    public void register(C c2) {
        this.protocol.registerClientbound(c2, packetWrapper -> {
            int n2 = packetWrapper.passthrough(Type.VAR_INT);
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = packetWrapper.passthrough(Type.STRING);
                packetWrapper.passthrough(Type.STRING);
                this.handleRecipeType(packetWrapper, Key.stripMinecraftNamespace(string));
            }
        });
    }

    public void handleCraftingShaped(PacketWrapper packetWrapper) {
        int n2 = packetWrapper.passthrough(Type.VAR_INT) * packetWrapper.passthrough(Type.VAR_INT);
        packetWrapper.passthrough(Type.STRING);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.handleIngredient(packetWrapper);
        }
        this.rewrite(packetWrapper.passthrough(Type.FLAT_VAR_INT_ITEM));
    }

    public void handleCraftingShapeless(PacketWrapper packetWrapper) {
        packetWrapper.passthrough(Type.STRING);
        this.handleIngredients(packetWrapper);
        this.rewrite(packetWrapper.passthrough(Type.FLAT_VAR_INT_ITEM));
    }

    public void handleSmelting(PacketWrapper packetWrapper) {
        packetWrapper.passthrough(Type.STRING);
        this.handleIngredient(packetWrapper);
        this.rewrite(packetWrapper.passthrough(Type.FLAT_VAR_INT_ITEM));
        packetWrapper.passthrough(Type.FLOAT);
        packetWrapper.passthrough(Type.VAR_INT);
    }

    public void handleStonecutting(PacketWrapper packetWrapper) {
        packetWrapper.passthrough(Type.STRING);
        this.handleIngredient(packetWrapper);
        this.rewrite(packetWrapper.passthrough(Type.FLAT_VAR_INT_ITEM));
    }

    public void handleSmithing(PacketWrapper packetWrapper) {
        this.handleIngredient(packetWrapper);
        this.handleIngredient(packetWrapper);
        this.rewrite(packetWrapper.passthrough(Type.FLAT_VAR_INT_ITEM));
    }

    public void handleSimpleRecipe(PacketWrapper packetWrapper) {
        packetWrapper.passthrough(Type.VAR_INT);
    }

    public void handleSmithingTransform(PacketWrapper packetWrapper) {
        this.handleIngredient(packetWrapper);
        this.handleIngredient(packetWrapper);
        this.handleIngredient(packetWrapper);
        this.rewrite(packetWrapper.passthrough(Type.FLAT_VAR_INT_ITEM));
    }

    public void handleSmithingTrim(PacketWrapper packetWrapper) {
        this.handleIngredient(packetWrapper);
        this.handleIngredient(packetWrapper);
        this.handleIngredient(packetWrapper);
    }

    protected void rewrite(@Nullable Item item) {
        if (this.protocol.getItemRewriter() != null) {
            this.protocol.getItemRewriter().handleItemToClient(item);
        }
    }

    protected void handleIngredient(PacketWrapper packetWrapper) {
        Item[] itemArray;
        for (Item item : itemArray = packetWrapper.passthrough(Type.FLAT_VAR_INT_ITEM_ARRAY_VAR_INT)) {
            this.rewrite(item);
        }
    }

    protected void handleIngredients(PacketWrapper packetWrapper) {
        int n2 = packetWrapper.passthrough(Type.VAR_INT);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.handleIngredient(packetWrapper);
        }
    }
}

