/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.rewriter;

import com.viaversion.viaversion.api.data.ParticleMappings;
import com.viaversion.viaversion.api.minecraft.item.Item;
import com.viaversion.viaversion.api.protocol.Protocol;
import com.viaversion.viaversion.api.protocol.packet.ClientboundPacketType;
import com.viaversion.viaversion.api.protocol.packet.ServerboundPacketType;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandler;
import com.viaversion.viaversion.api.rewriter.RewriterBase;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.rewriter.ItemRewriter$1;
import com.viaversion.viaversion.rewriter.ItemRewriter$10;
import com.viaversion.viaversion.rewriter.ItemRewriter$11;
import com.viaversion.viaversion.rewriter.ItemRewriter$12;
import com.viaversion.viaversion.rewriter.ItemRewriter$13;
import com.viaversion.viaversion.rewriter.ItemRewriter$2;
import com.viaversion.viaversion.rewriter.ItemRewriter$3;
import com.viaversion.viaversion.rewriter.ItemRewriter$4;
import com.viaversion.viaversion.rewriter.ItemRewriter$5;
import com.viaversion.viaversion.rewriter.ItemRewriter$6;
import com.viaversion.viaversion.rewriter.ItemRewriter$7;
import com.viaversion.viaversion.rewriter.ItemRewriter$8;
import com.viaversion.viaversion.rewriter.ItemRewriter$9;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class ItemRewriter<C extends ClientboundPacketType, S extends ServerboundPacketType, T extends Protocol<C, ?, ?, S>>
extends RewriterBase<T>
implements com.viaversion.viaversion.api.rewriter.ItemRewriter<T> {
    protected ItemRewriter(T t2) {
        super(t2);
    }

    @Override
    public @Nullable Item handleItemToClient(@Nullable Item item) {
        if (item == null) {
            return null;
        }
        if (this.protocol.getMappingData() != null && this.protocol.getMappingData().getItemMappings() != null) {
            item.setIdentifier(this.protocol.getMappingData().getNewItemId(item.identifier()));
        }
        return item;
    }

    public @Nullable Item handleItemToServer(@Nullable Item item) {
        if (item == null) {
            return null;
        }
        if (this.protocol.getMappingData() != null && this.protocol.getMappingData().getItemMappings() != null) {
            item.setIdentifier(this.protocol.getMappingData().getOldItemId(item.identifier()));
        }
        return item;
    }

    public void registerWindowItems(C c2, Type<Item[]> type) {
        this.protocol.registerClientbound(c2, new ItemRewriter$1(this, type));
    }

    public void registerWindowItems1_17_1(C c2) {
        this.protocol.registerClientbound(c2, new ItemRewriter$2(this));
    }

    public void registerOpenWindow(C c2) {
        this.protocol.registerClientbound(c2, new ItemRewriter$3(this));
    }

    public void registerSetSlot(C c2, Type<Item> type) {
        this.protocol.registerClientbound(c2, new ItemRewriter$4(this, type));
    }

    public void registerSetSlot1_17_1(C c2) {
        this.protocol.registerClientbound(c2, new ItemRewriter$5(this));
    }

    public void registerEntityEquipment(C c2, Type<Item> type) {
        this.protocol.registerClientbound(c2, new ItemRewriter$6(this, type));
    }

    public void registerEntityEquipmentArray(C c2) {
        this.protocol.registerClientbound(c2, new ItemRewriter$7(this));
    }

    public void registerCreativeInvAction(S s2, Type<Item> type) {
        this.protocol.registerServerbound(s2, new ItemRewriter$8(this, type));
    }

    public void registerClickWindow(S s2, Type<Item> type) {
        this.protocol.registerServerbound(s2, new ItemRewriter$9(this, type));
    }

    public void registerClickWindow1_17_1(S s2) {
        this.protocol.registerServerbound(s2, new ItemRewriter$10(this));
    }

    public void registerSetCooldown(C c2) {
        this.protocol.registerClientbound(c2, packetWrapper -> {
            int n2 = packetWrapper.read(Type.VAR_INT);
            packetWrapper.write(Type.VAR_INT, this.protocol.getMappingData().getNewItemId(n2));
        });
    }

    public void registerTradeList(C c2) {
        this.protocol.registerClientbound(c2, packetWrapper -> {
            packetWrapper.passthrough(Type.VAR_INT);
            int n2 = packetWrapper.passthrough(Type.UNSIGNED_BYTE).shortValue();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.handleItemToClient(packetWrapper.passthrough(Type.FLAT_VAR_INT_ITEM));
                this.handleItemToClient(packetWrapper.passthrough(Type.FLAT_VAR_INT_ITEM));
                if (packetWrapper.passthrough(Type.BOOLEAN).booleanValue()) {
                    this.handleItemToClient(packetWrapper.passthrough(Type.FLAT_VAR_INT_ITEM));
                }
                packetWrapper.passthrough(Type.BOOLEAN);
                packetWrapper.passthrough(Type.INT);
                packetWrapper.passthrough(Type.INT);
                packetWrapper.passthrough(Type.INT);
                packetWrapper.passthrough(Type.INT);
                packetWrapper.passthrough(Type.FLOAT);
                packetWrapper.passthrough(Type.INT);
            }
        });
    }

    public void registerTradeList1_19(C c2) {
        this.protocol.registerClientbound(c2, packetWrapper -> {
            packetWrapper.passthrough(Type.VAR_INT);
            int n2 = packetWrapper.passthrough(Type.VAR_INT);
            for (int i2 = 0; i2 < n2; ++i2) {
                this.handleItemToClient(packetWrapper.passthrough(Type.FLAT_VAR_INT_ITEM));
                this.handleItemToClient(packetWrapper.passthrough(Type.FLAT_VAR_INT_ITEM));
                this.handleItemToClient(packetWrapper.passthrough(Type.FLAT_VAR_INT_ITEM));
                packetWrapper.passthrough(Type.BOOLEAN);
                packetWrapper.passthrough(Type.INT);
                packetWrapper.passthrough(Type.INT);
                packetWrapper.passthrough(Type.INT);
                packetWrapper.passthrough(Type.INT);
                packetWrapper.passthrough(Type.FLOAT);
                packetWrapper.passthrough(Type.INT);
            }
        });
    }

    public void registerAdvancements(C c2, Type<Item> type) {
        this.protocol.registerClientbound(c2, packetWrapper -> {
            packetWrapper.passthrough(Type.BOOLEAN);
            int n2 = packetWrapper.passthrough(Type.VAR_INT);
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3;
                packetWrapper.passthrough(Type.STRING);
                if (packetWrapper.passthrough(Type.BOOLEAN).booleanValue()) {
                    packetWrapper.passthrough(Type.STRING);
                }
                if (packetWrapper.passthrough(Type.BOOLEAN).booleanValue()) {
                    packetWrapper.passthrough(Type.COMPONENT);
                    packetWrapper.passthrough(Type.COMPONENT);
                    this.handleItemToClient((Item)packetWrapper.passthrough(type));
                    packetWrapper.passthrough(Type.VAR_INT);
                    n3 = packetWrapper.passthrough(Type.INT);
                    if ((n3 & 1) != 0) {
                        packetWrapper.passthrough(Type.STRING);
                    }
                    packetWrapper.passthrough(Type.FLOAT);
                    packetWrapper.passthrough(Type.FLOAT);
                }
                packetWrapper.passthrough(Type.STRING_ARRAY);
                n3 = packetWrapper.passthrough(Type.VAR_INT);
                for (int i3 = 0; i3 < n3; ++i3) {
                    packetWrapper.passthrough(Type.STRING_ARRAY);
                }
            }
        });
    }

    public void registerWindowPropertyEnchantmentHandler(C c2) {
        this.protocol.registerClientbound(c2, new ItemRewriter$11(this));
    }

    public void registerSpawnParticle(C c2, Type<Item> type, Type<?> type2) {
        this.protocol.registerClientbound(c2, new ItemRewriter$12(this, type2, type));
    }

    public void registerSpawnParticle1_19(C c2) {
        this.protocol.registerClientbound(c2, new ItemRewriter$13(this));
    }

    public PacketHandler getSpawnParticleHandler(Type<Item> type) {
        return this.getSpawnParticleHandler(Type.INT, type);
    }

    public PacketHandler getSpawnParticleHandler(Type<Integer> type, Type<Item> type2) {
        return packetWrapper -> {
            int n2;
            int n3 = (Integer)packetWrapper.get(type, 0);
            if (n3 == -1) {
                return;
            }
            ParticleMappings particleMappings = this.protocol.getMappingData().getParticleMappings();
            if (particleMappings.isBlockParticle(n3)) {
                n2 = packetWrapper.read(Type.VAR_INT);
                packetWrapper.write(Type.VAR_INT, this.protocol.getMappingData().getNewBlockStateId(n2));
            } else if (particleMappings.isItemParticle(n3)) {
                this.handleItemToClient((Item)packetWrapper.passthrough(type2));
            }
            n2 = this.protocol.getMappingData().getNewParticleId(n3);
            if (n2 != n3) {
                packetWrapper.set(type, 0, n2);
            }
        };
    }

    public PacketHandler itemArrayHandler(Type<Item[]> type) {
        return packetWrapper -> {
            Item[] itemArray;
            for (Item item : itemArray = (Item[])packetWrapper.get(type, 0)) {
                this.handleItemToClient(item);
            }
        };
    }

    public PacketHandler itemToClientHandler(Type<Item> type) {
        return packetWrapper -> this.handleItemToClient((Item)packetWrapper.get(type, 0));
    }

    public PacketHandler itemToServerHandler(Type<Item> type) {
        return packetWrapper -> this.handleItemToServer((Item)packetWrapper.get(type, 0));
    }

    static /* synthetic */ Protocol access$000(ItemRewriter itemRewriter) {
        return itemRewriter.protocol;
    }

    static /* synthetic */ Protocol access$100(ItemRewriter itemRewriter) {
        return itemRewriter.protocol;
    }
}

