/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.rewriter;

import com.google.common.base.X;
import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.data.Int2IntMapMappings;
import com.viaversion.viaversion.api.data.Mappings;
import com.viaversion.viaversion.api.data.ParticleMappings;
import com.viaversion.viaversion.api.data.entity.DimensionData;
import com.viaversion.viaversion.api.data.entity.TrackedEntity;
import com.viaversion.viaversion.api.minecraft.entities.EntityType;
import com.viaversion.viaversion.api.minecraft.item.Item;
import com.viaversion.viaversion.api.minecraft.metadata.MetaType;
import com.viaversion.viaversion.api.minecraft.metadata.Metadata;
import com.viaversion.viaversion.api.protocol.Protocol;
import com.viaversion.viaversion.api.protocol.packet.ClientboundPacketType;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandler;
import com.viaversion.viaversion.api.rewriter.RewriterBase;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.types.Particle;
import com.viaversion.viaversion.api.type.types.Particle$ParticleData;
import com.viaversion.viaversion.data.entity.DimensionDataImpl;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.CompoundTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.IntTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.ListTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.Tag;
import com.viaversion.viaversion.rewriter.EntityRewriter$1;
import com.viaversion.viaversion.rewriter.EntityRewriter$2;
import com.viaversion.viaversion.rewriter.EntityRewriter$3;
import com.viaversion.viaversion.rewriter.EntityRewriter$4;
import com.viaversion.viaversion.rewriter.meta.MetaFilter;
import com.viaversion.viaversion.rewriter.meta.MetaFilter$Builder;
import com.viaversion.viaversion.rewriter.meta.MetaHandlerEvent;
import com.viaversion.viaversion.rewriter.meta.MetaHandlerEventImpl;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class EntityRewriter<C extends ClientboundPacketType, T extends Protocol<C, ?, ?, ?>>
extends RewriterBase<T>
implements com.viaversion.viaversion.api.rewriter.EntityRewriter<T> {
    private static final Metadata[] EMPTY_ARRAY = new Metadata[0];
    protected final List<MetaFilter> metadataFilters = new ArrayList<MetaFilter>();
    protected final boolean trackMappedType;
    protected Mappings typeMappings;

    protected EntityRewriter(T t2) {
        this(t2, true);
    }

    protected EntityRewriter(T t2, boolean bl2) {
        super(t2);
        this.trackMappedType = bl2;
        t2.put(this);
    }

    public MetaFilter$Builder filter() {
        return new MetaFilter$Builder(this);
    }

    public void registerFilter(MetaFilter metaFilter) {
        X.checkArgument(!this.metadataFilters.contains(metaFilter));
        this.metadataFilters.add(metaFilter);
    }

    public void handleMetadata(int n2, List<Metadata> list, UserConnection userConnection) {
        TrackedEntity trackedEntity = this.tracker(userConnection).entity(n2);
        EntityType entityType = trackedEntity != null ? trackedEntity.entityType() : null;
        int n3 = 0;
        for (Metadata metadata : list.toArray(EMPTY_ARRAY)) {
            if (!this.callOldMetaHandler(n2, entityType, metadata, list, userConnection)) {
                list.remove(n3--);
                continue;
            }
            MetaHandlerEvent metaHandlerEvent = null;
            for (MetaFilter metaFilter : this.metadataFilters) {
                if (!metaFilter.isFiltered(entityType, metadata)) continue;
                if (metaHandlerEvent == null) {
                    metaHandlerEvent = new MetaHandlerEventImpl(userConnection, trackedEntity, n2, metadata, list);
                }
                try {
                    metaFilter.handler().handle(metaHandlerEvent, metadata);
                }
                catch (Exception exception) {
                    this.logException(exception, entityType, list, metadata);
                    list.remove(n3--);
                    break;
                }
                if (!metaHandlerEvent.cancelled()) continue;
                list.remove(n3--);
                break;
            }
            if (metaHandlerEvent != null && metaHandlerEvent.extraMeta() != null) {
                list.addAll(metaHandlerEvent.extraMeta());
            }
            ++n3;
        }
        if (trackedEntity != null) {
            trackedEntity.sentMetadata(true);
        }
    }

    @Deprecated
    private boolean callOldMetaHandler(int n2, @Nullable EntityType entityType, Metadata metadata, List<Metadata> list, UserConnection userConnection) {
        try {
            this.handleMetadata(n2, entityType, metadata, list, userConnection);
            return true;
        }
        catch (Exception exception) {
            this.logException(exception, entityType, list, metadata);
            return false;
        }
    }

    @Deprecated
    protected void handleMetadata(int n2, @Nullable EntityType entityType, Metadata metadata, List<Metadata> list, UserConnection userConnection) {
    }

    @Override
    public int newEntityId(int n2) {
        return this.typeMappings != null ? this.typeMappings.getNewIdOrDefault(n2, n2) : n2;
    }

    public void mapEntityType(EntityType entityType, EntityType entityType2) {
        X.PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_(entityType.getClass() != entityType2.getClass(), "EntityTypes should not be of the same class/enum");
        this.mapEntityType(entityType.getId(), entityType2.getId());
    }

    protected void mapEntityType(int n2, int n3) {
        if (this.typeMappings == null) {
            this.typeMappings = Int2IntMapMappings.of();
        }
        this.typeMappings.setNewId(n2, n3);
    }

    public <E extends Enum<E>> void mapTypes(EntityType[] entityTypeArray, Class<E> clazz) {
        if (this.typeMappings == null) {
            this.typeMappings = Int2IntMapMappings.of();
        }
        for (EntityType entityType : entityTypeArray) {
            try {
                E e2 = Enum.valueOf(clazz, entityType.name());
                this.typeMappings.setNewId(entityType.getId(), ((EntityType)e2).getId());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (this.typeMappings.contains(entityType.getId())) continue;
                Via.getPlatform().getLogger().warning("Could not find new entity type for " + entityType + "! Old type: " + entityType.getClass().getEnclosingClass().getSimpleName() + ", new type: " + clazz.getEnclosingClass().getSimpleName());
            }
        }
    }

    public void mapTypes() {
        X.PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_(this.typeMappings == null, "Type mappings have already been set - manual type mappings should be set *after* this");
        X.a(this.protocol.getMappingData().getEntityMappings(), (Object)"Protocol does not have entity mappings");
        this.typeMappings = this.protocol.getMappingData().getEntityMappings();
    }

    public void registerMetaTypeHandler(@Nullable MetaType metaType, @Nullable MetaType metaType2, @Nullable MetaType metaType3, @Nullable MetaType metaType4) {
        this.filter().handler((metaHandlerEvent, metadata) -> {
            MetaType metaType5 = metadata.metaType();
            if (metaType5 == metaType) {
                this.protocol.getItemRewriter().handleItemToClient((Item)metadata.value());
            } else if (metaType5 == metaType2) {
                int n2 = (Integer)metadata.value();
                metadata.setValue(this.protocol.getMappingData().getNewBlockStateId(n2));
            } else if (metaType5 == metaType3) {
                int n3 = (Integer)metadata.value();
                if (n3 != 0) {
                    metadata.setValue(this.protocol.getMappingData().getNewBlockStateId(n3));
                }
            } else if (metaType5 == metaType4) {
                this.rewriteParticle((Particle)metadata.value());
            }
        });
    }

    public void registerTracker(C c2) {
        this.protocol.registerClientbound(c2, new EntityRewriter$1(this));
    }

    public void registerTrackerWithData(C c2, EntityType entityType) {
        this.protocol.registerClientbound(c2, new EntityRewriter$2(this, entityType));
    }

    public void registerTrackerWithData1_19(C c2, EntityType entityType) {
        this.protocol.registerClientbound(c2, new EntityRewriter$3(this, entityType));
    }

    public void registerTracker(C c2, EntityType entityType, Type<Integer> type) {
        this.protocol.registerClientbound(c2, packetWrapper -> {
            int n2 = (Integer)packetWrapper.passthrough(type);
            this.tracker(packetWrapper.user()).addEntity(n2, entityType);
        });
    }

    public void registerTracker(C c2, EntityType entityType) {
        this.registerTracker(c2, entityType, Type.VAR_INT);
    }

    public void registerRemoveEntities(C c2) {
        this.protocol.registerClientbound(c2, packetWrapper -> {
            int[] nArray = packetWrapper.passthrough(Type.VAR_INT_ARRAY_PRIMITIVE);
            Object e2 = this.tracker(packetWrapper.user());
            for (int n2 : nArray) {
                e2.removeEntity(n2);
            }
        });
    }

    public void registerMetadataRewriter(C c2, @Nullable Type<List<Metadata>> type, Type<List<Metadata>> type2) {
        this.protocol.registerClientbound(c2, new EntityRewriter$4(this, type, type2));
    }

    public void registerMetadataRewriter(C c2, Type<List<Metadata>> type) {
        this.registerMetadataRewriter(c2, null, type);
    }

    public PacketHandler trackerHandler() {
        return this.trackerAndRewriterHandler(null);
    }

    public PacketHandler playerTrackerHandler() {
        return packetWrapper -> {
            Object e2 = this.tracker(packetWrapper.user());
            int n2 = packetWrapper.get(Type.INT, 0);
            e2.setClientEntityId(n2);
            e2.addEntity(n2, e2.playerType());
        };
    }

    public PacketHandler worldDataTrackerHandler(int n2) {
        return packetWrapper -> {
            Object e2 = this.tracker(packetWrapper.user());
            CompoundTag compoundTag = packetWrapper.get(Type.NBT, n2);
            Object t2 = compoundTag.get("height");
            if (t2 instanceof IntTag) {
                int n3 = ((IntTag)t2).asInt();
                e2.setCurrentWorldSectionHeight(n3 >> 4);
            } else {
                Via.getPlatform().getLogger().warning("Height missing in dimension data: " + compoundTag);
            }
            Object t3 = compoundTag.get("min_y");
            if (t3 instanceof IntTag) {
                e2.setCurrentMinY(((IntTag)t3).asInt());
            } else {
                Via.getPlatform().getLogger().warning("Min Y missing in dimension data: " + compoundTag);
            }
            String string = packetWrapper.get(Type.STRING, 0);
            if (e2.currentWorld() != null && !e2.currentWorld().equals(string)) {
                e2.clearEntities();
                e2.trackClientEntity();
            }
            e2.setCurrentWorld(string);
        };
    }

    public PacketHandler worldDataTrackerHandlerByKey() {
        return packetWrapper -> {
            String string;
            Object e2 = this.tracker(packetWrapper.user());
            DimensionData dimensionData = e2.dimensionData(string = packetWrapper.get(Type.STRING, 0));
            if (dimensionData == null) {
                Via.getPlatform().getLogger().severe("Dimension data missing for dimension: " + string + ", falling back to overworld");
                dimensionData = e2.dimensionData("minecraft:overworld");
                X.a(dimensionData, (Object)"Overworld data missing");
            }
            e2.setCurrentWorldSectionHeight(dimensionData.height() >> 4);
            e2.setCurrentMinY(dimensionData.minY());
            String string2 = packetWrapper.get(Type.STRING, 1);
            if (e2.currentWorld() != null && !e2.currentWorld().equals(string2)) {
                e2.clearEntities();
                e2.trackClientEntity();
            }
            e2.setCurrentWorld(string2);
        };
    }

    public PacketHandler biomeSizeTracker() {
        return packetWrapper -> {
            CompoundTag compoundTag = packetWrapper.get(Type.NBT, 0);
            CompoundTag compoundTag2 = (CompoundTag)compoundTag.get("minecraft:worldgen/biome");
            ListTag listTag = (ListTag)compoundTag2.get("value");
            this.tracker(packetWrapper.user()).setBiomesSent(listTag.size());
        };
    }

    public PacketHandler dimensionDataHandler() {
        return packetWrapper -> {
            CompoundTag compoundTag = packetWrapper.get(Type.NBT, 0);
            ListTag listTag = (ListTag)((CompoundTag)compoundTag.get("minecraft:dimension_type")).get("value");
            HashMap<String, DimensionData> hashMap = new HashMap<String, DimensionData>(listTag.size());
            for (Tag tag : listTag) {
                CompoundTag compoundTag2 = (CompoundTag)tag;
                CompoundTag compoundTag3 = (CompoundTag)compoundTag2.get("element");
                String string = (String)((Tag)compoundTag2.get("name")).getValue();
                hashMap.put(string, new DimensionDataImpl(compoundTag3));
            }
            this.tracker(packetWrapper.user()).setDimensions(hashMap);
        };
    }

    public PacketHandler trackerAndRewriterHandler(@Nullable Type<List<Metadata>> type) {
        return packetWrapper -> {
            int n2 = packetWrapper.get(Type.VAR_INT, 0);
            int n3 = packetWrapper.get(Type.VAR_INT, 1);
            int n4 = this.newEntityId(n3);
            if (n4 != n3) {
                packetWrapper.set(Type.VAR_INT, 1, n4);
            }
            EntityType entityType = this.typeFromId(this.trackMappedType ? n4 : n3);
            this.tracker(packetWrapper.user()).addEntity(n2, entityType);
            if (type != null) {
                this.handleMetadata(n2, (List)packetWrapper.get(type, 0), packetWrapper.user());
            }
        };
    }

    public PacketHandler trackerAndRewriterHandler(@Nullable Type<List<Metadata>> type, EntityType entityType) {
        return packetWrapper -> {
            int n2 = packetWrapper.get(Type.VAR_INT, 0);
            this.tracker(packetWrapper.user()).addEntity(n2, entityType);
            if (type != null) {
                this.handleMetadata(n2, (List)packetWrapper.get(type, 0), packetWrapper.user());
            }
        };
    }

    public PacketHandler objectTrackerHandler() {
        return packetWrapper -> {
            int n2 = packetWrapper.get(Type.VAR_INT, 0);
            byte by2 = packetWrapper.get(Type.BYTE, 0);
            EntityType entityType = this.objectTypeFromId(by2);
            this.tracker(packetWrapper.user()).addEntity(n2, entityType);
        };
    }

    @Deprecated
    protected @Nullable Metadata metaByIndex(int n2, List<Metadata> list) {
        for (Metadata metadata : list) {
            if (metadata.id() != n2) continue;
            return metadata;
        }
        return null;
    }

    protected void rewriteParticle(Particle particle) {
        int n2;
        ParticleMappings particleMappings = this.protocol.getMappingData().getParticleMappings();
        if (particleMappings.isBlockParticle(n2 = particle.getId())) {
            Particle$ParticleData particle$ParticleData = particle.getArguments().get(0);
            particle$ParticleData.setValue(this.protocol.getMappingData().getNewBlockStateId((Integer)particle$ParticleData.get()));
        } else if (particleMappings.isItemParticle(n2) && this.protocol.getItemRewriter() != null) {
            Particle$ParticleData particle$ParticleData = particle.getArguments().get(0);
            Item item = (Item)particle$ParticleData.get();
            this.protocol.getItemRewriter().handleItemToClient(item);
        }
        particle.setId(this.protocol.getMappingData().getNewParticleId(n2));
    }

    private void logException(Exception exception, @Nullable EntityType entityType, List<Metadata> list, Metadata metadata) {
        if (!Via.getConfig().isSuppressMetadataErrors() || Via.getManager().isDebug()) {
            Logger logger = Via.getPlatform().getLogger();
            logger.severe("An error occurred in metadata handler " + this.getClass().getSimpleName() + " for " + (entityType != null ? entityType.name() : "untracked") + " entity type: " + metadata);
            logger.severe(list.stream().sorted(Comparator.comparingInt(Metadata::id)).map(Metadata::toString).collect(Collectors.joining("\n", "Full metadata: ", "")));
            exception.printStackTrace();
        }
    }

    static /* synthetic */ Protocol access$000(EntityRewriter entityRewriter) {
        return entityRewriter.protocol;
    }

    static /* synthetic */ Protocol access$100(EntityRewriter entityRewriter) {
        return entityRewriter.protocol;
    }
}

