/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.rewriter;

import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.protocol.Protocol;
import com.viaversion.viaversion.api.protocol.packet.ClientboundPacketType;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.libs.gson.JsonElement;
import com.viaversion.viaversion.libs.gson.JsonObject;
import com.viaversion.viaversion.libs.gson.JsonParser;
import com.viaversion.viaversion.libs.gson.JsonPrimitive;
import com.viaversion.viaversion.libs.gson.JsonSyntaxException;
import com.viaversion.viaversion.rewriter.ComponentRewriter$1;

public class ComponentRewriter<C extends ClientboundPacketType> {
    protected final Protocol<C, ?, ?, ?> protocol;

    public ComponentRewriter(Protocol<C, ?, ?, ?> protocol) {
        this.protocol = protocol;
    }

    public ComponentRewriter() {
        this.protocol = null;
    }

    public void registerComponentPacket(C c2) {
        this.protocol.registerClientbound(c2, packetWrapper -> this.processText(packetWrapper.passthrough(Type.COMPONENT)));
    }

    public void registerBossBar(C c2) {
        this.protocol.registerClientbound(c2, new ComponentRewriter$1(this));
    }

    public void registerCombatEvent(C c2) {
        this.protocol.registerClientbound(c2, packetWrapper -> {
            if (packetWrapper.passthrough(Type.VAR_INT) == 2) {
                packetWrapper.passthrough(Type.VAR_INT);
                packetWrapper.passthrough(Type.INT);
                this.processText(packetWrapper.passthrough(Type.COMPONENT));
            }
        });
    }

    public void registerTitle(C c2) {
        this.protocol.registerClientbound(c2, packetWrapper -> {
            int n2 = packetWrapper.passthrough(Type.VAR_INT);
            if (n2 >= 0 && n2 <= 2) {
                this.processText(packetWrapper.passthrough(Type.COMPONENT));
            }
        });
    }

    public JsonElement processText(String string) {
        try {
            JsonElement jsonElement = JsonParser.parseString(string);
            this.processText(jsonElement);
            return jsonElement;
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            if (Via.getManager().isDebug()) {
                Via.getPlatform().getLogger().severe("Error when trying to parse json: " + string);
                throw jsonSyntaxException;
            }
            return new JsonPrimitive(string);
        }
    }

    public void processText(JsonElement jsonElement) {
        JsonObject jsonObject;
        JsonElement jsonElement2;
        JsonElement jsonElement3;
        if (jsonElement == null || jsonElement.isJsonNull()) {
            return;
        }
        if (jsonElement.isJsonArray()) {
            this.processAsArray(jsonElement);
            return;
        }
        if (jsonElement.isJsonPrimitive()) {
            this.handleText(jsonElement.getAsJsonPrimitive());
            return;
        }
        JsonObject jsonObject2 = jsonElement.getAsJsonObject();
        JsonPrimitive jsonPrimitive = jsonObject2.getAsJsonPrimitive("text");
        if (jsonPrimitive != null) {
            this.handleText(jsonPrimitive);
        }
        if ((jsonElement3 = jsonObject2.get("translate")) != null) {
            this.handleTranslate(jsonObject2, jsonElement3.getAsString());
            jsonElement2 = jsonObject2.get("with");
            if (jsonElement2 != null) {
                this.processAsArray(jsonElement2);
            }
        }
        if ((jsonElement2 = jsonObject2.get("extra")) != null) {
            this.processAsArray(jsonElement2);
        }
        if ((jsonObject = jsonObject2.getAsJsonObject("hoverEvent")) != null) {
            this.handleHoverEvent(jsonObject);
        }
    }

    protected void handleText(JsonPrimitive jsonPrimitive) {
    }

    protected void handleTranslate(JsonObject jsonObject, String string) {
    }

    protected void handleHoverEvent(JsonObject jsonObject) {
        JsonObject jsonObject2;
        String string = jsonObject.getAsJsonPrimitive("action").getAsString();
        if (string.equals("show_text")) {
            JsonElement jsonElement = jsonObject.get("value");
            this.processText(jsonElement != null ? jsonElement : jsonObject.get("contents"));
        } else if (string.equals("show_entity") && (jsonObject2 = jsonObject.getAsJsonObject("contents")) != null) {
            this.processText(jsonObject2.get("name"));
        }
    }

    private void processAsArray(JsonElement jsonElement) {
        for (JsonElement jsonElement2 : jsonElement.getAsJsonArray()) {
            this.processText(jsonElement2);
        }
    }
}

