/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.protocols.protocol1_9to1_8.types;

import com.viaversion.viaversion.api.minecraft.Environment;
import com.viaversion.viaversion.api.minecraft.chunks.BaseChunk;
import com.viaversion.viaversion.api.minecraft.chunks.Chunk;
import com.viaversion.viaversion.api.minecraft.chunks.ChunkSection;
import com.viaversion.viaversion.api.type.PartialType;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.types.minecraft.BaseChunkType;
import com.viaversion.viaversion.api.type.types.version.Types1_8;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.CompoundTag;
import com.viaversion.viaversion.protocols.protocol1_9_3to1_9_1_2.storage.ClientWorld;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;

public class Chunk1_8Type
extends PartialType<Chunk, ClientWorld> {
    public Chunk1_8Type(ClientWorld clientWorld) {
        super(clientWorld, Chunk.class);
    }

    @Override
    public Class<? extends Type> getBaseClass() {
        return BaseChunkType.class;
    }

    @Override
    public Chunk read(ByteBuf byteBuf, ClientWorld clientWorld) {
        int n2 = byteBuf.readInt();
        int n3 = byteBuf.readInt();
        boolean bl2 = byteBuf.readBoolean();
        int n4 = byteBuf.readUnsignedShort();
        int n5 = Type.VAR_INT.readPrimitive(byteBuf);
        byte[] byArray = new byte[n5];
        byteBuf.readBytes(byArray);
        if (bl2 && n4 == 0) {
            return new BaseChunk(n2, n3, true, false, 0, new ChunkSection[16], null, new ArrayList<CompoundTag>());
        }
        return Chunk1_8Type.deserialize(n2, n3, bl2, clientWorld.getEnvironment() == Environment.NORMAL, n4, byArray);
    }

    @Override
    public void write(ByteBuf byteBuf, ClientWorld clientWorld, Chunk chunk) {
        byteBuf.writeInt(chunk.getX());
        byteBuf.writeInt(chunk.getZ());
        byteBuf.writeBoolean(chunk.isFullChunk());
        byteBuf.writeShort(chunk.getBitmask());
        byte[] byArray = Chunk1_8Type.serialize(chunk);
        Type.VAR_INT.writePrimitive(byteBuf, byArray.length);
        byteBuf.writeBytes(byArray);
    }

    public static Chunk deserialize(int n2, int n3, boolean bl2, boolean bl3, int n4, byte[] byArray) {
        int n5;
        ByteBuf byteBuf = Unpooled.wrappedBuffer(byArray);
        ChunkSection[] chunkSectionArray = new ChunkSection[16];
        int[] nArray = null;
        for (n5 = 0; n5 < chunkSectionArray.length; ++n5) {
            if ((n4 & 1 << n5) == 0) continue;
            chunkSectionArray[n5] = (ChunkSection)Types1_8.CHUNK_SECTION.read(byteBuf);
        }
        for (n5 = 0; n5 < chunkSectionArray.length; ++n5) {
            if ((n4 & 1 << n5) == 0) continue;
            chunkSectionArray[n5].getLight().readBlockLight(byteBuf);
        }
        if (bl3) {
            for (n5 = 0; n5 < chunkSectionArray.length; ++n5) {
                if ((n4 & 1 << n5) == 0) continue;
                chunkSectionArray[n5].getLight().readSkyLight(byteBuf);
            }
        }
        if (bl2) {
            nArray = new int[256];
            for (n5 = 0; n5 < 256; ++n5) {
                nArray[n5] = byteBuf.readUnsignedByte();
            }
        }
        byteBuf.release();
        return new BaseChunk(n2, n3, bl2, false, n4, chunkSectionArray, nArray, new ArrayList<CompoundTag>());
    }

    public static byte[] serialize(Chunk chunk) {
        int n2;
        ByteBuf byteBuf = Unpooled.buffer();
        for (n2 = 0; n2 < chunk.getSections().length; ++n2) {
            if ((chunk.getBitmask() & 1 << n2) == 0) continue;
            Types1_8.CHUNK_SECTION.write(byteBuf, chunk.getSections()[n2]);
        }
        for (n2 = 0; n2 < chunk.getSections().length; ++n2) {
            if ((chunk.getBitmask() & 1 << n2) == 0) continue;
            chunk.getSections()[n2].getLight().writeBlockLight(byteBuf);
        }
        for (n2 = 0; n2 < chunk.getSections().length; ++n2) {
            if ((chunk.getBitmask() & 1 << n2) == 0 || !chunk.getSections()[n2].getLight().hasSkyLight()) continue;
            chunk.getSections()[n2].getLight().writeSkyLight(byteBuf);
        }
        if (chunk.isFullChunk() && chunk.getBiomeData() != null) {
            for (int n3 : chunk.getBiomeData()) {
                byteBuf.writeByte((byte)n3);
            }
        }
        byte[] byArray = new byte[byteBuf.readableBytes()];
        byteBuf.readBytes(byArray);
        byteBuf.release();
        return byArray;
    }
}

