/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.protocols.protocol1_9to1_8.providers;

import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.protocols.protocol1_9to1_8.providers.CompressionProvider$CompressionHandler;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.List;
import java.util.zip.Inflater;

class CompressionProvider$Decompressor
extends MessageToMessageDecoder<ByteBuf>
implements CompressionProvider$CompressionHandler {
    private final Inflater inflater;
    private int threshold;

    public CompressionProvider$Decompressor(int n2) {
        this.threshold = n2;
        this.inflater = new Inflater();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        if (!byteBuf.isReadable()) {
            return;
        }
        int n2 = Type.VAR_INT.readPrimitive(byteBuf);
        if (n2 == 0) {
            list.add(byteBuf.readBytes(byteBuf.readableBytes()));
            return;
        }
        if (n2 < this.threshold) {
            throw new DecoderException("Badly compressed packet - size of " + n2 + " is below server threshold of " + this.threshold);
        }
        if (n2 > 0x200000) {
            throw new DecoderException("Badly compressed packet - size of " + n2 + " is larger than protocol maximum of " + 0x200000);
        }
        ByteBuf byteBuf2 = byteBuf;
        if (!byteBuf.hasArray()) {
            byteBuf2 = channelHandlerContext.alloc().heapBuffer().writeBytes(byteBuf);
        } else {
            byteBuf.retain();
        }
        ByteBuf byteBuf3 = channelHandlerContext.alloc().heapBuffer(n2, n2);
        try {
            this.inflater.setInput(byteBuf2.array(), byteBuf2.arrayOffset() + byteBuf2.readerIndex(), byteBuf2.readableBytes());
            byteBuf3.writerIndex(byteBuf3.writerIndex() + this.inflater.inflate(byteBuf3.array(), byteBuf3.arrayOffset(), n2));
            list.add(byteBuf3.retain());
        }
        finally {
            byteBuf3.release();
            byteBuf2.release();
            this.inflater.reset();
        }
    }

    @Override
    public void setCompressionThreshold(int n2) {
        this.threshold = n2;
    }
}

