/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.protocols.protocol1_9_3to1_9_1_2.types;

import com.viaversion.viaversion.api.minecraft.Environment;
import com.viaversion.viaversion.api.minecraft.chunks.BaseChunk;
import com.viaversion.viaversion.api.minecraft.chunks.Chunk;
import com.viaversion.viaversion.api.minecraft.chunks.ChunkSection;
import com.viaversion.viaversion.api.type.PartialType;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.types.minecraft.BaseChunkType;
import com.viaversion.viaversion.api.type.types.version.Types1_9;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.CompoundTag;
import com.viaversion.viaversion.protocols.protocol1_9_3to1_9_1_2.storage.ClientWorld;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.BitSet;

public class Chunk1_9_1_2Type
extends PartialType<Chunk, ClientWorld> {
    public Chunk1_9_1_2Type(ClientWorld clientWorld) {
        super(clientWorld, Chunk.class);
    }

    @Override
    public Chunk read(ByteBuf byteBuf, ClientWorld clientWorld) {
        int[] nArray;
        int n2;
        int n3 = byteBuf.readInt();
        int n4 = byteBuf.readInt();
        boolean bl2 = byteBuf.readBoolean();
        int n5 = Type.VAR_INT.readPrimitive(byteBuf);
        Type.VAR_INT.readPrimitive(byteBuf);
        BitSet bitSet = new BitSet(16);
        ChunkSection[] chunkSectionArray = new ChunkSection[16];
        for (n2 = 0; n2 < 16; ++n2) {
            if ((n5 & 1 << n2) == 0) continue;
            bitSet.set(n2);
        }
        for (n2 = 0; n2 < 16; ++n2) {
            ChunkSection chunkSection;
            if (!bitSet.get(n2)) continue;
            chunkSectionArray[n2] = chunkSection = (ChunkSection)Types1_9.CHUNK_SECTION.read(byteBuf);
            chunkSection.getLight().readBlockLight(byteBuf);
            if (clientWorld.getEnvironment() != Environment.NORMAL) continue;
            chunkSection.getLight().readSkyLight(byteBuf);
        }
        int[] nArray2 = nArray = bl2 ? new int[256] : null;
        if (bl2) {
            for (int i2 = 0; i2 < 256; ++i2) {
                nArray[i2] = byteBuf.readByte() & 0xFF;
            }
        }
        return new BaseChunk(n3, n4, bl2, false, n5, chunkSectionArray, nArray, new ArrayList<CompoundTag>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ByteBuf byteBuf, ClientWorld clientWorld, Chunk chunk) {
        byteBuf.writeInt(chunk.getX());
        byteBuf.writeInt(chunk.getZ());
        byteBuf.writeBoolean(chunk.isFullChunk());
        Type.VAR_INT.writePrimitive(byteBuf, chunk.getBitmask());
        ByteBuf byteBuf2 = byteBuf.alloc().buffer();
        try {
            for (int i2 = 0; i2 < 16; ++i2) {
                ChunkSection chunkSection = chunk.getSections()[i2];
                if (chunkSection == null) continue;
                Types1_9.CHUNK_SECTION.write(byteBuf2, chunkSection);
                chunkSection.getLight().writeBlockLight(byteBuf2);
                if (!chunkSection.getLight().hasSkyLight()) continue;
                chunkSection.getLight().writeSkyLight(byteBuf2);
            }
            byteBuf2.readerIndex(0);
            Type.VAR_INT.writePrimitive(byteBuf, byteBuf2.readableBytes() + (chunk.isBiomeData() ? 256 : 0));
            byteBuf.writeBytes(byteBuf2);
        }
        finally {
            byteBuf2.release();
        }
        if (chunk.isBiomeData()) {
            for (int n2 : chunk.getBiomeData()) {
                byteBuf.writeByte((byte)n2);
            }
        }
    }

    @Override
    public Class<? extends Type> getBaseClass() {
        return BaseChunkType.class;
    }
}

