/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.protocols.protocol1_17to1_16_4.packets;

import com.viaversion.viaversion.api.minecraft.BlockChangeRecord;
import com.viaversion.viaversion.api.minecraft.BlockChangeRecord1_16_2;
import com.viaversion.viaversion.api.minecraft.chunks.Chunk;
import com.viaversion.viaversion.api.minecraft.chunks.ChunkSection;
import com.viaversion.viaversion.api.minecraft.chunks.DataPalette;
import com.viaversion.viaversion.api.minecraft.chunks.PaletteType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.protocols.protocol1_16_2to1_16_1.ClientboundPackets1_16_2;
import com.viaversion.viaversion.protocols.protocol1_16_2to1_16_1.types.Chunk1_16_2Type;
import com.viaversion.viaversion.protocols.protocol1_17to1_16_4.ClientboundPackets1_17;
import com.viaversion.viaversion.protocols.protocol1_17to1_16_4.Protocol1_17To1_16_4;
import com.viaversion.viaversion.protocols.protocol1_17to1_16_4.packets.WorldPackets$1;
import com.viaversion.viaversion.protocols.protocol1_17to1_16_4.types.Chunk1_17Type;
import com.viaversion.viaversion.rewriter.BlockRewriter;
import java.util.BitSet;

public final class WorldPackets {
    public static void register(Protocol1_17To1_16_4 protocol1_17To1_16_4) {
        BlockRewriter<ClientboundPackets1_16_2> blockRewriter = new BlockRewriter<ClientboundPackets1_16_2>(protocol1_17To1_16_4, Type.POSITION1_14);
        blockRewriter.registerBlockAction(ClientboundPackets1_16_2.BLOCK_ACTION);
        blockRewriter.registerBlockChange(ClientboundPackets1_16_2.BLOCK_CHANGE);
        blockRewriter.registerVarLongMultiBlockChange(ClientboundPackets1_16_2.MULTI_BLOCK_CHANGE);
        blockRewriter.registerAcknowledgePlayerDigging(ClientboundPackets1_16_2.ACKNOWLEDGE_PLAYER_DIGGING);
        protocol1_17To1_16_4.registerClientbound(ClientboundPackets1_16_2.WORLD_BORDER, null, packetWrapper -> {
            ClientboundPackets1_17 clientboundPackets1_17;
            int n2 = packetWrapper.read(Type.VAR_INT);
            switch (n2) {
                case 0: {
                    clientboundPackets1_17 = ClientboundPackets1_17.WORLD_BORDER_SIZE;
                    break;
                }
                case 1: {
                    clientboundPackets1_17 = ClientboundPackets1_17.WORLD_BORDER_LERP_SIZE;
                    break;
                }
                case 2: {
                    clientboundPackets1_17 = ClientboundPackets1_17.WORLD_BORDER_CENTER;
                    break;
                }
                case 3: {
                    clientboundPackets1_17 = ClientboundPackets1_17.WORLD_BORDER_INIT;
                    break;
                }
                case 4: {
                    clientboundPackets1_17 = ClientboundPackets1_17.WORLD_BORDER_WARNING_DELAY;
                    break;
                }
                case 5: {
                    clientboundPackets1_17 = ClientboundPackets1_17.WORLD_BORDER_WARNING_DISTANCE;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid world border type received: " + n2);
                }
            }
            packetWrapper.setPacketType(clientboundPackets1_17);
        });
        protocol1_17To1_16_4.registerClientbound(ClientboundPackets1_16_2.UPDATE_LIGHT, new WorldPackets$1());
        protocol1_17To1_16_4.registerClientbound(ClientboundPackets1_16_2.CHUNK_DATA, packetWrapper -> {
            Chunk chunk = packetWrapper.read(new Chunk1_16_2Type());
            if (!chunk.isFullChunk()) {
                WorldPackets.writeMultiBlockChangePacket(packetWrapper, chunk);
                packetWrapper.cancel();
                return;
            }
            packetWrapper.write(new Chunk1_17Type(chunk.getSections().length), chunk);
            chunk.setChunkMask(BitSet.valueOf(new long[]{chunk.getBitmask()}));
            for (int i2 = 0; i2 < chunk.getSections().length; ++i2) {
                ChunkSection chunkSection = chunk.getSections()[i2];
                if (chunkSection == null) continue;
                DataPalette dataPalette = chunkSection.palette(PaletteType.BLOCKS);
                for (int i3 = 0; i3 < dataPalette.size(); ++i3) {
                    int n2 = protocol1_17To1_16_4.getMappingData().getNewBlockStateId(dataPalette.idByIndex(i3));
                    dataPalette.setIdByIndex(i3, n2);
                }
            }
        });
        blockRewriter.registerEffect(ClientboundPackets1_16_2.EFFECT, 1010, 2001);
    }

    private static void writeMultiBlockChangePacket(PacketWrapper packetWrapper, Chunk chunk) {
        long l2 = ((long)chunk.getX() & 0x3FFFFFL) << 42;
        l2 |= ((long)chunk.getZ() & 0x3FFFFFL) << 20;
        ChunkSection[] chunkSectionArray = chunk.getSections();
        for (int i2 = 0; i2 < chunkSectionArray.length; ++i2) {
            ChunkSection chunkSection = chunkSectionArray[i2];
            if (chunkSection == null) continue;
            PacketWrapper packetWrapper2 = packetWrapper.create(ClientboundPackets1_17.MULTI_BLOCK_CHANGE);
            packetWrapper2.write(Type.LONG, l2 | (long)i2 & 0xFFFFFL);
            packetWrapper2.write(Type.BOOLEAN, true);
            BlockChangeRecord[] blockChangeRecordArray = new BlockChangeRecord[4096];
            DataPalette dataPalette = chunkSection.palette(PaletteType.BLOCKS);
            int n2 = 0;
            for (int i3 = 0; i3 < 16; ++i3) {
                for (int i4 = 0; i4 < 16; ++i4) {
                    for (int i5 = 0; i5 < 16; ++i5) {
                        int n3 = Protocol1_17To1_16_4.MAPPINGS.getNewBlockStateId(dataPalette.idAt(i3, i4, i5));
                        blockChangeRecordArray[n2++] = new BlockChangeRecord1_16_2(i3, i4, i5, n3);
                    }
                }
            }
            packetWrapper2.write(Type.VAR_LONG_BLOCK_CHANGE_RECORD_ARRAY, blockChangeRecordArray);
            packetWrapper2.send(Protocol1_17To1_16_4.class);
        }
    }
}

