/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.protocols.protocol1_16to1_15_2.types;

import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.minecraft.chunks.BaseChunk;
import com.viaversion.viaversion.api.minecraft.chunks.Chunk;
import com.viaversion.viaversion.api.minecraft.chunks.ChunkSection;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.types.minecraft.BaseChunkType;
import com.viaversion.viaversion.api.type.types.version.Types1_16;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.CompoundTag;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;

public class Chunk1_16Type
extends Type<Chunk> {
    private static final CompoundTag[] EMPTY_COMPOUNDS = new CompoundTag[0];

    public Chunk1_16Type() {
        super(Chunk.class);
    }

    @Override
    public Chunk read(ByteBuf byteBuf) {
        int[] nArray;
        int n2 = byteBuf.readInt();
        int n3 = byteBuf.readInt();
        boolean bl2 = byteBuf.readBoolean();
        boolean bl3 = byteBuf.readBoolean();
        int n4 = Type.VAR_INT.readPrimitive(byteBuf);
        CompoundTag compoundTag = (CompoundTag)Type.NBT.read(byteBuf);
        int[] nArray2 = nArray = bl2 ? new int[1024] : null;
        if (bl2) {
            for (int i2 = 0; i2 < 1024; ++i2) {
                nArray[i2] = byteBuf.readInt();
            }
        }
        Type.VAR_INT.readPrimitive(byteBuf);
        ChunkSection[] chunkSectionArray = new ChunkSection[16];
        for (int i3 = 0; i3 < 16; ++i3) {
            if ((n4 & 1 << i3) == 0) continue;
            short s2 = byteBuf.readShort();
            ChunkSection chunkSection = (ChunkSection)Types1_16.CHUNK_SECTION.read(byteBuf);
            chunkSection.setNonAirBlocksCount(s2);
            chunkSectionArray[i3] = chunkSection;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(Arrays.asList((Object[])Type.NBT_ARRAY.read(byteBuf)));
        if (byteBuf.readableBytes() > 0) {
            byte[] byArray = (byte[])Type.REMAINING_BYTES.read(byteBuf);
            if (Via.getManager().isDebug()) {
                Via.getPlatform().getLogger().warning("Found " + byArray.length + " more bytes than expected while reading the chunk: " + n2 + "/" + n3);
            }
        }
        return new BaseChunk(n2, n3, bl2, bl3, n4, chunkSectionArray, nArray, compoundTag, arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ByteBuf byteBuf, Chunk chunk) {
        byteBuf.writeInt(chunk.getX());
        byteBuf.writeInt(chunk.getZ());
        byteBuf.writeBoolean(chunk.isFullChunk());
        byteBuf.writeBoolean(chunk.isIgnoreOldLightData());
        Type.VAR_INT.writePrimitive(byteBuf, chunk.getBitmask());
        Type.NBT.write(byteBuf, chunk.getHeightMap());
        if (chunk.isBiomeData()) {
            for (int n2 : chunk.getBiomeData()) {
                byteBuf.writeInt(n2);
            }
        }
        Object object = byteBuf.alloc().buffer();
        try {
            for (int i2 = 0; i2 < 16; ++i2) {
                ChunkSection chunkSection = chunk.getSections()[i2];
                if (chunkSection == null) continue;
                ((ByteBuf)object).writeShort(chunkSection.getNonAirBlocksCount());
                Types1_16.CHUNK_SECTION.write((ByteBuf)object, chunkSection);
            }
            ((ByteBuf)object).readerIndex(0);
            Type.VAR_INT.writePrimitive(byteBuf, ((ByteBuf)object).readableBytes());
            byteBuf.writeBytes((ByteBuf)object);
        }
        finally {
            object.release();
        }
        Type.NBT_ARRAY.write(byteBuf, chunk.getBlockEntities().toArray(EMPTY_COMPOUNDS));
    }

    @Override
    public Class<? extends Type> getBaseClass() {
        return BaseChunkType.class;
    }
}

