/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.protocols.protocol1_16to1_15_2.packets;

import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.minecraft.WorldIdentifiers;
import com.viaversion.viaversion.api.minecraft.entities.Entity1_16Types;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandler;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.types.version.Types1_14;
import com.viaversion.viaversion.api.type.types.version.Types1_16;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.ByteTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.CompoundTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.FloatTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.IntTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.ListTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.LongTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.StringTag;
import com.viaversion.viaversion.protocols.protocol1_13to1_12_2.data.MappingData;
import com.viaversion.viaversion.protocols.protocol1_15to1_14_4.ClientboundPackets1_15;
import com.viaversion.viaversion.protocols.protocol1_16to1_15_2.ClientboundPackets1_16;
import com.viaversion.viaversion.protocols.protocol1_16to1_15_2.Protocol1_16To1_15_2;
import com.viaversion.viaversion.protocols.protocol1_16to1_15_2.ServerboundPackets1_16;
import com.viaversion.viaversion.protocols.protocol1_16to1_15_2.metadata.MetadataRewriter1_16To1_15_2;
import com.viaversion.viaversion.protocols.protocol1_16to1_15_2.packets.EntityPackets$1;
import com.viaversion.viaversion.protocols.protocol1_16to1_15_2.packets.EntityPackets$2;
import com.viaversion.viaversion.protocols.protocol1_16to1_15_2.storage.InventoryTracker1_16;
import java.util.UUID;

public class EntityPackets {
    private static final PacketHandler DIMENSION_HANDLER = packetWrapper -> {
        String string;
        String string2;
        WorldIdentifiers worldIdentifiers = Via.getConfig().get1_16WorldNamesMap();
        WorldIdentifiers worldIdentifiers2 = packetWrapper.user().get(WorldIdentifiers.class);
        if (worldIdentifiers2 != null) {
            worldIdentifiers = worldIdentifiers2;
        }
        int n2 = packetWrapper.read(Type.INT);
        switch (n2) {
            case -1: {
                string2 = "minecraft:the_nether";
                string = worldIdentifiers.nether();
                break;
            }
            case 0: {
                string2 = "minecraft:overworld";
                string = worldIdentifiers.overworld();
                break;
            }
            case 1: {
                string2 = "minecraft:the_end";
                string = worldIdentifiers.end();
                break;
            }
            default: {
                Via.getPlatform().getLogger().warning("Invalid dimension id: " + n2);
                string2 = "minecraft:overworld";
                string = worldIdentifiers.overworld();
            }
        }
        packetWrapper.write(Type.STRING, string2);
        packetWrapper.write(Type.STRING, string);
    };
    public static final CompoundTag DIMENSIONS_TAG = new CompoundTag();
    private static final String[] WORLD_NAMES = new String[]{"minecraft:overworld", "minecraft:the_nether", "minecraft:the_end"};

    private static CompoundTag createOverworldEntry() {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.put("name", new StringTag("minecraft:overworld"));
        compoundTag.put("has_ceiling", new ByteTag(0));
        EntityPackets.addSharedOverwaldEntries(compoundTag);
        return compoundTag;
    }

    private static CompoundTag createOverworldCavesEntry() {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.put("name", new StringTag("minecraft:overworld_caves"));
        compoundTag.put("has_ceiling", new ByteTag(1));
        EntityPackets.addSharedOverwaldEntries(compoundTag);
        return compoundTag;
    }

    private static void addSharedOverwaldEntries(CompoundTag compoundTag) {
        compoundTag.put("piglin_safe", new ByteTag(0));
        compoundTag.put("natural", new ByteTag(1));
        compoundTag.put("ambient_light", new FloatTag(0.0f));
        compoundTag.put("infiniburn", new StringTag("minecraft:infiniburn_overworld"));
        compoundTag.put("respawn_anchor_works", new ByteTag(0));
        compoundTag.put("has_skylight", new ByteTag(1));
        compoundTag.put("bed_works", new ByteTag(1));
        compoundTag.put("has_raids", new ByteTag(1));
        compoundTag.put("logical_height", new IntTag(256));
        compoundTag.put("shrunk", new ByteTag(0));
        compoundTag.put("ultrawarm", new ByteTag(0));
    }

    private static CompoundTag createNetherEntry() {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.put("piglin_safe", new ByteTag(1));
        compoundTag.put("natural", new ByteTag(0));
        compoundTag.put("ambient_light", new FloatTag(0.1f));
        compoundTag.put("infiniburn", new StringTag("minecraft:infiniburn_nether"));
        compoundTag.put("respawn_anchor_works", new ByteTag(1));
        compoundTag.put("has_skylight", new ByteTag(0));
        compoundTag.put("bed_works", new ByteTag(0));
        compoundTag.put("fixed_time", new LongTag(18000L));
        compoundTag.put("has_raids", new ByteTag(0));
        compoundTag.put("name", new StringTag("minecraft:the_nether"));
        compoundTag.put("logical_height", new IntTag(128));
        compoundTag.put("shrunk", new ByteTag(1));
        compoundTag.put("ultrawarm", new ByteTag(1));
        compoundTag.put("has_ceiling", new ByteTag(1));
        return compoundTag;
    }

    private static CompoundTag createEndEntry() {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.put("piglin_safe", new ByteTag(0));
        compoundTag.put("natural", new ByteTag(0));
        compoundTag.put("ambient_light", new FloatTag(0.0f));
        compoundTag.put("infiniburn", new StringTag("minecraft:infiniburn_end"));
        compoundTag.put("respawn_anchor_works", new ByteTag(0));
        compoundTag.put("has_skylight", new ByteTag(0));
        compoundTag.put("bed_works", new ByteTag(0));
        compoundTag.put("fixed_time", new LongTag(6000L));
        compoundTag.put("has_raids", new ByteTag(1));
        compoundTag.put("name", new StringTag("minecraft:the_end"));
        compoundTag.put("logical_height", new IntTag(256));
        compoundTag.put("shrunk", new ByteTag(0));
        compoundTag.put("ultrawarm", new ByteTag(0));
        compoundTag.put("has_ceiling", new ByteTag(0));
        return compoundTag;
    }

    public static void register(Protocol1_16To1_15_2 protocol1_16To1_15_2) {
        MetadataRewriter1_16To1_15_2 metadataRewriter1_16To1_15_2 = protocol1_16To1_15_2.get(MetadataRewriter1_16To1_15_2.class);
        protocol1_16To1_15_2.registerClientbound(ClientboundPackets1_15.SPAWN_GLOBAL_ENTITY, ClientboundPackets1_16.SPAWN_ENTITY, packetWrapper -> {
            int n2 = packetWrapper.passthrough(Type.VAR_INT);
            byte by2 = packetWrapper.read(Type.BYTE);
            if (by2 != 1) {
                packetWrapper.cancel();
                return;
            }
            packetWrapper.user().getEntityTracker(Protocol1_16To1_15_2.class).addEntity(n2, Entity1_16Types.LIGHTNING_BOLT);
            packetWrapper.write(Type.UUID, UUID.randomUUID());
            packetWrapper.write(Type.VAR_INT, Entity1_16Types.LIGHTNING_BOLT.getId());
            packetWrapper.passthrough(Type.DOUBLE);
            packetWrapper.passthrough(Type.DOUBLE);
            packetWrapper.passthrough(Type.DOUBLE);
            packetWrapper.write(Type.BYTE, (byte)0);
            packetWrapper.write(Type.BYTE, (byte)0);
            packetWrapper.write(Type.INT, 0);
            packetWrapper.write(Type.SHORT, (short)0);
            packetWrapper.write(Type.SHORT, (short)0);
            packetWrapper.write(Type.SHORT, (short)0);
        });
        metadataRewriter1_16To1_15_2.registerTrackerWithData(ClientboundPackets1_15.SPAWN_ENTITY, Entity1_16Types.FALLING_BLOCK);
        metadataRewriter1_16To1_15_2.registerTracker(ClientboundPackets1_15.SPAWN_MOB);
        metadataRewriter1_16To1_15_2.registerTracker(ClientboundPackets1_15.SPAWN_PLAYER, Entity1_16Types.PLAYER);
        metadataRewriter1_16To1_15_2.registerMetadataRewriter(ClientboundPackets1_15.ENTITY_METADATA, Types1_14.METADATA_LIST, Types1_16.METADATA_LIST);
        metadataRewriter1_16To1_15_2.registerRemoveEntities(ClientboundPackets1_15.DESTROY_ENTITIES);
        protocol1_16To1_15_2.registerClientbound(ClientboundPackets1_15.RESPAWN, new EntityPackets$1());
        protocol1_16To1_15_2.registerClientbound(ClientboundPackets1_15.JOIN_GAME, new EntityPackets$2());
        protocol1_16To1_15_2.registerClientbound(ClientboundPackets1_15.ENTITY_PROPERTIES, packetWrapper -> {
            int n2;
            packetWrapper.passthrough(Type.VAR_INT);
            int n3 = n2 = packetWrapper.passthrough(Type.INT).intValue();
            for (int i2 = 0; i2 < n2; ++i2) {
                int n4;
                int n5;
                String string = packetWrapper.read(Type.STRING);
                String string2 = (String)protocol1_16To1_15_2.getMappingData().getAttributeMappings().get(string);
                if (string2 == null && !MappingData.isValid1_13Channel(string2 = "minecraft:" + string)) {
                    if (!Via.getConfig().isSuppressConversionWarnings()) {
                        Via.getPlatform().getLogger().warning("Invalid attribute: " + string);
                    }
                    --n3;
                    packetWrapper.read(Type.DOUBLE);
                    n5 = packetWrapper.read(Type.VAR_INT);
                    for (n4 = 0; n4 < n5; ++n4) {
                        packetWrapper.read(Type.UUID);
                        packetWrapper.read(Type.DOUBLE);
                        packetWrapper.read(Type.BYTE);
                    }
                    continue;
                }
                packetWrapper.write(Type.STRING, string2);
                packetWrapper.passthrough(Type.DOUBLE);
                n5 = packetWrapper.passthrough(Type.VAR_INT);
                for (n4 = 0; n4 < n5; ++n4) {
                    packetWrapper.passthrough(Type.UUID);
                    packetWrapper.passthrough(Type.DOUBLE);
                    packetWrapper.passthrough(Type.BYTE);
                }
            }
            if (n2 != n3) {
                packetWrapper.set(Type.INT, 0, n3);
            }
        });
        protocol1_16To1_15_2.registerServerbound(ServerboundPackets1_16.ANIMATION, packetWrapper -> {
            InventoryTracker1_16 inventoryTracker1_16 = packetWrapper.user().get(InventoryTracker1_16.class);
            if (inventoryTracker1_16.isInventoryOpen()) {
                packetWrapper.cancel();
            }
        });
    }

    static /* synthetic */ PacketHandler access$000() {
        return DIMENSION_HANDLER;
    }

    static /* synthetic */ String[] access$100() {
        return WORLD_NAMES;
    }

    static {
        ListTag listTag = new ListTag(CompoundTag.class);
        listTag.add(EntityPackets.createOverworldEntry());
        listTag.add(EntityPackets.createOverworldCavesEntry());
        listTag.add(EntityPackets.createNetherEntry());
        listTag.add(EntityPackets.createEndEntry());
        DIMENSIONS_TAG.put("dimension", listTag);
    }
}

