/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.protocols.protocol1_16_2to1_16_1.types;

import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.minecraft.chunks.BaseChunk;
import com.viaversion.viaversion.api.minecraft.chunks.Chunk;
import com.viaversion.viaversion.api.minecraft.chunks.ChunkSection;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.types.minecraft.BaseChunkType;
import com.viaversion.viaversion.api.type.types.version.Types1_16;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.CompoundTag;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;

public class Chunk1_16_2Type
extends Type<Chunk> {
    private static final CompoundTag[] EMPTY_COMPOUNDS = new CompoundTag[0];

    public Chunk1_16_2Type() {
        super(Chunk.class);
    }

    @Override
    public Chunk read(ByteBuf byteBuf) {
        int n2 = byteBuf.readInt();
        int n3 = byteBuf.readInt();
        boolean bl2 = byteBuf.readBoolean();
        int n4 = Type.VAR_INT.readPrimitive(byteBuf);
        CompoundTag compoundTag = (CompoundTag)Type.NBT.read(byteBuf);
        int[] nArray = null;
        if (bl2) {
            nArray = (int[])Type.VAR_INT_ARRAY_PRIMITIVE.read(byteBuf);
        }
        Type.VAR_INT.readPrimitive(byteBuf);
        ChunkSection[] chunkSectionArray = new ChunkSection[16];
        for (int i2 = 0; i2 < 16; ++i2) {
            if ((n4 & 1 << i2) == 0) continue;
            short s2 = byteBuf.readShort();
            ChunkSection chunkSection = (ChunkSection)Types1_16.CHUNK_SECTION.read(byteBuf);
            chunkSection.setNonAirBlocksCount(s2);
            chunkSectionArray[i2] = chunkSection;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(Arrays.asList((Object[])Type.NBT_ARRAY.read(byteBuf)));
        if (byteBuf.readableBytes() > 0) {
            byte[] byArray = (byte[])Type.REMAINING_BYTES.read(byteBuf);
            if (Via.getManager().isDebug()) {
                Via.getPlatform().getLogger().warning("Found " + byArray.length + " more bytes than expected while reading the chunk: " + n2 + "/" + n3);
            }
        }
        return new BaseChunk(n2, n3, bl2, false, n4, chunkSectionArray, nArray, compoundTag, arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ByteBuf byteBuf, Chunk chunk) {
        byteBuf.writeInt(chunk.getX());
        byteBuf.writeInt(chunk.getZ());
        byteBuf.writeBoolean(chunk.isFullChunk());
        Type.VAR_INT.writePrimitive(byteBuf, chunk.getBitmask());
        Type.NBT.write(byteBuf, chunk.getHeightMap());
        if (chunk.isBiomeData()) {
            Type.VAR_INT_ARRAY_PRIMITIVE.write(byteBuf, chunk.getBiomeData());
        }
        ByteBuf byteBuf2 = byteBuf.alloc().buffer();
        try {
            for (int i2 = 0; i2 < 16; ++i2) {
                ChunkSection chunkSection = chunk.getSections()[i2];
                if (chunkSection == null) continue;
                byteBuf2.writeShort(chunkSection.getNonAirBlocksCount());
                Types1_16.CHUNK_SECTION.write(byteBuf2, chunkSection);
            }
            byteBuf2.readerIndex(0);
            Type.VAR_INT.writePrimitive(byteBuf, byteBuf2.readableBytes());
            byteBuf.writeBytes(byteBuf2);
        }
        finally {
            byteBuf2.release();
        }
        Type.NBT_ARRAY.write(byteBuf, chunk.getBlockEntities().toArray(EMPTY_COMPOUNDS));
    }

    @Override
    public Class<? extends Type> getBaseClass() {
        return BaseChunkType.class;
    }
}

