/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.protocols.protocol1_14to1_13_2.packets;

import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.BlockFace;
import com.viaversion.viaversion.api.minecraft.chunks.Chunk;
import com.viaversion.viaversion.api.minecraft.chunks.ChunkSection;
import com.viaversion.viaversion.api.minecraft.chunks.DataPalette;
import com.viaversion.viaversion.api.minecraft.chunks.NibbleArray;
import com.viaversion.viaversion.api.minecraft.chunks.PaletteType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.CompoundTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.LongArrayTag;
import com.viaversion.viaversion.protocols.protocol1_13to1_12_2.ClientboundPackets1_13;
import com.viaversion.viaversion.protocols.protocol1_13to1_12_2.types.Chunk1_13Type;
import com.viaversion.viaversion.protocols.protocol1_14to1_13_2.ClientboundPackets1_14;
import com.viaversion.viaversion.protocols.protocol1_14to1_13_2.Protocol1_14To1_13_2;
import com.viaversion.viaversion.protocols.protocol1_14to1_13_2.packets.WorldPackets$1;
import com.viaversion.viaversion.protocols.protocol1_14to1_13_2.packets.WorldPackets$10;
import com.viaversion.viaversion.protocols.protocol1_14to1_13_2.packets.WorldPackets$2;
import com.viaversion.viaversion.protocols.protocol1_14to1_13_2.packets.WorldPackets$3;
import com.viaversion.viaversion.protocols.protocol1_14to1_13_2.packets.WorldPackets$4;
import com.viaversion.viaversion.protocols.protocol1_14to1_13_2.packets.WorldPackets$5;
import com.viaversion.viaversion.protocols.protocol1_14to1_13_2.packets.WorldPackets$6;
import com.viaversion.viaversion.protocols.protocol1_14to1_13_2.packets.WorldPackets$7;
import com.viaversion.viaversion.protocols.protocol1_14to1_13_2.packets.WorldPackets$8;
import com.viaversion.viaversion.protocols.protocol1_14to1_13_2.packets.WorldPackets$9;
import com.viaversion.viaversion.protocols.protocol1_14to1_13_2.storage.EntityTracker1_14;
import com.viaversion.viaversion.protocols.protocol1_14to1_13_2.types.Chunk1_14Type;
import com.viaversion.viaversion.protocols.protocol1_9_3to1_9_1_2.storage.ClientWorld;
import com.viaversion.viaversion.rewriter.BlockRewriter;
import com.viaversion.viaversion.util.CompactArrayUtil;
import java.util.Arrays;

public class WorldPackets {
    private static final byte[] FULL_LIGHT = new byte[2048];
    public static int air;
    public static int voidAir;
    public static int caveAir;

    public static void register(Protocol1_14To1_13_2 protocol1_14To1_13_2) {
        BlockRewriter<ClientboundPackets1_13> blockRewriter = new BlockRewriter<ClientboundPackets1_13>(protocol1_14To1_13_2, null);
        protocol1_14To1_13_2.registerClientbound(ClientboundPackets1_13.BLOCK_BREAK_ANIMATION, new WorldPackets$1());
        protocol1_14To1_13_2.registerClientbound(ClientboundPackets1_13.BLOCK_ENTITY_DATA, new WorldPackets$2());
        protocol1_14To1_13_2.registerClientbound(ClientboundPackets1_13.BLOCK_ACTION, new WorldPackets$3(protocol1_14To1_13_2));
        protocol1_14To1_13_2.registerClientbound(ClientboundPackets1_13.BLOCK_CHANGE, new WorldPackets$4(protocol1_14To1_13_2));
        protocol1_14To1_13_2.registerClientbound(ClientboundPackets1_13.SERVER_DIFFICULTY, new WorldPackets$5());
        blockRewriter.registerMultiBlockChange(ClientboundPackets1_13.MULTI_BLOCK_CHANGE);
        protocol1_14To1_13_2.registerClientbound(ClientboundPackets1_13.EXPLOSION, new WorldPackets$6());
        protocol1_14To1_13_2.registerClientbound(ClientboundPackets1_13.CHUNK_DATA, packetWrapper -> {
            int n2;
            int n3;
            int n4;
            Object object;
            ClientWorld clientWorld = packetWrapper.user().get(ClientWorld.class);
            Chunk chunk = packetWrapper.read(new Chunk1_13Type(clientWorld));
            packetWrapper.write(new Chunk1_14Type(), chunk);
            int[] nArray = new int[256];
            int[] nArray2 = new int[256];
            for (int i2 = 0; i2 < chunk.getSections().length; ++i2) {
                int n5;
                object = chunk.getSections()[i2];
                if (object == null) continue;
                DataPalette dataPalette = object.palette(PaletteType.BLOCKS);
                n4 = 0;
                for (n3 = 0; n3 < dataPalette.size(); ++n3) {
                    n5 = dataPalette.idByIndex(n3);
                    n2 = protocol1_14To1_13_2.getMappingData().getNewBlockStateId(n5);
                    if (n4 == 0 && n2 != air && n2 != voidAir && n2 != caveAir) {
                        n4 = 1;
                    }
                    dataPalette.setIdByIndex(n3, n2);
                }
                if (n4 == 0) {
                    object.setNonAirBlocksCount(0);
                    continue;
                }
                n3 = 0;
                n5 = i2 << 4;
                for (n2 = 0; n2 < 4096; ++n2) {
                    int n6 = dataPalette.idAt(n2);
                    if (n6 == air || n6 == voidAir || n6 == caveAir) continue;
                    ++n3;
                    int n7 = n2 & 0xFF;
                    int n8 = ChunkSection.yFromIndex(n2);
                    nArray2[n7] = n5 + n8 + 1;
                    if (protocol1_14To1_13_2.getMappingData().getMotionBlocking().contains(n6)) {
                        nArray[n7] = n5 + n8 + 1;
                    }
                    if (!Via.getConfig().isNonFullBlockLightFix() || !protocol1_14To1_13_2.getMappingData().getNonFullBlocks().contains(n6)) continue;
                    int n9 = ChunkSection.xFromIndex(n2);
                    int n10 = ChunkSection.zFromIndex(n2);
                    WorldPackets.setNonFullLight(chunk, (ChunkSection)object, i2, n9, n8, n10);
                }
                object.setNonAirBlocksCount(n3);
            }
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.put("MOTION_BLOCKING", new LongArrayTag(WorldPackets.encodeHeightMap(nArray)));
            compoundTag.put("WORLD_SURFACE", new LongArrayTag(WorldPackets.encodeHeightMap(nArray2)));
            chunk.setHeightMap(compoundTag);
            object = packetWrapper.create(ClientboundPackets1_14.UPDATE_LIGHT);
            object.write(Type.VAR_INT, chunk.getX());
            object.write(Type.VAR_INT, chunk.getZ());
            int n11 = chunk.isFullChunk() ? 262143 : 0;
            n4 = 0;
            for (n3 = 0; n3 < chunk.getSections().length; ++n3) {
                ChunkSection chunkSection = chunk.getSections()[n3];
                if (chunkSection == null) continue;
                if (!chunk.isFullChunk() && chunkSection.getLight().hasSkyLight()) {
                    n11 |= 1 << n3 + 1;
                }
                n4 |= 1 << n3 + 1;
            }
            object.write(Type.VAR_INT, n11);
            object.write(Type.VAR_INT, n4);
            object.write(Type.VAR_INT, 0);
            object.write(Type.VAR_INT, 0);
            if (chunk.isFullChunk()) {
                object.write(Type.BYTE_ARRAY_PRIMITIVE, FULL_LIGHT);
            }
            for (ChunkSection chunkSection : chunk.getSections()) {
                if (chunkSection == null || !chunkSection.getLight().hasSkyLight()) {
                    if (!chunk.isFullChunk()) continue;
                    object.write(Type.BYTE_ARRAY_PRIMITIVE, FULL_LIGHT);
                    continue;
                }
                object.write(Type.BYTE_ARRAY_PRIMITIVE, chunkSection.getLight().getSkyLight());
            }
            if (chunk.isFullChunk()) {
                object.write(Type.BYTE_ARRAY_PRIMITIVE, FULL_LIGHT);
            }
            for (ChunkSection chunkSection : chunk.getSections()) {
                if (chunkSection == null) continue;
                object.write(Type.BYTE_ARRAY_PRIMITIVE, chunkSection.getLight().getBlockLight());
            }
            EntityTracker1_14 entityTracker1_14 = (EntityTracker1_14)packetWrapper.user().getEntityTracker(Protocol1_14To1_13_2.class);
            int n12 = Math.abs(entityTracker1_14.getChunkCenterX() - chunk.getX());
            n2 = Math.abs(entityTracker1_14.getChunkCenterZ() - chunk.getZ());
            if (entityTracker1_14.isForceSendCenterChunk() || n12 >= 64 || n2 >= 64) {
                PacketWrapper packetWrapper2 = packetWrapper.create(ClientboundPackets1_14.UPDATE_VIEW_POSITION);
                packetWrapper2.write(Type.VAR_INT, chunk.getX());
                packetWrapper2.write(Type.VAR_INT, chunk.getZ());
                packetWrapper2.send(Protocol1_14To1_13_2.class);
                entityTracker1_14.setChunkCenterX(chunk.getX());
                entityTracker1_14.setChunkCenterZ(chunk.getZ());
            }
            object.send(Protocol1_14To1_13_2.class);
            for (ChunkSection chunkSection : chunk.getSections()) {
                if (chunkSection == null) continue;
                chunkSection.setLight(null);
            }
        });
        protocol1_14To1_13_2.registerClientbound(ClientboundPackets1_13.EFFECT, new WorldPackets$7(protocol1_14To1_13_2));
        protocol1_14To1_13_2.registerClientbound(ClientboundPackets1_13.MAP_DATA, new WorldPackets$8());
        protocol1_14To1_13_2.registerClientbound(ClientboundPackets1_13.RESPAWN, new WorldPackets$9(protocol1_14To1_13_2));
        protocol1_14To1_13_2.registerClientbound(ClientboundPackets1_13.SPAWN_POSITION, new WorldPackets$10());
    }

    static void sendViewDistancePacket(UserConnection userConnection) {
        PacketWrapper packetWrapper = PacketWrapper.create(ClientboundPackets1_14.UPDATE_VIEW_DISTANCE, null, userConnection);
        packetWrapper.write(Type.VAR_INT, 64);
        packetWrapper.send(Protocol1_14To1_13_2.class);
    }

    private static long[] encodeHeightMap(int[] nArray) {
        return CompactArrayUtil.createCompactArray(9, nArray.length, n2 -> nArray[n2]);
    }

    private static void setNonFullLight(Chunk chunk, ChunkSection chunkSection, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        int n7 = 0;
        for (BlockFace blockFace : BlockFace.values()) {
            NibbleArray nibbleArray = chunkSection.getLight().getSkyLightNibbleArray();
            NibbleArray nibbleArray2 = chunkSection.getLight().getBlockLightNibbleArray();
            int n8 = n3 + blockFace.modX();
            int n9 = n4 + blockFace.modY();
            int n10 = n5 + blockFace.modZ();
            if (blockFace.modX() != 0) {
                if (n8 == 16 || n8 == -1) {
                    continue;
                }
            } else if (blockFace.modY() != 0) {
                if (n9 == 16 || n9 == -1) {
                    ChunkSection n11;
                    if (n9 == 16) {
                        ++n2;
                        n9 = 0;
                    } else {
                        --n2;
                        n9 = 15;
                    }
                    if (n2 == chunk.getSections().length || n2 == -1 || (n11 = chunk.getSections()[n2]) == null) continue;
                    nibbleArray = n11.getLight().getSkyLightNibbleArray();
                    nibbleArray2 = n11.getLight().getBlockLightNibbleArray();
                }
            } else if (blockFace.modZ() != 0 && (n10 == 16 || n10 == -1)) continue;
            if (nibbleArray2 != null && n7 != 15) {
                int n12 = nibbleArray2.get(n8, n9, n10);
                if (n12 == 15) {
                    n7 = 14;
                } else if (n12 > n7) {
                    n7 = n12 - 1;
                }
            }
            if (nibbleArray == null || n6 == 15) continue;
            int n11 = nibbleArray.get(n8, n9, n10);
            if (n11 == 15) {
                if (blockFace.modY() == 1) {
                    n6 = 15;
                    continue;
                }
                n6 = 14;
                continue;
            }
            if (n11 <= n6) continue;
            n6 = n11 - 1;
        }
        if (n6 != 0) {
            if (!chunkSection.getLight().hasSkyLight()) {
                byte[] byArray = new byte[2028];
                chunkSection.getLight().setSkyLight(byArray);
            }
            chunkSection.getLight().getSkyLightNibbleArray().set(n3, n4, n5, n6);
        }
        if (n7 != 0) {
            chunkSection.getLight().getBlockLightNibbleArray().set(n3, n4, n5, n7);
        }
    }

    static {
        Arrays.fill(FULL_LIGHT, (byte)-1);
    }
}

