/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.protocols.protocol1_13to1_12_2.storage;

import com.google.common.collect.aF;
import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.connection.StorableObject;
import com.viaversion.viaversion.api.minecraft.Position;
import com.viaversion.viaversion.protocols.protocol1_13to1_12_2.storage.BlockConnectionStorage$SectionData;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import org.checkerframework.checker.nullness.qual.Nullable;

public class BlockConnectionStorage
implements StorableObject {
    private static Constructor<?> fastUtilLongObjectHashMap;
    private final Map<Long, BlockConnectionStorage$SectionData> blockStorage = this.createLongObjectMap();
    private final Queue<Position> modified = aF.PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_(5);
    private Long lastIndex;
    private BlockConnectionStorage$SectionData lastSection;

    public static void init() {
    }

    public void store(int n2, int n3, int n4, int n5) {
        long l2 = BlockConnectionStorage.getChunkSectionIndex(n2, n3, n4);
        BlockConnectionStorage$SectionData blockConnectionStorage$SectionData = this.getSection(l2);
        if (blockConnectionStorage$SectionData == null) {
            if (n5 == 0) {
                return;
            }
            blockConnectionStorage$SectionData = new BlockConnectionStorage$SectionData(null);
            this.blockStorage.put(l2, blockConnectionStorage$SectionData);
            this.lastSection = blockConnectionStorage$SectionData;
            this.lastIndex = l2;
        }
        blockConnectionStorage$SectionData.setBlockAt(n2, n3, n4, n5);
    }

    public int get(int n2, int n3, int n4) {
        long l2 = BlockConnectionStorage.getChunkSectionIndex(n2, n3, n4);
        BlockConnectionStorage$SectionData blockConnectionStorage$SectionData = this.getSection(l2);
        if (blockConnectionStorage$SectionData == null) {
            return 0;
        }
        return blockConnectionStorage$SectionData.blockAt(n2, n3, n4);
    }

    public void remove(int n2, int n3, int n4) {
        long l2 = BlockConnectionStorage.getChunkSectionIndex(n2, n3, n4);
        BlockConnectionStorage$SectionData blockConnectionStorage$SectionData = this.getSection(l2);
        if (blockConnectionStorage$SectionData == null) {
            return;
        }
        blockConnectionStorage$SectionData.setBlockAt(n2, n3, n4, 0);
        if (blockConnectionStorage$SectionData.nonEmptyBlocks() == 0) {
            this.removeSection(l2);
        }
    }

    public void markModified(Position position) {
        if (!this.modified.contains(position)) {
            this.modified.add(position);
        }
    }

    public boolean recentlyModified(Position position) {
        for (Position position2 : this.modified) {
            if (Math.abs(position.x() - position2.x()) + Math.abs(position.y() - position2.y()) + Math.abs(position.z() - position2.z()) > 2) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this.blockStorage.clear();
        this.lastSection = null;
        this.lastIndex = null;
        this.modified.clear();
    }

    public void unloadChunk(int n2, int n3) {
        for (int i2 = 0; i2 < 16; ++i2) {
            this.unloadSection(n2, i2, n3);
        }
    }

    public void unloadSection(int n2, int n3, int n4) {
        this.removeSection(BlockConnectionStorage.getChunkSectionIndex(n2 << 4, n3 << 4, n4 << 4));
    }

    private @Nullable BlockConnectionStorage$SectionData getSection(long l2) {
        if (this.lastIndex != null && this.lastIndex == l2) {
            return this.lastSection;
        }
        this.lastIndex = l2;
        this.lastSection = this.blockStorage.get(l2);
        return this.lastSection;
    }

    private void removeSection(long l2) {
        this.blockStorage.remove(l2);
        if (this.lastIndex != null && this.lastIndex == l2) {
            this.lastIndex = null;
            this.lastSection = null;
        }
    }

    private static long getChunkSectionIndex(int n2, int n3, int n4) {
        return ((long)(n2 >> 4) & 0x3FFFFFFL) << 38 | ((long)(n3 >> 4) & 0xFFFL) << 26 | (long)(n4 >> 4) & 0x3FFFFFFL;
    }

    private <T> Map<Long, T> createLongObjectMap() {
        if (fastUtilLongObjectHashMap != null) {
            try {
                return (Map)fastUtilLongObjectHashMap.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
            }
        }
        return new HashMap();
    }

    static {
        try {
            String string = "it" + ".unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap";
            fastUtilLongObjectHashMap = Class.forName(string).getConstructor(new Class[0]);
            Via.getPlatform().getLogger().info("Using FastUtil Long2ObjectOpenHashMap for block connections");
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
    }
}

