/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.protocols.protocol1_13to1_12_2.blockconnections;

import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.BlockFace;
import com.viaversion.viaversion.api.minecraft.Position;
import com.viaversion.viaversion.protocols.protocol1_13to1_12_2.blockconnections.AbstractFenceConnectionHandler;
import com.viaversion.viaversion.protocols.protocol1_13to1_12_2.blockconnections.ConnectionData$ConnectorInitAction;
import com.viaversion.viaversion.protocols.protocol1_13to1_12_2.blockconnections.WrappedBlockData;
import java.util.ArrayList;
import java.util.List;

public class WallConnectionHandler
extends AbstractFenceConnectionHandler {
    private static final BlockFace[] BLOCK_FACES = new BlockFace[]{BlockFace.EAST, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.WEST};
    private static final int[] OPPOSITES = new int[]{3, 2, 1, 0};

    static List<ConnectionData$ConnectorInitAction> init() {
        ArrayList<ConnectionData$ConnectorInitAction> arrayList = new ArrayList<ConnectionData$ConnectorInitAction>(2);
        arrayList.add(new WallConnectionHandler("cobbleWall").getInitAction("minecraft:cobblestone_wall"));
        arrayList.add(new WallConnectionHandler("cobbleWall").getInitAction("minecraft:mossy_cobblestone_wall"));
        return arrayList;
    }

    public WallConnectionHandler(String string) {
        super(string);
    }

    @Override
    protected byte getStates(WrappedBlockData wrappedBlockData) {
        byte by2 = super.getStates(wrappedBlockData);
        if (wrappedBlockData.getValue("up").equals("true")) {
            by2 = (byte)(by2 | 0x10);
        }
        return by2;
    }

    @Override
    protected byte getStates(UserConnection userConnection, Position position, int n2) {
        byte by2 = super.getStates(userConnection, position, n2);
        if (this.up(userConnection, position)) {
            by2 = (byte)(by2 | 0x10);
        }
        return by2;
    }

    @Override
    protected byte statesSize() {
        return 32;
    }

    public boolean up(UserConnection userConnection, Position position) {
        if (this.isWall(this.getBlockData(userConnection, position.getRelative(BlockFace.BOTTOM))) || this.isWall(this.getBlockData(userConnection, position.getRelative(BlockFace.TOP)))) {
            return true;
        }
        int n2 = this.getBlockFaces(userConnection, position);
        if (n2 == 0 || n2 == 15) {
            return true;
        }
        for (int i2 = 0; i2 < BLOCK_FACES.length; ++i2) {
            if ((n2 & 1 << i2) == 0 || (n2 & 1 << OPPOSITES[i2]) != 0) continue;
            return true;
        }
        return false;
    }

    private int getBlockFaces(UserConnection userConnection, Position position) {
        int n2 = 0;
        for (int i2 = 0; i2 < BLOCK_FACES.length; ++i2) {
            if (!this.isWall(this.getBlockData(userConnection, position.getRelative(BLOCK_FACES[i2])))) continue;
            n2 |= 1 << i2;
        }
        return n2;
    }

    private boolean isWall(int n2) {
        return this.getBlockStates().contains(n2);
    }
}

