/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.protocols.protocol1_13to1_12_2.blockconnections;

import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.BlockFace;
import com.viaversion.viaversion.api.minecraft.Position;
import com.viaversion.viaversion.libs.fastutil.ints.Int2ObjectArrayMap;
import com.viaversion.viaversion.libs.fastutil.ints.Int2ObjectMap;
import com.viaversion.viaversion.libs.fastutil.ints.Int2ObjectOpenHashMap;
import com.viaversion.viaversion.protocols.protocol1_13to1_12_2.blockconnections.ConnectionData;
import com.viaversion.viaversion.protocols.protocol1_13to1_12_2.blockconnections.ConnectionData$ConnectorInitAction;
import com.viaversion.viaversion.protocols.protocol1_13to1_12_2.blockconnections.ConnectionHandler;
import com.viaversion.viaversion.protocols.protocol1_13to1_12_2.blockconnections.TripwireConnectionHandler$TripwireData;
import com.viaversion.viaversion.protocols.protocol1_13to1_12_2.blockconnections.WrappedBlockData;
import java.util.Arrays;
import java.util.Locale;

public class TripwireConnectionHandler
extends ConnectionHandler {
    private static final Int2ObjectMap<TripwireConnectionHandler$TripwireData> TRIPWIRE_DATA_MAP = new Int2ObjectOpenHashMap<TripwireConnectionHandler$TripwireData>();
    private static final Int2ObjectMap<BlockFace> TRIPWIRE_HOOKS = new Int2ObjectArrayMap<BlockFace>();
    private static final int[] CONNECTED_BLOCKS = new int[128];

    static ConnectionData$ConnectorInitAction init() {
        Arrays.fill(CONNECTED_BLOCKS, -1);
        TripwireConnectionHandler tripwireConnectionHandler = new TripwireConnectionHandler();
        return wrappedBlockData -> {
            if (wrappedBlockData.getMinecraftKey().equals("minecraft:tripwire_hook")) {
                TRIPWIRE_HOOKS.put(wrappedBlockData.getSavedBlockStateId(), BlockFace.valueOf(wrappedBlockData.getValue("facing").toUpperCase(Locale.ROOT)));
            } else if (wrappedBlockData.getMinecraftKey().equals("minecraft:tripwire")) {
                TripwireConnectionHandler$TripwireData tripwireConnectionHandler$TripwireData = new TripwireConnectionHandler$TripwireData(wrappedBlockData.getValue("attached").equals("true"), wrappedBlockData.getValue("disarmed").equals("true"), wrappedBlockData.getValue("powered").equals("true"), null);
                TRIPWIRE_DATA_MAP.put(wrappedBlockData.getSavedBlockStateId(), tripwireConnectionHandler$TripwireData);
                TripwireConnectionHandler.CONNECTED_BLOCKS[TripwireConnectionHandler.getStates((WrappedBlockData)wrappedBlockData)] = wrappedBlockData.getSavedBlockStateId();
                ConnectionData.connectionHandlerMap.put(wrappedBlockData.getSavedBlockStateId(), (ConnectionHandler)tripwireConnectionHandler);
            }
        };
    }

    private static byte getStates(WrappedBlockData wrappedBlockData) {
        byte by2 = 0;
        if (wrappedBlockData.getValue("attached").equals("true")) {
            by2 = (byte)(by2 | 1);
        }
        if (wrappedBlockData.getValue("disarmed").equals("true")) {
            by2 = (byte)(by2 | 2);
        }
        if (wrappedBlockData.getValue("powered").equals("true")) {
            by2 = (byte)(by2 | 4);
        }
        if (wrappedBlockData.getValue("east").equals("true")) {
            by2 = (byte)(by2 | 8);
        }
        if (wrappedBlockData.getValue("north").equals("true")) {
            by2 = (byte)(by2 | 0x10);
        }
        if (wrappedBlockData.getValue("south").equals("true")) {
            by2 = (byte)(by2 | 0x20);
        }
        if (wrappedBlockData.getValue("west").equals("true")) {
            by2 = (byte)(by2 | 0x40);
        }
        return by2;
    }

    @Override
    public int connect(UserConnection userConnection, Position position, int n2) {
        int n3;
        TripwireConnectionHandler$TripwireData tripwireConnectionHandler$TripwireData = (TripwireConnectionHandler$TripwireData)TRIPWIRE_DATA_MAP.get(n2);
        if (tripwireConnectionHandler$TripwireData == null) {
            return n2;
        }
        byte by2 = 0;
        if (tripwireConnectionHandler$TripwireData.isAttached()) {
            by2 = (byte)(by2 | 1);
        }
        if (tripwireConnectionHandler$TripwireData.isDisarmed()) {
            by2 = (byte)(by2 | 2);
        }
        if (tripwireConnectionHandler$TripwireData.isPowered()) {
            by2 = (byte)(by2 | 4);
        }
        int n4 = this.getBlockData(userConnection, position.getRelative(BlockFace.EAST));
        int n5 = this.getBlockData(userConnection, position.getRelative(BlockFace.NORTH));
        int n6 = this.getBlockData(userConnection, position.getRelative(BlockFace.SOUTH));
        int n7 = this.getBlockData(userConnection, position.getRelative(BlockFace.WEST));
        if (TRIPWIRE_DATA_MAP.containsKey(n4) || TRIPWIRE_HOOKS.get(n4) == BlockFace.WEST) {
            by2 = (byte)(by2 | 8);
        }
        if (TRIPWIRE_DATA_MAP.containsKey(n5) || TRIPWIRE_HOOKS.get(n5) == BlockFace.SOUTH) {
            by2 = (byte)(by2 | 0x10);
        }
        if (TRIPWIRE_DATA_MAP.containsKey(n6) || TRIPWIRE_HOOKS.get(n6) == BlockFace.NORTH) {
            by2 = (byte)(by2 | 0x20);
        }
        if (TRIPWIRE_DATA_MAP.containsKey(n7) || TRIPWIRE_HOOKS.get(n7) == BlockFace.EAST) {
            by2 = (byte)(by2 | 0x40);
        }
        return (n3 = CONNECTED_BLOCKS[by2]) == -1 ? n2 : n3;
    }
}

