/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.protocols.protocol1_13to1_12_2.blockconnections;

import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.BlockFace;
import com.viaversion.viaversion.api.minecraft.Position;
import com.viaversion.viaversion.libs.fastutil.ints.Int2ObjectMap;
import com.viaversion.viaversion.libs.fastutil.ints.Int2ObjectOpenHashMap;
import com.viaversion.viaversion.protocols.protocol1_13to1_12_2.blockconnections.ConnectionData;
import com.viaversion.viaversion.protocols.protocol1_13to1_12_2.blockconnections.ConnectionData$ConnectorInitAction;
import com.viaversion.viaversion.protocols.protocol1_13to1_12_2.blockconnections.ConnectionHandler;
import com.viaversion.viaversion.protocols.protocol1_13to1_12_2.blockconnections.StairConnectionHandler$StairData;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;

public class StairConnectionHandler
extends ConnectionHandler {
    private static final Int2ObjectMap<StairConnectionHandler$StairData> STAIR_DATA_MAP = new Int2ObjectOpenHashMap<StairConnectionHandler$StairData>();
    private static final Map<Short, Integer> CONNECTED_BLOCKS = new HashMap<Short, Integer>();

    static ConnectionData$ConnectorInitAction init() {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add("minecraft:oak_stairs");
        linkedList.add("minecraft:cobblestone_stairs");
        linkedList.add("minecraft:brick_stairs");
        linkedList.add("minecraft:stone_brick_stairs");
        linkedList.add("minecraft:nether_brick_stairs");
        linkedList.add("minecraft:sandstone_stairs");
        linkedList.add("minecraft:spruce_stairs");
        linkedList.add("minecraft:birch_stairs");
        linkedList.add("minecraft:jungle_stairs");
        linkedList.add("minecraft:quartz_stairs");
        linkedList.add("minecraft:acacia_stairs");
        linkedList.add("minecraft:dark_oak_stairs");
        linkedList.add("minecraft:red_sandstone_stairs");
        linkedList.add("minecraft:purpur_stairs");
        linkedList.add("minecraft:prismarine_stairs");
        linkedList.add("minecraft:prismarine_brick_stairs");
        linkedList.add("minecraft:dark_prismarine_stairs");
        StairConnectionHandler stairConnectionHandler = new StairConnectionHandler();
        return wrappedBlockData -> {
            byte by2;
            int n2 = linkedList.indexOf(wrappedBlockData.getMinecraftKey());
            if (n2 == -1) {
                return;
            }
            if (wrappedBlockData.getValue("waterlogged").equals("true")) {
                return;
            }
            switch (wrappedBlockData.getValue("shape")) {
                case "straight": {
                    by2 = 0;
                    break;
                }
                case "inner_left": {
                    by2 = 1;
                    break;
                }
                case "inner_right": {
                    by2 = 2;
                    break;
                }
                case "outer_left": {
                    by2 = 3;
                    break;
                }
                case "outer_right": {
                    by2 = 4;
                    break;
                }
                default: {
                    return;
                }
            }
            Object object = new StairConnectionHandler$StairData(wrappedBlockData.getValue("half").equals("bottom"), by2, (byte)n2, BlockFace.valueOf(wrappedBlockData.getValue("facing").toUpperCase(Locale.ROOT)), null);
            STAIR_DATA_MAP.put(wrappedBlockData.getSavedBlockStateId(), (StairConnectionHandler$StairData)object);
            CONNECTED_BLOCKS.put(StairConnectionHandler.getStates((StairConnectionHandler$StairData)object), wrappedBlockData.getSavedBlockStateId());
            ConnectionData.connectionHandlerMap.put(wrappedBlockData.getSavedBlockStateId(), (ConnectionHandler)stairConnectionHandler);
        };
    }

    private static short getStates(StairConnectionHandler$StairData stairConnectionHandler$StairData) {
        short s2 = 0;
        if (stairConnectionHandler$StairData.isBottom()) {
            s2 = (short)(s2 | 1);
        }
        s2 = (short)(s2 | stairConnectionHandler$StairData.getShape() << 1);
        s2 = (short)(s2 | stairConnectionHandler$StairData.getType() << 4);
        s2 = (short)(s2 | stairConnectionHandler$StairData.getFacing().ordinal() << 9);
        return s2;
    }

    @Override
    public int connect(UserConnection userConnection, Position position, int n2) {
        StairConnectionHandler$StairData stairConnectionHandler$StairData = (StairConnectionHandler$StairData)STAIR_DATA_MAP.get(n2);
        if (stairConnectionHandler$StairData == null) {
            return n2;
        }
        short s2 = 0;
        if (stairConnectionHandler$StairData.isBottom()) {
            s2 = (short)(s2 | 1);
        }
        s2 = (short)(s2 | this.getShape(userConnection, position, stairConnectionHandler$StairData) << 1);
        s2 = (short)(s2 | stairConnectionHandler$StairData.getType() << 4);
        Integer n3 = CONNECTED_BLOCKS.get(s2 = (short)(s2 | stairConnectionHandler$StairData.getFacing().ordinal() << 9));
        return n3 == null ? n2 : n3;
    }

    private int getShape(UserConnection userConnection, Position position, StairConnectionHandler$StairData stairConnectionHandler$StairData) {
        BlockFace blockFace;
        BlockFace blockFace2 = stairConnectionHandler$StairData.getFacing();
        StairConnectionHandler$StairData stairConnectionHandler$StairData2 = (StairConnectionHandler$StairData)STAIR_DATA_MAP.get(this.getBlockData(userConnection, position.getRelative(blockFace2)));
        if (stairConnectionHandler$StairData2 != null && stairConnectionHandler$StairData2.isBottom() == stairConnectionHandler$StairData.isBottom()) {
            blockFace = stairConnectionHandler$StairData2.getFacing();
            if (blockFace2.axis() != blockFace.axis() && this.checkOpposite(userConnection, stairConnectionHandler$StairData, position, blockFace.opposite())) {
                return blockFace == this.rotateAntiClockwise(blockFace2) ? 3 : 4;
            }
        }
        if ((stairConnectionHandler$StairData2 = (StairConnectionHandler$StairData)STAIR_DATA_MAP.get(this.getBlockData(userConnection, position.getRelative(blockFace2.opposite())))) != null && stairConnectionHandler$StairData2.isBottom() == stairConnectionHandler$StairData.isBottom()) {
            blockFace = stairConnectionHandler$StairData2.getFacing();
            if (blockFace2.axis() != blockFace.axis() && this.checkOpposite(userConnection, stairConnectionHandler$StairData, position, blockFace)) {
                return blockFace == this.rotateAntiClockwise(blockFace2) ? 1 : 2;
            }
        }
        return 0;
    }

    private boolean checkOpposite(UserConnection userConnection, StairConnectionHandler$StairData stairConnectionHandler$StairData, Position position, BlockFace blockFace) {
        StairConnectionHandler$StairData stairConnectionHandler$StairData2 = (StairConnectionHandler$StairData)STAIR_DATA_MAP.get(this.getBlockData(userConnection, position.getRelative(blockFace)));
        return stairConnectionHandler$StairData2 == null || stairConnectionHandler$StairData2.getFacing() != stairConnectionHandler$StairData.getFacing() || stairConnectionHandler$StairData2.isBottom() != stairConnectionHandler$StairData.isBottom();
    }

    private BlockFace rotateAntiClockwise(BlockFace blockFace) {
        switch (blockFace) {
            case NORTH: {
                return BlockFace.WEST;
            }
            case SOUTH: {
                return BlockFace.EAST;
            }
            case EAST: {
                return BlockFace.NORTH;
            }
            case WEST: {
                return BlockFace.SOUTH;
            }
        }
        return blockFace;
    }
}

