/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.protocols.protocol1_13to1_12_2.blockconnections;

import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.BlockFace;
import com.viaversion.viaversion.api.minecraft.Position;
import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import com.viaversion.viaversion.libs.fastutil.ints.IntOpenHashSet;
import com.viaversion.viaversion.libs.fastutil.ints.IntSet;
import com.viaversion.viaversion.protocols.protocol1_13to1_12_2.blockconnections.BlockData;
import com.viaversion.viaversion.protocols.protocol1_13to1_12_2.blockconnections.ConnectionData;
import com.viaversion.viaversion.protocols.protocol1_13to1_12_2.blockconnections.ConnectionData$ConnectorInitAction;
import com.viaversion.viaversion.protocols.protocol1_13to1_12_2.blockconnections.ConnectionHandler;
import com.viaversion.viaversion.protocols.protocol1_13to1_12_2.blockconnections.StairConnectionHandler;
import com.viaversion.viaversion.protocols.protocol1_13to1_12_2.blockconnections.WrappedBlockData;
import java.util.Arrays;

public abstract class AbstractFenceConnectionHandler
extends ConnectionHandler {
    private static final StairConnectionHandler STAIR_CONNECTION_HANDLER = new StairConnectionHandler();
    private final IntSet blockStates = new IntOpenHashSet();
    private final int[] connectedBlockStates = new int[this.statesSize()];
    private final int blockConnectionsTypeId;

    protected AbstractFenceConnectionHandler(String string) {
        this.blockConnectionsTypeId = string != null ? BlockData.connectionTypeId(string) : -1;
        Arrays.fill(this.connectedBlockStates, -1);
    }

    public ConnectionData$ConnectorInitAction getInitAction(String string) {
        AbstractFenceConnectionHandler abstractFenceConnectionHandler = this;
        return wrappedBlockData -> {
            if (string.equals(wrappedBlockData.getMinecraftKey())) {
                if (wrappedBlockData.hasData("waterlogged") && wrappedBlockData.getValue("waterlogged").equals("true")) {
                    return;
                }
                this.blockStates.add(wrappedBlockData.getSavedBlockStateId());
                ConnectionData.connectionHandlerMap.put(wrappedBlockData.getSavedBlockStateId(), (ConnectionHandler)abstractFenceConnectionHandler);
                byte by2 = this.getStates(wrappedBlockData);
                this.connectedBlockStates[by2] = wrappedBlockData.getSavedBlockStateId();
            }
        };
    }

    protected byte getStates(WrappedBlockData wrappedBlockData) {
        byte by2 = 0;
        if (wrappedBlockData.getValue("east").equals("true")) {
            by2 = (byte)(by2 | 1);
        }
        if (wrappedBlockData.getValue("north").equals("true")) {
            by2 = (byte)(by2 | 2);
        }
        if (wrappedBlockData.getValue("south").equals("true")) {
            by2 = (byte)(by2 | 4);
        }
        if (wrappedBlockData.getValue("west").equals("true")) {
            by2 = (byte)(by2 | 8);
        }
        return by2;
    }

    protected byte getStates(UserConnection userConnection, Position position, int n2) {
        boolean bl2;
        byte by2 = 0;
        boolean bl3 = bl2 = userConnection.getProtocolInfo().getServerProtocolVersion() < ProtocolVersion.v1_12.getVersion();
        if (this.connects(BlockFace.EAST, this.getBlockData(userConnection, position.getRelative(BlockFace.EAST)), bl2)) {
            by2 = (byte)(by2 | 1);
        }
        if (this.connects(BlockFace.NORTH, this.getBlockData(userConnection, position.getRelative(BlockFace.NORTH)), bl2)) {
            by2 = (byte)(by2 | 2);
        }
        if (this.connects(BlockFace.SOUTH, this.getBlockData(userConnection, position.getRelative(BlockFace.SOUTH)), bl2)) {
            by2 = (byte)(by2 | 4);
        }
        if (this.connects(BlockFace.WEST, this.getBlockData(userConnection, position.getRelative(BlockFace.WEST)), bl2)) {
            by2 = (byte)(by2 | 8);
        }
        return by2;
    }

    protected byte statesSize() {
        return 16;
    }

    @Override
    public int getBlockData(UserConnection userConnection, Position position) {
        return STAIR_CONNECTION_HANDLER.connect(userConnection, position, super.getBlockData(userConnection, position));
    }

    @Override
    public int connect(UserConnection userConnection, Position position, int n2) {
        int n3 = this.connectedBlockStates[this.getStates(userConnection, position, n2)];
        return n3 == -1 ? n2 : n3;
    }

    protected boolean connects(BlockFace blockFace, int n2, boolean bl2) {
        if (this.blockStates.contains(n2)) {
            return true;
        }
        if (this.blockConnectionsTypeId == -1) {
            return false;
        }
        BlockData blockData = (BlockData)ConnectionData.blockConnectionData.get(n2);
        return blockData != null && blockData.connectsTo(this.blockConnectionsTypeId, blockFace.opposite(), bl2);
    }

    public IntSet getBlockStates() {
        return this.blockStates;
    }
}

