/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.protocols.base;

import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.connection.ProtocolInfo;
import com.viaversion.viaversion.api.platform.providers.ViaProviders;
import com.viaversion.viaversion.api.protocol.AbstractProtocol;
import com.viaversion.viaversion.api.protocol.Protocol;
import com.viaversion.viaversion.api.protocol.ProtocolPathEntry;
import com.viaversion.viaversion.api.protocol.ProtocolPipeline;
import com.viaversion.viaversion.api.protocol.packet.Direction;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.packet.State;
import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import com.viaversion.viaversion.api.protocol.version.VersionProvider;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.protocols.base.BaseVersionProvider;
import com.viaversion.viaversion.protocols.base.ServerboundHandshakePackets;
import java.util.ArrayList;
import java.util.List;

public class BaseProtocol
extends AbstractProtocol {
    @Override
    protected void registerPackets() {
        this.registerServerbound(ServerboundHandshakePackets.CLIENT_INTENTION, packetWrapper -> {
            int n2 = packetWrapper.passthrough(Type.VAR_INT);
            packetWrapper.passthrough(Type.STRING);
            packetWrapper.passthrough(Type.UNSIGNED_SHORT);
            int n3 = packetWrapper.passthrough(Type.VAR_INT);
            ProtocolInfo protocolInfo = packetWrapper.user().getProtocolInfo();
            protocolInfo.setProtocolVersion(n2);
            VersionProvider versionProvider = Via.getManager().getProviders().get(VersionProvider.class);
            if (versionProvider == null) {
                packetWrapper.user().setActive(false);
                return;
            }
            int n4 = versionProvider.getClosestServerProtocol(packetWrapper.user());
            protocolInfo.setServerProtocolVersion(n4);
            List<ProtocolPathEntry> list = null;
            if (protocolInfo.getProtocolVersion() >= n4 || Via.getPlatform().isOldClientsAllowed()) {
                list = Via.getManager().getProtocolManager().getProtocolPath(protocolInfo.getProtocolVersion(), n4);
            }
            ProtocolPipeline protocolPipeline = packetWrapper.user().getProtocolInfo().getPipeline();
            if (list != null) {
                ArrayList<Protocol> arrayList = new ArrayList<Protocol>(list.size());
                for (ProtocolPathEntry protocolPathEntry : list) {
                    arrayList.add(protocolPathEntry.protocol());
                    Via.getManager().getProtocolManager().completeMappingDataLoading(protocolPathEntry.protocol().getClass());
                }
                protocolPipeline.add(arrayList);
                ProtocolVersion protocolVersion = ProtocolVersion.getProtocol(n4);
                packetWrapper.set(Type.VAR_INT, 0, protocolVersion.getOriginalVersion());
            }
            protocolPipeline.add(Via.getManager().getProtocolManager().getBaseProtocol(n4));
            if (n3 == 1) {
                protocolInfo.setState(State.STATUS);
            } else if (n3 == 2) {
                protocolInfo.setState(State.LOGIN);
            }
        });
    }

    @Override
    public boolean isBaseProtocol() {
        return true;
    }

    @Override
    public void register(ViaProviders viaProviders) {
        viaProviders.register(VersionProvider.class, new BaseVersionProvider());
    }

    @Override
    public void transform(Direction direction, State state, PacketWrapper packetWrapper) {
        super.transform(direction, state, packetWrapper);
        if (direction == Direction.SERVERBOUND && state == State.HANDSHAKE && packetWrapper.getId() != 0) {
            packetWrapper.user().setActive(false);
        }
    }
}

